//
//	FindinSite-CD-JS-HelpIndex database naturalformainframes
//
//	Copyright (c) 2016-2025 Software AG, Darmstadt, Germany and/or Software AG USA Inc., Reston, VA, USA
//
var naturalformainframes = {
    baseurls: ["../"],
    varname: "naturalformainframes",
        tree: [
            { url: "about/about.htm", title: "About this Documentation",
              tree: [
                  { url: "about/document_conventions.htm", title: "Document Conventions" },
                  { url: "about/online_information.htm", title: "Online Information and Support" },
                  { url: "about/data_protection.htm", title: "Data Protection" },
              ]
            },
            { url: "using/use-over.htm", title: "Using Natural",
              tree: [
                  { url: "using/use_mf_invoke.htm", title: "Invoking and Terminating a Natural Session" },
                  { url: "using/use_mf_execute.htm", title: "Using Commands and Menu Functions" },
                  { url: "using/use_mf_help.htm", title: "Natural Online Help" },
                  { url: "using/use_mf_libs.htm", title: "Using Natural Libraries" },
                  { url: "using/use_mf_objects.htm", title: "Maintaining and Executing Natural Objects" },
                  { url: "using/use_mf_menus.htm", title: "Natural Main Menu" },
                  { url: "using/use_mf_print.htm", title: "Print and Work Files" },
                  { url: "using/use_mf_config.htm", title: "Configuring your Natural Environment" },
                  { url: "using/use_rules.htm", title: "Rules and Naming Conventions" },
              ]
            },
            { url: "arc/arc-over.htm", title: "Natural System Architecture",
              tree: [
                  { url: "arc/base_arc_overview.htm", title: "Natural Basic Architecture Overview",
                    tree: [
                        { url: "arc/nucleus_mf.htm", title: "Natural Nucleus" },
                        { url: "arc/work_area.htm", title: "User Session Data" },
                        { url: "arc/buffer.htm", title: "Natural Buffer Pool" },
                        { url: "arc/tools.htm", title: "Natural Editors and Utilities" },
                        { url: "arc/tp_mf.htm", title: "TP/OS Interface" },
                        { url: "arc/user_inter.htm", title: "User Interface" },
                        { url: "arc/work_print.htm", title: "Print Files - Work Files" },
                        { url: "arc/files.htm", title: "Natural System Files" },
                        { url: "arc/db_inter.htm", title: "DBMS Interface - Database Access" },
                    ]
                  },
                  { url: "arc/one_arc.htm", title: "NaturalONE Architecture" },
                  { url: "arc/spod_arc_overview.htm", title: "Natural SPoD Architecture" },
              ]
            },
            { url: "firststeps/fs-over.htm", title: "First Steps",
              tree: [
                  { url: "firststeps/fs-about.htm", title: "About this Tutorial" },
                  { url: "firststeps/fs-start.htm", title: "Getting Started with Natural" },
                  { url: "firststeps/fs-hello.htm", title: "Hello World!" },
                  { url: "firststeps/fs-dbaccess.htm", title: "Database Access" },
                  { url: "firststeps/fs-input.htm", title: "User Input" },
                  { url: "firststeps/fs-loop.htm", title: "Loops and Labels" },
                  { url: "firststeps/fs-inlinesub.htm", title: "Inline Subroutines" },
                  { url: "firststeps/fs-proc.htm", title: "Processing Rules and Helproutines" },
                  { url: "firststeps/fs-lda.htm", title: "Local Data Areas" },
                  { url: "firststeps/fs-gda.htm", title: "Global Data Areas" },
                  { url: "firststeps/fs-extsub.htm", title: "External Subroutines" },
                  { url: "firststeps/fs-subprog.htm", title: "Subprograms" },
              ]
            },
            { url: "unicode/uni-over.htm", title: "Unicode and Code Page Support",
              tree: [
                  { url: "unicode/uni-intro.htm", title: "Introduction to Unicode and Code Page Support" },
                  { url: "unicode/uni-enable.htm", title: "Enabling Unicode and Code Page Support" },
                  { url: "unicode/uni_ics322.htm", title: "ICS 322" },
                  { url: "unicode/uni-config.htm", title: "Configuration and Administration of the Unicode and Code Page Environment" },
                  { url: "unicode/uni-devenv.htm", title: "Development Environment" },
                  { url: "unicode/uni-language.htm", title: "Unicode and Code Page Support in the Natural Programming Language" },
                  { url: "unicode/uni-io.htm", title: "Unicode Input and Output Handling in Natural Applications" },
                  { url: "unicode/uni-bidir.htm", title: "Bidirectional Language Support" },
                  { url: "unicode/uni-data.htm", title: "Unicode Data Storage" },
                  { url: "unicode/uni-migrate.htm", title: "Migrating Existing Applications" },
                  { url: "unicode/uni-faq.htm", title: "Help and Troubleshooting" },
              ]
            },
            { url: "rnotes_mf/rn-mf-over.htm", title: "Natural Version 9.2.3 Release Notes for Mainframes",
              tree: [
                  { url: "rnotes_mf/rn-mf-env.htm", title: "Supported Environments" },
                  { url: "rnotes_mf/rn-mf-sag-available-supported.htm", title: "Available and Supported Software AG Product Versions" },
                  { url: "rnotes_mf/rn-mf-inst-comp.htm", title: "Installation and Compatibility" },
                  { url: "rnotes_mf/rn-mf-ce.htm", title: "New and Changed Features of Base Natural" },
                  { url: "rnotes_mf/rn-mf-add-on-new.htm", title: "New and Changed Features of Natural Add-On Products" },
                  { url: "rnotes_mf/rn-mf-dropped.htm", title: "Dropped Features" },
                  { url: "rnotes_mf/rn-mf-prev-relnotes.htm", title: "Previous Release Notes" },
              ]
            },
            { url: "license/license.htm", title: "Software AG Mainframe Product Licensing" },
            { url: "inst_zos/inst_zos-over.htm", title: "Installation for z/OS",
              tree: [
                  { url: "inst_zos/install_process_overview.htm", title: "Installation Process and Major Natural Features on z/OS" },
                  { url: "inst_zos/install_nat.htm", title: "Installing Natural on z/OS" },
                  { url: "inst_zos/install_ics.htm", title: "Installing International Components for Unicode for Software AG on z/OS" },
                  { url: "inst_zos/install_reqdoc.htm", title: "Installation for REQUEST DOCUMENT, PARSE JSON, and PARSE XML Statements on z/OS" },
                  { url: "inst_zos/install_esx.htm", title: "Installing Entire System Server Interface on z/OS" },
                  { url: "inst_zos/install_sagedt.htm", title: "Installing Software AG Editor on z/OS" },
                  { url: "inst_zos/install_nci.htm", title: "Installing Natural CICS Interface on z/OS" },
                  { url: "inst_zos/install_ncf.htm", title: "Installing Natural Com-plete/SMARTS Interface on z/OS" },
                  { url: "inst_zos/install_nii.htm", title: "Installing Natural IMS TM Interface on z/OS" },
                  { url: "inst_zos/install_nti.htm", title: "Installing Natural TSO Interface on z/OS" },
                  { url: "inst_zos/install_ndb.htm", title: "Installing Natural for Db2 Version on z/OS" },
                  { url: "inst_zos/install_ndz.htm", title: "Installing Natural for Db2 for zIIP Version 9.2.3 on z/OS" },
                  { url: "inst_zos/install_nvs.htm", title: "Installing Natural for VSAM on z/OS",
                    tree: [
                        { url: "inst_zos/install_nvs_prerequisites.htm", title: "Prerequisites" },
                        { url: "inst_zos/install_nvs_ada_files.htm", title: "Installing Natural for VSAM on Adabas System Files on z/OS" },
                        { url: "inst_zos/install_nvs_vsam_files.htm", title: "Installing Natural for VSAM on VSAM System Files on z/OS" },
                    ]
                  },
                  { url: "inst_zos/install_nsc.htm", title: "Installing Natural Security on z/OS" },
                  { url: "inst_zos/install_nsf.htm", title: "Installing Natural SAF Security on z/OS" },
                  { url: "inst_zos/install_naf.htm", title: "Installing Natural Advanced Facilities on z/OS",
                    tree: [
                        { url: "inst_zos/install_naf_nci.htm", title: "Installing Natural Advanced Facilities under CICS on z/OS" },
                        { url: "inst_zos/install_naf_cics_veri.htm", title: "Installation Verification for Natural Advanced Facilities under CICS on z/OS" },
                        { url: "inst_zos/install_naf_nii_zos.htm", title: "Installing Natural Advanced Facilities under IMS TM on z/OS" },
                    ]
                  },
                  { url: "inst_zos/install_noc.htm", title: "Installing Natural Optimizer Compiler on z/OS" },
                  { url: "inst_zos/install_ntc.htm", title: "Installing Natural Connection on z/OS" },
                  { url: "inst_zos/install_rnm.htm", title: "Installing Natural Review" },
                  { url: "inst_zos/install_naz.htm", title: "Installing Natural for zIIP on z/OS" },
              ]
            },
            { url: "ops_mf/ops_mf-over.htm", title: "Operations",
              tree: [
                  { url: "ops_mf/conf-over.htm", title: "Configuring Natural",
                    tree: [
                        { url: "ops_mf/conf_link.htm", title: "Linking Natural Objects to the Natural Nucleus" },
                        { url: "ops_mf/conf_usrex.htm", title: "Natural User Exits" },
                        { url: "ops_mf/conf_access.htm", title: "Natural User Access Method for Print and Work Files" },
                        { url: "ops_mf/conf_system_files.htm", title: "Natural System Files" },
                        { url: "ops_mf/conf_txtmod_macros.htm", title: "Natural Text Modules and Macros" },
                        { url: "ops_mf/conf_conf.htm", title: "Natural Configuration Tables" },
                        { url: "ops_mf/conf_stormng.htm", title: "Natural Storage Management" },
                    ]
                  },
                  { url: "ops_mf/parmov-over.htm", title: "Profile Parameter Usage",
                    tree: [
                        { url: "ops_mf/parmov_hi.htm", title: "Natural Parameter Hierarchy" },
                        { url: "ops_mf/parmov_as.htm", title: "Assignment of Parameter Values" },
                        { url: "ops_mf/build_parm_module.htm", title: "Building a Natural Parameter Module" },
                    ]
                  },
                  { url: "ops_mf/zos-over.htm", title: "z/OS Environment",
                    tree: [
                        { url: "ops_mf/zos_env.htm", title: "Natural under z/OS" },
                        { url: "ops_mf/zos_asm.htm", title: "Authorized Services Manager under z/OS" },
                        { url: "ops_mf/zos_fun.htm", title: "Natural Roll Server Functionality" },
                        { url: "ops_mf/zos_op.htm", title: "Natural Roll Server Operation" },
                    ]
                  },
                  { url: "ops_mf/batch-over.htm", title: "Natural in Batch Mode",
                    tree: [
                        { url: "ops_mf/batch_zos.htm", title: "Natural in Batch Mode under z/OS" },
                        { url: "ops_mf/batch_gen.htm", title: "Natural in Batch Mode (All Environments)" },
                    ]
                  },
                  { url: "ops_mf/bp-over.htm", title: "Natural Buffer Pools",
                    tree: [
                        { url: "ops_mf/bp_buff.htm", title: "Natural Buffer Pool - General" },
                        { url: "ops_mf/bp_gbpzos.htm", title: "Natural Global Buffer Pool under z/OS" },
                    ]
                  },
                  { url: "ops_mf/mbp.htm", title: "Message Buffer Pool" },
                  { url: "ops_mf/spool-over.htm", title: "System Spool Access" },
                  { url: "ops_mf/calln-over.htm", title: "Natural 3GL CALLNAT Interface",
                    tree: [
                        { url: "ops_mf/calln-preliminaries.htm", title: "Natural 3GL CALLNAT Interface - Purpose, Prerequisites, Restrictions" },
                        { url: "ops_mf/calln-usage-examples.htm", title: "Natural 3GL CALLNAT Interface - Usage, Examples" },
                    ]
                  },
                  { url: "ops_mf/sagedt-over.htm", title: "Operating the Software AG Editor",
                    tree: [
                        { url: "ops_mf/sagedt_wfile.htm", title: "Editor Work File" },
                        { url: "ops_mf/sagedt_edbp.htm", title: "Editor Buffer Pool" },
                    ]
                  },
                  { url: "ops_mf/servmon-over.htm", title: "Natural as a Server",
                    tree: [
                        { url: "ops_mf/servmon_zos.htm", title: "Natural as a Server under z/OS" },
                        { url: "ops_mf/servmon_cics.htm", title: "Natural as a Server under CICS" },
                    ]
                  },
                  { url: "ops_mf/misc-over.htm", title: "Natural Execution - Miscellaneous Topics",
                    tree: [
                        { url: "ops_mf/misc_bit.htm", title: "Natural 31-Bit Mode Support" },
                        { url: "ops_mf/misc_objects.htm", title: "Support and Use of Natural and Non-Natural Objects" },
                        { url: "ops_mf/misc_devs.htm", title: "Input/Output Devices" },
                        { url: "ops_mf/misc_dbcs.htm", title: "Double-Byte Character Sets" },
                        { url: "ops_mf/misc_async.htm", title: "Asynchronous Processing" },
                    ]
                  },
              ]
            },
            { url: "ziip/ziip-over.htm", title: "Natural for zIIP",
              tree: [
                  { url: "ziip/naz-prereq.htm", title: "Prerequisites" },
                  { url: "ziip/naz-general.htm", title: "General Information on zIIP Processing" },
                  { url: "ziip/naz-nat-processing.htm", title: "Natural zIIP Processing: TCBs, SRBs and Enclaves" },
                  { url: "ziip/naz-monitor.htm", title: "Monitoring zIIP Usage" },
                  { url: "ziip/naz-tune.htm", title: "Tuning zIIP Usage" },
              ]
            },
            { url: "webio/webio-over.htm", title: "Natural Web I/O Interface",
              tree: [
                  { url: "webio/webio-intro.htm", title: "Introduction" },
                  { url: "webio/nwo-cics-intro.htm", title: "Introducing the Natural Web I/O Interface Server CICS Adapter" },
                  { url: "webio/nwo-ims-intro.htm", title: "Introducing the Natural Web I/O Interface Server IMS Adapter" },
                  { url: "webio/nwo-over.htm", title: "Installing and Configuring the Natural Web I/O Interface Server",
                    tree: [
                        { url: "webio/nwo-concept.htm", title: "Natural Web I/O Interface Server Concept and Structure" },
                        { url: "webio/nwo-prereq.htm", title: "Prerequisites" },
                        { url: "webio/nwo-inst-zos.htm", title: "Installing the Natural Web I/O Interface Server under z/OS" },
                        { url: "webio/nwo-conf.htm", title: "Configuring the Natural Web I/O Interface Server" },
                        { url: "webio/nwo-cics-instos.htm", title: "Installing the Natural Web I/O Interface Server CICS Adapter under z/OS" },
                        { url: "webio/nwo-cics-conf.htm", title: "Configuring the Natural Web I/O Interface Server CICS Adapter" },
                        { url: "webio/nwo-ims-instos.htm", title: "Installing the Natural Web I/O Interface Server IMS Adapter" },
                        { url: "webio/nwo-ims-conf.htm", title: "Configuring the Natural Web I/O Interface Server IMS Adapter" },
                    ]
                  },
                  { url: "webio/nwoclient-over.htm", title: "Installing the Natural Web I/O Interface Client",
                    tree: [
                        { url: "webio/nwoclient-prereq.htm", title: "Prerequisites" },
                        { url: "webio/nwoclient-installtomcat.htm", title: "Installing the Natural Web I/O Interface Client on Apache Tomcat" },
                        { url: "webio/nwoclient-migrateiis.htm", title: "Migrating the Natural Web I/O Interface Client from IIS to Apache Tomcat" },
                    ]
                  },
                  { url: "webio/clientcfg-over.htm", title: "Configuring the Client",
                    tree: [
                        { url: "webio/clientcfg-logon.htm", title: "About the Logon Page" },
                        { url: "webio/clientcfg-tool.htm", title: "Natural Client Configuration Tool" },
                        { url: "webio/clientcfg-ajax.htm", title: "Ajax Configuration" },
                        { url: "webio/cfg-mode.htm", title: "Design Time Mode and Runtime Mode" },
                        { url: "webio/clientcfg-css.htm", title: "Natural Web I/O Style Sheets" },
                        { url: "webio/multilanguagemanagement.htm", title: "Multi-Language Management" },
                        { url: "webio/clientcfg-url.htm", title: "Starting a Natural Application with a URL" },
                        { url: "webio/clientcfg-security-container.htm", title: "Configuring Container-Managed Security" },
                        { url: "webio/clientcfg-ssl.htm", title: "Configuring SSL" },
                        { url: "webio/clientcfg-log.htm", title: "Logging" },
                    ]
                  },
                  { url: "webio/nwo-cfgmon-over.htm", title: "Operating and Monitoring the Natural Web I/O Interface Server",
                    tree: [
                        { url: "webio/nwo-operating.htm", title: "Operating the Natural Web I/O Interface Server" },
                        { url: "webio/nwo-natmopi.htm", title: "Monitor Client NATMOPI" },
                        { url: "webio/nwo-htmlmon.htm", title: "HTML Monitor Client" },
                    ]
                  },
              ]
            },
            { url: "tp_mf/tp_mf-over.htm", title: "TP Monitor Interfaces",
              tree: [
                  { url: "tp_mf/tpuse.htm", title: "Using Natural with TP Monitors" },
                  { url: "tp_mf/nci-docu.htm", title: "Natural under CICS",
                    tree: [
                        { url: "tp_mf/nci_ziip.htm", title: "Support for zIIP under CICS" },
                        { url: "tp_mf/cicsif.htm", title: "Natural CICS Interface Functionality" },
                        { url: "tp_mf/cicspar.htm", title: "Natural CICS Generation Parameters" },
                        { url: "tp_mf/cicsmrol.htm", title: "Customizing VSAM RRDS Roll Files" },
                        { url: "tp_mf/cicsmro.htm", title: "Natural in CICS MRO Environments" },
                        { url: "tp_mf/cicsnod.htm", title: "CICS Node Error Program and Timeout Considerations for Natural" },
                        { url: "tp_mf/cicsbrg.htm", title: "CICS 3270 Bridge Support" },
                        { url: "tp_mf/cicsts.htm", title: "Threadsafe Considerations" },
                        { url: "tp_mf/cics_open_transaction.htm", title: "CICS Open Transaction Environment Considerations" },
                        { url: "tp_mf/cicscs.htm", title: "Support for CICS Channels and Containers" },
                        { url: "tp_mf/cicsle.htm", title: "IBM Language Environment (LE) and Natural CICS Interface" },
                        { url: "tp_mf/cicsfun.htm", title: "Special Natural CICS Functionality" },
                        { url: "tp_mf/cicsprg.htm", title: "Natural CICS Sample Programs" },
                        { url: "tp_mf/cicsinv.htm", title: "Invoking Natural from User Programs" },
                        { url: "tp_mf/cicsasy.htm", title: "Asynchronous Natural Processing under CICS" },
                        { url: "tp_mf/cicslog.htm", title: "Logging Natural Sessions under CICS" },
                        { url: "tp_mf/cicsprf.htm", title: "Natural CICS Performance Considerations" },
                        { url: "tp_mf/cicswf.htm", title: "Natural Print and Work Files under CICS" },
                    ]
                  },
                  { url: "tp_mf/cmpl.htm", title: "Natural under Com-plete/SMARTS" },
                  { url: "tp_mf/ims-over.htm", title: "Natural under IMS TM",
                    tree: [
                        { url: "tp_mf/imsenv.htm", title: "Natural under IMS TM - Environments" },
                        { url: "tp_mf/imscom.htm", title: "Natural under IMS TM - Components" },
                        { url: "tp_mf/nii_configuration.htm", title: "Natural under IMS TM - Configuration" },
                        { url: "tp_mf/imsprg.htm", title: "Natural under IMS TM - Service Programs" },
                        { url: "tp_mf/imsmod.htm", title: "Natural under IMS TM - Service Modules" },
                        { url: "tp_mf/imsusr.htm", title: "Natural under IMS TM - User Exits" },
                        { url: "tp_mf/imsfun.htm", title: "Natural under IMS TM - Special Functions" },
                        { url: "tp_mf/imsrec.htm", title: "Natural under IMS TM - Recovery Handling" },
                    ]
                  },
                  { url: "tp_mf/tso.htm", title: "Natural under TSO" },
              ]
            },
            { url: "dbms/dbms-over.htm", title: "Database Management System Interfaces",
              tree: [
                  { url: "dbms/db2-over.htm", title: "Natural for Db2",
                    tree: [
                        { url: "dbms/ndb-gen.htm", title: "General Information" },
                        { url: "dbms/ndb-tableaccess.htm", title: "Accessing a Db2 Table" },
                        { url: "dbms/ndb-tools-using.htm", title: "Using Natural Tools for Db2" },
                        { url: "dbms/ndb-apm.htm", title: "Application Plan Maintenance" },
                        { url: "dbms/ndb-cm.htm", title: "Catalog Maintenance" },
                        { url: "dbms/ndb-isql.htm", title: "Interactive SQL" },
                        { url: "dbms/ndb-rst.htm", title: "Retrieval of System Tables" },
                        { url: "dbms/ndb-envset.htm", title: "Environment Setting" },
                        { url: "dbms/ndb-explain.htm", title: "Explain PLAN_TABLE" },
                        { url: "dbms/ndb-servstat.htm", title: "File Server Statistics" },
                        { url: "dbms/ndb-db2cmds.htm", title: "Issuing Db2 Commands from Natural" },
                        { url: "dbms/ndb-natsyscom.htm", title: "Using Natural System Commands for Db2" },
                        { url: "dbms/ndb-ddm.htm", title: "Generating Natural Data Definition Modules (DDMs)" },
                        { url: "dbms/ndb-sqlsupp.htm", title: "Dynamic and Static SQL Support" },
                        { url: "dbms/ndb-natsm.htm", title: "Using Natural Statements and System Variables" },
                        { url: "dbms/ndb-storedproc.htm", title: "Processing Natural Stored Procedures and UDFs" },
                        { url: "dbms/ndb-subpgm.htm", title: "Interface Subprograms" },
                        { url: "dbms/ndb-fserv.htm", title: "Natural File Server for Db2" },
                        { url: "dbms/ndb-dyntrace.htm", title: "Tracing Dynamic SQL Statements" },
                    ]
                  },
                  { url: "dbms/ndb-ziip.htm", title: "Natural for Db2 for zIIP",
                    tree: [
                        { url: "dbms/ndb-ziip-over.htm", title: "Overview" },
                        { url: "dbms/ndb-ziip-restrictions.htm", title: "Restrictions" },
                        { url: "dbms/ndb-ziip-oper.htm", title: "Operation" },
                        { url: "dbms/ndb-ziip-configparm.htm", title: "Configuration and Parameters" },
                        { url: "dbms/ndb-ziip-error.htm", title: "Error codes" },
                        { url: "dbms/ndb-ziip-prepstexec.htm", title: "Preparing Programs for Static Execution" },
                        { url: "dbms/ndb-ziip-statexec.htm", title: "Static Program Execution" },
                    ]
                  },
                  { url: "dbms/nvs-over.htm", title: "Natural for VSAM",
                    tree: [
                        { url: "dbms/nvs-gen.htm", title: "General Information" },
                        { url: "dbms/nvs-intro.htm", title: "Introduction to Natural for VSAM" },
                        { url: "dbms/nvs-customiz.htm", title: "Customizing Natural for VSAM" },
                        { url: "dbms/nvs-ops.htm", title: "Operation" },
                        { url: "dbms/nvs-natsmtl.htm", title: "Natural Statements and Transaction Logic with VSAM" },
                    ]
                  },
              ]
            },
            { url: "mc_mf/mc-over.htm", title: "Messages and Codes",
              tree: [
                  { url: "mc_mf/mc_err-over.htm", title: "Natural System Error Messages",
                    tree: [
                        { url: "mc_mf/mcERRN_0001.htm", title: "Natural System Error Messages 0001-0049" },
                        { url: "mc_mf/mcERRN_0050.htm", title: "Natural System Error Messages 0050-0099" },
                        { url: "mc_mf/mcERRN_0100.htm", title: "Natural System Error Messages 0100-0149" },
                        { url: "mc_mf/mcERRN_0150.htm", title: "Natural System Error Messages 0150-0199" },
                        { url: "mc_mf/mcERRN_0200.htm", title: "Natural System Error Messages 0200-0249" },
                        { url: "mc_mf/mcERRN_0250.htm", title: "Natural System Error Messages 0250-0299" },
                        { url: "mc_mf/mcERRN_0300.htm", title: "Natural System Error Messages 0300-0349" },
                        { url: "mc_mf/mcERRN_0350.htm", title: "Natural System Error Messages 0350-0399" },
                        { url: "mc_mf/mcERRN_0400.htm", title: "Natural System Error Messages 0400-0449" },
                        { url: "mc_mf/mcERRN_0450.htm", title: "Natural System Error Messages 0450-0499" },
                        { url: "mc_mf/mcERRN_0550.htm", title: "Natural System Error Messages 0550-0599" },
                        { url: "mc_mf/mcERRN_0600.htm", title: "Natural System Error Messages 0600-0649" },
                        { url: "mc_mf/mcERRN_0650.htm", title: "Natural System Error Messages 0650-0699" },
                        { url: "mc_mf/mcERRN_0700.htm", title: "Natural System Error Messages 0700-0749" },
                        { url: "mc_mf/mcERRN_0750.htm", title: "Natural System Error Messages 0750-0799" },
                        { url: "mc_mf/mcERRN_0800.htm", title: "Natural System Error Messages 0800-0849" },
                        { url: "mc_mf/mcERRN_0850.htm", title: "Natural System Error Messages 0850-0899" },
                        { url: "mc_mf/mcERRN_0900.htm", title: "Natural System Error Messages 0900-0949" },
                        { url: "mc_mf/mcERRN_0950.htm", title: "Natural System Error Messages 0950-0999" },
                        { url: "mc_mf/mcERRN_1000.htm", title: "Natural System Error Messages 1000-1049" },
                        { url: "mc_mf/mcERRN_1050.htm", title: "Natural System Error Messages 1050-1099" },
                        { url: "mc_mf/mcERRN_1100.htm", title: "Natural System Error Messages 1100-1149" },
                        { url: "mc_mf/mcERRN_1150.htm", title: "Natural System Error Messages 1150-1199" },
                        { url: "mc_mf/mcERRN_1200.htm", title: "Natural System Error Messages 1200-1249" },
                        { url: "mc_mf/mcERRN_1250.htm", title: "Natural System Error Messages 1250-1299" },
                        { url: "mc_mf/mcERRN_1300.htm", title: "Natural System Error Messages 1300-1349" },
                        { url: "mc_mf/mcERRN_1350.htm", title: "Natural System Error Messages 1350-1399" },
                        { url: "mc_mf/mcERRN_1400.htm", title: "Natural System Error Messages 1400-1449" },
                        { url: "mc_mf/mcERRN_1500.htm", title: "Natural System Error Messages 1500-1549" },
                        { url: "mc_mf/mcERRN_1550.htm", title: "Natural System Error Messages 1550-1599" },
                        { url: "mc_mf/mcERRN_1600.htm", title: "Natural System Error Messages 1600-1649" },
                        { url: "mc_mf/mcERRN_1650.htm", title: "Natural System Error Messages 1650-1699" },
                        { url: "mc_mf/mcERRN_1700.htm", title: "Natural System Error Messages 1700-1749" },
                        { url: "mc_mf/mcERRN_1800.htm", title: "Natural System Error Messages 1800-1849" },
                        { url: "mc_mf/mcERRN_1950.htm", title: "Natural System Error Messages 1950-1999" },
                        { url: "mc_mf/mcERRN_2000.htm", title: "Natural System Error Messages 2000-2049" },
                        { url: "mc_mf/mcERRN_2150.htm", title: "Natural System Error Messages 2150-2199" },
                        { url: "mc_mf/mcERRN_2650.htm", title: "Natural System Error Messages 2650-2699" },
                        { url: "mc_mf/mcERRN_2950.htm", title: "Natural System Error Messages 2950-2999" },
                        { url: "mc_mf/mcERRN_3000.htm", title: "Natural System Error Messages 3000-3049" },
                        { url: "mc_mf/mcERRN_3050.htm", title: "Natural System Error Messages 3050-3099" },
                        { url: "mc_mf/mcERRN_3100.htm", title: "Natural System Error Messages 3100-3149" },
                        { url: "mc_mf/mcERRN_3150.htm", title: "Natural System Error Messages 3150-3199" },
                        { url: "mc_mf/mcERRN_3200.htm", title: "Natural System Error Messages 3200-3249" },
                        { url: "mc_mf/mcERRN_3250.htm", title: "Natural System Error Messages 3250-3299" },
                        { url: "mc_mf/mcERRN_3400.htm", title: "Natural System Error Messages 3400-3449" },
                        { url: "mc_mf/mcERRN_3500.htm", title: "Natural System Error Messages 3500-3549" },
                        { url: "mc_mf/mcERRN_3550.htm", title: "Natural System Error Messages 3550-3599" },
                        { url: "mc_mf/mcERRN_3600.htm", title: "Natural System Error Messages 3600-3649" },
                        { url: "mc_mf/mcERRN_3700.htm", title: "Natural System Error Messages 3700-3749" },
                        { url: "mc_mf/mcERRN_3750.htm", title: "Natural System Error Messages 3750-3799" },
                        { url: "mc_mf/mcERRN_3800.htm", title: "Natural System Error Messages 3800-3849" },
                        { url: "mc_mf/mcERRN_3850.htm", title: "Natural System Error Messages 3850-3899" },
                        { url: "mc_mf/mcERRN_3900.htm", title: "Natural System Error Messages 3900-3949" },
                        { url: "mc_mf/mcERRN_3950.htm", title: "Natural System Error Messages 3950-3999" },
                        { url: "mc_mf/mcERRN_4000.htm", title: "Natural System Error Messages 4000-4049" },
                        { url: "mc_mf/mcERRN_4050.htm", title: "Natural System Error Messages 4050-4099" },
                        { url: "mc_mf/mcERRN_4100.htm", title: "Natural System Error Messages 4100-4149" },
                        { url: "mc_mf/mcERRN_4150.htm", title: "Natural System Error Messages 4150-4199" },
                        { url: "mc_mf/mcERRN_4200.htm", title: "Natural System Error Messages 4200-4249" },
                        { url: "mc_mf/mcERRN_4250.htm", title: "Natural System Error Messages 4250-4299" },
                        { url: "mc_mf/mcERRN_4300.htm", title: "Natural System Error Messages 4300-4349" },
                        { url: "mc_mf/mcERRN_4350.htm", title: "Natural System Error Messages 4350-4399" },
                        { url: "mc_mf/mcERRN_4400.htm", title: "Natural System Error Messages 4400-4449" },
                        { url: "mc_mf/mcERRN_4450.htm", title: "Natural System Error Messages 4450-4499" },
                        { url: "mc_mf/mcERRN_4500.htm", title: "Natural System Error Messages 4500-4549" },
                        { url: "mc_mf/mcERRN_4550.htm", title: "Natural System Error Messages 4550-4599" },
                        { url: "mc_mf/mcERRN_4600.htm", title: "Natural System Error Messages 4600-4649" },
                        { url: "mc_mf/mcERRN_4650.htm", title: "Natural System Error Messages 4650-4699" },
                        { url: "mc_mf/mcERRN_4700.htm", title: "Natural System Error Messages 4700-4749" },
                        { url: "mc_mf/mcERRN_4750.htm", title: "Natural System Error Messages 4750-4799" },
                        { url: "mc_mf/mcERRN_4800.htm", title: "Natural System Error Messages 4800-4849" },
                        { url: "mc_mf/mcERRN_4850.htm", title: "Natural System Error Messages 4850-4899" },
                        { url: "mc_mf/mcERRN_4900.htm", title: "Natural System Error Messages 4900-4949" },
                        { url: "mc_mf/mcERRN_4950.htm", title: "Natural System Error Messages 4950-4999" },
                        { url: "mc_mf/mcERRN_5000.htm", title: "Natural System Error Messages 5000-5049" },
                        { url: "mc_mf/mcERRN_5050.htm", title: "Natural System Error Messages 5050-5099" },
                        { url: "mc_mf/mcERRN_5100.htm", title: "Natural System Error Messages 5100-5149" },
                        { url: "mc_mf/mcERRN_5150.htm", title: "Natural System Error Messages 5150-5199" },
                        { url: "mc_mf/mcERRN_5200.htm", title: "Natural System Error Messages 5200-5249" },
                        { url: "mc_mf/mcERRN_5250.htm", title: "Natural System Error Messages 5250-5299" },
                        { url: "mc_mf/mcERRN_5300.htm", title: "Natural System Error Messages 5300-5349" },
                        { url: "mc_mf/mcERRN_5350.htm", title: "Natural System Error Messages 5350-5399" },
                        { url: "mc_mf/mcERRN_5400.htm", title: "Natural System Error Messages 5400-5449" },
                        { url: "mc_mf/mcERRN_5450.htm", title: "Natural System Error Messages 5450-5499" },
                        { url: "mc_mf/mcERRN_5500.htm", title: "Natural System Error Messages 5500-5549" },
                        { url: "mc_mf/mcERRN_5550.htm", title: "Natural System Error Messages 5550-5599" },
                        { url: "mc_mf/mcERRN_5600.htm", title: "Natural System Error Messages 5600-5649" },
                        { url: "mc_mf/mcERRN_5650.htm", title: "Natural System Error Messages 5650-5699" },
                        { url: "mc_mf/mcERRN_5700.htm", title: "Natural System Error Messages 5700-5749" },
                        { url: "mc_mf/mcERRN_5750.htm", title: "Natural System Error Messages 5750-5799" },
                        { url: "mc_mf/mcERRN_5800.htm", title: "Natural System Error Messages 5800-5849" },
                        { url: "mc_mf/mcERRN_5850.htm", title: "Natural System Error Messages 5850-5899" },
                        { url: "mc_mf/mcERRN_5900.htm", title: "Natural System Error Messages 5900-5949" },
                        { url: "mc_mf/mcERRN_5950.htm", title: "Natural System Error Messages 5950-5999" },
                        { url: "mc_mf/mcERRN_6000.htm", title: "Natural System Error Messages 6000-6049" },
                        { url: "mc_mf/mcERRN_6050.htm", title: "Natural System Error Messages 6050-6099" },
                        { url: "mc_mf/mcERRN_6100.htm", title: "Natural System Error Messages 6100-6149" },
                        { url: "mc_mf/mcERRN_6150.htm", title: "Natural System Error Messages 6150-6199" },
                        { url: "mc_mf/mcERRN_6200.htm", title: "Natural System Error Messages 6200-6249" },
                        { url: "mc_mf/mcERRN_6250.htm", title: "Natural System Error Messages 6250-6299" },
                        { url: "mc_mf/mcERRN_6300.htm", title: "Natural System Error Messages 6300-6349" },
                        { url: "mc_mf/mcERRN_6350.htm", title: "Natural System Error Messages 6350-6399" },
                        { url: "mc_mf/mcERRN_6400.htm", title: "Natural System Error Messages 6400-6449" },
                        { url: "mc_mf/mcERRN_6450.htm", title: "Natural System Error Messages 6450-6499" },
                        { url: "mc_mf/mcERRN_6500.htm", title: "Natural System Error Messages 6500-6549" },
                        { url: "mc_mf/mcERRN_6700.htm", title: "Natural System Error Messages 6700-6749" },
                        { url: "mc_mf/mcERRN_6750.htm", title: "Natural System Error Messages 6750-6799" },
                        { url: "mc_mf/mcERRN_6800.htm", title: "Natural System Error Messages 6800-6849" },
                        { url: "mc_mf/mcERRN_6850.htm", title: "Natural System Error Messages 6850-6899" },
                        { url: "mc_mf/mcERRN_6900.htm", title: "Natural System Error Messages 6900-6949" },
                        { url: "mc_mf/mcERRN_6950.htm", title: "Natural System Error Messages 6950-6999" },
                        { url: "mc_mf/mcERRN_7000.htm", title: "Natural System Error Messages 7000-7049" },
                        { url: "mc_mf/mcERRN_7050.htm", title: "Natural System Error Messages 7050-7099" },
                        { url: "mc_mf/mcERRN_7200.htm", title: "Natural System Error Messages 7200-7249" },
                        { url: "mc_mf/mcERRN_7350.htm", title: "Natural System Error Messages 7350-7399" },
                        { url: "mc_mf/mcERRN_7400.htm", title: "Natural System Error Messages 7400-7449" },
                        { url: "mc_mf/mcERRN_7500.htm", title: "Natural System Error Messages 7500-7549" },
                        { url: "mc_mf/mcERRN_7600.htm", title: "Natural System Error Messages 7600-7649" },
                        { url: "mc_mf/mcERRN_7650.htm", title: "Natural System Error Messages 7650-7699" },
                        { url: "mc_mf/mcERRN_7700.htm", title: "Natural System Error Messages 7700-7749" },
                        { url: "mc_mf/mcERRN_7950.htm", title: "Natural System Error Messages 7950-7999" },
                        { url: "mc_mf/mcERRN_8000.htm", title: "Natural System Error Messages 8000-8049" },
                        { url: "mc_mf/mcERRN_8200.htm", title: "Natural System Error Messages 8200-8249" },
                        { url: "mc_mf/mcERRN_8250.htm", title: "Natural System Error Messages 8250-8299" },
                        { url: "mc_mf/mcERRN_8300.htm", title: "Natural System Error Messages 8300-8349" },
                        { url: "mc_mf/mcERRN_9000.htm", title: "Natural System Error Messages 9000-9049" },
                        { url: "mc_mf/mcERRN_9100.htm", title: "Natural System Error Messages 9100-9149" },
                        { url: "mc_mf/mcERRN_9200.htm", title: "Natural System Error Messages 9200-9249" },
                        { url: "mc_mf/mcERRN_9850.htm", title: "Natural System Error Messages 9850-9899" },
                        { url: "mc_mf/mcERRN_9900.htm", title: "Natural System Error Messages 9900-9949" },
                        { url: "mc_mf/mcERRN_9950.htm", title: "Natural System Error Messages 9950-9999" },
                    ]
                  },
                  { url: "mc_mf/mc_getmain.htm", title: "GETMAIN Error Numbers in NAT7545" },
                  { url: "mc_mf/mc_freemain.htm", title: "FREEMAIN Error Numbers in NAT7546" },
                  { url: "mc_mf/mc_parse_json.htm", title: "PARSE JSON: Reason Codes for Error Message NAT8331" },
                  { url: "mc_mf/mc_compres.htm", title: "Compression/Decompression Error Messages" },
                  { url: "mc_mf/mc_gbpm.htm", title: "Natural Global Buffer Pool Manager Messages" },
                  { url: "mc_mf/mc_mbp-buffer-pool.htm", title: "Message Buffer Pool Messages" },
                  { url: "mc_mf/mc_rollsrv.htm", title: "Roll Server Messages" },
                  { url: "mc_mf/mc_reason.htm", title: "Return Codes and Reason Codes of the Roll Server Requests" },
                  { url: "mc_mf/mc_asm.htm", title: "Authorized Services Manager Messages" },
                  { url: "mc_mf/mc_sip.htm", title: "SIP Service Return Codes and Reason Codes" },
                  { url: "mc_mf/mc_rpcsrv.htm", title: "RPC Server Front-End Messages" },
                  { url: "mc_mf/mc_complete.htm", title: "Natural under Com-plete/SMARTS User Abend Codes" },
                  { url: "mc_mf/mc_cics.htm", title: "Natural under CICS Messages" },
                  { url: "mc_mf/mc_nii.htm", title: "Natural under IMS TM Error Messages" },
                  { url: "mc_mf/ndb-nsq-messages.htm", title: "Static Generation Messages and Codes Issued under NDB" },
                  { url: "mc_mf/ndb-messages-fssm.htm", title: "Messages from the Shared Memory Objects File Server under NDB" },
                  { url: "mc_mf/ndb-reason-codes-fssm.htm", title: "Reason Codes for the Shared Memory Objects File Server under NDB" },
                  { url: "mc_mf/mc_nvsabc.htm", title: "Natural for VSAM Interface Abend Codes" },
                  { url: "mc_mf/mc_debug_attach_server.htm", title: "Debug Attach Server" },
              ]
            },
            { url: "nsc/nsc-over.htm", title: "Natural Security",
              tree: [
                  { url: "nsc/nsc_struct.htm", title: "Structure And Terminology Of Natural Security" },
                  { url: "nsc/nsc_platf.htm", title: "Natural Security On Different Platforms" },
                  { url: "nsc/nsc-post-install.htm", title: "First Steps After the Installation" },
                  { url: "nsc/nsc_logon.htm", title: "Logging On" },
                  { url: "nsc/nsc_way.htm", title: "Finding Your Way In Natural Security" },
                  { url: "nsc/nsc_admin.htm", title: "Administrator Services" },
                  { url: "nsc/nsc_user.htm", title: "User Maintenance" },
                  { url: "nsc/nsc_lib.htm", title: "Library Maintenance" },
                  { url: "nsc/nsc_prolib.htm", title: "Protecting Libraries" },
                  { url: "nsc/nsc_environ.htm", title: "Protecting Environments" },
                  { url: "nsc/nsc_ddmmf.htm", title: "Protecting DDMs On Mainframes" },
                  { url: "nsc/nsc_ddmos.htm", title: "Protecting DDMs On Linux And Windows" },
                  { url: "nsc/nsc_util.htm", title: "Protecting Utilities" },
                  { url: "nsc/nsc_appl.htm", title: "Protecting the Natural Development Server Environment and Applications" },
                  { url: "nsc/nsc_naturalONE.htm", title: "Protecting the Natural Development Environment in Eclipse" },
                  { url: "nsc/nsc_rpc.htm", title: "Protecting Natural RPC Servers and Services" },
                  { url: "nsc/nsc_extobj.htm", title: "Protecting External Objects" },
                  { url: "nsc/nsc_mail.htm", title: "Mailboxes" },
                  { url: "nsc/nsc_retrie.htm", title: "Retrieval" },
                  { url: "nsc/nsc_count.htm", title: "Countersignatures" },
                  { url: "nsc/nsc_func.htm", title: "Functional Security" },
                  { url: "nsc/nsc_batch.htm", title: "Natural Security In Batch Mode" },
                  { url: "nsc/nsc_transf.htm", title: "Transferring Security Data To Another System File" },
                  { url: "nsc/nsc_exits.htm", title: "User Exits" },
                  { url: "nsc/nsc_iface.htm", title: "Application Programming Interfaces" },
                  { url: "nsc/nsc_addon.htm", title: "Add-On Products and Plug-Ins" },
              ]
            },
            { url: "nsf_mf/nsf_mf-over.htm", title: "Natural SAF Security - Overview",
              tree: [
                  { url: "nsf_mf/nsf_mf_intro.htm", title: "Introducing Natural SAF Security" },
                  { url: "nsf_mf/nsf_mf_install.htm", title: "Activating Natural SAF Security" },
                  { url: "nsf_mf/nsf_mf_ext.htm", title: "Defining Resources in the External Security System and Activating Them" },
                  { url: "nsf_mf/nsf_mf_admin.htm", title: "Administrator Services" },
                  { url: "nsf_mf/nsf_mf_exits.htm", title: "Application Programming Interfaces" },
              ]
            },
            { url: "safkernel/safover.htm", title: "SAF Security Kernel",
              tree: [
                  { url: "safkernel/intro.htm", title: "Introduction" },
                  { url: "safkernel/install.htm", title: "Installation" },
                  { url: "safkernel/operator.htm", title: "Operator Commands" },
                  { url: "safkernel/SAF.htm", title: "SAF* - SAF Daemon Messages" },
                  { url: "safkernel/SEFM.htm", title: "SEFM* - ADASAF SAF Interface and SAF Security Kernel Messages" },
                  { url: "safkernel/aafmrtn.htm", title: "SAF Return Codes" },
                  { url: "safkernel/aafmfx.htm", title: "SAF Internal Function Codes" },
                  { url: "safkernel/trcmsgs.htm", title: "Interpreting Trace Messages" },
                  { url: "safkernel/secdef.htm", title: "Security Definitions" },
              ]
            },
            { url: "rpc/rpc-over.htm", title: "Natural RPC (Remote Procedure Call)",
              tree: [
                  { url: "rpc/intro_rpc.htm", title: "Introducing Natural RPC" },
                  { url: "rpc/prereq.htm", title: "Prerequisites and Preparatory Information" },
                  { url: "rpc/limits.htm", title: "Restrictions and Limitations" },
                  { url: "rpc/setup.htm", title: "Setting Up a Natural RPC Environment" },
                  { url: "rpc/start.htm", title: "Starting a Natural RPC Server" },
                  { url: "rpc/end.htm", title: "Terminating a Natural RPC Server" },
                  { url: "rpc/oper.htm", title: "Operating a Natural RPC Environment" },
                  { url: "rpc/using.htm", title: "Using a Conversational RPC" },
                  { url: "rpc/reliable_rpc.htm", title: "Reliable RPC" },
                  { url: "rpc/rds.htm", title: "Using a Remote Directory Server - RDS" },
                  { url: "rpc/securi.htm", title: "Using Security" },
                  { url: "rpc/rpc-exx-broker-support.htm", title: "EntireX Broker Support" },
                  { url: "rpc/apis.htm", title: "API for Providing an RPC Context from the Natural Client Side" },
                  { url: "rpc/rpc-api-natrpc.htm", title: "APIs for Use with Natural RPC" },
              ]
            },
            { url: "ntc/ntc-over.htm", title: "Natural Connection",
              tree: [
                  { url: "ntc/ntc-main.htm", title: "Main Functionality" },
                  { url: "ntc/ntc-prep.htm", title: "Preparing to Use Natural Connection" },
                  { url: "ntc/ntc-state.htm", title: "Natural Statements" },
                  { url: "ntc/ntc-proc.htm", title: "Processing Work Files and Nested Loops" },
              ]
            },
            { url: "naf_mf/naf_mf-over.htm", title: "Natural Advanced Facilities",
              tree: [
                  { url: "naf_mf/naf_mf_intro.htm", title: "Natural Advanced Facilities - Introduction" },
                  { url: "naf_mf/naf_mf_ad.htm", title: "NAF - Administration",
                    tree: [
                        { url: "naf_mf/naf_mf_reports.htm", title: "NAF - Reports/Queues - Function 10" },
                        { url: "naf_mf/naf_mf_devices.htm", title: "NAF - Devices - Function 11" },
                        { url: "naf_mf/naf_mf_abstracts.htm", title: "NAF - Abstracts - Function 12" },
                        { url: "naf_mf/naf_mf_applications.htm", title: "NAF - Applications - Function 13" },
                        { url: "naf_mf/naf_mf_change.htm", title: "NAF - Change Spool File - Function 14" },
                    ]
                  },
                  { url: "naf_mf/naf_mf_inf.htm", title: "NAF - Information",
                    tree: [
                        { url: "naf_mf/naf_mf_crossref.htm", title: "NAF - Cross-Reference - Function 20" },
                        { url: "naf_mf/naf_mf_statistics.htm", title: "NAF - Statistics - Function 21" },
                        { url: "naf_mf/naf_mf_lookat.htm", title: "NAF - Look at Spool File - Function 22" },
                        { url: "naf_mf/naf_mf_callnat.htm", title: "NAF - CALLNAT Handling - Function 23" },
                    ]
                  },
                  { url: "naf_mf/naf_mf_main.htm", title: "NAF - Maintenance - Overview",
                    tree: [
                        { url: "naf_mf/naf_mf_proper.htm", title: "NAF - Spool File Properties - Function 30" },
                        { url: "naf_mf/naf_mf_objects.htm", title: "NAF - Objects - Function 31 - Overview" },
                    ]
                  },
                  { url: "naf_mf/naf_mf_uprof.htm", title: "NAF - User Profile - Function 31.1" },
                  { url: "naf_mf/naf_mf_logprint.htm", title: "NAF - Logical Printer - Function 31.2" },
                  { url: "naf_mf/naf_mf_alloc.htm", title: "NAF - Allocation Table - Function 31.3" },
                  { url: "naf_mf/naf_mf_printer.htm", title: "NAF - Printer - Function 31.4" },
                  { url: "naf_mf/naf_mf_header.htm", title: "NAF - Header Page - Function 31.5" },
                  { url: "naf_mf/naf_mf_applic.htm", title: "NAF - Application - Function 31.6" },
                  { url: "naf_mf/naf_mf_cluster.htm", title: "NAF - Cluster - Function 31.7" },
                  { url: "naf_mf/naf_mf_ntcc.htm", title: "NAF - NTCC Table - Function 31.8" },
                  { url: "naf_mf/naf_mf_calendar.htm", title: "NAF - Calendar - Function 31.9" },
                  { url: "naf_mf/naf_mf_massupd.htm", title: "NAF - Mass Update - Function 32" },
                  { url: "naf_mf/naf_mf_hardcopy.htm", title: "NAF - Hardcopy Allocations - Function 33" },
                  { url: "naf_mf/naf_mf_transfer.htm", title: "NAF - Transfer Objects - Function 34" },
                  { url: "naf_mf/naf_mf_cont.htm", title: "NAF - Control Functions - Overview",
                    tree: [
                        { url: "naf_mf/naf_mf_check.htm", title: "NAF - Check Spool File - Function 40" },
                        { url: "naf_mf/naf_mf_logging.htm", title: "NAF - Logging Data - Function 41" },
                        { url: "naf_mf/naf_mf_create.htm", title: "NAF - Create Test Report - Function 42" },
                        { url: "naf_mf/naf_mf_delete.htm", title: "NAF - Delete Report by Date - Function 43" },
                    ]
                  },
                  { url: "naf_mf/naf_mf_nfea.htm", title: "NAF - Natural Features Supported" },
                  { url: "naf_mf/naf_mf_nsec.htm", title: "NAF - NATSPOOL and Natural Security" },
                  { url: "naf_mf/naf_mf_cfea.htm", title: "NAF - Features in a CICS Environment" },
                  { url: "naf_mf/naf_mf_ifea.htm", title: "NAF - Features in an IMS TM Environment" },
                  { url: "naf_mf/naf_mf_npar.htm", title: "Natural Profile Parameters for NATSPOOL" },
                  { url: "naf_mf/naf_mf_init.htm", title: "NAF - NATSPOOL Initialization" },
                  { url: "naf_mf/naf_mf_bat.htm", title: "NAF - NATSPOOL in Batch Mode" },
                  { url: "naf_mf/naf_mf_tso.htm", title: "NAF - NATSPOOL under TSO" },
              ]
            },
            { url: "sm/sm-over.htm", title: "Statements",
              tree: [
                  { url: "sm/stmt_groups.htm", title: "Statements Grouped by Function" },
                  { url: "sm/synsym.htm", title: "Syntax Symbols and Operand Definition Tables" },
                  { url: "sm/sql_use.htm", title: "Using Natural SQL Statements",
                    tree: [
                        { url: "sm/sql-common-extended-set.htm", title: "Common Set and Extended Set" },
                        { url: "sm/sql-bsi.htm", title: "Basic Syntactical Items" },
                        { url: "sm/sql-natural-view-concept.htm", title: "Natural View Concept" },
                        { url: "sm/sql-scl-expr.htm", title: "Scalar Expressions" },
                        { url: "sm/sql-search-conditions.htm", title: "Search Conditions" },
                        { url: "sm/sql-select-expressions.htm", title: "Select Expressions" },
                        { url: "sm/sql-flexible-sql.htm", title: "Flexible SQL" },
                    ]
                  },
                  { url: "sm/sm_exas.htm", title: "Referenced Example Programs" },
                  { url: "sm/accept.htm", title: "ACCEPT/REJECT" },
                  { url: "sm/add.htm", title: "ADD" },
                  { url: "sm/assign.htm", title: "ASSIGN" },
                  { url: "sm/atbreak.htm", title: "AT BREAK" },
                  { url: "sm/atenddat.htm", title: "AT END OF DATA" },
                  { url: "sm/atendpag.htm", title: "AT END OF PAGE" },
                  { url: "sm/atstart.htm", title: "AT START OF DATA" },
                  { url: "sm/attoppag.htm", title: "AT TOP OF PAGE" },
                  { url: "sm/backout.htm", title: "BACKOUT TRANSACTION" },
                  { url: "sm/before.htm", title: "BEFORE BREAK PROCESSING" },
                  { url: "sm/call.htm", title: "CALL" },
                  { url: "sm/callfile.htm", title: "CALL FILE" },
                  { url: "sm/callloop.htm", title: "CALL LOOP" },
                  { url: "sm/calldbpr-sql.htm", title: "CALLDBPROC (SQL)" },
                  { url: "sm/callnat.htm", title: "CALLNAT" },
                  { url: "sm/closecon.htm", title: "CLOSE CONVERSATION" },
                  { url: "sm/closepc.htm", title: "CLOSE PC FILE" },
                  { url: "sm/closepri.htm", title: "CLOSE PRINTER" },
                  { url: "sm/closewf.htm", title: "CLOSE WORK FILE" },
                  { url: "sm/commit-sql.htm", title: "COMMIT (SQL)" },
                  { url: "sm/compose.htm", title: "COMPOSE" },
                  { url: "sm/compress.htm", title: "COMPRESS" },
                  { url: "sm/compute.htm", title: "COMPUTE" },
                  { url: "sm/create.htm", title: "CREATE OBJECT" },
                  { url: "sm/decidefo.htm", title: "DECIDE FOR" },
                  { url: "sm/decideon.htm", title: "DECIDE ON" },
                  { url: "sm/definecl.htm", title: "DEFINE CLASS" },
                  { url: "sm/defineda.htm", title: "DEFINE DATA",
                    tree: [
                        { url: "sm/defineda_basic.htm", title: "Function and Basic Syntax Rules" },
                        { url: "sm/defineda_gda.htm", title: "Defining Global Data" },
                        { url: "sm/defineda_pda.htm", title: "Defining Parameter Data" },
                        { url: "sm/defineda_lda.htm", title: "Defining Local Data" },
                        { url: "sm/defineda_aiv.htm", title: "Defining Application-Independent Variables" },
                        { url: "sm/defineda_cv.htm", title: "Defining Context Variables for Natural RPC" },
                        { url: "sm/defineda_nxx.htm", title: "Defining NaturalX Objects" },
                        { url: "sm/defineda_vari.htm", title: "Variable Definition" },
                        { url: "sm/defineda_view.htm", title: "View Definition" },
                        { url: "sm/defineda_redef.htm", title: "Redefinition" },
                        { url: "sm/defineda_array.htm", title: "Array Dimension Definition" },
                        { url: "sm/defineda_iniv.htm", title: "Initial-Value Definition" },
                        { url: "sm/defineda_inia.htm", title: "Initial/Constant Values for an Array" },
                        { url: "sm/defineda_parms.htm", title: "EM, HD, PM Parameters for Field/Variable" },
                        { url: "sm/defineda_exa.htm", title: "Examples of DEFINE DATA Statement Usage" },
                    ]
                  },
                  { url: "sm/definefu.htm", title: "DEFINE FUNCTION" },
                  { url: "sm/definepr_m.htm", title: "DEFINE PRINTER" },
                  { url: "sm/definepro.htm", title: "DEFINE PROTOTYPE" },
                  { url: "sm/definesu.htm", title: "DEFINE SUBROUTINE" },
                  { url: "sm/definewi.htm", title: "DEFINE WINDOW" },
                  { url: "sm/definewo.htm", title: "DEFINE WORK FILE" },
                  { url: "sm/delete.htm", title: "DELETE" },
                  { url: "sm/delete-sql.htm", title: "DELETE (SQL)" },
                  { url: "sm/display.htm", title: "DISPLAY" },
                  { url: "sm/divide.htm", title: "DIVIDE" },
                  { url: "sm/dodoend.htm", title: "DO/DOEND" },
                  { url: "sm/download.htm", title: "DOWNLOAD PC FILE" },
                  { url: "sm/eject.htm", title: "EJECT" },
                  { url: "sm/end.htm", title: "END" },
                  { url: "sm/endtrans.htm", title: "END TRANSACTION" },
                  { url: "sm/escape.htm", title: "ESCAPE" },
                  { url: "sm/examine.htm", title: "EXAMINE" },
                  { url: "sm/expand.htm", title: "EXPAND" },
                  { url: "sm/fetch.htm", title: "FETCH" },
                  { url: "sm/find.htm", title: "FIND" },
                  { url: "sm/for.htm", title: "FOR" },
                  { url: "sm/format.htm", title: "FORMAT" },
                  { url: "sm/get.htm", title: "GET" },
                  { url: "sm/getsame.htm", title: "GET SAME" },
                  { url: "sm/gettrans.htm", title: "GET TRANSACTION DATA" },
                  { url: "sm/histogra.htm", title: "HISTOGRAM" },
                  { url: "sm/if.htm", title: "IF" },
                  { url: "sm/ifselec.htm", title: "IF SELECTION" },
                  { url: "sm/ignore.htm", title: "IGNORE" },
                  { url: "sm/include.htm", title: "INCLUDE" },
                  { url: "sm/input.htm", title: "INPUT",
                    tree: [
                        { url: "sm/input1.htm", title: "INPUT Syntax 1 - Dynamic Screen Layout Specification" },
                        { url: "sm/input2.htm", title: "INPUT Syntax 2 - Using Predefined Map Layout" },
                    ]
                  },
                  { url: "sm/insert-sql.htm", title: "INSERT (SQL)" },
                  { url: "sm/interfa.htm", title: "INTERFACE" },
                  { url: "sm/limit.htm", title: "LIMIT" },
                  { url: "sm/loop.htm", title: "LOOP" },
                  { url: "sm/merge-sql.htm", title: "MERGE (SQL)" },
                  { url: "sm/method.htm", title: "METHOD" },
                  { url: "sm/move.htm", title: "MOVE" },
                  { url: "sm/moveindx.htm", title: "MOVE INDEXED" },
                  { url: "sm/multiply.htm", title: "MULTIPLY" },
                  { url: "sm/newpage.htm", title: "NEWPAGE" },
                  { url: "sm/obtain.htm", title: "OBTAIN" },
                  { url: "sm/onerror.htm", title: "ON ERROR" },
                  { url: "sm/opencon.htm", title: "OPEN CONVERSATION" },
                  { url: "sm/options.htm", title: "OPTIONS" },
                  { url: "sm/parse_json.htm", title: "PARSE JSON" },
                  { url: "sm/parse.htm", title: "PARSE XML" },
                  { url: "sm/passw.htm", title: "PASSW" },
                  { url: "sm/perform.htm", title: "PERFORM" },
                  { url: "sm/performb.htm", title: "PERFORM BREAK PROCESSING" },
                  { url: "sm/printsm.htm", title: "PRINT" },
                  { url: "sm/process.htm", title: "PROCESS" },
                  { url: "sm/processc.htm", title: "PROCESS COMMAND" },
                  { url: "sm/processpage.htm", title: "PROCESS PAGE" },
                  { url: "sm/process-sql.htm", title: "PROCESS SQL (SQL)" },
                  { url: "sm/property.htm", title: "PROPERTY" },
                  { url: "sm/read.htm", title: "READ" },
                  { url: "sm/read-result-set-sql.htm", title: "READ RESULT SET (SQL)" },
                  { url: "sm/readwork.htm", title: "READ WORK FILE" },
                  { url: "sm/readlob.htm", title: "READLOB" },
                  { url: "sm/redefine.htm", title: "REDEFINE" },
                  { url: "sm/reduce.htm", title: "REDUCE" },
                  { url: "sm/reinput.htm", title: "REINPUT" },
                  { url: "sm/reject.htm", title: "REJECT" },
                  { url: "sm/release.htm", title: "RELEASE" },
                  { url: "sm/repeat.htm", title: "REPEAT" },
                  { url: "sm/reqdocu.htm", title: "REQUEST DOCUMENT" },
                  { url: "sm/reset.htm", title: "RESET" },
                  { url: "sm/resize.htm", title: "RESIZE" },
                  { url: "sm/rollback-sql.htm", title: "ROLLBACK (SQL)" },
                  { url: "sm/retry.htm", title: "RETRY" },
                  { url: "sm/run.htm", title: "RUN" },
                  { url: "sm/select-sql.htm", title: "SELECT (SQL)" },
                  { url: "sm/sendmeth.htm", title: "SEND METHOD" },
                  { url: "sm/separate.htm", title: "SEPARATE" },
                  { url: "sm/setcontr.htm", title: "SET CONTROL" },
                  { url: "sm/setgloba.htm", title: "SET GLOBALS" },
                  { url: "sm/setkey.htm", title: "SET KEY" },
                  { url: "sm/settime.htm", title: "SET TIME" },
                  { url: "sm/setwindo.htm", title: "SET WINDOW" },
                  { url: "sm/skip.htm", title: "SKIP" },
                  { url: "sm/sort.htm", title: "SORT" },
                  { url: "sm/stack.htm", title: "STACK" },
                  { url: "sm/stop.htm", title: "STOP" },
                  { url: "sm/store.htm", title: "STORE" },
                  { url: "sm/subtract.htm", title: "SUBTRACT" },
                  { url: "sm/suspend.htm", title: "SUSPEND IDENTICAL SUPPRESS" },
                  { url: "sm/terminat.htm", title: "TERMINATE" },
                  { url: "sm/update.htm", title: "UPDATE" },
                  { url: "sm/update-sql.htm", title: "UPDATE (SQL)" },
                  { url: "sm/updatelob.htm", title: "UPDATELOB" },
                  { url: "sm/upload.htm", title: "UPLOAD PC FILE" },
                  { url: "sm/write.htm", title: "WRITE" },
                  { url: "sm/writeti.htm", title: "WRITE TITLE" },
                  { url: "sm/writetra.htm", title: "WRITE TRAILER" },
                  { url: "sm/writewor.htm", title: "WRITE WORK FILE" },
              ]
            },
            { url: "func/func-over.htm", title: "System Functions",
              tree: [
                  { url: "func/func_sf.htm", title: "Natural System Functions for Use in Processing Loops" },
                  { url: "func/func_math.htm", title: "Mathematical System Functions" },
                  { url: "func/func_string.htm", title: "Miscellaneous System Functions",
                    tree: [
                        { url: "func/func_mval.htm", title: "*MINVAL/*MAXVAL - Evaluate the Minimum/Maximum" },
                        { url: "func/func_transl.htm", title: "*TRANSLATE - Translate to Lower/Upper Case Characters" },
                        { url: "func/func_trim.htm", title: "*TRIM - Remove Leading and/or Trailing Blanks" },
                        { url: "func/func_pos.htm", title: "POS - Field Identification Function" },
                        { url: "func/func_ret.htm", title: "RET - Return Code Function" },
                        { url: "func/func_sortk.htm", title: "SORTKEY - Sort-Key Function" },
                    ]
                  },
                  { url: "func/func_function_objects.htm", title: "Functions Supplied as Natural Objects" },
              ]
            },
            { url: "vari/vari-over.htm", title: "System Variables",
              tree: [
                  { url: "vari/appl.htm", title: "Application-Related System Variables" },
                  { url: "vari/dtime.htm", title: "Date and Time System Variables" },
                  { url: "vari/inout.htm", title: "Input/Output-Related System Variables" },
                  { url: "vari/json.htm", title: "JSON-Related System Variables" },
                  { url: "vari/natenv.htm", title: "Natural Environment-Related System Variables" },
                  { url: "vari/sysenv.htm", title: "System Environment-Related System Variables" },
                  { url: "vari/xml.htm", title: "XML-Related System Variables" },
              ]
            },
            { url: "tcom/tcom-over.htm", title: "Terminal Commands",
              tree: [
                  { url: "tcom/tcomintro.htm", title: "Introduction to Terminal Commands" },
                  { url: "tcom/tcomfu.htm", title: "Terminal Commands Grouped by Function" },
                  { url: "tcom/keys.htm", title: "Terminal Command Key Assignments" },
                  { url: "tcom/pc.htm", title: "% - Continuation Indicator for INPUT in Batch" },
                  { url: "tcom/pcpc.htm", title: "%% and %. - Interrupt Current Operation" },
                  { url: "tcom/pcast.htm", title: "%* - Inhibit Character Display" },
                  { url: "tcom/pcdotp.htm", title: "%.P - Delete First Entry from Stack" },
                  { url: "tcom/pcdots.htm", title: "%.S - Read Stack Entry without Deleting it" },
                  { url: "tcom/pcslash.htm", title: "%/ - End-of-File" },
                  { url: "tcom/pcplus.htm", title: "%+ and %- - Enable/Disable Use of Natural Connection" },
                  { url: "tcom/pcltrdc.htm", title: "%&lt;RDC+ and %&lt;RDC- - Activate/Deactivate Trace Recording" },
                  { url: "tcom/pctech.htm", title: "%&lt;TECH - Display Technical Information" },
                  { url: "tcom/pctest.htm", title: "%&lt;TEST - Invoke the Debugger" },
                  { url: "tcom/pceq.htm", title: "%= - Assigning Colors to Fields" },
                  { url: "tcom/pca.htm", title: "%A - Play Back a Recording" },
                  { url: "tcom/pcb.htm", title: "%B - Activate/Deactivate a Recording" },
                  { url: "tcom/pcbeq.htm", title: "%B= - Specify Library for a Recording" },
                  { url: "tcom/pcc.htm", title: "%C - Copying Contents of Page Buffer" },
                  { url: "tcom/pccs.htm", title: "%CS and %CC - Copying Data to Stack or *COM" },
                  { url: "tcom/pcd.htm", title: "%D - Activate Keyword/Delimiter Mode" },
                  { url: "tcom/pcdeq.htm", title: "%D= - Control of Outlining" },
                  { url: "tcom/pcdue.htm", title: "%DUE - Dump for Specific Error" },
                  { url: "tcom/pce.htm", title: "%E - Display Screen Captures" },
                  { url: "tcom/pceeq.htm", title: "%E= - Activate/Deactivate Error Processing" },
                  { url: "tcom/pcf.htm", title: "%F - Activate Forms/Screen Mode" },
                  { url: "tcom/pcfeq.htm", title: "%F= - Frame Characters for Window" },
                  { url: "tcom/pcfm.htm", title: "%FM - Numeric Edit Mask Free Mode" },
                  { url: "tcom/pcg.htm", title: "%G - Set Playback Mode for a Recording" },
                  { url: "tcom/pch.htm", title: "%H - Hardcopy Output" },
                  { url: "tcom/pci.htm", title: "%I - Capture Current Screen" },
                  { url: "tcom/pcj.htm", title: "%J - Invoke Helproutine" },
                  { url: "tcom/pckp.htm", title: "%K and %KP - Simulate PF- and PA-Key" },
                  { url: "tcom/pcl.htm", title: "%L - Disable Lower- to Upper-Case Translation" },
                  { url: "tcom/pcleq.htm", title: "%L= - Set Language Code" },
                  { url: "tcom/pcm.htm", title: "%M - Control of Message Line" },
                  { url: "tcom/pcmsg.htm", title: "%MSGSF - Display System Error Messages in Full" },
                  { url: "tcom/pcn.htm", title: "%N - Activate Non-Conversational Mode" },
                  { url: "tcom/pco.htm", title: "%O - Deactivate Screen Capturing" },
                  { url: "tcom/pcp.htm", title: "%P - Capture Screen Sequence" },
                  { url: "tcom/pcpeq.htm", title: "%P= - CALL Options" },
                  { url: "tcom/pcq.htm", title: "%Q - Suppress Next Input" },
                  { url: "tcom/pcqo.htm", title: "%QO - Suppress Pseudo-Conversational Output" },
                  { url: "tcom/pcqs.htm", title: "%QS - Simultaneous Output of Multiple Screens" },
                  { url: "tcom/pcr.htm", title: "%R - Repeat INPUT Statement" },
                  { url: "tcom/pcrm.htm", title: "%RM - Protection of Light Pen Sensitive Fields" },
                  { url: "tcom/pcrn.htm", title: "%RN - Suppress Compression of Screen Data" },
                  { url: "tcom/pcro.htm", title: "%RO - Activate/Deactivate Screen Optimization" },
                  { url: "tcom/pcs.htm", title: "%S - Resume Screen Capturing" },
                  { url: "tcom/pct.htm", title: "%T - Position Cursor to Top of Active Window" },
                  { url: "tcom/pctll.htm", title: "%Tll/cc - Position Cursor to Line ll, Column cc" },
                  { url: "tcom/pctast.htm", title: "%T* - Position Cursor Outside Window" },
                  { url: "tcom/pcteq.htm", title: "%T= - Activate Converter Routine for Device Type" },
                  { url: "tcom/pctre.htm", title: "%TRE - Activate/Deactivate External Trace" },
                  { url: "tcom/pctri.htm", title: "%TRI - Activate/Deactivate Internal Trace" },
                  { url: "tcom/pcu.htm", title: "%U - Translate Lower to Upper Case" },
                  { url: "tcom/pcv.htm", title: "%V - Control of Print Mode" },
                  { url: "tcom/pcw.htm", title: "%W - Window Processing" },
                  { url: "tcom/pcx.htm", title: "%X - Control of Infoline" },
                  { url: "tcom/pcy.htm", title: "%Y - Control of PF-Key Lines" },
                  { url: "tcom/pcz.htm", title: "%Z - Clear Source Area" },
              ]
            },
            { url: "parms/parms-over.htm", title: "Parameter Reference",
              tree: [
                  { url: "parms/pp_intro.htm", title: "Introduction to Profile Parameters" },
                  { url: "parms/sp_intro.htm", title: "Introduction to Session Parameters" },
                  { url: "parms/parms_summary.htm", title: "Profile Parameters Grouped by Category" },
                  { url: "parms/ablog.htm", title: "ABLOG – Log Program Execution Errors" },
                  { url: "parms/sp_ad.htm", title: "AD - Attribute Definition" },
                  { url: "parms/adaacbx.htm", title: "ADAACBX – Use of the Extended Adabas Control Block" },
                  { url: "parms/adamode.htm", title: "ADAMODE - Adabas Call Interface Mode" },
                  { url: "parms/adaname.htm", title: "ADANAME - Name of Adabas Link Routine" },
                  { url: "parms/ADAPRM.htm", title: "ADAPRM - Adabas Review Support" },
                  { url: "parms/adasbv.htm", title: "ADASBV - Adabas Security by Setting" },
                  { url: "parms/sp_al.htm", title: "AL - Alphanumeric Length for Output" },
                  { url: "parms/asize.htm", title: "ASIZE - Entire System Server Auxiliary Buffer" },
                  { url: "parms/aspsize.htm", title: "ASPSIZE - Work Area Size of Adabas Stored Procedures and Triggers" },
                  { url: "parms/attn.htm", title: "ATTN - Attention Key Interrupt Support" },
                  { url: "parms/auto.htm", title: "AUTO - Automatic Logon" },
                  { url: "parms/bp82.htm", title: "BP82 - Buffer Pool Placeholder when Object not Found" },
                  { url: "parms/bpc64.htm", title: "BPC64 - Buffer Pool Cache Storage Type" },
                  { url: "parms/bpcsize.htm", title: "BPCSIZE - Cache Size for Natural Buffer Pool" },
                  { url: "parms/bpi.htm", title: "BPI - Buffer Pool Initialization" },
                  { url: "parms/bplist.htm", title: "BPLIST - Name of Preload List for Natural Buffer Pool" },
                  { url: "parms/bpmeth.htm", title: "BPMETH - Buffer Pool Space Search Algorithm" },
                  { url: "parms/bpname.htm", title: "BPNAME - Name of Natural Global Buffer Pool" },
                  { url: "parms/bpprop.htm", title: "BPPROP - Global Buffer Pool Propagation" },
                  { url: "parms/bpsfi.htm", title: "BPSFI - Object Search First in Buffer Pool" },
                  { url: "parms/bpsize.htm", title: "BPSIZE - Size of Natural Local Buffer Pool" },
                  { url: "parms/bptext.htm", title: "BPTEXT - Size of Text Segments in Natural Buffer Pool" },
                  { url: "parms/bsize.htm", title: "BSIZE - Size of EntireX Broker Buffer" },
                  { url: "parms/sp_bx.htm", title: "BX - Box Definition" },
                  { url: "parms/cancel.htm", title: "CANCEL - Session Cancellation with Dump" },
                  { url: "parms/cc.htm", title: "CC - Error Processing in Batch Mode" },
                  { url: "parms/cchar.htm", title: "CCHAR - Allow Output Control Characters" },
                  { url: "parms/cctab.htm", title: "CCTAB - Printer Escape Sequence Definition" },
                  { url: "parms/sp_cd.htm", title: "CD - Color Definition" },
                  { url: "parms/cdynam.htm", title: "CDYNAM - Dynamic Loading of Non-Natural Programs" },
                  { url: "parms/cf.htm", title: "CF - Character for Terminal Commands" },
                  { url: "parms/cficu.htm", title: "CFICU - Unicode and Code Page Support" },
                  { url: "parms/cfwsize.htm", title: "CFWSIZE (Internal Use)" },
                  { url: "parms/cicsp.htm", title: "CICSP - Environment Parameters for Natural CICS Interface" },
                  { url: "parms/clear.htm", title: "CLEAR - Processing of CLEAR Key in NEXT Mode" },
                  { url: "parms/cm.htm", title: "CM - Command Mode" },
                  { url: "parms/cmpo.htm", title: "CMPO - Compilation Options" },
                  { url: "parms/cmpr.htm", title: "CMPR - General Default Compression Optimization Algorithm" },
                  { url: "parms/comp.htm", title: "COMP - Parameters for Natural Com-plete/SMARTS Interface" },
                  { url: "parms/cp.htm", title: "CP - Default Code Page Name" },
                  { url: "parms/cpcverr.htm", title: "CPCVERR - Code Page Conversion Error" },
                  { url: "parms/cpobjin.htm", title: "CPOBJIN - Code Page of Batch Input File" },
                  { url: "parms/cpprint.htm", title: "CPPRINT - Code Page of Batch Output File" },
                  { url: "parms/cpsynin.htm", title: "CPSYNIN - Code Page of Batch Input File for Commands" },
                  { url: "parms/csize.htm", title: "CSIZE - Size of Con-nect/Con-form Buffer Area" },
                  { url: "parms/cstatic.htm", title: "CSTATIC - Statically Linked Modules" },
                  { url: "parms/sp_cv.htm", title: "CV - Attribute Control Variable" },
                  { url: "parms/cvmin.htm", title: "CVMIN - Control Variable Modified at Input" },
                  { url: "parms/datsize.htm", title: "DATSIZE - Minimum Size of Buffer for Local Data" },
                  { url: "parms/db.htm", title: "DB - Database Types and Options" },
                  { url: "parms/db2.htm", title: "DB2 - Parameters for SQL Database Management Interfaces" },
                  { url: "parms/db2size.htm", title: "DB2SIZE - Natural Buffer Area for Db2" },
                  { url: "parms/dbclose.htm", title: "DBCLOSE - Database Close at Session End" },
                  { url: "parms/dbgat.htm", title: "DBGAT - Debug Attach Server for NaturalONE" },
                  { url: "parms/dbgerr.htm", title: "DBGERR - Automatic Start of Debugger at Runtime Error" },
                  { url: "parms/dbid.htm", title: "DBID - Default Database ID for Natural System Files" },
                  { url: "parms/dbopen.htm", title: "DBOPEN - Database Open without ETID" },
                  { url: "parms/dbroll.htm", title: "DBROLL - Database Calls before Session Suspension" },
                  { url: "parms/dbupd.htm", title: "DBUPD - Database Updating" },
                  { url: "parms/dc.htm", title: "DC - Character for Decimal Point Notation" },
                  { url: "parms/dd.htm", title: "DD - Day Differential" },
                  { url: "parms/delete.htm", title: "DELETE - Deletion of Dynamically Loaded Programs" },
                  { url: "parms/sp_df.htm", title: "DF - Date Format" },
                  { url: "parms/dfout.htm", title: "DFOUT - Date Format for Output" },
                  { url: "parms/dfstack.htm", title: "DFSTACK - Date Format for Stack" },
                  { url: "parms/dftitle.htm", title: "DFTITLE - Output Format of Date in Standard Report Title" },
                  { url: "parms/sp_dl.htm", title: "DL - Display Length for Output" },
                  { url: "parms/do.htm", title: "DO - Display Order of Output Data" },
                  { url: "parms/ds.htm", title: "DS - Define Size of Storage Buffer" },
                  { url: "parms/dsc.htm", title: "DSC - Data-Stream Compression (for 3270-Type Terminals)" },
                  { url: "parms/dsize.htm", title: "DSIZE - Size of DBLOG Buffer" },
                  { url: "parms/dtform.htm", title: "DTFORM - Date Format" },
                  { url: "parms/du.htm", title: "DU - Dump Generation" },
                  { url: "parms/due.htm", title: "DUE - Dump Generation, Error-Specific" },
                  { url: "parms/sp_dy.htm", title: "DY - Dynamic Attributes" },
                  { url: "parms/dynparm.htm", title: "DYNPARM - Control Use of Dynamic Parameters" },
                  { url: "parms/echo.htm", title: "ECHO - Control Printing of Batch Input Data" },
                  { url: "parms/edbp.htm", title: "EDBP - Software AG Editor Buffer Pool Definitions" },
                  { url: "parms/edpsize.htm", title: "EDPSIZE - Size of Software AG Editor Auxiliary Buffer Pool" },
                  { url: "parms/ej.htm", title: "EJ - Page Eject" },
                  { url: "parms/sp_em.htm", title: "EM - Edit Mask" },
                  { url: "parms/emfm.htm", title: "EMFM - Edit Mask Free Mode" },
                  { url: "parms/sp_emu.htm", title: "EMU - Unicode Edit Mask" },
                  { url: "parms/endbt.htm", title: "ENDBT - BACKOUT TRANSACTION at Session End" },
                  { url: "parms/endmsg.htm", title: "ENDMSG - Display Session-End Message" },
                  { url: "parms/sp_es.htm", title: "ES - Empty Line Suppression" },
                  { url: "parms/escape.htm", title: "ESCAPE - Ignore Terminal Commands %% and %." },
                  { url: "parms/esize.htm", title: "ESIZE - Size of User-Buffer Extension Area" },
                  { url: "parms/et.htm", title: "ET - Execution of END/BACKOUT TRANSACTION Statements" },
                  { url: "parms/eta.htm", title: "ETA - Error Transaction Program" },
                  { url: "parms/etdb.htm", title: "ETDB - Database for Transaction Data" },
                  { url: "parms/eteop.htm", title: "ETEOP - Issue END TRANSACTION at End of Program" },
                  { url: "parms/etid.htm", title: "ETID - Adabas User Identification" },
                  { url: "parms/etio.htm", title: "ETIO - Issue END TRANSACTION upon Terminal I/O" },
                  { url: "parms/etrace.htm", title: "ETRACE - External Trace Function" },
                  { url: "parms/etsync.htm", title: "ETSYNC - Issue Syncpoint upon End of Transaction/Backout Transaction" },
                  { url: "parms/excsize.htm", title: "EXCSIZE - Size of Buffer for Natural Expert C Interface" },
                  { url: "parms/exrsize.htm", title: "EXRSIZE - Size of Buffer for Natural Expert Rule Tables" },
                  { url: "parms/famstd.htm", title: "FAMSTD - Overwriting of Print and Work File Access Method Assignments" },
                  { url: "parms/fc.htm", title: "FC - Filler Character for INPUT Statement" },
                  { url: "parms/sp_fc.htm", title: "FC - Filler Character for DISPLAY Statement" },
                  { url: "parms/fcdp.htm", title: "FCDP - Filler Character for Dynamically Protected Input Fields" },
                  { url: "parms/fdic.htm", title: "FDIC - Predict System File" },
                  { url: "parms/sp_fl.htm", title: "FL - Floating Point Mantissa Length" },
                  { url: "parms/fnat.htm", title: "FNAT - Natural System File for System Programs" },
                  { url: "parms/fnr.htm", title: "FNR - Default File Number of Natural System Files" },
                  { url: "parms/fprof.htm", title: "FPROF - Natural System File for Parameter Profiles" },
                  { url: "parms/freegda.htm", title: "FREEGDA - Release GDA in Utility Mode" },
                  { url: "parms/freg.htm", title: "FREG - Natural Registry System File" },
                  { url: "parms/fs.htm", title: "FS - Default Format/Length Setting for User-Defined Variables" },
                  { url: "parms/fsec.htm", title: "FSEC - Natural Security System File" },
                  { url: "parms/fsize.htm", title: "FSIZE (Internal Use)" },
                  { url: "parms/fspool.htm", title: "FSPOOL - Natural Advanced Facilities Spool File" },
                  { url: "parms/fuser.htm", title: "FUSER - Natural System File for User Programs" },
                  { url: "parms/sp_gc.htm", title: "GC - Filler Character for Group Headers" },
                  { url: "parms/sp_hc.htm", title: "HC - Header Centering" },
                  { url: "parms/hcam.htm", title: "HCAM - Hardcopy Access Method" },
                  { url: "parms/hcdest.htm", title: "HCDEST - Hardcopy Output Destination" },
                  { url: "parms/sp_hd.htm", title: "HD - Header Definition" },
                  { url: "parms/sp_he.htm", title: "HE - Helproutine" },
                  { url: "parms/hi.htm", title: "HI - Help Character" },
                  { url: "parms/sp_hw.htm", title: "HW - Heading Width" },
                  { url: "parms/ia.htm", title: "IA - Input Assign Character" },
                  { url: "parms/sp_ic.htm", title: "IC - Insertion Character" },
                  { url: "parms/sp_icu.htm", title: "ICU - Unicode Insertion Character" },
                  { url: "parms/id.htm", title: "ID - Input Delimiter Character" },
                  { url: "parms/ikey.htm", title: "IKEY - Processing of PA and PF Keys" },
                  { url: "parms/im.htm", title: "IM - Input Mode" },
                  { url: "parms/imsg.htm", title: "IMSG - Session Initialization Error Messages" },
                  { url: "parms/imsp.htm", title: "IMSP - General Parameters for Natural IMS TM Interface" },
                  { url: "parms/imspe.htm", title: "IMSPE - Environment Parameters for Natural IMS TM Interface" },
                  { url: "parms/imspt.htm", title: "IMSPT - Transaction Definitions for Natural IMS TM Interface" },
                  { url: "parms/intens.htm", title: "INTENS - Printing of Intensified Fields" },
                  { url: "parms/sp_ip.htm", title: "IP - INPUT Prompting Text" },
                  { url: "parms/sp_is.htm", title: "IS - Identical Suppress" },
                  { url: "parms/isize.htm", title: "ISIZE - Size of Initialization Buffer" },
                  { url: "parms/iterm.htm", title: "ITERM - Session Termination in Case of Initialization Error" },
                  { url: "parms/itrace.htm", title: "ITRACE - Internal Trace Function" },
                  { url: "parms/sp_kd.htm", title: "KD - Key Definition" },
                  { url: "parms/key.htm", title: "KEY - Setting Assignments to PA, PF and CLEAR Keys" },
                  { url: "parms/lc.htm", title: "LC - Lower to Upper Case Translation" },
                  { url: "parms/sp_lc.htm", title: "LC - Leading Characters" },
                  { url: "parms/sp_lcu.htm", title: "LCU - Unicode Leading Characters" },
                  { url: "parms/le.htm", title: "LE - Reaction when Limit for Processing Loop Exceeded" },
                  { url: "parms/lfile.htm", title: "LFILE - Logical System File Definition" },
                  { url: "parms/libnam.htm", title: "LIBNAM - Name of External Program Load Library" },
                  { url: "parms/log.htm", title: "LOG (Internal Use)" },
                  { url: "parms/ls.htm", title: "LS - Line Size" },
                  { url: "parms/lt.htm", title: "LT - Limit for Processing Loops" },
                  { url: "parms/madio.htm", title: "MADIO - Maximum DBMS Calls between Screen I/O Operations" },
                  { url: "parms/mainpr.htm", title: "MAINPR - Override Default Output Report Number" },
                  { url: "parms/maxcl.htm", title: "MAXCL - Maximum Number of Program Calls" },
                  { url: "parms/maxroll.htm", title: "MAXROLL - Number of CMROLL Calls before Session Suspension" },
                  { url: "parms/maxyear.htm", title: "MAXYEAR - Maximum Year for Date/Time Values" },
                  { url: "parms/sp_mc.htm", title: "MC - Multiple-Value Field Count" },
                  { url: "parms/menu.htm", title: "MENU - Menu Mode" },
                  { url: "parms/ml.htm", title: "ML - Position of Message Line" },
                  { url: "parms/monsize.htm", title: "MONSIZE - Size of SYSTP Monitor Buffer" },
                  { url: "parms/mp.htm", title: "MP - Maximum Number of Pages of a Report" },
                  { url: "parms/sp_ms.htm", title: "MS - Manual Skip" },
                  { url: "parms/msgsf.htm", title: "MSGSF - Display System Error Messages in Short/Full Format" },
                  { url: "parms/mt.htm", title: "MT - Maximum CPU Time" },
                  { url: "parms/nafsize.htm", title: "NAFSIZE - Size of Buffer for Natural Advanced Facilities" },
                  { url: "parms/nafupf.htm", title: "NAFUPF - Natural Advanced Facilities User Profile" },
                  { url: "parms/nc.htm", title: "NC - Use of Natural System Commands" },
                  { url: "parms/nisn.htm", title: "NISN (Internal Use)" },
                  { url: "parms/sp_nl.htm", title: "NL - Numeric Length for Output" },
                  { url: "parms/nucname.htm", title: "NUCNAME - Name of Environment-Independent Nucleus" },
                  { url: "parms/objin.htm", title: "OBJIN - Use of CMOBJIN as Natural Input File" },
                  { url: "parms/opf.htm", title: "OPF - Overwriting of Protected Fields by Helproutines" },
                  { url: "parms/oprb.htm", title: "OPRB - Database Open/Close Processing" },
                  { url: "parms/opt.htm", title: "OPT - Control of Natural Optimizer Compiler" },
                  { url: "parms/osp.htm", title: "OSP - Parameters for z/OS Batch" },
                  { url: "parms/outdest.htm", title: "OUTDEST - Output Destination for Asynchronous Processing" },
                  { url: "parms/ovsize.htm", title: "OVSIZE - Storage Thread Overflow Size" },
                  { url: "parms/parm.htm", title: "PARM - Alternative Parameter Module" },
                  { url: "parms/pc.htm", title: "PC - Control of Personal-Computer Access Method" },
                  { url: "parms/sp_pc.htm", title: "PC - Periodic Group Count" },
                  { url: "parms/pcntrl.htm", title: "PCNTRL - Print-Control Characters" },
                  { url: "parms/pd.htm", title: "PD - Limit of Pages for NATPAGE" },
                  { url: "parms/pdpsize.htm", title: "PDPSIZE - Size of the Profiler Data Pool" },
                  { url: "parms/peck.htm", title: "PECK - PCHECK/ECHECK Error Processing" },
                  { url: "parms/pgp.htm", title: "PGP - Properties for External Programs" },
                  { url: "parms/plog.htm", title: "PLOG - Logging of Dynamic Parameters" },
                  { url: "parms/pm.htm", title: "PM - Print Mode" },
                  { url: "parms/print.htm", title: "PRINT - Print File Assignments" },
                  { url: "parms/profile.htm", title: "PROFILE - Apply Parameter Profile" },
                  { url: "parms/program.htm", title: "PROGRAM - Non-Natural Program Receiving Control after Termination" },
                  { url: "parms/ps.htm", title: "PS - Page Size for Natural Reports" },
                  { url: "parms/pseudo.htm", title: "PSEUDO - CICS Pseudo-Conversational Mode" },
                  { url: "parms/rca.htm", title: "RCA - Resolve Addresses of Statically Linked Modules" },
                  { url: "parms/rcalias.htm", title: "RCALIAS - External Name Definition for Statically Linked Modules" },
                  { url: "parms/rcfind.htm", title: "RCFIND - Handling of Response Code 113 for FIND Statement" },
                  { url: "parms/rcget.htm", title: "RCGET - Handling of Response Code 113 for GET Statement" },
                  { url: "parms/rdact.htm", title: "RDACT - (Internal Use)" },
                  { url: "parms/rdc.htm", title: "RDC - Configure the Natural Data Collector" },
                  { url: "parms/rdcexit.htm", title: "RDCEXIT - Define Natural Data Collector User Exits" },
                  { url: "parms/rdcsize.htm", title: "RDCSIZE - Size of Buffer for the Natural Data Collector" },
                  { url: "parms/rdnode.htm", title: "RDNODE - (Internal Use)" },
                  { url: "parms/rdport.htm", title: "RDPORT - (Internal Use)" },
                  { url: "parms/recat.htm", title: "RECAT - Dynamic Recataloging" },
                  { url: "parms/reinp.htm", title: "REINP - Issue Internal REINPUT Statement for Invalid Data" },
                  { url: "parms/relo.htm", title: "RELO - Storage Thread Relocation" },
                  { url: "parms/rfile.htm", title: "RFILE - File for Recordings" },
                  { url: "parms/ri.htm", title: "RI - Release ISNs" },
                  { url: "parms/rjesize.htm", title: "RJESIZE - Initial Size of NATRJE Buffer" },
                  { url: "parms/rm.htm", title: "RM - Retransmit Modified Fields" },
                  { url: "parms/rnconst.htm", title: "RNCONST - Renumber Line Numbers in Constants" },
                  { url: "parms/rosy.htm", title: "ROSY - Read-Only Access to System Files" },
                  { url: "parms/rpc_settings.htm", title: "RPC - Remote-Procedure-Call Settings" },
                  { url: "parms/runsize.htm", title: "RUNSIZE - Size of Runtime Buffer" },
                  { url: "parms/sa.htm", title: "SA - Sound Terminal Alarm" },
                  { url: "parms/sp_sb.htm", title: "SB - Selection Box" },
                  { url: "parms/sctab.htm", title: "SCTAB - Scanner Characters" },
                  { url: "parms/sender.htm", title: "SENDER - Screen Output Destination for Asynchronous Processing" },
                  { url: "parms/sf.htm", title: "SF - Spacing Factor" },
                  { url: "parms/sp_sg.htm", title: "SG - Sign Position" },
                  { url: "parms/shape.htm", title: "SHAPED - Control of Character Shaping" },
                  { url: "parms/skey.htm", title: "SKEY - Storage Key for Program Execution" },
                  { url: "parms/sl.htm", title: "SL - Source Line Length" },
                  { url: "parms/slock.htm", title: "SLOCK - Source Locking" },
                  { url: "parms/sm.htm", title: "SM - Programming in Structured Mode" },
                  { url: "parms/sort.htm", title: "SORT - Control of Sort Program" },
                  { url: "parms/sosi.htm", title: "SOSI - Shift-Out/Shift-In Codes for Double-Byte Character Set" },
                  { url: "parms/sretain.htm", title: "SRETAIN - Retain Source Format" },
                  { url: "parms/ssize.htm", title: "SSIZE - Size of Source Area Allocated by the Editors" },
                  { url: "parms/stack.htm", title: "STACK - Place Data/Commands on the Stack" },
                  { url: "parms/stackd.htm", title: "STACKD - Stack Delimiter Character" },
                  { url: "parms/steplib.htm", title: "STEPLIB - Additional Steplib Library" },
                  { url: "parms/subsid.htm", title: "SUBSID - Subsystem ID" },
                  { url: "parms/synerr.htm", title: "SYNERR - Control of Syntax Errors" },
                  { url: "parms/sys.htm", title: "SYS - Define and Activate a Set of Dynamic Profile Parameters" },
                  { url: "parms/syscip.htm", title: "SYSCIP - Adabas Cipher Key for Natural System Files" },
                  { url: "parms/syspsw.htm", title: "SYSPSW - Adabas Default Password for Natural System Files" },
                  { url: "parms/tab.htm", title: "TAB - Standard Output Character Translation" },
                  { url: "parms/tab1.htm", title: "TAB1 - Alternative Output Translation" },
                  { url: "parms/tab2.htm", title: "TAB2 - Alternative Input Translation" },
                  { url: "parms/taba1.htm", title: "TABA1 - EBCDIC-to-ASCII Translation" },
                  { url: "parms/taba2.htm", title: "TABA2 - ASCII-to-EBCDIC Translation" },
                  { url: "parms/tabl.htm", title: "TABL - SYS Library Output Translation" },
                  { url: "parms/sp_tc.htm", title: "TC - Trailing Characters" },
                  { url: "parms/sp_tcu.htm", title: "TCU - Unicode Trailing Characters" },
                  { url: "parms/td.htm", title: "TD - Time Differential" },
                  { url: "parms/tf.htm", title: "TF - Translation of Database ID/File Number" },
                  { url: "parms/thpinit.htm", title: "THPINIT - Name of Pre-initialized Storage Thread Model" },
                  { url: "parms/thsepch.htm", title: "THSEPCH - Thousands Separator Character" },
                  { url: "parms/thsize.htm", title: "THSIZE – Thread Size" },
                  { url: "parms/tmodel.htm", title: "TMODEL - IBM 3270 Terminal Model" },
                  { url: "parms/tpf.htm", title: "TPF (Internal Use)" },
                  { url: "parms/tq.htm", title: "TQ - Translate Quotation Marks" },
                  { url: "parms/trace_parm.htm", title: "TRACE - Define Components to be Traced" },
                  { url: "parms/ts.htm", title: "TS - Translate Output from Programs in System Libraries" },
                  { url: "parms/tsize.htm", title: "TSIZE - Size of Buffer for Adabas Text Retrieval" },
                  { url: "parms/tsop.htm", title: "TSOP - Parameters for Natural TSO Interface" },
                  { url: "parms/ttype.htm", title: "TTYPE - Terminal Type" },
                  { url: "parms/sp_uc.htm", title: "UC - Underlining Character" },
                  { url: "parms/uconmax.htm", title: "UCONMAX - Maximum Number of Concurrent Sessions for a User" },
                  { url: "parms/udb.htm", title: "UDB - User Database ID" },
                  { url: "parms/ulang.htm", title: "ULANG - User Language" },
                  { url: "parms/uniio.htm", title: "UNIIO (Internal Use)" },
                  { url: "parms/user.htm", title: "USER - Restrict Use of Profile Parameter Strings and Modules" },
                  { url: "parms/userbuf.htm", title: "USERBUF (Internal Use)" },
                  { url: "parms/utab1.htm", title: "UTAB1 - Lower-to-Upper-Case Translation" },
                  { url: "parms/utab2.htm", title: "UTAB2 - Upper-to-Lower-Case Translation" },
                  { url: "parms/vsam.htm", title: "VSAM - Parameters for Natural for VSAM" },
                  { url: "parms/VSIZE.htm", title: "VSIZE - Size of Buffer Area for Natural for VSAM" },
                  { url: "parms/webio-mf.htm", title: "WEBIO - Web I/O Interface Screen Rendering" },
                  { url: "parms/wh.htm", title: "WH - Wait for Record in Hold Status" },
                  { url: "parms/work.htm", title: "WORK - Work-File Assignments" },
                  { url: "parms/wpsize.htm", title: "WPSIZE - Sizes of Natural Work Pools" },
                  { url: "parms/wsisize.htm", title: "WSISIZE - Buffer for Natural Workstation Interface" },
                  { url: "parms/xml.htm", title: "XML - Activate PARSE XML and REQUEST DOCUMENT Statements" },
                  { url: "parms/xref.htm", title: "XREF - Creation of XRef Data for Natural" },
                  { url: "parms/yd.htm", title: "YD - Year Differential" },
                  { url: "parms/yslw.htm", title: "YSLW - Year Sliding or Fixed Window" },
                  { url: "parms/zd.htm", title: "ZD - Zero-Division Check" },
                  { url: "parms/ziip.htm", title: "ZIIP - zIIP Processing (z/OS Only)" },
                  { url: "parms/zp.htm", title: "ZP - Zero Printing" },
                  { url: "parms/zsize.htm", title: "ZSIZE - Size of Entire DB Buffer Area" },
              ]
            },
            { url: "pg/pg-over.htm", title: "Programming Guide",
              tree: [
                  { url: "pg/pg_mode.htm", title: "Natural Programming Modes" },
                  { url: "pg/pg_objects.htm", title: "Objects for Natural Application Management",
                    tree: [
                        { url: "pg/pg_obj_darea.htm", title: "Data Areas" },
                        { url: "pg/pg_obj_ddm.htm", title: "Data Definition Module (DDM)" },
                        { url: "pg/pg_obj_pgm_routine.htm", title: "Programs and Subordinate Routines" },
                        { url: "pg/pg_obj_helproutine.htm", title: "Helproutine" },
                        { url: "pg/pg_obj_copycode.htm", title: "Copycode" },
                        { url: "pg/pg_objects_text.htm", title: "Text" },
                        { url: "pg/pg_objects_class.htm", title: "Class" },
                        { url: "pg/pg_obj_map.htm", title: "Map" },
                        { url: "pg/pg_objects_adapter.htm", title: "Adapter" },
                        { url: "pg/pg_obj_dialog.htm", title: "Dialog" },
                        { url: "pg/pg_obj_resource.htm", title: "Resource" },
                        { url: "pg/pg_obj_recording.htm", title: "Recording" },
                        { url: "pg/pg_obj_error_msg.htm", title: "Error Message" },
                        { url: "pg/pg_obj_processor.htm", title: "Command Processor" },
                        { url: "pg/pg_obj_editor_profile.htm", title: "Editor Profile" },
                        { url: "pg/pg_obj_map_profile.htm", title: "Map Profile and Device Profile" },
                        { url: "pg/pg_obj_profile.htm", title: "Parameter Profile" },
                        { url: "pg/pg_obj_debug.htm", title: "Debug Environment" },
                        { url: "pg/pg_obj_apis.htm", title: "Application Programming Interfaces (APIs)" },
                    ]
                  },
                  { url: "pg/pg_function_call.htm", title: "Function Call" },
                  { url: "pg/pg_fields.htm", title: "Field Definitions",
                    tree: [
                        { url: "pg/pg_defi.htm", title: "Use and Structure of DEFINE DATA Statement" },
                        { url: "pg/pg_defi_dv.htm", title: "User-Defined Variables" },
                        { url: "pg/pg_defi_ldvfin.htm", title: "Introduction to Dynamic Variables and Fields" },
                        { url: "pg/pg_defi_ldvfus.htm", title: "Using Dynamic and Large Variables" },
                        { url: "pg/pg_defi_udc.htm", title: "User-Defined Constants" },
                        { url: "pg/pg_defi_init.htm", title: "Initial Values (and the RESET Statement)" },
                        { url: "pg/pg_defi_redef.htm", title: "Redefining Fields" },
                        { url: "pg/pg_defi_array.htm", title: "Arrays" },
                        { url: "pg/pg_defi_xarry.htm", title: "X-Arrays" },
                    ]
                  },
                  { url: "pg/pg_dbms_access.htm", title: "Database Access",
                    tree: [
                        { url: "pg/pg_dbms_dbgen.htm", title: "Natural and Database Access" },
                        { url: "pg/pg_dbms_ada.htm", title: "Accessing Data in an Adabas Database" },
                        { url: "pg/pg_dbms_sqlmf.htm", title: "Accessing Data in an SQL Database" },
                        { url: "pg/pg_dbms_nvs.htm", title: "Accessing Data in a VSAM Database" },
                    ]
                  },
                  { url: "pg/pg_report_format.htm", title: "Report Format and Control",
                    tree: [
                        { url: "pg/pg_output_rep.htm", title: "Report Specification - (rep) Notation" },
                        { url: "pg/pg_output_layout.htm", title: "Layout of an Output Page" },
                        { url: "pg/pg_output_display.htm", title: "Statements DISPLAY and WRITE" },
                        { url: "pg/pg_output_index.htm", title: "Index Notation for Multiple-Value Fields and Periodic Groups" },
                        { url: "pg/pg_output_titles.htm", title: "Page Titles, Page Breaks, Blank Lines" },
                        { url: "pg/pg_output_headers.htm", title: "Column Headers" },
                        { url: "pg/pg_output_parms.htm", title: "Parameters to Influence the Output of Fields" },
                        { url: "pg/pg_output_masks.htm", title: "Code Page Edit Masks - EM Parameter" },
                        { url: "pg/pg_output_umasks.htm", title: "Unicode Edit Masks - EMU Parameter" },
                        { url: "pg/pg_output_vdispl.htm", title: "Vertical Displays" },
                    ]
                  },
                  { url: "pg/pg_furth-over.htm", title: "Further Programming Aspects",
                    tree: [
                        { url: "pg/pg_furth_txtnot.htm", title: "Text Notation" },
                        { url: "pg/pg_furth_ucom.htm", title: "User Comments" },
                        { url: "pg/pg_furth_compu.htm", title: "Data Computation" },
                        { url: "pg/pg_furth_arithm.htm", title: "Rules for Arithmetic Assignment" },
                        { url: "pg/pg_furth_condi.htm", title: "Conditional Processing - IF Statement" },
                        { url: "pg/pg_furth_lcc.htm", title: "Logical Condition Criteria" },
                        { url: "pg/pg_furth_loop.htm", title: "Loop Processing" },
                        { url: "pg/pg_furth_break.htm", title: "Control Breaks" },
                        { url: "pg/pg_furth_stack_process.htm", title: "Stack Processing" },
                        { url: "pg/pg_furth_vari.htm", title: "System Variables and System Functions" },
                        { url: "pg/pg_furth_date.htm", title: "Processing of Date Information" },
                        { url: "pg/pg_furth_store_clock_val.htm", title: "Processing of Store Clock Values" },
                        { url: "pg/pg_furth_end.htm", title: "End of Statement, Program or Application" },
                        { url: "pg/pg_furth_appl_err_proc.htm", title: "Processing of Application Errors" },
                        { url: "pg/pg_furth_compile.htm", title: "Compilation Aspects" },
                    ]
                  },
                  { url: "pg/pg_xml.htm", title: "Statements for Internet Access and Parsing" },
                  { url: "pg/pg_user_interfaces.htm", title: "Application User Interfaces",
                    tree: [
                        { url: "pg/pg_desgn_screen.htm", title: "Screen Design" },
                        { url: "pg/pg_desgn_dialog.htm", title: "Dialog Design" },
                    ]
                  },
                  { url: "pg/pg_natx-over.htm", title: "NaturalX",
                    tree: [
                        { url: "pg/pg_natx_intro.htm", title: "Introduction to NaturalX" },
                        { url: "pg/pg_natx_dev.htm", title: "Developing NaturalX Applications" },
                    ]
                  },
                  { url: "pg/pg_keyw.htm", title: "Natural Reserved Keywords" },
                  { url: "pg/pg_exas.htm", title: "Referenced Example Programs" },
              ]
            },
            { url: "edis/edis-over.htm", title: "Editors",
              tree: [
                  { url: "edis/disabled_editors.htm", title: "Disabled Natural Editors" },
                  { url: "edis/one_as_ide.htm", title: "NaturalONE as the Default Development Environment" },
                  { url: "edis/edis_mf_lock.htm", title: "Locking of Source Objects" },
                  { url: "edis/edis_mf_edit.htm", title: "Editors - General Information" },
                  { url: "edis/edis_mf_pgm.htm", title: "Program Editor" },
                  { url: "edis/edis_mf_data.htm", title: "Data Area Editor" },
                  { url: "edis/map_mf-over.htm", title: "Map Editor",
                    tree: [
                        { url: "edis/map_mf_components.htm", title: "Components of the Map Editor" },
                        { url: "edis/map_mf_summary.htm", title: "Summary of Map Creation" },
                        { url: "edis/map_mf_invoke.htm", title: "Invoking and Leaving the Map Editor" },
                        { url: "edis/map_mf_functions.htm", title: "Functions in the Edit Map Menu" },
                        { url: "edis/map_mf_init_map.htm", title: "Initializing a Map" },
                        { url: "edis/map_mf_edit.htm", title: "Editing a Map" },
                        { url: "edis/map_mf_define_fields.htm", title: "Defining Map Fields" },
                        { url: "edis/map_mf_ext_fields.htm", title: "Extended Field Editing" },
                        { url: "edis/map_mf_post_assign.htm", title: "Post Assignment of Fields" },
                        { url: "edis/map_mf_array_table.htm", title: "Array and Table Definitions" },
                        { url: "edis/map_mf_proc_rules.htm", title: "Processing Rules" },
                    ]
                  },
                  { url: "edis/mapt_mf-over.htm", title: "Map Editor Tutorial",
                    tree: [
                        { url: "edis/mapt_mf_invoke.htm", title: "Opening the Map Editor" },
                        { url: "edis/mapt_mf_create_fields.htm", title: "Creating, Positioning and Deleting Map Fields" },
                        { url: "edis/mapt_mf_test_save.htm", title: "Testing and Saving a Map" },
                        { url: "edis/mapt_mf_proc_rule.htm", title: "Defining Processing Rules" },
                        { url: "edis/mapt_mf_name_stow.htm", title: "Naming Fields and Saving/Cataloging a Map" },
                        { url: "edis/mapt_mf_ext_edit.htm", title: "Defining Field Properties" },
                        { url: "edis/mapt_mf_help_map.htm", title: "Creating and Testing a Help Map" },
                        { url: "edis/mapt_mf_INPUT_USING.htm", title: "Invoking a Map with INPUT USING MAP" },
                        { url: "edis/mapt_mf_WRITE_copy.htm", title: "Creating a Map for WRITE and Copying Field Definitions" },
                        { url: "edis/mapt_mf_copy_layout.htm", title: "Reusing the Layout of a Map" },
                        { url: "edis/mapt_mf_invoke_WRITE.htm", title: "Invoking a Map with WRITE USING MAP" },
                    ]
                  },
                  { url: "edis/ddm-over.htm", title: "SYSDDM Utility",
                    tree: [
                        { url: "edis/ddm_gen.htm", title: "Principles of Operation" },
                        { url: "edis/ddm_mf_invoke_sys.htm", title: "Invoking and Terminating SYSDDM" },
                        { url: "edis/ddm_mf_maint_funct.htm", title: "Using SYSDDM Maintenance and Service Functions" },
                        { url: "edis/ddm_mf_create.htm", title: "Creating DDMs" },
                        { url: "edis/ddm_invoke_editor.htm", title: "Invoking and Terminating the DDM Editor" },
                        { url: "edis/ddm_use_editor.htm", title: "Using the DDM Editor" },
                        { url: "edis/ddm_save_cat_object.htm", title: "Cataloging a DDM" },
                        { url: "edis/ddm_mf_list.htm", title: "Listing DDMs" },
                        { url: "edis/ddm_maint_env.htm", title: "Maintaining DDMs in Different Environments" },
                    ]
                  },
                  { url: "edis/edis_mf_sagedt-over.htm", title: "Software AG Editor",
                    tree: [
                        { url: "edis/sagedt_general.htm", title: "General Information on the Software AG Editor" },
                        { url: "edis/sagedt_invoke.htm", title: "Invoking the Software AG Editor" },
                        { url: "edis/sagedt_use_screen.htm", title: "Using the Editor Screen" },
                        { url: "edis/sagedt_use_cmds.htm", title: "Using Commands" },
                        { url: "edis/sagedt_create_modify.htm", title: "Creating and Modifying Data" },
                        { url: "edis/sagedt_set_profile.htm", title: "Setting the Editor Profile" },
                        { url: "edis/sagedt_store_leave_editor.htm", title: "Storing Data and Leaving the Software AG Editor" },
                        { url: "edis/sagedt_line_summary.htm", title: "Summary of Line Commands" },
                        { url: "edis/sagedt_main_summary.htm", title: "Summary of Main Commands" },
                    ]
                  },
              ]
            },
            { url: "syscom/syscom-over.htm", title: "System Commands",
              tree: [
                  { url: "syscom/issue.htm", title: "Issuing System Commands" },
                  { url: "syscom/syntax.htm", title: "System Command Syntax" },
                  { url: "syscom/syscom_groups.htm", title: "System Commands Grouped by Category" },
                  { url: "syscom/aiv.htm", title: "AIV" },
                  { url: "syscom/bus.htm", title: "BUS" },
                  { url: "syscom/catall_m.htm", title: "CATALL" },
                  { url: "syscom/catalog.htm", title: "CATALOG" },
                  { url: "syscom/check.htm", title: "CHECK" },
                  { url: "syscom/clear.htm", title: "CLEAR" },
                  { url: "syscom/compopt.htm", title: "COMPOPT" },
                  { url: "syscom/cpinfo.htm", title: "CPINFO" },
                  { url: "syscom/delete.htm", title: "DELETE" },
                  { url: "syscom/dump.htm", title: "DUMP" },
                  { url: "syscom/edit.htm", title: "EDIT" },
                  { url: "syscom/edt.htm", title: "EDT" },
                  { url: "syscom/execute.htm", title: "EXECUTE" },
                  { url: "syscom/fin.htm", title: "FIN" },
                  { url: "syscom/globals.htm", title: "GLOBALS" },
                  { url: "syscom/help.htm", title: "HELP" },
                  { url: "syscom/inpl.htm", title: "INPL" },
                  { url: "syscom/key.htm", title: "KEY" },
                  { url: "syscom/last.htm", title: "LAST" },
                  { url: "syscom/lastmsg.htm", title: "LASTMSG" },
                  { url: "syscom/list_m.htm", title: "LIST" },
                  { url: "syscom/listdbrm.htm", title: "LISTDBRM" },
                  { url: "syscom/listprof.htm", title: "LISTPROF" },
                  { url: "syscom/list_xref.htm", title: "LIST XREF" },
                  { url: "syscom/listsql.htm", title: "LISTSQL" },
                  { url: "syscom/listsqlb.htm", title: "LISTSQLB" },
                  { url: "syscom/logoff.htm", title: "LOGOFF" },
                  { url: "syscom/logon.htm", title: "LOGON" },
                  { url: "syscom/mail.htm", title: "MAIL" },
                  { url: "syscom/mainmenu.htm", title: "MAINMENU" },
                  { url: "syscom/natqvs.htm", title: "NATQVS" },
                  { url: "syscom/nocopt.htm", title: "NOCOPT" },
                  { url: "syscom/nocshow.htm", title: "NOCSHOW" },
                  { url: "syscom/nocstat.htm", title: "NOCSTAT" },
                  { url: "syscom/profile.htm", title: "PROFILE" },
                  { url: "syscom/profiler.htm", title: "PROFILER" },
                  { url: "syscom/rdc.htm", title: "RDC" },
                  { url: "syscom/read.htm", title: "READ" },
                  { url: "syscom/rename.htm", title: "RENAME" },
                  { url: "syscom/renumber.htm", title: "RENUMBER" },
                  { url: "syscom/return.htm", title: "RETURN" },
                  { url: "syscom/routines.htm", title: "ROUTINES" },
                  { url: "syscom/rpcerr.htm", title: "RPCERR" },
                  { url: "syscom/run.htm", title: "RUN" },
                  { url: "syscom/save.htm", title: "SAVE" },
                  { url: "syscom/scan_m.htm", title: "SCAN" },
                  { url: "syscom/scratch.htm", title: "SCRATCH" },
                  { url: "syscom/setup.htm", title: "SETUP" },
                  { url: "syscom/showdbs.htm", title: "SHOWDBS" },
                  { url: "syscom/sqldiag.htm", title: "SQLDIAG" },
                  { url: "syscom/sqlerr.htm", title: "SQLERR" },
                  { url: "syscom/stow.htm", title: "STOW" },
                  { url: "syscom/struct.htm", title: "STRUCT" },
                  { url: "syscom/sysada.htm", title: "SYSADA" },
                  { url: "syscom/sysapi.htm", title: "SYSAPI" },
                  { url: "syscom/sysbpm.htm", title: "SYSBPM" },
                  { url: "syscom/syscp.htm", title: "SYSCP" },
                  { url: "syscom/sysdb2.htm", title: "SYSDB2" },
                  { url: "syscom/sysddm.htm", title: "SYSDDM" },
                  { url: "syscom/sysedt.htm", title: "SYSEDT" },
                  { url: "syscom/syserr.htm", title: "SYSERR" },
                  { url: "syscom/sysext.htm", title: "SYSEXT" },
                  { url: "syscom/sysexv.htm", title: "SYSEXV" },
                  { url: "syscom/sysfile.htm", title: "SYSFILE" },
                  { url: "syscom/sysmain.htm", title: "SYSMAIN" },
                  { url: "syscom/sysncp.htm", title: "SYSNCP" },
                  { url: "syscom/sysobjh.htm", title: "SYSOBJH" },
                  { url: "syscom/sysparm.htm", title: "SYSPARM" },
                  { url: "syscom/sysprod.htm", title: "SYSPROD" },
                  { url: "syscom/sysprof.htm", title: "SYSPROF" },
                  { url: "syscom/sysrpc.htm", title: "SYSRPC" },
                  { url: "syscom/systp.htm", title: "SYSTP" },
                  { url: "syscom/tech.htm", title: "TECH" },
                  { url: "syscom/test.htm", title: "TEST" },
                  { url: "syscom/test_dblog.htm", title: "TEST DBLOG" },
                  { url: "syscom/uncatalog.htm", title: "UNCATALOG" },
                  { url: "syscom/unlock.htm", title: "UNLOCK" },
                  { url: "syscom/update.htm", title: "UPDATE" },
                  { url: "syscom/which.htm", title: "WHICH" },
                  { url: "syscom/xref.htm", title: "XREF" },
                  { url: "syscom/ziip.htm", title: "ZIIP" },
              ]
            },
            { url: "utis/utis-over.htm", title: "Utilities",
              tree: [
                  { url: "utis/utis_activate.htm", title: "Utility Activation" },
                  { url: "utis/utis_mf_groups.htm", title: "Utilities Grouped by Purpose" },
                  { url: "utis/ada.htm", title: "ADACALL Utility - Issuing Adabas Direct Calls" },
                  { url: "utis/log.htm", title: "DBLOG Utility - Logging Database Calls",
                    tree: [
                        { url: "utis/log_exec.htm", title: "Executing DBLOG" },
                        { url: "utis/log_menu.htm", title: "DBLOG Menu" },
                        { url: "utis/log_trace.htm", title: "DBLOG Trace Screen" },
                        { url: "utis/log_snap.htm", title: "DBLOG Snapshot Function" },
                        { url: "utis/log_comm.htm", title: "TEST DBLOG Command" },
                    ]
                  },
                  { url: "utis/inpl.htm", title: "INPL Utility" },
                  { url: "utis/screen.htm", title: "NATPAGE Utility - Screen Capturing" },
                  { url: "utis/rje.htm", title: "NATRJE Utility - Natural Remote Job Entry" },
                  { url: "utis/sysobjh.htm", title: "Object Handler",
                    tree: [
                        { url: "utis/sysobjh_gen_info.htm", title: "General Information on the Object Handler" },
                        { url: "utis/sysobjh_func.htm", title: "Functions" },
                        { url: "utis/sysobjh_wizard.htm", title: "Wizards" },
                        { url: "utis/sysobjh_adv.htm", title: "Advanced User" },
                        { url: "utis/sysobj_compact.htm", title: "Compact Mode" },
                        { url: "utis/sysobjh_restart_cui.htm", title: "Restart Load" },
                        { url: "utis/sysobjh_view.htm", title: "View" },
                        { url: "utis/sysobjh_find.htm", title: "Find" },
                        { url: "utis/sysobjh_admin.htm", title: "Administration" },
                        { url: "utis/sysobjh_sel_fi.htm", title: "Select System File" },
                        { url: "utis/sysobjh_sel_lib.htm", title: "Select Library" },
                        { url: "utis/sysobjh_sel_mess.htm", title: "Select System Error Messages" },
                        { url: "utis/sysobjh_sel_obj.htm", title: "Select Objects" },
                        { url: "utis/sysobjh_objects.htm", title: "Object Specification" },
                        { url: "utis/sysobjh_all.htm", title: "Object Specification - All Objects on the Work File" },
                        { url: "utis/sysobjh_library.htm", title: "Object Specification - Natural Library Objects" },
                        { url: "utis/sysobjh_syserr.htm", title: "Object Specification - Natural System Error Messages" },
                        { url: "utis/sysobjh_ncp.htm", title: "Object Specification - Natural Command Processors" },
                        { url: "utis/sysobjh_related.htm", title: "Object Specification - Natural-Related Objects" },
                        { url: "utis/sysobjh_ddm_mf.htm", title: "Object Specification - DDMs" },
                        { url: "utis/sysobjh_fdt.htm", title: "Object Specification - FDTs" },
                        { url: "utis/sysobjh_use_work.htm", title: "Use Selection or List Workplan" },
                        { url: "utis/sysobjh_settings.htm", title: "Settings" },
                        { url: "utis/sysobjh_workplan.htm", title: "Workplans" },
                        { url: "utis/sysobjh_dat_time.htm", title: "Name, Date and Time Specification" },
                        { url: "utis/sysobjh_workfile.htm", title: "Work Files" },
                        { url: "utis/sysobjh_commands.htm", title: "Direct Commands" },
                        { url: "utis/sysobjh_work_cmd.htm", title: "Basic Command Syntax" },
                        { url: "utis/sysobjh_select.htm", title: "select-clause" },
                        { url: "utis/sysobjh_object.htm", title: "Object List - LIST Workplan" },
                        { url: "utis/sysobjh_parm.htm", title: "parameter-setting" },
                        { url: "utis/sysobjh_option.htm", title: "option-setting" },
                        { url: "utis/sysobjh_example_cmds.htm", title: "Examples of Using Direct Commands" },
                        { url: "utis/sysobjh_int_cmd.htm", title: "Commands for Navigation and Special Functions" },
                        { url: "utis/sysobjh_cc_uexit.htm", title: "Batch Condition Codes and User Exit Routines" },
                        { url: "utis/sysobjh_tools.htm", title: "Tools" },
                        { url: "utis/sysobjh_profile.htm", title: "Profile Settings" },
                        { url: "utis/sysobjh_migration.htm", title: "Migration from NATUNLD/NATLOAD and SYSTRANS to the Object Handler" },
                    ]
                  },
                  { url: "utis/record.htm", title: "Recording Utility" },
                  { url: "utis/sysapi_mfwin.htm", title: "SYSAPI Utility - APIs of Natural Add-On Products" },
                  { url: "utis/bpm-over.htm", title: "SYSBPM Utility - Buffer Pool Management",
                    tree: [
                        { url: "utis/bpm_invoke.htm", title: "Invoking and Operating SYSBPM" },
                        { url: "utis/bpm_list_obj.htm", title: "List Objects" },
                        { url: "utis/bpm_del_obj.htm", title: "Delete Objects" },
                        { url: "utis/bpm_obj_dir.htm", title: "Directory Information" },
                        { url: "utis/bpm_obj_hex.htm", title: "Hexadecimal Display" },
                        { url: "utis/bpm_workfile.htm", title: "Write to Work File" },
                        { url: "utis/bpm_dis_sort.htm", title: "Display Sorted Extract" },
                        { url: "utis/bpm_bp_stat.htm", title: "Buffer Pool Statistics" },
                        { url: "utis/bpm_cache_stat.htm", title: "BP Cache Statistics" },
                        { url: "utis/bpm_message_stat.htm", title: "Message Buffer Pool Statistics" },
                        { url: "utis/bpm_sel_buff.htm", title: "Select Buffer Pool" },
                        { url: "utis/bpm_sel_mess.htm", title: "Select Message Pool" },
                        { url: "utis/bpm_blacklist.htm", title: "Blacklist Maintenance" },
                        { url: "utis/bpm_preload.htm", title: "Preload List Maintenance" },
                        { url: "utis/bpm_perf.htm", title: "Performance Considerations" },
                        { url: "utis/bpm_dir_cmd.htm", title: "SYSBPM Direct Commands" },
                        { url: "utis/bpm_batch.htm", title: "Batch Processing" },
                        { url: "utis/bpm_inter.htm", title: "Application Programming Interfaces" },
                    ]
                  },
                  { url: "utis/syscp.htm", title: "SYSCP Utility - Code Page Administration" },
                  { url: "utis/sysedt.htm", title: "SYSEDT Utility - Editor Buffer Pool Administration" },
                  { url: "utis/syserr.htm", title: "SYSERR Utility",
                    tree: [
                        { url: "utis/syserr_gen_mess.htm", title: "General Information on Messages" },
                        { url: "utis/syserr_invoke.htm", title: "Invoking SYSERR" },
                        { url: "utis/syserr_function.htm", title: "SYSERR Functions" },
                        { url: "utis/syserr_parms.htm", title: "SYSERR Parameters" },
                        { url: "utis/syserr_dir_com.htm", title: "SYSERR Direct Commands" },
                        { url: "utis/syserr_errupper.htm", title: "Upper Case Conversion - ERRUPPER" },
                        { url: "utis/syserr_errchar.htm", title: "Replacing Characters - ERRCHAR" },
                        { url: "utis/syserr_manage_messages.htm", title: "Managing Messages in Different Libraries" },
                    ]
                  },
                  { url: "utis/sysext.htm", title: "SYSEXT Utility - Natural Application Programming Interfaces" },
                  { url: "utis/sysexv.htm", title: "SYSEXV Utility" },
                  { url: "utis/sysmain_mf-over.htm", title: "SYSMAIN Utility - Object Maintenance",
                    tree: [
                        { url: "utis/sysmain_mf_gen.htm", title: "General Information on SYSMAIN" },
                        { url: "utis/sysmain_mf_invoke.htm", title: "Invoking and Terminating SYSMAIN" },
                        { url: "utis/sysmain_mf_functions.htm", title: "Using Menu Functions and Commands" },
                        { url: "utis/sysmain_mf_prog_obj.htm", title: "Processing Programming Objects" },
                        { url: "utis/sysmain_mf_debug.htm", title: "Processing Debug Environments" },
                        { url: "utis/sysmain_mf_error.htm", title: "Processing Error Messages" },
                        { url: "utis/sysmain_mf_profiles.htm", title: "Processing Profiles" },
                        { url: "utis/sysmain_mf_rules.htm", title: "Processing Rules" },
                        { url: "utis/sysmain_mf_ddm.htm", title: "Processing DDMs" },
                        { url: "utis/sysmain_mf_predict_sets.htm", title: "Processing Predict Sets" },
                        { url: "utis/sysmain_mf_keywords.htm", title: "Keywords and Variables in Direct Commands" },
                        { url: "utis/sysmain_mf_cmds_sys.htm", title: "Special Commands Issued to SYSMAIN" },
                        { url: "utis/sysmain_mf_reject.htm", title: "Processing Status and Error Notification" },
                        { url: "utis/sysmain_mf_consider.htm", title: "Special Considerations for Administrators" },
                    ]
                  },
                  { url: "utis/sysncp.htm", title: "SYSNCP Utility" },
                  { url: "utis/parm.htm", title: "SYSPARM Utility" },
                  { url: "utis/profiler.htm", title: "Natural Profiler and Code Coverage",
                    tree: [
                        { url: "utis/profiling_applications.htm", title: "Profiling Natural Applications" },
                        { url: "utis/code_coverage_applications.htm", title: "Code Coverage of Natural Applications" },
                        { url: "utis/profiler_intro.htm", title: "Basic Concepts of the Profiler Utility" },
                        { url: "utis/profiler_online.htm", title: "Using the Profiler Utility in Online Mode" },
                        { url: "utis/profiler_batch_mode.htm", title: "Using the Profiler Utility in Batch Mode" },
                        { url: "utis/profiler_rich_gui.htm", title: "Natural Profiler Rich GUI" },
                    ]
                  },
                  { url: "utis/rdc.htm", title: "SYSRDC Utility" },
                  { url: "utis/sysrpc-over.htm", title: "SYSRPC Utility",
                    tree: [
                        { url: "utis/sysrpc_basic.htm", title: "Invoking and Terminating SYSRPC" },
                        { url: "utis/sysrpc_sm.htm", title: "Service Directory Maintenance" },
                        { url: "utis/sysrpc_replace_command.htm", title: "Replacing Items in the Service Directory" },
                        { url: "utis/sysrpc_interface_general.htm", title: "Generating Interface Objects - General Considerations" },
                        { url: "utis/sysrpc_interface_object_single.htm", title: "Generating Single Interface Objects with Parameter Specification" },
                        { url: "utis/sysrpc_interface_object_mass.htm", title: "Generating Multiple Interface Objects" },
                        { url: "utis/sysrpc_buffer.htm", title: "Calculating Size Requirements" },
                        { url: "utis/sysrpc_parm_cui.htm", title: "Parameter Maintenance" },
                        { url: "utis/sysrpc_com_exec.htm", title: "Server Command Execution" },
                        { url: "utis/sysrpc_srvlist.htm", title: "Listing Servers Registered on EntireX Broker" },
                        { url: "utis/sysrpc_direct_batch_commands.htm", title: "Overview of SYSRPC Direct and Batch Commands" },
                    ]
                  },
                  { url: "utis/systp-over.htm", title: "SYSTP Utility",
                    tree: [
                        { url: "utis/systp_invoke_utility.htm", title: "Invoking SYSTP and Executing Functions" },
                        { url: "utis/systp_use_systp_screens.htm", title: "Using SYSTP Utility Screens" },
                        { url: "utis/systp_env_ind.htm", title: "General SYSTP Functions" },
                        { url: "utis/systp_dep_cics.htm", title: "SYSTP Functions under CICS" },
                        { url: "utis/systp_dep_ims.htm", title: "SYSTP Functions under IMS TM" },
                        { url: "utis/systp_batch.htm", title: "SYSTP in Batch for CICS Sessions" },
                    ]
                  },
              ]
            },
            { url: "debug_mf/debug_mf-over.htm", title: "Debugger",
              tree: [
                  { url: "debug_mf/debug_mf_tutorial.htm", title: "Debugger Tutorial" },
                  { url: "debug_mf/debug_mf_conc.htm", title: "Concepts of the Debugger" },
                  { url: "debug_mf/debug_mf_invoke.htm", title: "Start the Debugger" },
                  { url: "debug_mf/debug_mf_set.htm", title: "Switch Test Mode On and Off" },
                  { url: "debug_mf/debug_mf_env.htm", title: "Debug Environment Maintenance" },
                  { url: "debug_mf/debug_mf_spy.htm", title: "Spy Maintenance" },
                  { url: "debug_mf/debug_mf_break.htm", title: "Breakpoint Maintenance" },
                  { url: "debug_mf/debug_mf_watch.htm", title: "Watchpoint Maintenance" },
                  { url: "debug_mf/debug_mf_call.htm", title: "Call Statistics Maintenance" },
                  { url: "debug_mf/debug_mf_state.htm", title: "Statement Execution Statistics Maintenance" },
                  { url: "debug_mf/debug_mf_vari.htm", title: "Variable Maintenance" },
                  { url: "debug_mf/debug_mf_list.htm", title: "List Object Source" },
                  { url: "debug_mf/debug_mf_error.htm", title: "Error Handling" },
                  { url: "debug_mf/debug_mf_exec.htm", title: "Execution Control Commands" },
                  { url: "debug_mf/debug_mf_navig.htm", title: "Navigation and Information Commands" },
                  { url: "debug_mf/debug_mf_summ.htm", title: "Command Summary and Syntax" },
                  { url: "debug_mf/debug_mf_attach.htm", title: "Preparing Natural for Attached Debugging" },
              ]
            },
            { url: "webtech/webtech-over.htm", title: "Web Technology",
              tree: [
                  { url: "webtech/webtech_json.htm", title: "JSON Parser" },
                  { url: "webtech/nwx-over.htm", title: "Natural Web Interface",
                    tree: [
                        { url: "webtech/nwx_intro.htm", title: "Introducing the Natural Web Interface" },
                        { url: "webtech/nwx_inst.htm", title: "Natural Web Interface Configuration" },
                        { url: "webtech/nwx_configuring.htm", title: "Configuring the Natural Web Interface" },
                        { url: "webtech/nwx_troublesh.htm", title: "Web Interface Troubleshooting" },
                        { url: "webtech/nwx_inter.htm", title: "Natural Web Interface Essentials" },
                        { url: "webtech/nwx_working.htm", title: "Working with the Natural Web Interface" },
                    ]
                  },
                  { url: "webtech/nwx_adapt.htm", title: "Natural Web Server Extensions",
                    tree: [
                        { url: "webtech/nwx_general_old.htm", title: "Natural Web Server Extensions - Introduction" },
                        { url: "webtech/nwx_initfile.htm", title: "Natural Web Server Extensions - Initialization File" },
                        { url: "webtech/nwx_errormsg.htm", title: "Natural Web Server Extensions - Error Messages" },
                        { url: "webtech/nwx_tipsprog.htm", title: "Programming Tips" },
                        { url: "webtech/nwx_administr.htm", title: "Web Interface Administration" },
                        { url: "webtech/nwx_demoapp.htm", title: "Demonstration Application - without JavaScript" },
                        { url: "webtech/nwx_demonew.htm", title: "Demonstration Application - with JavaScript" },
                        { url: "webtech/nwx_error.htm", title: "Natural Web Interface Error Messages" },
                    ]
                  },
                  { url: "webtech/nwx_examp-over_t31_0300.htm", title: "Natural Web Online Documentation SYSWEB" },
                  { url: "webtech/t31_0310.htm", title: "Clear Output Area" },
                  { url: "webtech/t31_0320.htm", title: "Set Document Content-Type" },
                  { url: "webtech/t31_0330.htm", title: "Count Size of Output Area" },
                  { url: "webtech/t31_0340.htm", title: "Generate Error Page" },
                  { url: "webtech/t31_0350.htm", title: "Writes to the Document and Converts to Valid HTML" },
                  { url: "webtech/t31_0360.htm", title: "Writes HTTP Settings to the Document" },
                  { url: "webtech/t31_0370.htm", title: "Info About Internal Values" },
                  { url: "webtech/t31_0380.htm", title: "End and Initialize Document" },
                  { url: "webtech/t31_0390.htm", title: "List All Environment Variables" },
                  { url: "webtech/t31_0400.htm", title: "Set Document Location" },
                  { url: "webtech/t31_0410.htm", title: "Read Environment Variable" },
                  { url: "webtech/t31_0420.htm", title: "Read Environment Variables Groups" },
                  { url: "webtech/t31_0430.htm", title: "Read Environment Text Area Variables" },
                  { url: "webtech/t31_0440.htm", title: "Write Text to Document" },
                  { url: "webtech/t31_0450.htm", title: "Write Newline to Output Area" },
                  { url: "webtech/t31_0460.htm", title: "Text to HTML" },
                  { url: "webtech/t31_0470.htm", title: "Text to XML" },
                  { url: "webtech/t31_0480.htm", title: "Text to URL" },
                  { url: "webtech/t31_0490.htm", title: "Replace Inside Return Document" },
                  { url: "webtech/t31_0580.htm", title: "Read Output Page" },
                  { url: "webtech/t31_0590.htm", title: "Anchor" },
                  { url: "webtech/t31_0600.htm", title: "Button" },
                  { url: "webtech/t31_0610.htm", title: "Checkbox Group" },
                  { url: "webtech/t31_0620.htm", title: "Comment Line" },
                  { url: "webtech/t31_0630.htm", title: "Level n Header" },
                  { url: "webtech/t31_0640.htm", title: "Image" },
                  { url: "webtech/t31_0650.htm", title: "Input" },
                  { url: "webtech/t31_0660.htm", title: "Line Break" },
                  { url: "webtech/t31_0670.htm", title: "Form" },
                  { url: "webtech/t31_0680.htm", title: "HTML Document" },
                  { url: "webtech/t31_0690.htm", title: "List" },
                  { url: "webtech/t31_0700.htm", title: "Paragraph" },
                  { url: "webtech/t31_0710.htm", title: "Radio Button Group" },
                  { url: "webtech/t31_0720.htm", title: "Horizontal Rule" },
                  { url: "webtech/t31_0730.htm", title: "Scrolling List" },
                  { url: "webtech/t31_0740.htm", title: "Table" },
                  { url: "webtech/t31_0750.htm", title: "Universal Tag" },
                  { url: "webtech/t31_0760.htm", title: "Text Area" },
                  { url: "webtech/t31_0770.htm", title: "Text to URL - Decoded" },
                  { url: "webtech/t31_0780.htm", title: "Time/Date String" },
                  { url: "webtech/t31_0790.htm", title: "List all Natural Libraries" },
                  { url: "webtech/t31_0800.htm", title: "Run Online Natural Web Interface Subprograms" },
                  { url: "webtech/t31_0810.htm", title: "Generate Natural Subprogram to use with Natural Web Interface" },
                  { url: "webtech/t31_0820.htm", title: "List Directory of a Natural Library" },
                  { url: "webtech/t31_0830.htm", title: "List All Parameters Passed From a HTTP Server To a Called Natural Subprogram" },
                  { url: "webtech/t31_0840.htm", title: "Return an HTML Page Saved as Natural Source Object" },
                  { url: "webtech/t31_0850.htm", title: "List the Current Natural Web Interface Settings" },
                  { url: "webtech/t31_0860.htm", title: "List Source of Natural Object" },
                  { url: "webtech/t31_0870.htm", title: "Online Documentation" },
                  { url: "webtech/xml-over.htm", title: "XML Toolkit",
                    tree: [
                        { url: "webtech/xml.htm", title: "Introduction" },
                        { url: "webtech/xml_run.htm", title: "Using the XML Toolkit" },
                        { url: "webtech/xml_opti.htm", title: "Setting up Specific Generation Options" },
                        { url: "webtech/xml_nda.htm", title: "Using a Natural Data Source" },
                        { url: "webtech/xml_dtd.htm", title: "Using an external Data Source" },
                        { url: "webtech/xml_nixe.htm", title: "Natural Simple XML Parser" },
                        { url: "webtech/xml_exa.htm", title: "Examples" },
                        { url: "webtech/xml_err.htm", title: "XML Parser Error Messages" },
                    ]
                  },
              ]
            },
            { url: "noc_mf/noc_mf-over.htm", title: "Natural Optimizer Compiler",
              tree: [
                  { url: "noc_mf/noc_mf_gen.htm", title: "NOC - General Information" },
                  { url: "noc_mf/noc_mf_conditio.htm", title: "Using the Optimizer Compiler - Overview",
                    tree: [
                        { url: "noc_mf/noc_mf_whatcomp.htm", title: "What is Compiled and What is Not" },
                        { url: "noc_mf/noc_mf_nocstat.htm", title: "NOCSTAT Command" },
                        { url: "noc_mf/noc_mf_dissize.htm", title: "Displaying the Size of the Machine Code" },
                        { url: "noc_mf/noc_mf_examples.htm", title: "Optimizer Usage Examples" },
                    ]
                  },
                  { url: "noc_mf/noc_mf_switch.htm", title: "Activating the Optimizer Compiler" },
                  { url: "noc_mf/noc_mf_options.htm", title: "Optimizer Options" },
                  { url: "noc_mf/noc_mf_perf.htm", title: "Performance Considerations" },
                  { url: "noc_mf/noc_mf_zaps.htm", title: "Listing Zaps" },
              ]
            },
            { url: "rnm_mf/rnm_mf-over.htm", title: "Natural Review",
              tree: [
                  { url: "rnm_mf/start.htm", title: "Getting Started with Natural Review" },
                  { url: "rnm_mf/access.htm", title: "Accessing Natural Monitor" },
                  { url: "rnm_mf/response.htm", title: "Using Response Time Reports" },
                  { url: "rnm_mf/user.htm", title: "Active User Information" },
                  { url: "rnm_mf/tech.htm", title: "Technical Information" },
                  { url: "rnm_mf/admin.htm", title: "Administrative Functions" },
                  { url: "rnm_mf/fcc.htm", title: "Function Codes and Commands" },
                  { url: "rnm_mf/lda.htm", title: "Local Data Area View Description" },
                  { url: "rnm_mf/repfile.htm", title: "Natural Review Repository File" },
              ]
            },
            { url: "glossary/glossary.htm", title: "Glossary" },
            { url: "general/legal.htm", title: "Copyright" },
        ]
};

var mainProject = 1;

$.event.trigger({ type: "fishidbloaded", db: naturalformainframes });
