//
//	FindinSite-CD-JS-HelpIndex database naturalformainframes
//
//	Copyright (c) 2016-2025 Software AG, Darmstadt, Germany and/or Software AG USA Inc., Reston, VA, USA
//
var naturalformainframes = {
    baseurls: ["../"],
    varname: "naturalformainframes",
        tree: [
            { url: "about/about.htm", title: "Über diese Dokumentation",
              tree: [
                  { url: "about/document_conventions.htm", title: "Dokumentationskonventionen" },
                  { url: "about/online_information.htm", title: "Online-Informationen und Support" },
                  { url: "about/data_protection.htm", title: "Datenschutz" },
              ]
            },
            { url: "using/use-over.htm", title: "Natural benutzen",
              tree: [
                  { url: "using/use_mf_invoke_terminate_session.htm", title: "Natural-Session aufrufen und beenden" },
                  { url: "using/use_mf_execute.htm", title: "Kommandos und Menü-Funktionen benutzen" },
                  { url: "using/use_mf_help.htm", title: "Hilfe benutzen" },
                  { url: "using/use_mf_libs.htm", title: "Natural-Libraries benutzen" },
                  { url: "using/use_mf_objects.htm", title: "Natural-Objekte pflegen und ausführen" },
                  { url: "using/use_mf_menus.htm", title: "Natural-Hauptmenü" },
                  { url: "using/use_mf_print.htm", title: "Druck- und Arbeitsdateien (Printfiles und Workfiles)" },
                  { url: "using/use_mf_config.htm", title: "Natural-Umgebung konfigurieren" },
                  { url: "using/use_rules.htm", title: "Regeln und Namenskonventionen" },
              ]
            },
            { url: "arc/arc-over.htm", title: "System-Architektur",
              tree: [
                  { url: "arc/base_arc_overview.htm", title: "Natural-Architektur",
                    tree: [
                        { url: "arc/nucleus_mf.htm", title: "Natural-Nukleus" },
                        { url: "arc/work_area.htm", title: "Benutzer-Session-Daten" },
                        { url: "arc/buffer.htm", title: "Natural Buffer Pool" },
                        { url: "arc/tools.htm", title: "Natural-Editoren und Natural-Utilities" },
                        { url: "arc/tp_mf.htm", title: "TP/OS-Schnittstelle" },
                        { url: "arc/user_inter.htm", title: "Benutzerschnittstelle" },
                        { url: "arc/work_print.htm", title: "Druckdateien und Arbeitsdateien" },
                        { url: "arc/files.htm", title: "Natural-Systemdateien" },
                        { url: "arc/db_inter.htm", title: "DBMS-Schnittstelle - Datenbankzugriff" },
                    ]
                  },
                  { url: "arc/one_arc.htm", title: "NaturalONE-Architektur" },
                  { url: "arc/what_is_nat1.htm", title: "Was ist NaturalONE?" },
                  { url: "arc/intro-modes.htm", title: "Verschiedene Modi für die Entwicklung von Natural-Anwendungen" },
                  { url: "arc/intro-version.htm", title: "Verwendung eines Versionskontrollsystems" },
                  { url: "arc/spod_arc_overview.htm", title: "Natural-SPoD-Architektur" },
              ]
            },
            { url: "firststeps/fs-over.htm", title: "Erste Schritte",
              tree: [
                  { url: "firststeps/fs-about.htm", title: "Über dieses Tutorial" },
                  { url: "firststeps/fs-start.htm", title: "Grundlagen der Benutzung" },
                  { url: "firststeps/fs-hello.htm", title: "Hello World!" },
                  { url: "firststeps/fs-dbaccess.htm", title: "Datenbankzugriff" },
                  { url: "firststeps/fs-input.htm", title: "Benutzereingaben" },
                  { url: "firststeps/fs-loop.htm", title: "Verarbeitungsschleifen und Labels" },
                  { url: "firststeps/fs-inlinesub.htm", title: "Interne Subroutinen" },
                  { url: "firststeps/fs-proc.htm", title: "Verarbeitungsregeln und Helproutinen" },
                  { url: "firststeps/fs-lda.htm", title: "Local Data Areas" },
                  { url: "firststeps/fs-gda.htm", title: "Global Data Areas" },
                  { url: "firststeps/fs-extsub.htm", title: "Externe Subroutinen" },
                  { url: "firststeps/fs-subprog.htm", title: "Subprogramme" },
              ]
            },
            { url: "unicode/uni-over.htm", title: "Unicode- und Codepage-Unterstützung",
              tree: [
                  { url: "unicode/uni-intro.htm", title: "Einführung" },
                  { url: "unicode/uni-enable.htm", title: "Unicode- und Codepage-Unterstützung aktivieren" },
                  { url: "unicode/uni_ics322.htm", title: "ICS 322" },
                  { url: "unicode/uni-config.htm", title: "Unicode-/Codepage-Umgebung konfigurieren und verwalten" },
                  { url: "unicode/uni-devenv.htm", title: "Entwicklungsumgebung" },
                  { url: "unicode/uni-language.htm", title: "Unicode- und Codepage-Unterstützung in der Natural-Programmiersprache" },
                  { url: "unicode/uni-io.htm", title: "Behandlung von Unicode-Ein-/Ausgaben in Natural-Anwendungen" },
                  { url: "unicode/uni-bidir.htm", title: "Unterstützung bidirektionaler Sprachen" },
                  { url: "unicode/uni-data.htm", title: "Unicode-Datenspeicherung" },
                  { url: "unicode/uni-migrate.htm", title: "Migration existierender Anwendungen" },
                  { url: "unicode/uni-faq.htm", title: "Häufig gestellte Fragen" },
              ]
            },
            { url: "rnotes_mf/rn-mf-over.htm", title: "Natural Version 9.2.3 Freigabemitteilung für Großrechner",
              tree: [
                  { url: "rnotes_mf/rn_docu_de.htm", title: "Dokumentation" },
                  { url: "rnotes_mf/rn-mf-env.htm", title: "Unterstützte Umgebungen" },
                  { url: "rnotes_mf/rn-mf-sag-available-supported.htm", title: "Verfügbare und unterstützte Software AG-Produktversionen" },
                  { url: "rnotes_mf/rn-mf-inst-comp.htm", title: "Installation und Kompatibilität" },
                  { url: "rnotes_mf/rn-mf-ce.htm", title: "Neue und geänderte Merkmale des Basisprodukts Natural" },
                  { url: "rnotes_mf/rn-mf-add-on-new.htm", title: "Neue und geänderte Merkmale der Natural Add-On-Produkte" },
                  { url: "rnotes_mf/rn-mf-dropped.htm", title: "Weggefallene Merkmale" },
                  { url: "rnotes_mf/rn-mf-prev-relnotes.htm", title: "Frühere Release Notes" },
              ]
            },
            { url: "license/license.htm", title: "Software AG Mainframe-Produktlizenzierung" },
            { url: "inst_zos/inst_zos-over.htm", title: "Installation for z/OS",
              tree: [
                  { url: "inst_zos/install_process_overview.htm", title: "Installation Process and Major Natural Features on z/OS" },
                  { url: "inst_zos/install_nat.htm", title: "Installing Natural on z/OS" },
                  { url: "inst_zos/install_ics.htm", title: "Installing International Components for Unicode for Software AG on z/OS" },
                  { url: "inst_zos/install_reqdoc.htm", title: "Installation for REQUEST DOCUMENT, PARSE JSON, and PARSE XML Statements on z/OS" },
                  { url: "inst_zos/install_esx.htm", title: "Installing Entire System Server Interface on z/OS" },
                  { url: "inst_zos/install_sagedt.htm", title: "Installing Software AG Editor on z/OS" },
                  { url: "inst_zos/install_nci.htm", title: "Installing Natural CICS Interface on z/OS" },
                  { url: "inst_zos/install_ncf.htm", title: "Installing Natural Com-plete/SMARTS Interface on z/OS" },
                  { url: "inst_zos/install_nii.htm", title: "Installing Natural IMS TM Interface on z/OS" },
                  { url: "inst_zos/install_nti.htm", title: "Installing Natural TSO Interface on z/OS" },
                  { url: "inst_zos/install_ndb.htm", title: "Installing Natural for Db2 Version on z/OS" },
                  { url: "inst_zos/install_ndz.htm", title: "Installing Natural for Db2 for zIIP Version 9.2.3 on z/OS" },
                  { url: "inst_zos/install_nvs.htm", title: "Installing Natural for VSAM on z/OS",
                    tree: [
                        { url: "inst_zos/install_nvs_prerequisites.htm", title: "Prerequisites" },
                        { url: "inst_zos/install_nvs_ada_files.htm", title: "Installing Natural for VSAM on Adabas System Files on z/OS" },
                        { url: "inst_zos/install_nvs_vsam_files.htm", title: "Installing Natural for VSAM on VSAM System Files on z/OS" },
                    ]
                  },
                  { url: "inst_zos/install_nsc.htm", title: "Installing Natural Security on z/OS" },
                  { url: "inst_zos/install_nsf.htm", title: "Installing Natural SAF Security on z/OS" },
                  { url: "inst_zos/install_naf.htm", title: "Installing Natural Advanced Facilities on z/OS",
                    tree: [
                        { url: "inst_zos/install_naf_nci.htm", title: "Installing Natural Advanced Facilities under CICS on z/OS" },
                        { url: "inst_zos/install_naf_cics_veri.htm", title: "Installation Verification for Natural Advanced Facilities under CICS on z/OS" },
                        { url: "inst_zos/install_naf_nii_zos.htm", title: "Installing Natural Advanced Facilities under IMS TM on z/OS" },
                    ]
                  },
                  { url: "inst_zos/install_noc.htm", title: "Installing Natural Optimizer Compiler on z/OS" },
                  { url: "inst_zos/install_ntc.htm", title: "Installing Natural Connection on z/OS" },
                  { url: "inst_zos/install_rnm.htm", title: "Installing Natural Review" },
                  { url: "inst_zos/install_naz.htm", title: "Installing Natural for zIIP on z/OS" },
              ]
            },
            { url: "ops_mf/ops_mf-over.htm", title: "Operations (Verwaltung/Betrieb)",
              tree: [
                  { url: "ops_mf/conf-over.htm", title: "Natural konfigurieren",
                    tree: [
                        { url: "ops_mf/conf_link.htm", title: "Natural-Objekte mit dem Natural-Nukleus verlinken" },
                        { url: "ops_mf/conf_usrex.htm", title: "Natural User Exits" },
                        { url: "ops_mf/conf_access.htm", title: "Natural User Access Method für Druck- und Arbeitsdateien" },
                        { url: "ops_mf/conf_system_files.htm", title: "Natural-Systemdateien" },
                        { url: "ops_mf/conf_txtmod_macros.htm", title: "Natural-Text-Module und Makros" },
                        { url: "ops_mf/conf_conf.htm", title: "Natural-Konfigurationstabellen" },
                        { url: "ops_mf/conf_stormng.htm", title: "Natural-Speicherverwaltung" },
                    ]
                  },
                  { url: "ops_mf/parmov-over.htm", title: "Profilparameter anwenden",
                    tree: [
                        { url: "ops_mf/parmov_hi.htm", title: "Natural-Parameter-Hierarchie" },
                        { url: "ops_mf/parmov_as.htm", title: "Zuweisung von Parameterwerten" },
                        { url: "ops_mf/build_parm_module.htm", title: "Generierung eines Natural-Parametermoduls" },
                    ]
                  },
                  { url: "ops_mf/zos-over.htm", title: "z/OS-Umgebung",
                    tree: [
                        { url: "ops_mf/zos_env.htm", title: "Natural unter z/OS" },
                        { url: "ops_mf/zos_asm.htm", title: "Authorized Services Manager unter z/OS" },
                        { url: "ops_mf/zos_fun.htm", title: "Natural Roll Server-Funktionen" },
                        { url: "ops_mf/zos_op.htm", title: "Betrieb des Natural Roll Server" },
                    ]
                  },
                  { url: "ops_mf/batch-over.htm", title: "Natural im Batch-Modus",
                    tree: [
                        { url: "ops_mf/batch_gen.htm", title: "Natural im Batch-Modus - Allgemeines" },
                        { url: "ops_mf/batch_zos.htm", title: "Natural im Batch-Modus unter z/OS" },
                    ]
                  },
                  { url: "ops_mf/bp-over.htm", title: "Natural Buffer Pools",
                    tree: [
                        { url: "ops_mf/bp_buff.htm", title: "Natural Buffer Pool - Allgemeines" },
                        { url: "ops_mf/bp_gbpzos.htm", title: "Natural Global Buffer Pool under z/OS" },
                    ]
                  },
                  { url: "ops_mf/mbp.htm", title: "Message Buffer Pool verwenden" },
                  { url: "ops_mf/spool-over.htm", title: "System-Spool-Zugang verwalten" },
                  { url: "ops_mf/calln-over.htm", title: "Natural 3GL CALLNAT-Schnittstelle verwenden",
                    tree: [
                        { url: "ops_mf/calln-preliminaries.htm", title: "Natural 3GL CALLNAT-Schnittstelle - Zweck, Voraussetzungen, Einschränkungen" },
                        { url: "ops_mf/calln-usage-examples.htm", title: "Natural 3GL CALLNAT-Schnittstelle - Verwendung, Beispiele" },
                    ]
                  },
                  { url: "ops_mf/sagedt-over.htm", title: "Betrieb des Software AG-Editors",
                    tree: [
                        { url: "ops_mf/sagedt_wfile.htm", title: "Editor-Arbeitsdatei" },
                        { url: "ops_mf/sagedt_edbp.htm", title: "Editor Buffer Pool" },
                    ]
                  },
                  { url: "ops_mf/servmon-over.htm", title: "Natural als Server",
                    tree: [
                        { url: "ops_mf/servmon_zos.htm", title: "Natural als Server unter z/OS" },
                        { url: "ops_mf/servmon_cics.htm", title: "Natural als Server unter CICS" },
                    ]
                  },
                  { url: "ops_mf/misc-over.htm", title: "Natural-Ausführung - Verschiedene Themen",
                    tree: [
                        { url: "ops_mf/misc_bit.htm", title: "Natural 31-Bit Mode-Unterstützung" },
                        { url: "ops_mf/misc_objects.htm", title: "Unterstützung und Nutzung von Natural- und Nicht-Natural-Objekten" },
                        { url: "ops_mf/misc_devs.htm", title: "Eingabe-/Ausgabegeräte" },
                        { url: "ops_mf/misc_dbcs.htm", title: "Doppel-Byte-Zeichensätze" },
                        { url: "ops_mf/misc_async.htm", title: "Asynchrone Verarbeitung" },
                    ]
                  },
              ]
            },
            { url: "webio/webio-over.htm", title: "Natural Web I/O Interface",
              tree: [
                  { url: "webio/webio-intro.htm", title: "Introduction" },
                  { url: "webio/nwo-cics-intro.htm", title: "Introducing the Natural Web I/O Interface Server CICS Adapter" },
                  { url: "webio/nwo-ims-intro.htm", title: "Introducing the Natural Web I/O Interface Server IMS Adapter" },
                  { url: "webio/nwo-over.htm", title: "Installing and Configuring the Natural Web I/O Interface Server",
                    tree: [
                        { url: "webio/nwo-concept.htm", title: "Natural Web I/O Interface Server Concept and Structure" },
                        { url: "webio/nwo-prereq.htm", title: "Prerequisites" },
                        { url: "webio/nwo-inst-zos.htm", title: "Installing the Natural Web I/O Interface Server under z/OS" },
                        { url: "webio/nwo-conf.htm", title: "Configuring the Natural Web I/O Interface Server" },
                        { url: "webio/nwo-cics-instos.htm", title: "Installing the Natural Web I/O Interface Server CICS Adapter under z/OS" },
                        { url: "webio/nwo-cics-conf.htm", title: "Configuring the Natural Web I/O Interface Server CICS Adapter" },
                        { url: "webio/nwo-ims-instos.htm", title: "Installing the Natural Web I/O Interface Server IMS Adapter" },
                        { url: "webio/nwo-ims-conf.htm", title: "Configuring the Natural Web I/O Interface Server IMS Adapter" },
                    ]
                  },
                  { url: "webio/nwoclient-over.htm", title: "Installing the Natural Web I/O Interface Client",
                    tree: [
                        { url: "webio/nwoclient-prereq.htm", title: "Prerequisites" },
                        { url: "webio/nwoclient-installtomcat.htm", title: "Installing the Natural Web I/O Interface Client on Apache Tomcat" },
                        { url: "webio/nwoclient-migrateiis.htm", title: "Migrating the Natural Web I/O Interface Client from IIS to Apache Tomcat" },
                    ]
                  },
                  { url: "webio/clientcfg-over.htm", title: "Configuring the Client",
                    tree: [
                        { url: "webio/clientcfg-logon.htm", title: "About the Logon Page" },
                        { url: "webio/clientcfg-tool.htm", title: "Natural Client Configuration Tool" },
                        { url: "webio/clientcfg-ajax.htm", title: "Ajax Configuration" },
                        { url: "webio/cfg-mode.htm", title: "Design Time Mode and Runtime Mode" },
                        { url: "webio/clientcfg-css.htm", title: "Natural Web I/O Style Sheets" },
                        { url: "webio/multilanguagemanagement.htm", title: "Multi-Language Management" },
                        { url: "webio/clientcfg-url.htm", title: "Starting a Natural Application with a URL" },
                        { url: "webio/clientcfg-security-container.htm", title: "Configuring Container-Managed Security" },
                        { url: "webio/clientcfg-ssl.htm", title: "Configuring SSL" },
                        { url: "webio/clientcfg-log.htm", title: "Logging" },
                    ]
                  },
                  { url: "webio/nwo-cfgmon-over.htm", title: "Operating and Monitoring the Natural Web I/O Interface Server",
                    tree: [
                        { url: "webio/nwo-operating.htm", title: "Operating the Natural Web I/O Interface Server" },
                        { url: "webio/nwo-natmopi.htm", title: "Monitor Client NATMOPI" },
                        { url: "webio/nwo-htmlmon.htm", title: "HTML Monitor Client" },
                    ]
                  },
              ]
            },
            { url: "tp_mf/tp_mf-over.htm", title: "TP-Monitor-Schnittstellen",
              tree: [
                  { url: "tp_mf/tpuse.htm", title: "Verwendung von Natural mit TP-Monitoren" },
                  { url: "tp_mf/nci-docu.htm", title: "Natural unter CICS",
                    tree: [
                        { url: "tp_mf/nci_ziip.htm", title: "Unterstützung für zIIP unter CICS" },
                        { url: "tp_mf/cicsif.htm", title: "Funktionsweise der Natural CICS-Schnittstelle" },
                        { url: "tp_mf/cicspar.htm", title: "Natural-CICS-Generierungsparameter" },
                        { url: "tp_mf/cicsmrol.htm", title: "Anpassung von VSAM RRDS Roll Files" },
                        { url: "tp_mf/cicsmro.htm", title: "Natural in CICS MRO-Umgebungen" },
                        { url: "tp_mf/cicsnod.htm", title: "CICS-Knotenfehlerprogramm und Freigabe aller Ressourcen bei Zeitüberschreitung einer Natural-Sitzung" },
                        { url: "tp_mf/cicsbrg.htm", title: "Unterstützung der CICS 3270 Bridge" },
                        { url: "tp_mf/cicsts.htm", title: "Überlegungen zur Thread-Sicherheit" },
                        { url: "tp_mf/cics_open_transaction.htm", title: "Überlegungen zur CICS Open Transaction-Umgebung" },
                        { url: "tp_mf/cicscs.htm", title: "Unterstützung von CICS-Channels und -Containern" },
                        { url: "tp_mf/cicsle.htm", title: "Natural CICS-Schnittstelle und IBM Language Environment (LE)" },
                        { url: "tp_mf/cicsfun.htm", title: "Spezielle Natural CICS-Funktionalität" },
                        { url: "tp_mf/cicsprg.htm", title: "Natural CICS-Beispielprogramme" },
                        { url: "tp_mf/cicsinv.htm", title: "Aufruf von Natural aus Benutzerprogrammen" },
                        { url: "tp_mf/cicsasy.htm", title: "Asynchrone Natural-Verarbeitung unter CICS" },
                        { url: "tp_mf/cicslog.htm", title: "Protokollieren von Natural-Sitzungen unter CICS" },
                        { url: "tp_mf/cicsprf.htm", title: "Natural CICS Performance-Überlegungen" },
                        { url: "tp_mf/cicswf.htm", title: "Natural-Druck- und Arbeitsdateien unter CICS" },
                    ]
                  },
                  { url: "tp_mf/cmpl.htm", title: "Natural unter Com-plete/SMARTS" },
                  { url: "tp_mf/ims-over.htm", title: "Natural unter IMS TM",
                    tree: [
                        { url: "tp_mf/imsenv.htm", title: "Natural unter IMS TM - Umgebungen" },
                        { url: "tp_mf/imscom.htm", title: "Natural unter IMS TM - Komponenten" },
                        { url: "tp_mf/nii_configuration.htm", title: "Natural unter IMS TM - Konfiguration" },
                        { url: "tp_mf/imsprg.htm", title: "Natural unter IMS TM - Serviceprogramme" },
                        { url: "tp_mf/imsmod.htm", title: "Natural unter IMS TM - Servicemodule" },
                        { url: "tp_mf/imsusr.htm", title: "Natural unter IMS TM - User Exits" },
                        { url: "tp_mf/imsfun.htm", title: "Natural unter IMS TM - Spezielle Funktionen" },
                        { url: "tp_mf/imsrec.htm", title: "Natural unter IMS TM - Wiederherstellungsbehandlung" },
                    ]
                  },
                  { url: "tp_mf/tso.htm", title: "Natural unter TSO" },
              ]
            },
            { url: "dbms/dbms-over.htm", title: "Datenbankmanagementsystem-Schnittstellen",
              tree: [
                  { url: "dbms/db2-over.htm", title: "Natural for Db2",
                    tree: [
                        { url: "dbms/ndb-gen.htm", title: "Allgemeine Informationen" },
                        { url: "dbms/ndb-tableaccess.htm", title: "Zugriff auf eine Db2-Tabelle" },
                        { url: "dbms/ndb-tools-using.htm", title: "Natural Tools for Db2 benutzen" },
                        { url: "dbms/ndb-apm.htm", title: "Anwendungspläne verwalten" },
                        { url: "dbms/ndb-cm.htm", title: "Katalog verwalten" },
                        { url: "dbms/ndb-isql.htm", title: "Interaktives SQL" },
                        { url: "dbms/ndb-rst.htm", title: "Systemtabellen abrufen" },
                        { url: "dbms/ndb-envset.htm", title: "Environment Setting-Funktionen benutzen" },
                        { url: "dbms/ndb-explain.htm", title: "Explain PLAN_TABLE-Funktionalität benutzen" },
                        { url: "dbms/ndb-servstat.htm", title: "File Server-Statistiken" },
                        { url: "dbms/ndb-db2cmds.htm", title: "Db2-Kommandos aus Natural absetzen" },
                        { url: "dbms/ndb-natsyscom.htm", title: "Natural-Systemkommandos für Db2 benutzen" },
                        { url: "dbms/ndb-ddm.htm", title: "Natural-Datendefinitionsmodule (DDMs) generieren" },
                        { url: "dbms/ndb-sqlsupp.htm", title: "Dynamische und statische SQL-Unterstützung" },
                        { url: "dbms/ndb-natsm.htm", title: "Natural-Statements und Systemvariablen benutzen" },
                        { url: "dbms/ndb-storedproc.htm", title: "Verarbeitung von Natural Stored Procedures und UDFs" },
                        { url: "dbms/ndb-subpgm.htm", title: "Interface-Subprogramme" },
                        { url: "dbms/ndb-fserv.htm", title: "Natural File Server für Db2" },
                        { url: "dbms/ndb-dyntrace.htm", title: "Tracing von dynamischen SQL-Statements" },
                    ]
                  },
                  { url: "dbms/ndb-ziip.htm", title: "Natural for Db2 for zIIP",
                    tree: [
                        { url: "dbms/ndb-ziip-over.htm", title: "Übersicht" },
                        { url: "dbms/ndb-ziip-unsupported-restricted-functions.htm", title: "Einschränkungen" },
                        { url: "dbms/ndb-ziip-oper.htm", title: "Betrieb" },
                        { url: "dbms/ndb-ziip-configparm.htm", title: "Konfiguration und Parameter für NDZ" },
                        { url: "dbms/ndb-ziip-error.htm", title: "Fehlercodes" },
                        { url: "dbms/ndb-ziip-prepstexec.htm", title: "Programme zur statischen Ausführung vorbereiten" },
                        { url: "dbms/ndb-ziip-statexec.htm", title: "Statische Programmausführung" },
                    ]
                  },
                  { url: "dbms/nvs-over.htm", title: "Natural for VSAM",
                    tree: [
                        { url: "dbms/nvs-gen.htm", title: "Allgemeine Informationen" },
                        { url: "dbms/nvs-intro.htm", title: "Einführung in Natural für VSAM" },
                        { url: "dbms/nvs-customiz.htm", title: "Natural für VSAM anpassen" },
                        { url: "dbms/nvs-ops.htm", title: "Betrieb" },
                        { url: "dbms/nvs-natsmtl.htm", title: "Natural-Statements und Natural-Transaktionslogik mit VSAM" },
                    ]
                  },
              ]
            },
            { url: "mc_mf/mc-over.htm", title: "Messages and Codes",
              tree: [
                  { url: "mc_mf/mc_err-over.htm", title: "Natural System Error Messages",
                    tree: [
                        { url: "mc_mf/mcERRN_0001.htm", title: "Natural System Error Messages 0001-0049" },
                        { url: "mc_mf/mcERRN_0050.htm", title: "Natural System Error Messages 0050-0099" },
                        { url: "mc_mf/mcERRN_0100.htm", title: "Natural System Error Messages 0100-0149" },
                        { url: "mc_mf/mcERRN_0150.htm", title: "Natural System Error Messages 0150-0199" },
                        { url: "mc_mf/mcERRN_0200.htm", title: "Natural System Error Messages 0200-0249" },
                        { url: "mc_mf/mcERRN_0250.htm", title: "Natural System Error Messages 0250-0299" },
                        { url: "mc_mf/mcERRN_0300.htm", title: "Natural System Error Messages 0300-0349" },
                        { url: "mc_mf/mcERRN_0350.htm", title: "Natural System Error Messages 0350-0399" },
                        { url: "mc_mf/mcERRN_0400.htm", title: "Natural System Error Messages 0400-0449" },
                        { url: "mc_mf/mcERRN_0450.htm", title: "Natural System Error Messages 0450-0499" },
                        { url: "mc_mf/mcERRN_0550.htm", title: "Natural System Error Messages 0550-0599" },
                        { url: "mc_mf/mcERRN_0600.htm", title: "Natural System Error Messages 0600-0649" },
                        { url: "mc_mf/mcERRN_0650.htm", title: "Natural System Error Messages 0650-0699" },
                        { url: "mc_mf/mcERRN_0700.htm", title: "Natural System Error Messages 0700-0749" },
                        { url: "mc_mf/mcERRN_0750.htm", title: "Natural System Error Messages 0750-0799" },
                        { url: "mc_mf/mcERRN_0800.htm", title: "Natural System Error Messages 0800-0849" },
                        { url: "mc_mf/mcERRN_0850.htm", title: "Natural System Error Messages 0850-0899" },
                        { url: "mc_mf/mcERRN_0900.htm", title: "Natural System Error Messages 0900-0949" },
                        { url: "mc_mf/mcERRN_0950.htm", title: "Natural System Error Messages 0950-0999" },
                        { url: "mc_mf/mcERRN_1000.htm", title: "Natural System Error Messages 1000-1049" },
                        { url: "mc_mf/mcERRN_1050.htm", title: "Natural System Error Messages 1050-1099" },
                        { url: "mc_mf/mcERRN_1100.htm", title: "Natural System Error Messages 1100-1149" },
                        { url: "mc_mf/mcERRN_1150.htm", title: "Natural System Error Messages 1150-1199" },
                        { url: "mc_mf/mcERRN_1200.htm", title: "Natural System Error Messages 1200-1249" },
                        { url: "mc_mf/mcERRN_1250.htm", title: "Natural System Error Messages 1250-1299" },
                        { url: "mc_mf/mcERRN_1300.htm", title: "Natural System Error Messages 1300-1349" },
                        { url: "mc_mf/mcERRN_1350.htm", title: "Natural System Error Messages 1350-1399" },
                        { url: "mc_mf/mcERRN_1400.htm", title: "Natural System Error Messages 1400-1449" },
                        { url: "mc_mf/mcERRN_1500.htm", title: "Natural System Error Messages 1500-1549" },
                        { url: "mc_mf/mcERRN_1550.htm", title: "Natural System Error Messages 1550-1599" },
                        { url: "mc_mf/mcERRN_1600.htm", title: "Natural System Error Messages 1600-1649" },
                        { url: "mc_mf/mcERRN_1650.htm", title: "Natural System Error Messages 1650-1699" },
                        { url: "mc_mf/mcERRN_1700.htm", title: "Natural System Error Messages 1700-1749" },
                        { url: "mc_mf/mcERRN_1800.htm", title: "Natural System Error Messages 1800-1849" },
                        { url: "mc_mf/mcERRN_1950.htm", title: "Natural System Error Messages 1950-1999" },
                        { url: "mc_mf/mcERRN_2000.htm", title: "Natural System Error Messages 2000-2049" },
                        { url: "mc_mf/mcERRN_2150.htm", title: "Natural System Error Messages 2150-2199" },
                        { url: "mc_mf/mcERRN_2650.htm", title: "Natural System Error Messages 2650-2699" },
                        { url: "mc_mf/mcERRN_2950.htm", title: "Natural System Error Messages 2950-2999" },
                        { url: "mc_mf/mcERRN_3000.htm", title: "Natural System Error Messages 3000-3049" },
                        { url: "mc_mf/mcERRN_3050.htm", title: "Natural System Error Messages 3050-3099" },
                        { url: "mc_mf/mcERRN_3100.htm", title: "Natural System Error Messages 3100-3149" },
                        { url: "mc_mf/mcERRN_3150.htm", title: "Natural System Error Messages 3150-3199" },
                        { url: "mc_mf/mcERRN_3200.htm", title: "Natural System Error Messages 3200-3249" },
                        { url: "mc_mf/mcERRN_3250.htm", title: "Natural System Error Messages 3250-3299" },
                        { url: "mc_mf/mcERRN_3400.htm", title: "Natural System Error Messages 3400-3449" },
                        { url: "mc_mf/mcERRN_3500.htm", title: "Natural System Error Messages 3500-3549" },
                        { url: "mc_mf/mcERRN_3550.htm", title: "Natural System Error Messages 3550-3599" },
                        { url: "mc_mf/mcERRN_3600.htm", title: "Natural System Error Messages 3600-3649" },
                        { url: "mc_mf/mcERRN_3700.htm", title: "Natural System Error Messages 3700-3749" },
                        { url: "mc_mf/mcERRN_3750.htm", title: "Natural System Error Messages 3750-3799" },
                        { url: "mc_mf/mcERRN_3800.htm", title: "Natural System Error Messages 3800-3849" },
                        { url: "mc_mf/mcERRN_3850.htm", title: "Natural System Error Messages 3850-3899" },
                        { url: "mc_mf/mcERRN_3900.htm", title: "Natural System Error Messages 3900-3949" },
                        { url: "mc_mf/mcERRN_3950.htm", title: "Natural System Error Messages 3950-3999" },
                        { url: "mc_mf/mcERRN_4000.htm", title: "Natural System Error Messages 4000-4049" },
                        { url: "mc_mf/mcERRN_4050.htm", title: "Natural System Error Messages 4050-4099" },
                        { url: "mc_mf/mcERRN_4100.htm", title: "Natural System Error Messages 4100-4149" },
                        { url: "mc_mf/mcERRN_4150.htm", title: "Natural System Error Messages 4150-4199" },
                        { url: "mc_mf/mcERRN_4200.htm", title: "Natural System Error Messages 4200-4249" },
                        { url: "mc_mf/mcERRN_4250.htm", title: "Natural System Error Messages 4250-4299" },
                        { url: "mc_mf/mcERRN_4300.htm", title: "Natural System Error Messages 4300-4349" },
                        { url: "mc_mf/mcERRN_4350.htm", title: "Natural System Error Messages 4350-4399" },
                        { url: "mc_mf/mcERRN_4400.htm", title: "Natural System Error Messages 4400-4449" },
                        { url: "mc_mf/mcERRN_4450.htm", title: "Natural System Error Messages 4450-4499" },
                        { url: "mc_mf/mcERRN_4500.htm", title: "Natural System Error Messages 4500-4549" },
                        { url: "mc_mf/mcERRN_4550.htm", title: "Natural System Error Messages 4550-4599" },
                        { url: "mc_mf/mcERRN_4600.htm", title: "Natural System Error Messages 4600-4649" },
                        { url: "mc_mf/mcERRN_4650.htm", title: "Natural System Error Messages 4650-4699" },
                        { url: "mc_mf/mcERRN_4700.htm", title: "Natural System Error Messages 4700-4749" },
                        { url: "mc_mf/mcERRN_4750.htm", title: "Natural System Error Messages 4750-4799" },
                        { url: "mc_mf/mcERRN_4800.htm", title: "Natural System Error Messages 4800-4849" },
                        { url: "mc_mf/mcERRN_4850.htm", title: "Natural System Error Messages 4850-4899" },
                        { url: "mc_mf/mcERRN_4900.htm", title: "Natural System Error Messages 4900-4949" },
                        { url: "mc_mf/mcERRN_4950.htm", title: "Natural System Error Messages 4950-4999" },
                        { url: "mc_mf/mcERRN_5000.htm", title: "Natural System Error Messages 5000-5049" },
                        { url: "mc_mf/mcERRN_5050.htm", title: "Natural System Error Messages 5050-5099" },
                        { url: "mc_mf/mcERRN_5100.htm", title: "Natural System Error Messages 5100-5149" },
                        { url: "mc_mf/mcERRN_5150.htm", title: "Natural System Error Messages 5150-5199" },
                        { url: "mc_mf/mcERRN_5200.htm", title: "Natural System Error Messages 5200-5249" },
                        { url: "mc_mf/mcERRN_5250.htm", title: "Natural System Error Messages 5250-5299" },
                        { url: "mc_mf/mcERRN_5300.htm", title: "Natural System Error Messages 5300-5349" },
                        { url: "mc_mf/mcERRN_5350.htm", title: "Natural System Error Messages 5350-5399" },
                        { url: "mc_mf/mcERRN_5400.htm", title: "Natural System Error Messages 5400-5449" },
                        { url: "mc_mf/mcERRN_5450.htm", title: "Natural System Error Messages 5450-5499" },
                        { url: "mc_mf/mcERRN_5500.htm", title: "Natural System Error Messages 5500-5549" },
                        { url: "mc_mf/mcERRN_5550.htm", title: "Natural System Error Messages 5550-5599" },
                        { url: "mc_mf/mcERRN_5600.htm", title: "Natural System Error Messages 5600-5649" },
                        { url: "mc_mf/mcERRN_5650.htm", title: "Natural System Error Messages 5650-5699" },
                        { url: "mc_mf/mcERRN_5700.htm", title: "Natural System Error Messages 5700-5749" },
                        { url: "mc_mf/mcERRN_5750.htm", title: "Natural System Error Messages 5750-5799" },
                        { url: "mc_mf/mcERRN_5800.htm", title: "Natural System Error Messages 5800-5849" },
                        { url: "mc_mf/mcERRN_5850.htm", title: "Natural System Error Messages 5850-5899" },
                        { url: "mc_mf/mcERRN_5900.htm", title: "Natural System Error Messages 5900-5949" },
                        { url: "mc_mf/mcERRN_5950.htm", title: "Natural System Error Messages 5950-5999" },
                        { url: "mc_mf/mcERRN_6000.htm", title: "Natural System Error Messages 6000-6049" },
                        { url: "mc_mf/mcERRN_6050.htm", title: "Natural System Error Messages 6050-6099" },
                        { url: "mc_mf/mcERRN_6100.htm", title: "Natural System Error Messages 6100-6149" },
                        { url: "mc_mf/mcERRN_6150.htm", title: "Natural System Error Messages 6150-6199" },
                        { url: "mc_mf/mcERRN_6200.htm", title: "Natural System Error Messages 6200-6249" },
                        { url: "mc_mf/mcERRN_6250.htm", title: "Natural System Error Messages 6250-6299" },
                        { url: "mc_mf/mcERRN_6300.htm", title: "Natural System Error Messages 6300-6349" },
                        { url: "mc_mf/mcERRN_6350.htm", title: "Natural System Error Messages 6350-6399" },
                        { url: "mc_mf/mcERRN_6400.htm", title: "Natural System Error Messages 6400-6449" },
                        { url: "mc_mf/mcERRN_6450.htm", title: "Natural System Error Messages 6450-6499" },
                        { url: "mc_mf/mcERRN_6500.htm", title: "Natural System Error Messages 6500-6549" },
                        { url: "mc_mf/mcERRN_6700.htm", title: "Natural System Error Messages 6700-6749" },
                        { url: "mc_mf/mcERRN_6750.htm", title: "Natural System Error Messages 6750-6799" },
                        { url: "mc_mf/mcERRN_6800.htm", title: "Natural System Error Messages 6800-6849" },
                        { url: "mc_mf/mcERRN_6850.htm", title: "Natural System Error Messages 6850-6899" },
                        { url: "mc_mf/mcERRN_6900.htm", title: "Natural System Error Messages 6900-6949" },
                        { url: "mc_mf/mcERRN_6950.htm", title: "Natural System Error Messages 6950-6999" },
                        { url: "mc_mf/mcERRN_7000.htm", title: "Natural System Error Messages 7000-7049" },
                        { url: "mc_mf/mcERRN_7050.htm", title: "Natural System Error Messages 7050-7099" },
                        { url: "mc_mf/mcERRN_7200.htm", title: "Natural System Error Messages 7200-7249" },
                        { url: "mc_mf/mcERRN_7350.htm", title: "Natural System Error Messages 7350-7399" },
                        { url: "mc_mf/mcERRN_7400.htm", title: "Natural System Error Messages 7400-7449" },
                        { url: "mc_mf/mcERRN_7500.htm", title: "Natural System Error Messages 7500-7549" },
                        { url: "mc_mf/mcERRN_7600.htm", title: "Natural System Error Messages 7600-7649" },
                        { url: "mc_mf/mcERRN_7650.htm", title: "Natural System Error Messages 7650-7699" },
                        { url: "mc_mf/mcERRN_7700.htm", title: "Natural System Error Messages 7700-7749" },
                        { url: "mc_mf/mcERRN_7950.htm", title: "Natural System Error Messages 7950-7999" },
                        { url: "mc_mf/mcERRN_8000.htm", title: "Natural System Error Messages 8000-8049" },
                        { url: "mc_mf/mcERRN_8200.htm", title: "Natural System Error Messages 8200-8249" },
                        { url: "mc_mf/mcERRN_8250.htm", title: "Natural System Error Messages 8250-8299" },
                        { url: "mc_mf/mcERRN_8300.htm", title: "Natural System Error Messages 8300-8349" },
                        { url: "mc_mf/mcERRN_9000.htm", title: "Natural System Error Messages 9000-9049" },
                        { url: "mc_mf/mcERRN_9100.htm", title: "Natural System Error Messages 9100-9149" },
                        { url: "mc_mf/mcERRN_9200.htm", title: "Natural System Error Messages 9200-9249" },
                        { url: "mc_mf/mcERRN_9850.htm", title: "Natural System Error Messages 9850-9899" },
                        { url: "mc_mf/mcERRN_9900.htm", title: "Natural System Error Messages 9900-9949" },
                        { url: "mc_mf/mcERRN_9950.htm", title: "Natural System Error Messages 9950-9999" },
                    ]
                  },
                  { url: "mc_mf/mc_getmain.htm", title: "GETMAIN Error Numbers in NAT7545" },
                  { url: "mc_mf/mc_freemain.htm", title: "FREEMAIN Error Numbers in NAT7546" },
                  { url: "mc_mf/mc_parse_json.htm", title: "PARSE JSON: Reason Codes for Error Message NAT8331" },
                  { url: "mc_mf/mc_compres.htm", title: "Compression/Decompression Error Messages" },
                  { url: "mc_mf/mc_gbpm.htm", title: "Natural Global Buffer Pool Manager Messages" },
                  { url: "mc_mf/mc_mbp-buffer-pool.htm", title: "Message Buffer Pool Messages" },
                  { url: "mc_mf/mc_rollsrv.htm", title: "Roll Server Messages" },
                  { url: "mc_mf/mc_reason.htm", title: "Return Codes and Reason Codes of the Roll Server Requests" },
                  { url: "mc_mf/mc_asm.htm", title: "Authorized Services Manager Messages" },
                  { url: "mc_mf/mc_sip.htm", title: "SIP Service Return Codes and Reason Codes" },
                  { url: "mc_mf/mc_rpcsrv.htm", title: "RPC Server Front-End Messages" },
                  { url: "mc_mf/mc_complete.htm", title: "Natural under Com-plete/SMARTS User Abend Codes" },
                  { url: "mc_mf/mc_cics.htm", title: "Natural under CICS Messages" },
                  { url: "mc_mf/mc_nii.htm", title: "Natural under IMS TM Error Messages" },
                  { url: "mc_mf/ndb-nsq-messages.htm", title: "Static Generation Messages and Codes Issued under NDB" },
                  { url: "mc_mf/ndb-messages-fssm.htm", title: "Messages from the Shared Memory Objects File Server under NDB" },
                  { url: "mc_mf/ndb-reason-codes-fssm.htm", title: "Reason Codes for the Shared Memory Objects File Server under NDB" },
                  { url: "mc_mf/mc_nvsabc.htm", title: "Natural for VSAM Interface Abend Codes" },
                  { url: "mc_mf/mc_debug_attach_server.htm", title: "Debug Attach Server" },
              ]
            },
            { url: "nsc/nsc-over.htm", title: "Natural Security",
              tree: [
                  { url: "nsc/nsc_struct.htm", title: "Struktur und Terminologie von Natural Security" },
                  { url: "nsc/nsc_platf.htm", title: "Natural Security auf verschiedenen Plattformen" },
                  { url: "nsc/nsc-post-install.htm", title: "Erste Schritte nach der Installation" },
                  { url: "nsc/nsc_logon.htm", title: "Anmeldung (Logon)" },
                  { url: "nsc/nsc_way.htm", title: "Grundlagen der Benutzung" },
                  { url: "nsc/nsc_admin.htm", title: "Administrator Services" },
                  { url: "nsc/nsc_user.htm", title: "Benutzer verwalten" },
                  { url: "nsc/nsc_lib.htm", title: "Bibliotheken verwalten" },
                  { url: "nsc/nsc_prolib.htm", title: "Bibliotheken schützen" },
                  { url: "nsc/nsc_environ.htm", title: "Umgebungen schützen" },
                  { url: "nsc/nsc_ddmmf.htm", title: "DDMs auf Großrechnern schützen" },
                  { url: "nsc/nsc_ddmos.htm", title: "DDMs unter Linux und Windows schützen" },
                  { url: "nsc/nsc_util.htm", title: "Dienstprogramme (Utilities) schützen" },
                  { url: "nsc/nsc_appl.htm", title: "Natural Development Server-Umgebung und -Anwendungen schützen" },
                  { url: "nsc/nsc_naturalONE.htm", title: "Natural-Entwicklungsumgebung in Eclipse schützen" },
                  { url: "nsc/nsc_rpc.htm", title: "Natural RPC Server und Services schützen" },
                  { url: "nsc/nsc_extobj.htm", title: "Externe Objekte schützen" },
                  { url: "nsc/nsc_mail.htm", title: "Mailboxen" },
                  { url: "nsc/nsc_retrie.htm", title: "Retrieval-Funktionen (Retrieval Subsystem)" },
                  { url: "nsc/nsc_count.htm", title: "Gegenzeichnungen (Countersignatures)" },
                  { url: "nsc/nsc_func.htm", title: "Funktionssicherheit" },
                  { url: "nsc/nsc_batch.htm", title: "Natural Security im Batch-Modus" },
                  { url: "nsc/nsc_transf.htm", title: "Sicherheitsdaten in eine andere Systemdatei übertragen" },
                  { url: "nsc/nsc_exits.htm", title: "User Exits" },
                  { url: "nsc/nsc_iface.htm", title: "Anwendungsprogrammierschnittstellen" },
                  { url: "nsc/nsc_addon.htm", title: "Add-on-Produkte und Plug-ins" },
              ]
            },
            { url: "nsf_mf/nsf_mf-over.htm", title: "Natural SAF Security - Overview",
              tree: [
                  { url: "nsf_mf/nsf_mf_intro.htm", title: "Introducing Natural SAF Security" },
                  { url: "nsf_mf/nsf_mf_install.htm", title: "Activating Natural SAF Security" },
                  { url: "nsf_mf/nsf_mf_ext.htm", title: "Defining Resources in the External Security System and Activating Them" },
                  { url: "nsf_mf/nsf_mf_admin.htm", title: "Administrator Services" },
                  { url: "nsf_mf/nsf_mf_exits.htm", title: "Application Programming Interfaces" },
              ]
            },
            { url: "safkernel/safover.htm", title: "SAF Security Kernel",
              tree: [
                  { url: "safkernel/intro.htm", title: "Introduction" },
                  { url: "safkernel/install.htm", title: "Installation" },
                  { url: "safkernel/operator.htm", title: "Operator Commands" },
                  { url: "safkernel/SAF.htm", title: "SAF* - SAF Daemon Messages" },
                  { url: "safkernel/SEFM.htm", title: "SEFM* - ADASAF SAF Interface and SAF Security Kernel Messages" },
                  { url: "safkernel/aafmrtn.htm", title: "SAF Return Codes" },
                  { url: "safkernel/aafmfx.htm", title: "SAF Internal Function Codes" },
                  { url: "safkernel/trcmsgs.htm", title: "Interpreting Trace Messages" },
                  { url: "safkernel/secdef.htm", title: "Security Definitions" },
              ]
            },
            { url: "rpc/rpc-over.htm", title: "Natural RPC (Remote Procedure Call)",
              tree: [
                  { url: "rpc/intro_rpc.htm", title: "Einführung in Natural RPC" },
                  { url: "rpc/prereq.htm", title: "Voraussetzungen und vorbereitende Informationen" },
                  { url: "rpc/limits.htm", title: "Grenzen und Einschränkungen" },
                  { url: "rpc/setup.htm", title: "Einrichten einer Natural RPC-Umgebung" },
                  { url: "rpc/start.htm", title: "Starten eines Natural RPC Servers" },
                  { url: "rpc/end.htm", title: "Beenden eines Natural RPC Servers" },
                  { url: "rpc/oper.htm", title: "Betrieb einer Natural RPC-Umgebung" },
                  { url: "rpc/using.htm", title: "Verwendung des Natural RPC im konversationellen Modus" },
                  { url: "rpc/reliable_rpc.htm", title: "Reliable RPC" },
                  { url: "rpc/rds.htm", title: "Verwendung eines Remote Directory Servers - RDS" },
                  { url: "rpc/securi.htm", title: "Verwendung von Security" },
                  { url: "rpc/rpc-exx-broker-support.htm", title: "EntireX Broker-Unterstützung" },
                  { url: "rpc/apis.htm", title: "API zur Bereitstellung eines RPC-Kontexts von der Natural RPC-Client-Seite" },
                  { url: "rpc/rpc-specific_nat_apis.htm", title: "APIs zur Verwendung beim Natural RPC" },
              ]
            },
            { url: "ntc/ntc-over.htm", title: "Natural Connection",
              tree: [
                  { url: "ntc/ntc-main.htm", title: "Hauptfunktionen" },
                  { url: "ntc/ntc-prep.htm", title: "Vorbereitende Maßnahmen zur Benutzung von Natural Connection" },
                  { url: "ntc/ntc-state.htm", title: "Natural-Statements" },
                  { url: "ntc/ntc-proc.htm", title: "Verarbeitung von Arbeitsdateien und verschachtelten Schleifen" },
              ]
            },
            { url: "naf_mf/naf_mf-over.htm", title: "Natural Advanced Facilities",
              tree: [
                  { url: "naf_mf/naf_mf_intro.htm", title: "Natural Advanced Facilities - Einführung" },
                  { url: "naf_mf/naf_mf_ad.htm", title: "NAF-Administration",
                    tree: [
                        { url: "naf_mf/naf_mf_reports.htm", title: "Reports/Warteschlange (Reports/Queues) - Funktion 10" },
                        { url: "naf_mf/naf_mf_devices.htm", title: "Status der Geräte (Device Status) - Funktion 11" },
                        { url: "naf_mf/naf_mf_abstracts.htm", title: "Kurzdarstellung (Abstracts) - Funktion 12" },
                        { url: "naf_mf/naf_mf_applications.htm", title: "Anwendungen (Applications) - Funktion 13" },
                        { url: "naf_mf/naf_mf_change.htm", title: "Spool-Datei ändern (Change Spool File) - Funktion 14" },
                    ]
                  },
                  { url: "naf_mf/naf_mf_inf.htm", title: "NAF-Informationen",
                    tree: [
                        { url: "naf_mf/naf_mf_crossref.htm", title: "NAF-Cross-Referenzen (Cross-Reference) - Funktion 20" },
                        { url: "naf_mf/naf_mf_statistics.htm", title: "NAF-Statistiken (Statistics) - Funktion 21" },
                        { url: "naf_mf/naf_mf_lookat.htm", title: "Spool-Datei einsehen (Look at Spool File) - Funktion 22" },
                        { url: "naf_mf/naf_mf_callnat.htm", title: "CALLNATs - Funktion 23" },
                    ]
                  },
                  { url: "naf_mf/naf_mf_main.htm", title: "Verwaltungsfunktionen (Maintenance) - Übersicht",
                    tree: [
                        { url: "naf_mf/naf_mf_proper.htm", title: "Spool-Datei-Eigenschaften (Spool File Properties) - Funktion 30" },
                        { url: "naf_mf/naf_mf_objects.htm", title: "NAF-Objekte (Objects) - Funktion 31 - Übersicht" },
                    ]
                  },
                  { url: "naf_mf/naf_mf_uprof.htm", title: "NAF-Benutzerprofil (User Profile) - Funktion 31.1" },
                  { url: "naf_mf/naf_mf_logprint.htm", title: "Logischer Drucker (Logical Printer) - Funktion 31.2" },
                  { url: "naf_mf/naf_mf_alloc.htm", title: "Zuordnungstabelle (Allocation Table) - Funktion 31.3" },
                  { url: "naf_mf/naf_mf_printer.htm", title: "Physischer Drucker (Printer) - Funktion 31.4" },
                  { url: "naf_mf/naf_mf_header.htm", title: "Deckblatt (Header Page) - Funktion 31.5" },
                  { url: "naf_mf/naf_mf_applic.htm", title: "Anwendung (Application) - Funktion 31.6" },
                  { url: "naf_mf/naf_mf_cluster.htm", title: "Cluster - Funktion 31.7" },
                  { url: "naf_mf/naf_mf_ntcc.htm", title: "NTCC-Tabelle (NTCC Table) - Funktion 31.8" },
                  { url: "naf_mf/naf_mf_calendar.htm", title: "Kalender (Calendar) - Funktion 31.9" },
                  { url: "naf_mf/naf_mf_massupd.htm", title: "Massenänderung (Mass Update) - Funktion 32" },
                  { url: "naf_mf/naf_mf_hardcopy.htm", title: "Hardcopy-Zuordnung (Hardcopy Allocation) - Funktion 33" },
                  { url: "naf_mf/naf_mf_transfer.htm", title: "Objekte übertragen (Transfer Objects) - Funktion 34" },
                  { url: "naf_mf/naf_mf_cont.htm", title: "NAF-Kontrollfunktionen - Übersicht",
                    tree: [
                        { url: "naf_mf/naf_mf_check.htm", title: "NAF-Spool-Datei prüfen (Check Spool File) - Funktion 40" },
                        { url: "naf_mf/naf_mf_logging.htm", title: "NAF-Protokolldaten verwalten (Logging Data) - Funktion 41" },
                        { url: "naf_mf/naf_mf_create.htm", title: "Test-Report erstellen (Create Test Report) - Funktion 42" },
                        { url: "naf_mf/naf_mf_delete.htm", title: "Reports nach Datum löschen - Funktion 43" },
                    ]
                  },
                  { url: "naf_mf/naf_mf_nfea.htm", title: "Unterstützte Natural-Merkmale" },
                  { url: "naf_mf/naf_mf_nsec.htm", title: "NATSPOOL und Natural Security" },
                  { url: "naf_mf/naf_mf_cfea.htm", title: "NAF-Funktionen in einer CICS-Umgebung" },
                  { url: "naf_mf/naf_mf_ifea.htm", title: "NAF-Funktionen in einer IMS TM-Umgebung" },
                  { url: "naf_mf/naf_mf_npar.htm", title: "Natural-Profilparameter für NATSPOOL" },
                  { url: "naf_mf/naf_mf_init.htm", title: "NATSPOOL-Initialisierung" },
                  { url: "naf_mf/naf_mf_bat.htm", title: "NATSPOOL im Batch-Modus" },
                  { url: "naf_mf/naf_mf_tso.htm", title: "NATSPOOL unter TSO" },
              ]
            },
            { url: "ziip/ziip-over.htm", title: "Natural for zIIP",
              tree: [
                  { url: "ziip/naz-prereq.htm", title: "Voraussetzungen" },
                  { url: "ziip/naz-general.htm", title: "Allgemeine Informationen zur zIIP-Verarbeitung" },
                  { url: "ziip/naz-nat-processing.htm", title: "Natural zIIP-Verarbeitung: TCBs, SRBs und Enklaven" },
                  { url: "ziip/naz-monitor.htm", title: "Überwachung der zIIP-Nutzung" },
                  { url: "ziip/naz-tune.htm", title: "Tuning der zIIP-Nutzung" },
              ]
            },
            { url: "sm/sm-over.htm", title: "Statements",
              tree: [
                  { url: "sm/synsym.htm", title: "Syntax-Symbole und Operandentabellen" },
                  { url: "sm/stmt_groups.htm", title: "Statements nach Funktionen" },
                  { url: "sm/accept.htm", title: "ACCEPT/REJECT" },
                  { url: "sm/add.htm", title: "ADD" },
                  { url: "sm/assign.htm", title: "ASSIGN" },
                  { url: "sm/atbreak.htm", title: "AT BREAK" },
                  { url: "sm/atenddat.htm", title: "AT END OF DATA" },
                  { url: "sm/atendpag.htm", title: "AT END OF PAGE" },
                  { url: "sm/atstart.htm", title: "AT START OF DATA" },
                  { url: "sm/attoppag.htm", title: "AT TOP OF PAGE" },
                  { url: "sm/backout.htm", title: "BACKOUT TRANSACTION" },
                  { url: "sm/before.htm", title: "BEFORE BREAK PROCESSING" },
                  { url: "sm/call.htm", title: "CALL" },
                  { url: "sm/callfile.htm", title: "CALL FILE" },
                  { url: "sm/callloop.htm", title: "CALL LOOP" },
                  { url: "sm/calldbpr-sql.htm", title: "CALLDBPROC (SQL)" },
                  { url: "sm/callnat.htm", title: "CALLNAT" },
                  { url: "sm/closecon.htm", title: "CLOSE CONVERSATION" },
                  { url: "sm/closepc.htm", title: "CLOSE PC FILE" },
                  { url: "sm/closepri.htm", title: "CLOSE PRINTER" },
                  { url: "sm/closewf.htm", title: "CLOSE WORK FILE" },
                  { url: "sm/commit-sql.htm", title: "COMMIT (SQL)" },
                  { url: "sm/compose.htm", title: "COMPOSE" },
                  { url: "sm/compress.htm", title: "COMPRESS" },
                  { url: "sm/compute.htm", title: "COMPUTE" },
                  { url: "sm/create.htm", title: "CREATE OBJECT" },
                  { url: "sm/decidefo.htm", title: "DECIDE FOR" },
                  { url: "sm/decideon.htm", title: "DECIDE ON" },
                  { url: "sm/definecl.htm", title: "DEFINE CLASS" },
                  { url: "sm/defineda.htm", title: "DEFINE DATA" },
                  { url: "sm/defineda_basic.htm", title: "Funktion und generelle Syntaxregeln" },
                  { url: "sm/defineda_gda.htm", title: "Definition von Global Data" },
                  { url: "sm/defineda_pda.htm", title: "Definition von Parameter Data" },
                  { url: "sm/defineda_lda.htm", title: "Definition von Local Data" },
                  { url: "sm/defineda_aiv.htm", title: "Definition von anwendungsunabhängigen Variablen" },
                  { url: "sm/defineda_cv.htm", title: "Definition von Kontext-Variablen für den Natural RPC" },
                  { url: "sm/defineda_nxx.htm", title: "Definition von NaturalX-Objekten" },
                  { url: "sm/defineda_vari.htm", title: "Definition von Variablen" },
                  { url: "sm/defineda_view.htm", title: "View-Definition" },
                  { url: "sm/defineda_redef.htm", title: "Redefinition" },
                  { url: "sm/defineda_array.htm", title: "Definition von Array-Dimensionen" },
                  { url: "sm/defineda_iniv.htm", title: "Definition eines Ausgangswerts" },
                  { url: "sm/defineda_inia.htm", title: "Ausgangswerte/Konstanten-Werte für ein Array" },
                  { url: "sm/defineda_parms.htm", title: "Parameter EM, HD, PM für Feld/Variable" },
                  { url: "sm/defineda_exa.htm", title: "Beispiele für die Benutzung des DEFINE DATA-Statements" },
                  { url: "sm/definefu.htm", title: "DEFINE FUNCTION" },
                  { url: "sm/definepr_m.htm", title: "DEFINE PRINTER" },
                  { url: "sm/definepro.htm", title: "DEFINE PROTOTYPE" },
                  { url: "sm/definesu.htm", title: "DEFINE SUBROUTINE" },
                  { url: "sm/definewi.htm", title: "DEFINE WINDOW" },
                  { url: "sm/definewo.htm", title: "DEFINE WORK FILE" },
                  { url: "sm/delete.htm", title: "DELETE" },
                  { url: "sm/delete-sql.htm", title: "DELETE (SQL)" },
                  { url: "sm/display.htm", title: "DISPLAY" },
                  { url: "sm/divide.htm", title: "DIVIDE" },
                  { url: "sm/dodoend.htm", title: "DO/DOEND" },
                  { url: "sm/download.htm", title: "DOWNLOAD PC FILE" },
                  { url: "sm/eject.htm", title: "EJECT" },
                  { url: "sm/end.htm", title: "END" },
                  { url: "sm/endtrans.htm", title: "END TRANSACTION" },
                  { url: "sm/escape.htm", title: "ESCAPE" },
                  { url: "sm/examine.htm", title: "EXAMINE" },
                  { url: "sm/expand.htm", title: "EXPAND" },
                  { url: "sm/fetch.htm", title: "FETCH" },
                  { url: "sm/find.htm", title: "FIND" },
                  { url: "sm/for.htm", title: "FOR" },
                  { url: "sm/format.htm", title: "FORMAT" },
                  { url: "sm/get.htm", title: "GET" },
                  { url: "sm/getsame.htm", title: "GET SAME" },
                  { url: "sm/gettrans.htm", title: "GET TRANSACTION DATA" },
                  { url: "sm/histogra.htm", title: "HISTOGRAM" },
                  { url: "sm/if.htm", title: "IF" },
                  { url: "sm/ifselec.htm", title: "IF SELECTION" },
                  { url: "sm/ignore.htm", title: "IGNORE" },
                  { url: "sm/include.htm", title: "INCLUDE" },
                  { url: "sm/input.htm", title: "INPUT" },
                  { url: "sm/input1.htm", title: "INPUT-Syntax 1 — Dynamisch generierter Eingabeschirm" },
                  { url: "sm/input2.htm", title: "INPUT-Syntax 2 — Verwendung einer vordefinierten Eingabemaske" },
                  { url: "sm/insert-sql.htm", title: "INSERT (SQL)" },
                  { url: "sm/interfa.htm", title: "INTERFACE" },
                  { url: "sm/limit.htm", title: "LIMIT" },
                  { url: "sm/loop.htm", title: "LOOP" },
                  { url: "sm/merge-sql.htm", title: "MERGE (SQL)" },
                  { url: "sm/method.htm", title: "METHOD" },
                  { url: "sm/move.htm", title: "MOVE" },
                  { url: "sm/moveindx.htm", title: "MOVE INDEXED" },
                  { url: "sm/multiply.htm", title: "MULTIPLY" },
                  { url: "sm/newpage.htm", title: "NEWPAGE" },
                  { url: "sm/obtain.htm", title: "OBTAIN" },
                  { url: "sm/onerror.htm", title: "ON ERROR" },
                  { url: "sm/opencon.htm", title: "OPEN CONVERSATION" },
                  { url: "sm/options.htm", title: "OPTIONS" },
                  { url: "sm/parse_json.htm", title: "PARSE JSON" },
                  { url: "sm/parse.htm", title: "PARSE XML" },
                  { url: "sm/passw.htm", title: "PASSW" },
                  { url: "sm/perform.htm", title: "PERFORM" },
                  { url: "sm/performb.htm", title: "PERFORM BREAK PROCESSING" },
                  { url: "sm/printsm.htm", title: "PRINT" },
                  { url: "sm/process.htm", title: "PROCESS" },
                  { url: "sm/processc.htm", title: "PROCESS COMMAND" },
                  { url: "sm/processpage.htm", title: "PROCESS PAGE" },
                  { url: "sm/process-sql.htm", title: "PROCESS SQL (SQL)" },
                  { url: "sm/property.htm", title: "PROPERTY" },
                  { url: "sm/read.htm", title: "READ" },
                  { url: "sm/readlob.htm", title: "READLOB" },
                  { url: "sm/read-result-set-sql.htm", title: "READ RESULT SET (SQL)" },
                  { url: "sm/readwork.htm", title: "READ WORK FILE" },
                  { url: "sm/redefine.htm", title: "REDEFINE" },
                  { url: "sm/reduce.htm", title: "REDUCE" },
                  { url: "sm/reinput.htm", title: "REINPUT" },
                  { url: "sm/reject.htm", title: "REJECT" },
                  { url: "sm/release.htm", title: "RELEASE" },
                  { url: "sm/repeat.htm", title: "REPEAT" },
                  { url: "sm/reqdocu.htm", title: "REQUEST DOCUMENT" },
                  { url: "sm/reset.htm", title: "RESET" },
                  { url: "sm/resize.htm", title: "RESIZE" },
                  { url: "sm/retry.htm", title: "RETRY" },
                  { url: "sm/rollback-sql.htm", title: "ROLLBACK (SQL)" },
                  { url: "sm/run.htm", title: "RUN" },
                  { url: "sm/select-sql.htm", title: "SELECT (SQL)" },
                  { url: "sm/sendmeth.htm", title: "SEND METHOD" },
                  { url: "sm/separate.htm", title: "SEPARATE" },
                  { url: "sm/setcontr.htm", title: "SET CONTROL" },
                  { url: "sm/setgloba.htm", title: "SET GLOBALS" },
                  { url: "sm/setkey.htm", title: "SET KEY" },
                  { url: "sm/settime.htm", title: "SET TIME" },
                  { url: "sm/setwindo.htm", title: "SET WINDOW" },
                  { url: "sm/skip.htm", title: "SKIP" },
                  { url: "sm/sort.htm", title: "SORT" },
                  { url: "sm/stack.htm", title: "STACK" },
                  { url: "sm/stop.htm", title: "STOP" },
                  { url: "sm/store.htm", title: "STORE" },
                  { url: "sm/subtract.htm", title: "SUBTRACT" },
                  { url: "sm/suspend.htm", title: "SUSPEND IDENTICAL SUPPRESS" },
                  { url: "sm/terminat.htm", title: "TERMINATE" },
                  { url: "sm/update.htm", title: "UPDATE" },
                  { url: "sm/update-sql.htm", title: "UPDATE (SQL)" },
                  { url: "sm/updatelob.htm", title: "UPDATELOB" },
                  { url: "sm/upload.htm", title: "UPLOAD PC FILE" },
                  { url: "sm/write.htm", title: "WRITE" },
                  { url: "sm/writeti.htm", title: "WRITE TITLE" },
                  { url: "sm/writetra.htm", title: "WRITE TRAILER" },
                  { url: "sm/writewor.htm", title: "WRITE WORK FILE" },
                  { url: "sm/sql_use.htm", title: "Natural-SQL-Statements benutzen",
                    tree: [
                        { url: "sm/sql-common-extended-set.htm", title: "Common Set und Extended Set" },
                        { url: "sm/sql-bsi.htm", title: "Grundlegende Syntaxbestandteile" },
                        { url: "sm/sql-natural-view-concept.htm", title: "Das Natural-View-Konzept" },
                        { url: "sm/sql-scl-expr.htm", title: "Skalar-Ausdrücke" },
                        { url: "sm/sql-search-conditions.htm", title: "Suchbedingungen" },
                        { url: "sm/sql-select-expressions.htm", title: "SELECT-Ausdrücke" },
                        { url: "sm/sql-flexible-sql.htm", title: "Flexible SQL" },
                    ]
                  },
                  { url: "sm/sm_exas.htm", title: "Referenzierte Beispielprogramme" },
              ]
            },
            { url: "func/func-over.htm", title: "Systemfunktionen",
              tree: [
                  { url: "func/func_sf.htm", title: "Systemfunktionen für Verarbeitungsschleifen" },
                  { url: "func/func_math.htm", title: "Mathematische Systemfunktionen" },
                  { url: "func/func_string.htm", title: "Verschiedene Systemfunktionen",
                    tree: [
                        { url: "func/func_mval.htm", title: "*MINVAL/*MAXVAL - Minimal-/Maximalwertes eines Feldes" },
                        { url: "func/func_transl.htm", title: "*TRANSLATE - Umsetzung in Groß-/Kleinschreibung" },
                        { url: "func/func_trim.htm", title: "*TRIM - Entfernen von führenden und/oder nachfolgenden Leerstellen" },
                        { url: "func/func_pos.htm", title: "POS - Feldidentifikationsfunktion" },
                        { url: "func/func_ret.htm", title: "RET - Returncode-Funktion" },
                        { url: "func/func_sortk.htm", title: "SORTKEY - Sort-Key Function" },
                    ]
                  },
                  { url: "func/func_function_objects.htm", title: "Funktionen, die als Natural-Objekte ausgeliefert werden" },
              ]
            },
            { url: "vari/vari-over.htm", title: "Systemvariablen",
              tree: [
                  { url: "vari/appl.htm", title: "Anwendungsbezogene Systemvariablen" },
                  { url: "vari/dtime.htm", title: "Datums- und Zeit-Systemvariablen" },
                  { url: "vari/inout.htm", title: "Eingabe/Ausgabebezogene Systemvariablen" },
                  { url: "vari/json.htm", title: "Systemvariablen mit Bezug zu JSON" },
                  { url: "vari/natenv.htm", title: "Systemvariablen nach Natural-Umgebung" },
                  { url: "vari/sysenv.htm", title: "Systemvariablen nach System-Umgebung" },
                  { url: "vari/xml.htm", title: "XML-bezogene Systemvariablen" },
              ]
            },
            { url: "tcom/tcom-over.htm", title: "Terminalkommandos",
              tree: [
                  { url: "tcom/tcomintro.htm", title: "Einführung in Terminalkommandos" },
                  { url: "tcom/tcomfu.htm", title: "Terminalkommandos nach Funktionsgruppen" },
                  { url: "tcom/keys.htm", title: "Terminalkommando-Tastenbelegung" },
                  { url: "tcom/pc.htm", title: "% — Fortsetzungsanzeiger für INPUT im Batch" },
                  { url: "tcom/pcpc.htm", title: "%% und %. — Aktive Operation unterbrechen" },
                  { url: "tcom/pcast.htm", title: "%* — Anzeige von Eingabezeichen unterdrücken" },
                  { url: "tcom/pcdotp.htm", title: "%.P — Obersten Stack-Eintrag löschen" },
                  { url: "tcom/pcdots.htm", title: "%.S — Stack-Daten lesen ohne zu löschen" },
                  { url: "tcom/pcslash.htm", title: "%/ — End-of-File" },
                  { url: "tcom/pcplus.htm", title: "%+ und %- — Natural Connection ein-/ausschalten" },
                  { url: "tcom/pctech.htm", title: "%&lt;TECH — Technische Informationen anzeigen" },
                  { url: "tcom/pctest.htm", title: "%&lt;TEST — Debugging-Funktion aufrufen" },
                  { url: "tcom/pceq.htm", title: "%= — Zuordnen von Farben zu Feldern" },
                  { url: "tcom/pca.htm", title: "%A — Ausführen einer Bildschirm-Aufzeichnung" },
                  { url: "tcom/pcb.htm", title: "%B — Aktivieren/Deaktivieren des Bildschirm-Aufzeichnungsvorgangs" },
                  { url: "tcom/pcbeq.htm", title: "%B= — Library für Bildschirm-Aufzeichnung angeben" },
                  { url: "tcom/pcc.htm", title: "%C — Seitenpuffer kopieren" },
                  { url: "tcom/pccs.htm", title: "%CS und %CC — Daten in den Stack bzw. in *COM kopieren" },
                  { url: "tcom/pcd.htm", title: "%D — Aktivieren des Keyword/Delimiter-Modus" },
                  { url: "tcom/pcdeq.htm", title: "%D= — Outlining (Rahmung) steuern" },
                  { url: "tcom/pcdue.htm", title: "%DUE — Speicherauszug bei spezifischem Fehler" },
                  { url: "tcom/pce.htm", title: "%E — Aufgezeichnete Bildschirme anzeigen" },
                  { url: "tcom/pceeq.htm", title: "%E= — Fehlerbehandlung ein-/ausschalten" },
                  { url: "tcom/pcf.htm", title: "%F — Aktivieren des Forms/Screen-Modus" },
                  { url: "tcom/pcfeq.htm", title: "%F= — Zeichen für Bildschirmfenster-Rahmen" },
                  { url: "tcom/pcfm.htm", title: "%FM — Freimodus für numerische Editiermasken" },
                  { url: "tcom/pcg.htm", title: "%G — Wiedergabemodus für eine Bildschirm-Aufzeichnung" },
                  { url: "tcom/pch.htm", title: "%H — Hardcopy-Ausgabe" },
                  { url: "tcom/pci.htm", title: "%I — Aktuellen Bildschirm aufzeichnen" },
                  { url: "tcom/pcj.htm", title: "%J — Helproutine aufrufen" },
                  { url: "tcom/pckp.htm", title: "%K und %KP — Simulieren von PF- und PA-Tasten" },
                  { url: "tcom/pcl.htm", title: "%L — Keine Umsetzung von Klein- in Großbuchstaben" },
                  { url: "tcom/pcleq.htm", title: "%L= — Sprachcode" },
                  { url: "tcom/pcm.htm", title: "%M — Steuerung der Meldungszeile" },
                  { url: "tcom/pcmsg.htm", title: "%MSGSF — Anzeigeformat von Systemfehlermeldungen" },
                  { url: "tcom/pcn.htm", title: "%N — Aktivieren des Non-Conversational-Modus" },
                  { url: "tcom/pco.htm", title: "%O — Beenden der Aufzeichnung von Bildschirmen" },
                  { url: "tcom/pcp.htm", title: "%P — Aufzeichnung für nachfolgende Bildschirme aktivieren" },
                  { url: "tcom/pcpeq.htm", title: "%P= — CALL-Optionen" },
                  { url: "tcom/pcq.htm", title: "%Q — Map-Ausgabe im Batch-Betrieb unterdrücken" },
                  { url: "tcom/pcqo.htm", title: "%QO — Pseudo-konversationelle Ausgabe unterdrücken" },
                  { url: "tcom/pcqs.htm", title: "%QS — Gleichzeitige Ausgabe mehrerer Schirme" },
                  { url: "tcom/pcr.htm", title: "%R — INPUT-Statement wiederholen" },
                  { url: "tcom/pcltrdc.htm", title: "%&lt;RDC+ und %&lt;RDC- - Trace Recording aktivieren/deaktivieren" },
                  { url: "tcom/pcrm.htm", title: "%RM — Schreibschutz von lichtstift-sensitiven Feldern" },
                  { url: "tcom/pcrn.htm", title: "%RN — Bildschirmdaten-Komprimierung unterdrücken" },
                  { url: "tcom/pcro.htm", title: "%RO — Bildschirm-Optimierung ein-/ausschalten" },
                  { url: "tcom/pcs.htm", title: "%S — Fortsetzen der Aufzeichnung von Bildschirmen" },
                  { url: "tcom/pct.htm", title: "%T — Cursor am Schirmanfang platzieren" },
                  { url: "tcom/pctll.htm", title: "%Tll/cc — Cursor in Zeile ll, Spalte cc platzieren" },
                  { url: "tcom/pctast.htm", title: "%T* — Cursor außerhalb des Fensters platzieren" },
                  { url: "tcom/pcteq.htm", title: "%T= — Terminalspezifische Converter-Routine" },
                  { url: "tcom/pctre.htm", title: "%TRE — Externe Trace-Funktion aktivieren/deaktivieren" },
                  { url: "tcom/pctri.htm", title: "%TRI — Interne Trace-Funktion aktivieren/deaktivieren" },
                  { url: "tcom/pcu.htm", title: "%U — Umsetzen von Klein- in Großbuchstaben" },
                  { url: "tcom/pcv.htm", title: "%V — Steuerung des Print-Modus" },
                  { url: "tcom/pcw.htm", title: "%W — Window-Verarbeitung" },
                  { url: "tcom/pcx.htm", title: "%X — Steuerung der Statistikzeile/Infoline" },
                  { url: "tcom/pcy.htm", title: "%Y — Steuerung der PF-Tastenleiste" },
                  { url: "tcom/pcz.htm", title: "%Z — Arbeitsbereich des Editors löschen" },
              ]
            },
            { url: "parms/parms-over.htm", title: "Parameter-Referenz",
              tree: [
                  { url: "parms/pp_intro.htm", title: "Profilparameter - Einführung" },
                  { url: "parms/sp_intro.htm", title: "Session-Parameter - Einführung" },
                  { url: "parms/parms_summary.htm", title: "Profilparameter sortiert nach Kategorien" },
                  { url: "parms/ablog.htm", title: "ABLOG – Programmausführungsfehler protokollieren" },
                  { url: "parms/sp_ad.htm", title: "AD - Attribut-Definition" },
                  { url: "parms/adaacbx.htm", title: "ADAACBX – Verwendung des erweiterten Adabas Control Block" },
                  { url: "parms/adamode.htm", title: "ADAMODE - Adabas-Call-Schnittstellenmodus" },
                  { url: "parms/adaname.htm", title: "ADANAME - Name der Adabas-Link-Routine" },
                  { url: "parms/adaprm.htm", title: "ADAPRM - Adabas Review-Unterstützung" },
                  { url: "parms/adasbv.htm", title: "ADASBV - Adabas Security durch Einstellung" },
                  { url: "parms/sp_al.htm", title: "AL - Alphanumerische Länge der Ausgabe" },
                  { url: "parms/asize.htm", title: "ASIZE - Entire System Server-Hilfspuffer" },
                  { url: "parms/aspsize.htm", title: "ASPSIZE (für interne Verwendung)" },
                  { url: "parms/attn.htm", title: "ATTN - Unterstützung für Programm-Unterbrechungstaste" },
                  { url: "parms/auto.htm", title: "AUTO - Automatische Anmeldung" },
                  { url: "parms/bp82.htm", title: "BP82 - Buffer Pool-Platzhalter wenn Objekt nicht gefunden" },
                  { url: "parms/bpc64.htm", title: "BPC64 - Buffer Pool Cache-Speichertyp" },
                  { url: "parms/bpcsize.htm", title: "BPCSIZE - Cache-Größe für den Natural Buffer Pool" },
                  { url: "parms/bpi.htm", title: "BPI - Buffer Pool-Initialisierung" },
                  { url: "parms/bplist.htm", title: "BPLIST - Name der Preload-Liste für den Natural Buffer Pool" },
                  { url: "parms/bpmeth.htm", title: "BPMETH - Suchalgorithmus zur Zuweisung von Speicherplatz im Buffer Pool" },
                  { url: "parms/bpname.htm", title: "BPNAME - Name des globalen Natural Buffer Pool" },
                  { url: "parms/bpprop.htm", title: "BPPROP - Global Buffer Pool: Propagation von Änderungen" },
                  { url: "parms/bpsfi.htm", title: "BPSFI - Objektsuche zuerst im Buffer Pool" },
                  { url: "parms/bpsize.htm", title: "BPSIZE - Größe des lokalen Natural Buffer Pool" },
                  { url: "parms/bptext.htm", title: "BPTEXT - Größe der Textsegmente im Natural Buffer Pool" },
                  { url: "parms/bsize.htm", title: "BSIZE - Größe des EntireX Broker Buffer" },
                  { url: "parms/sp_bx.htm", title: "BX - Feldumrahmung (Box-Definition)" },
                  { url: "parms/cancel.htm", title: "CANCEL - Abbruch der Session mit Dump" },
                  { url: "parms/cc.htm", title: "CC - Fehlerverarbeitung im Batch-Modus" },
                  { url: "parms/cchar.htm", title: "CCHAR - Ausgabe-Steuerzeichen zulassen" },
                  { url: "parms/cctab.htm", title: "CCTAB - Drucker-ESC-Folge-Definition" },
                  { url: "parms/sp_cd.htm", title: "CD - Farbdefinition" },
                  { url: "parms/cdynam.htm", title: "CDYNAM - Dynamisches Laden von Nicht-Natural-Programmen" },
                  { url: "parms/cf.htm", title: "CF - Steuerzeichen für Terminalkommandos" },
                  { url: "parms/cficu.htm", title: "CFICU - Unicode- und Codepage-Unterstützung" },
                  { url: "parms/cfwsize.htm", title: "CFWSIZE (für interne Verwendung)" },
                  { url: "parms/cicsp.htm", title: "CICSP - Umgebungsparameter für Natural CICS-Schnittstelle" },
                  { url: "parms/clear.htm", title: "CLEAR - Verarbeitung der CLEAR-Taste im NEXT-Modus" },
                  { url: "parms/cm.htm", title: "CM - Kommandomodus" },
                  { url: "parms/cmpo.htm", title: "CMPO - Kompilierungsoptionen" },
                  { url: "parms/cmpr.htm", title: "CMPR - Standard-Algorithmus zur Komprimierungsoptimierung" },
                  { url: "parms/comp.htm", title: "COMP - Parameter für Natural Com-plete/SMARTS Interface" },
                  { url: "parms/cp.htm", title: "CP - Name der Standard-Codepage" },
                  { url: "parms/cpcverr.htm", title: "CPCVERR - Codepage-Umsetzungsfehler" },
                  { url: "parms/cpobjin.htm", title: "CPOBJIN - Codepage der Batch-Eingabedatei" },
                  { url: "parms/cpprint.htm", title: "CPPRINT - Codepage der Batch-Ausgabedatei" },
                  { url: "parms/cpsynin.htm", title: "CPSYNIN - Codepage der Batch-Eingabedatei für Kommandos" },
                  { url: "parms/csize.htm", title: "CSIZE - Größe des Con-nect/Con-form-Pufferbereichs" },
                  { url: "parms/cstatic.htm", title: "CSTATIC - Statisch verlinkte Module" },
                  { url: "parms/sp_cv.htm", title: "CV - Kontrollvariable" },
                  { url: "parms/cvmin.htm", title: "CVMIN - Status 'Modified' der Kontrollvariable bei Eingabe" },
                  { url: "parms/datsize.htm", title: "DATSIZE - Minimale Größe des lokalen Daten-Puffers" },
                  { url: "parms/db.htm", title: "DB - Datenbanktypen und -optionen" },
                  { url: "parms/db2.htm", title: "DB2 - Parameter für SQL-Datenbankmanagementsystem-Schnittstellen" },
                  { url: "parms/db2size.htm", title: "DB2SIZE - Natural-Pufferbereich für Db2" },
                  { url: "parms/dbclose.htm", title: "DBCLOSE - Datenbank-Schließung am Ende einer Session" },
                  { url: "parms/dbgat.htm", title: "DBGAT - Debug Attach Server für NaturalONE" },
                  { url: "parms/dbgerr.htm", title: "DBGERR - Automatischer Debugger-Start bei Laufzeitfehler" },
                  { url: "parms/dbid.htm", title: "DBID - Standard-Datenbankkennung für Natural-Systemdateien" },
                  { url: "parms/dbopen.htm", title: "DBOPEN - Datenbank-Öffnung ohne ETID" },
                  { url: "parms/dbroll.htm", title: "DBROLL - Datenbankaufrufe vor Session-Unterbrechung" },
                  { url: "parms/dbupd.htm", title: "DBUPD - Datenbankänderungen" },
                  { url: "parms/dc.htm", title: "DC - Dezimalstellenzeichen" },
                  { url: "parms/dd.htm", title: "DD - Tagesdifferenz einstellen" },
                  { url: "parms/delete.htm", title: "DELETE - Löschung dynamisch geladener Programme" },
                  { url: "parms/sp_df.htm", title: "DF - Datumsformat" },
                  { url: "parms/dfout.htm", title: "DFOUT - Datumsformat für Ausgabe" },
                  { url: "parms/dfstack.htm", title: "DFSTACK - Datumsformat für Natural-Stack" },
                  { url: "parms/dftitle.htm", title: "DFTITLE - Datumsformat in Standard-Seitenüberschrift" },
                  { url: "parms/sp_dl.htm", title: "DL - Ausgabelänge" },
                  { url: "parms/do.htm", title: "DO - Anzeige-Reihenfolge von Ausgabedaten" },
                  { url: "parms/ds.htm", title: "DS - Größe der Pufferspeicher festlegen" },
                  { url: "parms/dsc.htm", title: "DSC - Datenstromkomprimierung bei Terminals des Typs 3270" },
                  { url: "parms/dsize.htm", title: "DSIZE - Größe des DBLOG-Puffers" },
                  { url: "parms/dtform.htm", title: "DTFORM - Datumsformat" },
                  { url: "parms/du.htm", title: "DU - Dump-Erstellung" },
                  { url: "parms/due.htm", title: "DUE - Dump-Erstellung, fehlerspezifisch" },
                  { url: "parms/sp_dy.htm", title: "DY - Dynamische Attribute" },
                  { url: "parms/dynparm.htm", title: "DYNPARM - Verwendung dynamischer Parameter" },
                  { url: "parms/echo.htm", title: "ECHO - Ausdrucken von Batch-Eingabedaten ein-/ausschalten" },
                  { url: "parms/edbp.htm", title: "EDBP - Software AG Editor Buffer Pool-Definitionen" },
                  { url: "parms/edpsize.htm", title: "EDPSIZE - Größe des Software AG Editor-Hilfs-Buffer-Pool" },
                  { url: "parms/ej.htm", title: "EJ - Seitenvorschub" },
                  { url: "parms/sp_em.htm", title: "EM - Editiermaske" },
                  { url: "parms/emfm.htm", title: "EMFM - Editiermasken-Frei-Modus" },
                  { url: "parms/sp_emu.htm", title: "EMU - Unicode-Editiermaske" },
                  { url: "parms/endbt.htm", title: "ENDBT - BACKOUT TRANSACTION am Session-Ende" },
                  { url: "parms/endmsg.htm", title: "ENDMSG - Session-Ende-Meldung anzeigen" },
                  { url: "parms/sp_es.htm", title: "ES - Leerzeilenunterdrückung" },
                  { url: "parms/escape.htm", title: "ESCAPE - Terminalkommandos %% und %. ignorieren" },
                  { url: "parms/esize.htm", title: "ESIZE - Größe des User Buffer-Erweiterungsbereichs" },
                  { url: "parms/et.htm", title: "ET - Ausführung von END TRANSACTION/BACKOUT TRANSACTION-Statements" },
                  { url: "parms/eta.htm", title: "ETA - Fehlertransaktionsprogramm" },
                  { url: "parms/etdb.htm", title: "ETDB - Datenbank für Transaktionsdaten" },
                  { url: "parms/eteop.htm", title: "ETEOP - END TRANSACTION-Statement bei Programmende" },
                  { url: "parms/etid.htm", title: "ETID - Adabas-Benutzerkennung" },
                  { url: "parms/etio.htm", title: "ETIO - END TRANSACTION-Statement bei Terminal-Ein-/Ausgabe" },
                  { url: "parms/etrace.htm", title: "ETRACE - Externe Trace-Funktion aktivieren/deaktivieren" },
                  { url: "parms/etsync.htm", title: "ETSYNC - Syncpoint bei END TRANSACTION/BACKOUT TRANSACTION" },
                  { url: "parms/excsize.htm", title: "EXCSIZE - Puffergröße für Natural Expert C Interface" },
                  { url: "parms/exrsize.htm", title: "EXRSIZE - Puffergröße für Natural Expert-Regeltabellen" },
                  { url: "parms/famstd.htm", title: "FAMSTD - Überschreiben der Arbeitsdatei-Zugriffsmethoden-Zuweisungen" },
                  { url: "parms/fc.htm", title: "FC - Füllzeichen für INPUT-Statement" },
                  { url: "parms/sp_fc.htm", title: "FC - Füllzeichen für DISPLAY-Statement" },
                  { url: "parms/fcdp.htm", title: "FCDP - Füllzeichen für dynamisch geschützte Felder" },
                  { url: "parms/fdic.htm", title: "FDIC - Predict-Systemdatei" },
                  { url: "parms/sp_fl.htm", title: "FL - Gleitkomma-Mantissenlänge" },
                  { url: "parms/fnat.htm", title: "FNAT - Natural-Systemdatei für Systemprogramme" },
                  { url: "parms/fnr.htm", title: "FNR - Standard-Dateinummer der Natural-Systemdateien" },
                  { url: "parms/fprof.htm", title: "FPROF - Natural-Systemdatei für Parameterprofile" },
                  { url: "parms/freegda.htm", title: "FREEGDA - GDA im Utility-Modus freigeben" },
                  { url: "parms/freg.htm", title: "FREG - Natural-Registry-Systemdatei" },
                  { url: "parms/fs.htm", title: "FS - Format-Spezifikation für Benutzervariablen" },
                  { url: "parms/fsec.htm", title: "FSEC - Natural Security-Systemdatei" },
                  { url: "parms/fsize.htm", title: "FSIZE (für interne Verwendung)" },
                  { url: "parms/fspool.htm", title: "FSPOOL - Spool-Datei für Natural Advanced Facilities" },
                  { url: "parms/fuser.htm", title: "FUSER - Natural-Systemdatei für Benutzerprogramme" },
                  { url: "parms/sp_gc.htm", title: "GC - Füllzeichen für Gruppenüberschriften" },
                  { url: "parms/sp_hc.htm", title: "HC - Überschriften-Zentrierung" },
                  { url: "parms/hcam.htm", title: "HCAM - Hardcopy-Zugriffsmethode" },
                  { url: "parms/hcdest.htm", title: "HCDEST - Ziel für Hardcopy-Ausgabe" },
                  { url: "parms/sp_hd.htm", title: "HD - Festlegung der Standard-Spaltenüberschrift" },
                  { url: "parms/sp_he.htm", title: "HE - Helproutine" },
                  { url: "parms/hi.htm", title: "HI - Hilfe-Aufrufzeichen" },
                  { url: "parms/sp_hw.htm", title: "HW - Überschriftenbreite" },
                  { url: "parms/ia.htm", title: "IA - Input-Zuweisungszeichen" },
                  { url: "parms/sp_ic.htm", title: "IC - Einfügungszeichen" },
                  { url: "parms/sp_icu.htm", title: "ICU - Unicode-Einfügungszeichen" },
                  { url: "parms/id.htm", title: "ID - Input-Begrenzungszeichen" },
                  { url: "parms/ikey.htm", title: "IKEY - Verarbeitung von PA- und PF-Tasten" },
                  { url: "parms/im.htm", title: "IM - Input-Modus" },
                  { url: "parms/imsg.htm", title: "IMSG - Nachricht bei Session-Initialisierungsfehler" },
                  { url: "parms/imsp.htm", title: "IMSP - Allgemeine Parameter für das Natural IMS TM Interface" },
                  { url: "parms/imspe.htm", title: "IMSPE - Umgebungsparameter für das Natural IMS TM Interface" },
                  { url: "parms/imspt.htm", title: "IMSPT - Transaktionsdefinitionen für Natural IMS TM Interface" },
                  { url: "parms/intens.htm", title: "INTENS - Drucken von hervorgehobenen Feldern" },
                  { url: "parms/sp_ip.htm", title: "IP - Eingabeaufforderungstext" },
                  { url: "parms/sp_is.htm", title: "IS - Unterdrückung identischer Werte" },
                  { url: "parms/isize.htm", title: "ISIZE - Größe des Puffers für Initialisierung" },
                  { url: "parms/iterm.htm", title: "ITERM - Session-Beendigung bei Initialisierungsfehler" },
                  { url: "parms/itrace.htm", title: "ITRACE - Interne Trace-Funktion aktivieren/deaktivieren" },
                  { url: "parms/sp_kd.htm", title: "KD - Anzeige der PF-Tastennamen" },
                  { url: "parms/key.htm", title: "KEY - PA-, PF- und CLEAR-Tastenbelegungen zuweisen" },
                  { url: "parms/lc.htm", title: "LC - Umsetzung von Klein- in Großbuchstaben" },
                  { url: "parms/sp_lc.htm", title: "LC - Vorangestellte Zeichen" },
                  { url: "parms/sp_lcu.htm", title: "LCU - Vorangestellte Unicode-Zeichen" },
                  { url: "parms/le.htm", title: "LE - Reaktion auf Limit-Überschreitung bei Verarbeitungsschleifen" },
                  { url: "parms/lfile.htm", title: "LFILE - Logische Systemdatei-Definition" },
                  { url: "parms/libnam.htm", title: "LIBNAM - Name der externen Programm-Load Library" },
                  { url: "parms/log.htm", title: "LOG (für interne Verwendung)" },
                  { url: "parms/ls.htm", title: "LS - Zeilenlänge" },
                  { url: "parms/lt.htm", title: "LT - Limit für Verarbeitungsschleifen" },
                  { url: "parms/madio.htm", title: "MADIO - Maximale Anzahl der DBMS-Aufrufe zwischen Bildschirm-Ein-/Ausgaben" },
                  { url: "parms/mainpr.htm", title: "MAINPR - Standard-Ausgabe-Report-Nummer" },
                  { url: "parms/maxcl.htm", title: "MAXCL - Maximale Anzahl an Programmaufrufen" },
                  { url: "parms/maxroll.htm", title: "MAXROLL - Anzahl der CMROLL-Aufrufe vor vorübergehender Session-Unterbrechung" },
                  { url: "parms/maxyear.htm", title: "MAXYEAR - Maximale Jahresangabe bei Datums-/Zeitwerten" },
                  { url: "parms/sp_mc.htm", title: "MC - Anzahl multipler Feldwerte" },
                  { url: "parms/menu.htm", title: "MENU - Menü-Modus" },
                  { url: "parms/ml.htm", title: "ML - Position der Meldungszeile" },
                  { url: "parms/monsize.htm", title: "MONSIZE - Größe des SYSTP Monitor-Puffers" },
                  { url: "parms/mp.htm", title: "MP - Maximale Seitenzahl eines Reports" },
                  { url: "parms/sp_ms.htm", title: "MS - Manuelle Cursor-Positionierung" },
                  { url: "parms/msgsf.htm", title: "MSGSF - Anzeigeformat von Systemfehlermeldungen" },
                  { url: "parms/mt.htm", title: "MT - Maximale CPU-Zeit" },
                  { url: "parms/nafsize.htm", title: "NAFSIZE - Puffergröße für Natural Advanced Facilities" },
                  { url: "parms/nafupf.htm", title: "NAFUPF - Benutzerprofil für Natural Advanced Facilities" },
                  { url: "parms/nc.htm", title: "NC - Verwendung von Natural-Systemkommandos" },
                  { url: "parms/nisn.htm", title: "NISN (für interne Verwendung)" },
                  { url: "parms/sp_nl.htm", title: "NL - Numerische Länge der Ausgabe" },
                  { url: "parms/nucname.htm", title: "NUCNAME - Name des gemeinsam genutzen Nukleus" },
                  { url: "parms/objin.htm", title: "OBJIN - Benutzung von CMOBJIN als Natural-Eingabedatei" },
                  { url: "parms/opf.htm", title: "OPF - Überschreiben geschützter Felder durch Helproutinen" },
                  { url: "parms/oprb.htm", title: "OPRB - Datenbank-Open/Close-Befehlsverarbeitung" },
                  { url: "parms/opt.htm", title: "OPT - Steuerung des Natural Optimizer Compiler" },
                  { url: "parms/osp.htm", title: "OSP - Parameter für z/OS Batch" },
                  { url: "parms/outdest.htm", title: "OUTDEST - Ausgabeziel für asynchrone Verarbeitung" },
                  { url: "parms/ovsize.htm", title: "OVSIZE - Speicher-Thread-Überlaufgröße" },
                  { url: "parms/parm.htm", title: "PARM - Alternatives Parametermodul" },
                  { url: "parms/pc.htm", title: "PC - Personal-Computer-Zugriffsmethode" },
                  { url: "parms/sp_pc.htm", title: "PC - Anzahl der Periodengruppen-Ausprägungen" },
                  { url: "parms/pcntrl.htm", title: "PCNTRL - Druckersteuerzeichen" },
                  { url: "parms/pd.htm", title: "PD - Seiten-Limit für NATPAGE" },
                  { url: "parms/pdpsize.htm", title: "PDPSIZE - Profiler-Daten-Pool-Größe" },
                  { url: "parms/peck.htm", title: "PECK - PCHECK/ECHECK-Fehlerverarbeitung" },
                  { url: "parms/pgp.htm", title: "PGP - Eigenschaften für externe Programme" },
                  { url: "parms/plog.htm", title: "PLOG - Protokollieren von dynamischen Parametern" },
                  { url: "parms/pm.htm", title: "PM - Druck-/Anzeige-Modus" },
                  { url: "parms/pos22.htm", title: "POS22 - Version 2.2 Algorithmus für Systemfunktion POS" },
                  { url: "parms/print.htm", title: "PRINT - Druckdatei-Zuweisungen" },
                  { url: "parms/profile.htm", title: "PROFILE - Dynamisches Parameterprofil anwenden" },
                  { url: "parms/program.htm", title: "PROGRAM - Kontrolle durch Nicht-Natural-Programm nach Session-Beendigung" },
                  { url: "parms/ps.htm", title: "PS - Länge einer Reportseite" },
                  { url: "parms/pseudo.htm", title: "PSEUDO - Pseudo-konversationeller Modus unter CICS" },
                  { url: "parms/rca.htm", title: "RCA - Adressen von statischen Nicht-Natural-Programmen auflösen" },
                  { url: "parms/rcalias.htm", title: "RCALIAS - Externe Namen für Nicht-Natural-Programme" },
                  { url: "parms/rcfind.htm", title: "RCFIND - Maßnahme bei Adabas Response Code 113 beim FIND-Statement" },
                  { url: "parms/rcget.htm", title: "RCGET - Maßnahme bei Adabas Response Code 113 beim GET-Statement" },
                  { url: "parms/rdact.htm", title: "RDACT - (für interne Verwendung)" },
                  { url: "parms/rdc.htm", title: "RDC - Konfiguration des Natural Data Collector" },
                  { url: "parms/rdcexit.htm", title: "RDCEXIT - User Exits für den Natural Data Collector" },
                  { url: "parms/rdcsize.htm", title: "RDCSIZE - Puffergröße für den Natural Data Collector" },
                  { url: "parms/rdnode.htm", title: "RDNODE (für interne Verwendung)" },
                  { url: "parms/rdport.htm", title: "RDPORT (für interne Verwendung)" },
                  { url: "parms/recat.htm", title: "RECAT - Dynamisches Rekatalogisieren" },
                  { url: "parms/reinp.htm", title: "REINP - Interner REINPUT bei ungültigen Daten" },
                  { url: "parms/relo.htm", title: "RELO - Speicher-Thread-Verschiebung" },
                  { url: "parms/rfile.htm", title: "RFILE - Datei für Aufzeichnung per Recording-Funktion" },
                  { url: "parms/ri.htm", title: "RI - Freigabe von Adabas ISNs" },
                  { url: "parms/rjesize.htm", title: "RJESIZE - Anfangsgröße des NATRJE-Puffers" },
                  { url: "parms/rm.htm", title: "RM - Rückübertragung von geänderten Feldern" },
                  { url: "parms/rnconst.htm", title: "RNCONST - Zeilennummern in Konstanten umnummerieren" },
                  { url: "parms/rosy.htm", title: "ROSY - Schreibgeschützter Zugriff auf Systemdateien" },
                  { url: "parms/rpc_settings.htm", title: "RPC - Remote Procedure Call-Einstellungen" },
                  { url: "parms/runsize.htm", title: "RUNSIZE - Größe des Laufzeit-Puffers" },
                  { url: "parms/sa.htm", title: "SA - Terminal-Warnton" },
                  { url: "parms/sp_sb.htm", title: "SB - Auswahlfeld" },
                  { url: "parms/sctab.htm", title: "SCTAB - Scanner-Zeichentabelle" },
                  { url: "parms/sender.htm", title: "SENDER - Bestimmungsort für Bildschirmausgabe bei asynchroner Verarbeitung" },
                  { url: "parms/sf.htm", title: "SF - Spaltenabstand" },
                  { url: "parms/sp_sg.htm", title: "SG - Vorzeichen-Stelle" },
                  { url: "parms/shape.htm", title: "SHAPED - Steuerung der Zeichenumformung" },
                  { url: "parms/skey.htm", title: "SKEY - Speicherschutzschlüssel für Programmausführung" },
                  { url: "parms/sl.htm", title: "SL - Quellcode-Zeilenlänge" },
                  { url: "parms/slock.htm", title: "SLOCK - Source-Sperrung" },
                  { url: "parms/sm.htm", title: "SM - Programmierung im Structured Mode" },
                  { url: "parms/sort.htm", title: "SORT - Steuerung des Sortierprogramms" },
                  { url: "parms/sosi.htm", title: "SOSI - Shift-Out/Shift-In-Codes für Doppel-Byte-Zeichensätze" },
                  { url: "parms/sretain.htm", title: "SRETAIN - Source-Format beibehalten" },
                  { url: "parms/ssize.htm", title: "SSIZE - Größe des Software AG Editor-Arbeitsbereichs" },
                  { url: "parms/stack.htm", title: "STACK - Daten/Kommandos auf den Natural Stack stellen" },
                  { url: "parms/stackd.htm", title: "STACKD - Stack-Kommando-Abgrenzungszeichen" },
                  { url: "parms/steplib.htm", title: "STEPLIB - Zusätzliche Steplib Library" },
                  { url: "parms/subsid.htm", title: "SUBSID - Subsystemkennung unter z/OS" },
                  { url: "parms/synerr.htm", title: "SYNERR - Übergabe von Syntaxfehlern" },
                  { url: "parms/sys.htm", title: "SYS - Satz dynamischer Profilparameter definieren und aktivieren" },
                  { url: "parms/syscip.htm", title: "SYSCIP - Adabas-Standard-Chiffrierschlüssel für Natural-Systemdateien" },
                  { url: "parms/syspsw.htm", title: "SYSPSW - Adabas-Standard-Passwort für Natural-Systemdateien" },
                  { url: "parms/tab.htm", title: "TAB - Standard-Ausgabezeichen-Umsetzung" },
                  { url: "parms/tab1.htm", title: "TAB1 - Alternative Ausgabezeichen-Umsetzung" },
                  { url: "parms/tab2.htm", title: "TAB2 - Alternative Eingabezeichen-Umsetzung" },
                  { url: "parms/taba1.htm", title: "TABA1 - EBCDIC/ASCII-Zeichenumsetzung" },
                  { url: "parms/taba2.htm", title: "TABA2 - ASCII/EBCDIC-Zeichenumsetzung" },
                  { url: "parms/tabl.htm", title: "TABL - SYS-Library-Ausgabe-Zeichenumsetzung" },
                  { url: "parms/sp_tc.htm", title: "TC - Nachgezogene Zeichen" },
                  { url: "parms/sp_tcu.htm", title: "TCU - Nachgezogene Zeichen (Unicode)" },
                  { url: "parms/td.htm", title: "TD - Zeitdifferenz" },
                  { url: "parms/tf.htm", title: "TF - Umsetzung der Datenbankkennung/Dateinummer" },
                  { url: "parms/thpinit.htm", title: "THPINIT - Name des vorinitialisierten Speicher-Thread-Modells" },
                  { url: "parms/thsepch.htm", title: "THSEPCH - Tausender-Trennzeichen" },
                  { url: "parms/thsize.htm", title: "THSIZE - Größe des Speicher-Thread" },
                  { url: "parms/tmodel.htm", title: "TMODEL - IBM 3270-Terminal-Modell" },
                  { url: "parms/tpf.htm", title: "TPF (für interne Verwendung)" },
                  { url: "parms/tq.htm", title: "TQ - Translate Quotation Marks" },
                  { url: "parms/trace_parm.htm", title: "TRACE - Komponenten für den Trace angeben" },
                  { url: "parms/ts.htm", title: "TS - Umsetzung von System-Library-Programmausgaben" },
                  { url: "parms/tsize.htm", title: "TSIZE - Größe des Puffers für Adabas Text Retrieval" },
                  { url: "parms/tsop.htm", title: "TSOP - Parameter für Natural TSO Interface" },
                  { url: "parms/ttype.htm", title: "TTYPE - Terminaltyp" },
                  { url: "parms/sp_uc.htm", title: "UC - Unterstreichungszeichen" },
                  { url: "parms/uconmax.htm", title: "UCONMAX - Maximale Anzahl gleichzeitiger Sessions für einen Benutzer" },
                  { url: "parms/udb.htm", title: "UDB - Benutzer-Datenbankkennung" },
                  { url: "parms/ulang.htm", title: "ULANG - Benutzersprache" },
                  { url: "parms/uniio.htm", title: "UNIIO (für interne Verwendung)" },
                  { url: "parms/user.htm", title: "USER - Verwendung von Profilparameterketten und Modulen einschränken" },
                  { url: "parms/userbuf.htm", title: "USERBUF (für interne Verwendung)" },
                  { url: "parms/utab1.htm", title: "UTAB1 - Umsetzung von Klein- in Großschreibung" },
                  { url: "parms/utab2.htm", title: "UTAB2 - Umsetzung von Groß- in Kleinschreibung" },
                  { url: "parms/vsam.htm", title: "VSAM - Parameter für Natural for VSAM" },
                  { url: "parms/VSIZE.htm", title: "VSIZE - Größe des Pufferbereichs für Natural for VSAM" },
                  { url: "parms/webio-mf.htm", title: "WEBIO - Web I/O Interface Rendering" },
                  { url: "parms/wh.htm", title: "WH - Warten auf Datensatz im Hold-Status" },
                  { url: "parms/work.htm", title: "WORK - Arbeitsdatei-Zuweisungen" },
                  { url: "parms/wpsize.htm", title: "WPSIZE - Größe der Natural-Arbeitsspeicher" },
                  { url: "parms/wsisize.htm", title: "WSISIZE - Puffer für das Natural Workstation Interface" },
                  { url: "parms/xml.htm", title: "XML - Statements PARSE XML und REQUEST DOCUMENT aktivieren/deaktivieren" },
                  { url: "parms/xref.htm", title: "XREF - Erzeugung von XRef-Daten für Natural" },
                  { url: "parms/yd.htm", title: "YD - Jahresdifferenz einstellen" },
                  { url: "parms/yslw.htm", title: "YSLW - Gleitendes oder festes Jahr-Fenster" },
                  { url: "parms/zd.htm", title: "ZD - Division durch Null" },
                  { url: "parms/ziip.htm", title: "ZIIP - zIIP-Verarbeitung (nur z/OS)" },
                  { url: "parms/zp.htm", title: "ZP - Anzeige von Nullwerten" },
                  { url: "parms/zsize.htm", title: "ZSIZE - Größe des Entire DB-Pufferbereichs" },
              ]
            },
            { url: "pg/pg-over.htm", title: "Leitfaden zur Programmierung",
              tree: [
                  { url: "pg/pg_mode.htm", title: "Natural-Programmiermodi" },
                  { url: "pg/pg_objects.htm", title: "Objekte zum Erstellen und Pflegen von Natural-Anwendungen",
                    tree: [
                        { url: "pg/pg_obj_darea.htm", title: "Datenbereiche (Data Areas)" },
                        { url: "pg/pg_obj_ddm.htm", title: "Datendefinitionsmodul (DDM)" },
                        { url: "pg/pg_obj_pgm_routine.htm", title: "Programme und untergeordnete Routinen" },
                        { url: "pg/pg_obj_helproutine.htm", title: "Helproutine" },
                        { url: "pg/pg_obj_copycode.htm", title: "Copycode" },
                        { url: "pg/pg_objects_text.htm", title: "Text" },
                        { url: "pg/pg_objects_class.htm", title: "Class" },
                        { url: "pg/pg_obj_map.htm", title: "Map" },
                        { url: "pg/pg_objects_adapter.htm", title: "Adapter" },
                        { url: "pg/pg_obj_dialog.htm", title: "Dialog" },
                        { url: "pg/pg_obj_resource.htm", title: "Resource" },
                        { url: "pg/pg_obj_recording.htm", title: "Recording" },
                        { url: "pg/pg_obj_error_msg.htm", title: "Fehlermeldung (Error Message)" },
                        { url: "pg/pg_obj_processor.htm", title: "Kommandoprozessor" },
                        { url: "pg/pg_obj_editor_profile.htm", title: "Editor-Profil" },
                        { url: "pg/pg_obj_map_profile.htm", title: "Map-Profil und Device-Profil" },
                        { url: "pg/pg_obj_profile.htm", title: "Parameter-Profil" },
                        { url: "pg/pg_obj_debug.htm", title: "Debug-Umgebung" },
                        { url: "pg/pg_obj_api.htm", title: "Anwendungsprogrammierschnittstellen" },
                    ]
                  },
                  { url: "pg/pg_function_call.htm", title: "Function Call" },
                  { url: "pg/pg_defi-over.htm", title: "Felder definieren",
                    tree: [
                        { url: "pg/pg_defi.htm", title: "Benutzung und Struktur des DEFINE DATA-Statements" },
                        { url: "pg/pg_defi_dv.htm", title: "Benutzervariablen" },
                        { url: "pg/pg_defi_ldvfin.htm", title: "Dynamische Variablen" },
                        { url: "pg/pg_defi_ldvfus.htm", title: "Dynamische und große Variablen benutzen" },
                        { url: "pg/pg_defi_udc.htm", title: "Benutzerkonstanten" },
                        { url: "pg/pg_defi_init.htm", title: "Ausgangswerte (und das RESET-Statement)" },
                        { url: "pg/pg_defi_redef.htm", title: "Felder redefinieren" },
                        { url: "pg/pg_defi_array.htm", title: "Arrays" },
                        { url: "pg/pg_defi_xarry.htm", title: "X-Arrays" },
                    ]
                  },
                  { url: "pg/pg_dbms_access.htm", title: "Datenbankzugriffe",
                    tree: [
                        { url: "pg/pg_dbms_dbgen.htm", title: "Natural und Datenbankzugriff" },
                        { url: "pg/pg_dbms_ada.htm", title: "Daten in einer Adabas-Datenbank aufrufen" },
                        { url: "pg/pg_dbms_sqlmf.htm", title: "Daten in einer SQL-Datenbank aufrufen" },
                        { url: "pg/pg_dbms_nvs.htm", title: "Daten in einer VSAM-Datenbank aufrufen" },
                    ]
                  },
                  { url: "pg/pg_output-over.htm", title: "Steuerung der Ausgabe von Daten",
                    tree: [
                        { url: "pg/pg_output_rep.htm", title: "Report-Spezifikation — (rep)-Notation" },
                        { url: "pg/pg_output_layout.htm", title: "Layout einer Ausgabeseite" },
                        { url: "pg/pg_output_display.htm", title: "Statements DISPLAY und WRITE" },
                        { url: "pg/pg_output_index.htm", title: "Index-Notation für multiple Felder und Periodengruppen" },
                        { url: "pg/pg_output_titles.htm", title: "Seitenüberschriften, Seitenvorschübe und Leerzeilen" },
                        { url: "pg/pg_output_headers.htm", title: "Spaltenüberschriften" },
                        { url: "pg/pg_output_parms.htm", title: "Parameter zur Beeinflussung der Ausgabe von Feldern" },
                        { url: "pg/pg_output_masks.htm", title: "Codepage-Editiermasken — der EM-Parameter" },
                        { url: "pg/pg_output_umasks.htm", title: "Unicode-Editiermasken — EMU-Parameter" },
                        { url: "pg/pg_output_vdispl.htm", title: "Vertikale Ausgabe von Feldwerten" },
                    ]
                  },
                  { url: "pg/pg_furth-over.htm", title: "Weitere Programmieraspekte",
                    tree: [
                        { url: "pg/pg_furth_txtnot.htm", title: "Text-Notation" },
                        { url: "pg/pg_furth_ucom.htm", title: "Benutzerkommentare" },
                        { url: "pg/pg_furth_compu.htm", title: "Datenberechnungen" },
                        { url: "pg/pg_furth_arithm.htm", title: "Regeln für arithmetische Operationen" },
                        { url: "pg/pg_furth_condi.htm", title: "Bedingte Verarbeitung — das IF-Statement" },
                        { url: "pg/pg_furth_lcc.htm", title: "Logische Bedingungen" },
                        { url: "pg/pg_furth_loop.htm", title: "Schleifenverarbeitung" },
                        { url: "pg/pg_furth_break.htm", title: "Gruppenwechsel" },
                        { url: "pg/pg_furth_stack_process.htm", title: "Natural-Stack" },
                        { url: "pg/pg_furth_vari.htm", title: "Systemvariablen und Systemfunktionen" },
                        { url: "pg/pg_furth_date.htm", title: "Verarbeitung von Datumsinformationen" },
                        { url: "pg/pg_furth_store_clock_val.htm", title: "Verarbeitung von Store Clock-Werten" },
                        { url: "pg/pg_furth_end.htm", title: "Ende eines Statements, Programms oder einer Anwendung" },
                        { url: "pg/pg_furth_appl_err_proc.htm", title: "Verarbeitung von Anwendungsfehlern" },
                        { url: "pg/pg_furth_compile.htm", title: "Kompilierungsaspekte" },
                    ]
                  },
                  { url: "pg/pg_xml.htm", title: "Statements für den Internet- und JSON-XML-Zugriff" },
                  { url: "pg/pg_desgn-over.htm", title: "Gestaltung der Benutzungsoberflächen von Anwendungen",
                    tree: [
                        { url: "pg/pg_desgn_screen.htm", title: "Bildschirmgestaltung" },
                        { url: "pg/pg_desgn_dialog.htm", title: "Dialog-Gestaltung" },
                    ]
                  },
                  { url: "pg/pg_natx-over.htm", title: "NaturalX",
                    tree: [
                        { url: "pg/pg_natx_intro.htm", title: "Einführung in NaturalX" },
                        { url: "pg/pg_natx_dev.htm", title: "NaturalX-Anwendungen entwickeln" },
                    ]
                  },
                  { url: "pg/pg_keyw.htm", title: "Für Natural reservierte Schlüsselwörter" },
                  { url: "pg/pg_exas.htm", title: "Referenzierte Beispielprogramme" },
              ]
            },
            { url: "edis/edis-over.htm", title: "Editoren",
              tree: [
                  { url: "edis/one_as_ide.htm", title: "NaturalONE als Standard-Entwicklungsumgebung benutzen" },
                  { url: "edis/natural_cui_editors_disabled.htm", title: "Abgeschaltete CUI-Editoren" },
                  { url: "edis/use-edis-geninfo.htm", title: "Allgemeine Informationen zu den Editoren in NaturalONE" },
                  { url: "edis/use-edis-source.htm", title: "Benutzung des Source Editors" },
                  { url: "edis/use-edis-map.htm", title: "Benutzung des Map Editors" },
                  { url: "edis/use-edis-ddm.htm", title: "Benutzung des DDM Editors" },
                  { url: "edis/edis_mf_lock.htm", title: "Sperrmechanismen für Source-Objekte" },
                  { url: "edis/edis_mf_edit.htm", title: "Editoren — Allgemeine Informationen" },
                  { url: "edis/edis_mf_pgm.htm", title: "Programm-Editor" },
                  { url: "edis/edis_mf_data.htm", title: "Datenbereich-Editor (Data Area Editor)" },
                  { url: "edis/map_mf-over.htm", title: "Masken-Editor (Map Editor)",
                    tree: [
                        { url: "edis/map_mf_components.htm", title: "Komponenten des Masken-Editors" },
                        { url: "edis/map_mf_summary.htm", title: "In vier Schritten zur fertigen Maske" },
                        { url: "edis/map_mf_invoke.htm", title: "Masken-Editor aufrufen und beenden" },
                        { url: "edis/map_mf_functions.htm", title: "Funktionen im Menü 'Edit Map'" },
                        { url: "edis/map_mf_init_map.htm", title: "Maske erstellen — Funktion 'Initialize New Map'" },
                        { url: "edis/map_mf_edit.htm", title: "Maske bearbeiten — Funktion 'Edit Map'" },
                        { url: "edis/map_mf_define_fields.htm", title: "Maskenfelder definieren" },
                        { url: "edis/map_mf_ext_fields.htm", title: "Erweiterte Feld-Bearbeitung" },
                        { url: "edis/map_mf_oedit.htm", title: "Feldumrahmungen erstellen — mit dem Outline-Editor" },
                        { url: "edis/map_mf_post_assign.htm", title: "Nachträgliches Zuweisen von Feldern" },
                        { url: "edis/map_mf_array_table.htm", title: "Array- und Tabellen-Definitionen" },
                        { url: "edis/map_mf_proc_rules.htm", title: "Verarbeitungsregeln" },
                    ]
                  },
                  { url: "edis/mapt_mf-over.htm", title: "Map Editor Tutorial",
                    tree: [
                        { url: "edis/mapt_mf_invoke.htm", title: "Masken-Editor öffnen" },
                        { url: "edis/mapt_mf_create_fields.htm", title: "Maskenfelder anlegen, positionieren und löschen" },
                        { url: "edis/mapt_mf_test_save.htm", title: "Maske testen und speichern" },
                        { url: "edis/mapt_mf_proc_rule.htm", title: "Verarbeitungsregeln definieren" },
                        { url: "edis/mapt_mf_name_stow.htm", title: "Felder benennen und Maske speichern/katalogisieren" },
                        { url: "edis/mapt_mf_ext_edit.htm", title: "Feld-Eigenschaften definieren" },
                        { url: "edis/mapt_mf_help_map.htm", title: "Hilfe-Maske erstellen und testen" },
                        { url: "edis/mapt_mf_INPUT_USING.htm", title: "Maske mit INPUT USING MAP aufrufen" },
                        { url: "edis/mapt_mf_WRITE_copy.htm", title: "Maske für WRITE erstellen und Feld-Definitionen kopieren" },
                        { url: "edis/mapt_mf_copy_layout.htm", title: "Layout einer Maske wiederverwenden" },
                        { url: "edis/mapt_mf_invoke_WRITE.htm", title: "Maske mit WRITE USING MAP aufrufen" },
                    ]
                  },
                  { url: "edis/ddm-over.htm", title: "DDM-Editor (SYSDDM Utility)",
                    tree: [
                        { url: "edis/ddm_gen.htm", title: "Funktionsbeschreibung" },
                        { url: "edis/ddm_mf_invoke_sys.htm", title: "SYSDDM aufrufen und beenden" },
                        { url: "edis/ddm_mf_maint_funct.htm", title: "SYSDDM Pflege- und Service-Funktionen benutzen" },
                        { url: "edis/ddm_mf_create.htm", title: "DDMs erstellen" },
                        { url: "edis/ddm_invoke_editor.htm", title: "DDM-Editor aufrufen und beenden" },
                        { url: "edis/ddm_use_editor.htm", title: "DDM-Editor benutzen" },
                        { url: "edis/ddm_save_cat_object.htm", title: "DDM katalogisieren" },
                        { url: "edis/ddm_mf_list.htm", title: "DDMs auflisten" },
                        { url: "edis/ddm_maint_env.htm", title: "DDMs in unterschiedlichen Umgebungen pflegen" },
                    ]
                  },
                  { url: "edis/edis_mf_sagedt-over.htm", title: "Software AG Editor",
                    tree: [
                        { url: "edis/sagedt_general.htm", title: "Allgemeine Informationen zum Software AG Editor" },
                        { url: "edis/sagedt_invoke.htm", title: "Software AG Editor aufrufen" },
                        { url: "edis/sagedt_use_screen.htm", title: "Benutzung des Editor-Bildschirms" },
                        { url: "edis/sagedt_use_cmds.htm", title: "Kommandos benutzen" },
                        { url: "edis/sagedt_create_modify.htm", title: "Daten anlegen und ändern" },
                        { url: "edis/sagedt_set_profile.htm", title: "Editor-Profil einstellen" },
                        { url: "edis/sagedt_store_leave_editor.htm", title: "Daten speichern und den Software AG Editor verlassen" },
                        { url: "edis/sagedt_line_summary.htm", title: "Zeilenkommandos (Übersicht)" },
                        { url: "edis/sagedt_main_summary.htm", title: "Hauptkommandos (Übersicht)" },
                    ]
                  },
              ]
            },
            { url: "syscom/syscom-over.htm", title: "Systemkommandos",
              tree: [
                  { url: "syscom/issue.htm", title: "Kommandoausführung" },
                  { url: "syscom/syntax.htm", title: "Systemkommando-Syntax" },
                  { url: "syscom/syscom_groups.htm", title: "Systemkommandos sortiert nach Kategorien" },
                  { url: "syscom/aiv.htm", title: "AIV" },
                  { url: "syscom/bus.htm", title: "BUS" },
                  { url: "syscom/catall_m.htm", title: "CATALL" },
                  { url: "syscom/catalog.htm", title: "CATALOG" },
                  { url: "syscom/check.htm", title: "CHECK" },
                  { url: "syscom/clear.htm", title: "CLEAR" },
                  { url: "syscom/compopt.htm", title: "COMPOPT" },
                  { url: "syscom/cpinfo.htm", title: "CPINFO" },
                  { url: "syscom/delete.htm", title: "DELETE" },
                  { url: "syscom/dump.htm", title: "DUMP" },
                  { url: "syscom/edit.htm", title: "EDIT" },
                  { url: "syscom/edt.htm", title: "EDT" },
                  { url: "syscom/execute.htm", title: "EXECUTE" },
                  { url: "syscom/fin.htm", title: "FIN" },
                  { url: "syscom/globals.htm", title: "GLOBALS" },
                  { url: "syscom/help.htm", title: "HELP" },
                  { url: "syscom/inpl.htm", title: "INPL" },
                  { url: "syscom/key.htm", title: "KEY" },
                  { url: "syscom/last.htm", title: "LAST" },
                  { url: "syscom/lastmsg.htm", title: "LASTMSG" },
                  { url: "syscom/list_m.htm", title: "LIST" },
                  { url: "syscom/list_xref.htm", title: "LIST XREF" },
                  { url: "syscom/listdbrm.htm", title: "LISTDBRM" },
                  { url: "syscom/listprof.htm", title: "LISTPROF" },
                  { url: "syscom/listsql.htm", title: "LISTSQL" },
                  { url: "syscom/listsqlb.htm", title: "LISTSQLB" },
                  { url: "syscom/logoff.htm", title: "LOGOFF" },
                  { url: "syscom/logon.htm", title: "LOGON" },
                  { url: "syscom/mail.htm", title: "MAIL" },
                  { url: "syscom/mainmenu.htm", title: "MAINMENU" },
                  { url: "syscom/natqvs.htm", title: "NATQVS" },
                  { url: "syscom/nocopt.htm", title: "NOCOPT" },
                  { url: "syscom/nocshow.htm", title: "NOCSHOW" },
                  { url: "syscom/nocstat.htm", title: "NOCSTAT" },
                  { url: "syscom/profile.htm", title: "PROFILE" },
                  { url: "syscom/profiler.htm", title: "PROFILER" },
                  { url: "syscom/rdc.htm", title: "RDC" },
                  { url: "syscom/read.htm", title: "READ" },
                  { url: "syscom/rename.htm", title: "RENAME" },
                  { url: "syscom/renumber.htm", title: "RENUMBER" },
                  { url: "syscom/return.htm", title: "RETURN" },
                  { url: "syscom/routines.htm", title: "ROUTINES" },
                  { url: "syscom/rpcerr.htm", title: "RPCERR" },
                  { url: "syscom/run.htm", title: "RUN" },
                  { url: "syscom/save.htm", title: "SAVE" },
                  { url: "syscom/scan_m.htm", title: "SCAN" },
                  { url: "syscom/scratch.htm", title: "SCRATCH" },
                  { url: "syscom/setup.htm", title: "SETUP" },
                  { url: "syscom/showdbs.htm", title: "SHOWDBS" },
                  { url: "syscom/sqldiag.htm", title: "SQLDIAG" },
                  { url: "syscom/sqlerr.htm", title: "SQLERR" },
                  { url: "syscom/stow.htm", title: "STOW" },
                  { url: "syscom/struct.htm", title: "STRUCT" },
                  { url: "syscom/sysada.htm", title: "SYSADA" },
                  { url: "syscom/sysapi.htm", title: "SYSAPI" },
                  { url: "syscom/sysbpm.htm", title: "SYSBPM" },
                  { url: "syscom/syscp.htm", title: "SYSCP" },
                  { url: "syscom/sysdb2.htm", title: "SYSDB2" },
                  { url: "syscom/sysddm.htm", title: "SYSDDM" },
                  { url: "syscom/sysedt.htm", title: "SYSEDT" },
                  { url: "syscom/syserr.htm", title: "SYSERR" },
                  { url: "syscom/sysext.htm", title: "SYSEXT" },
                  { url: "syscom/sysexv.htm", title: "SYSEXV" },
                  { url: "syscom/sysfile.htm", title: "SYSFILE" },
                  { url: "syscom/sysmain.htm", title: "SYSMAIN" },
                  { url: "syscom/sysncp.htm", title: "SYSNCP" },
                  { url: "syscom/sysobjh.htm", title: "SYSOBJH" },
                  { url: "syscom/sysparm.htm", title: "SYSPARM" },
                  { url: "syscom/sysprod.htm", title: "SYSPROD" },
                  { url: "syscom/sysprof.htm", title: "SYSPROF" },
                  { url: "syscom/sysrpc.htm", title: "SYSRPC" },
                  { url: "syscom/systp.htm", title: "SYSTP" },
                  { url: "syscom/tech.htm", title: "TECH" },
                  { url: "syscom/test.htm", title: "TEST" },
                  { url: "syscom/test_dblog.htm", title: "TEST DBLOG" },
                  { url: "syscom/uncatalog.htm", title: "UNCATALOG" },
                  { url: "syscom/unlock.htm", title: "UNLOCK" },
                  { url: "syscom/update.htm", title: "UPDATE" },
                  { url: "syscom/which.htm", title: "WHICH" },
                  { url: "syscom/xref.htm", title: "XREF" },
                  { url: "syscom/ziip.htm", title: "ZIIP" },
              ]
            },
            { url: "utis/utis-over.htm", title: "Utilities",
              tree: [
                  { url: "utis/utis_activate.htm", title: "Utility Activation" },
                  { url: "utis/utis_mf_groups.htm", title: "Utilities Grouped by Purpose" },
                  { url: "utis/ada.htm", title: "ADACALL Utility - Issuing Adabas Direct Calls" },
                  { url: "utis/log.htm", title: "DBLOG Utility - Logging Database Calls",
                    tree: [
                        { url: "utis/log_exec.htm", title: "Executing DBLOG" },
                        { url: "utis/log_menu.htm", title: "DBLOG Menu" },
                        { url: "utis/log_trace.htm", title: "DBLOG Trace Screen" },
                        { url: "utis/log_snap.htm", title: "DBLOG Snapshot Function" },
                        { url: "utis/log_comm.htm", title: "TEST DBLOG Command" },
                    ]
                  },
                  { url: "utis/inpl.htm", title: "INPL Utility" },
                  { url: "utis/screen.htm", title: "NATPAGE Utility - Screen Capturing" },
                  { url: "utis/rje.htm", title: "NATRJE Utility - Natural Remote Job Entry" },
                  { url: "utis/sysobjh.htm", title: "Object Handler",
                    tree: [
                        { url: "utis/sysobjh_gen_info.htm", title: "General Information on the Object Handler" },
                        { url: "utis/sysobjh_func.htm", title: "Functions" },
                        { url: "utis/sysobjh_wizard.htm", title: "Wizards" },
                        { url: "utis/sysobjh_adv.htm", title: "Advanced User" },
                        { url: "utis/sysobj_compact.htm", title: "Compact Mode" },
                        { url: "utis/sysobjh_restart_cui.htm", title: "Restart Load" },
                        { url: "utis/sysobjh_view.htm", title: "View" },
                        { url: "utis/sysobjh_find.htm", title: "Find" },
                        { url: "utis/sysobjh_admin.htm", title: "Administration" },
                        { url: "utis/sysobjh_sel_fi.htm", title: "Select System File" },
                        { url: "utis/sysobjh_sel_lib.htm", title: "Select Library" },
                        { url: "utis/sysobjh_sel_mess.htm", title: "Select System Error Messages" },
                        { url: "utis/sysobjh_sel_obj.htm", title: "Select Objects" },
                        { url: "utis/sysobjh_objects.htm", title: "Object Specification" },
                        { url: "utis/sysobjh_all.htm", title: "Object Specification - All Objects on the Work File" },
                        { url: "utis/sysobjh_library.htm", title: "Object Specification - Natural Library Objects" },
                        { url: "utis/sysobjh_syserr.htm", title: "Object Specification - Natural System Error Messages" },
                        { url: "utis/sysobjh_ncp.htm", title: "Object Specification - Natural Command Processors" },
                        { url: "utis/sysobjh_related.htm", title: "Object Specification - Natural-Related Objects" },
                        { url: "utis/sysobjh_ddm_mf.htm", title: "Object Specification - DDMs" },
                        { url: "utis/sysobjh_fdt.htm", title: "Object Specification - FDTs" },
                        { url: "utis/sysobjh_use_work.htm", title: "Use Selection or List Workplan" },
                        { url: "utis/sysobjh_settings.htm", title: "Settings" },
                        { url: "utis/sysobjh_workplan.htm", title: "Workplans" },
                        { url: "utis/sysobjh_dat_time.htm", title: "Name, Date and Time Specification" },
                        { url: "utis/sysobjh_workfile.htm", title: "Work Files" },
                        { url: "utis/sysobjh_commands.htm", title: "Direct Commands" },
                        { url: "utis/sysobjh_work_cmd.htm", title: "Basic Command Syntax" },
                        { url: "utis/sysobjh_select.htm", title: "select-clause" },
                        { url: "utis/sysobjh_object.htm", title: "Object List - LIST Workplan" },
                        { url: "utis/sysobjh_parm.htm", title: "parameter-setting" },
                        { url: "utis/sysobjh_option.htm", title: "option-setting" },
                        { url: "utis/sysobjh_example_cmds.htm", title: "Examples of Using Direct Commands" },
                        { url: "utis/sysobjh_int_cmd.htm", title: "Commands for Navigation and Special Functions" },
                        { url: "utis/sysobjh_cc_uexit.htm", title: "Batch Condition Codes and User Exit Routines" },
                        { url: "utis/sysobjh_tools.htm", title: "Tools" },
                        { url: "utis/sysobjh_profile.htm", title: "Profile Settings" },
                        { url: "utis/sysobjh_migration.htm", title: "Migration from NATUNLD/NATLOAD and SYSTRANS to the Object Handler" },
                    ]
                  },
                  { url: "utis/record.htm", title: "Recording Utility" },
                  { url: "utis/sysapi_mfwin.htm", title: "SYSAPI Utility - APIs of Natural Add-On Products" },
                  { url: "utis/bpm-over.htm", title: "SYSBPM Utility - Buffer Pool Management",
                    tree: [
                        { url: "utis/bpm_invoke.htm", title: "Invoking and Operating SYSBPM" },
                        { url: "utis/bpm_list_obj.htm", title: "List Objects" },
                        { url: "utis/bpm_del_obj.htm", title: "Delete Objects" },
                        { url: "utis/bpm_obj_dir.htm", title: "Directory Information" },
                        { url: "utis/bpm_obj_hex.htm", title: "Hexadecimal Display" },
                        { url: "utis/bpm_workfile.htm", title: "Write to Work File" },
                        { url: "utis/bpm_dis_sort.htm", title: "Display Sorted Extract" },
                        { url: "utis/bpm_bp_stat.htm", title: "Buffer Pool Statistics" },
                        { url: "utis/bpm_cache_stat.htm", title: "BP Cache Statistics" },
                        { url: "utis/bpm_message_stat.htm", title: "Message Buffer Pool Statistics" },
                        { url: "utis/bpm_sel_buff.htm", title: "Select Buffer Pool" },
                        { url: "utis/bpm_sel_mess.htm", title: "Select Message Pool" },
                        { url: "utis/bpm_blacklist.htm", title: "Blacklist Maintenance" },
                        { url: "utis/bpm_preload.htm", title: "Preload List Maintenance" },
                        { url: "utis/bpm_perf.htm", title: "Performance Considerations" },
                        { url: "utis/bpm_dir_cmd.htm", title: "SYSBPM Direct Commands" },
                        { url: "utis/bpm_batch.htm", title: "Batch Processing" },
                        { url: "utis/bpm_inter.htm", title: "Application Programming Interfaces" },
                    ]
                  },
                  { url: "utis/syscp.htm", title: "SYSCP Utility - Code Page Administration" },
                  { url: "utis/sysedt.htm", title: "SYSEDT Utility - Editor Buffer Pool Administration" },
                  { url: "utis/syserr.htm", title: "SYSERR Utility",
                    tree: [
                        { url: "utis/syserr_gen_mess.htm", title: "General Information on Messages" },
                        { url: "utis/syserr_invoke.htm", title: "Invoking SYSERR" },
                        { url: "utis/syserr_function.htm", title: "SYSERR Functions" },
                        { url: "utis/syserr_parms.htm", title: "SYSERR Parameters" },
                        { url: "utis/syserr_dir_com.htm", title: "SYSERR Direct Commands" },
                        { url: "utis/syserr_errupper.htm", title: "Upper Case Conversion - ERRUPPER" },
                        { url: "utis/syserr_errchar.htm", title: "Replacing Characters - ERRCHAR" },
                        { url: "utis/syserr_manage_messages.htm", title: "Managing Messages in Different Libraries" },
                    ]
                  },
                  { url: "utis/sysext.htm", title: "SYSEXT Utility - Natural Application Programming Interfaces" },
                  { url: "utis/sysexv.htm", title: "SYSEXV Utility" },
                  { url: "utis/sysmain_mf-over.htm", title: "SYSMAIN Utility - Object Maintenance",
                    tree: [
                        { url: "utis/sysmain_mf_gen.htm", title: "General Information on SYSMAIN" },
                        { url: "utis/sysmain_mf_invoke.htm", title: "Invoking and Terminating SYSMAIN" },
                        { url: "utis/sysmain_mf_functions.htm", title: "Using Menu Functions and Commands" },
                        { url: "utis/sysmain_mf_prog_obj.htm", title: "Processing Programming Objects" },
                        { url: "utis/sysmain_mf_debug.htm", title: "Processing Debug Environments" },
                        { url: "utis/sysmain_mf_error.htm", title: "Processing Error Messages" },
                        { url: "utis/sysmain_mf_profiles.htm", title: "Processing Profiles" },
                        { url: "utis/sysmain_mf_rules.htm", title: "Processing Rules" },
                        { url: "utis/sysmain_mf_ddm.htm", title: "Processing DDMs" },
                        { url: "utis/sysmain_mf_predict_sets.htm", title: "Processing Predict Sets" },
                        { url: "utis/sysmain_mf_keywords.htm", title: "Keywords and Variables in Direct Commands" },
                        { url: "utis/sysmain_mf_cmds_sys.htm", title: "Special Commands Issued to SYSMAIN" },
                        { url: "utis/sysmain_mf_reject.htm", title: "Processing Status and Error Notification" },
                        { url: "utis/sysmain_mf_consider.htm", title: "Special Considerations for Administrators" },
                    ]
                  },
                  { url: "utis/sysncp.htm", title: "SYSNCP Utility" },
                  { url: "utis/parm.htm", title: "SYSPARM Utility" },
                  { url: "utis/profiler.htm", title: "Natural Profiler and Code Coverage",
                    tree: [
                        { url: "utis/profiling_applications.htm", title: "Profiling Natural Applications" },
                        { url: "utis/code_coverage_applications.htm", title: "Code Coverage of Natural Applications" },
                        { url: "utis/profiler_intro.htm", title: "Basic Concepts of the Profiler Utility" },
                        { url: "utis/profiler_online.htm", title: "Using the Profiler Utility in Online Mode" },
                        { url: "utis/profiler_batch_mode.htm", title: "Using the Profiler Utility in Batch Mode" },
                        { url: "utis/profiler_rich_gui.htm", title: "Natural Profiler Rich GUI" },
                    ]
                  },
                  { url: "utis/rdc.htm", title: "SYSRDC Utility" },
                  { url: "utis/sysrpc-over.htm", title: "SYSRPC Utility",
                    tree: [
                        { url: "utis/sysrpc_basic.htm", title: "Invoking and Terminating SYSRPC" },
                        { url: "utis/sysrpc_sm.htm", title: "Service Directory Maintenance" },
                        { url: "utis/sysrpc_replace_command.htm", title: "Replacing Items in the Service Directory" },
                        { url: "utis/sysrpc_interface_general.htm", title: "Generating Interface Objects - General Considerations" },
                        { url: "utis/sysrpc_interface_object_single.htm", title: "Generating Single Interface Objects with Parameter Specification" },
                        { url: "utis/sysrpc_interface_object_mass.htm", title: "Generating Multiple Interface Objects" },
                        { url: "utis/sysrpc_buffer.htm", title: "Calculating Size Requirements" },
                        { url: "utis/sysrpc_parm_cui.htm", title: "Parameter Maintenance" },
                        { url: "utis/sysrpc_com_exec.htm", title: "Server Command Execution" },
                        { url: "utis/sysrpc_srvlist.htm", title: "Listing Servers Registered on EntireX Broker" },
                        { url: "utis/sysrpc_direct_batch_commands.htm", title: "Overview of SYSRPC Direct and Batch Commands" },
                    ]
                  },
                  { url: "utis/systp-over.htm", title: "SYSTP Utility",
                    tree: [
                        { url: "utis/systp_invoke_utility.htm", title: "Invoking SYSTP and Executing Functions" },
                        { url: "utis/systp_use_systp_screens.htm", title: "Using SYSTP Utility Screens" },
                        { url: "utis/systp_env_ind.htm", title: "General SYSTP Functions" },
                        { url: "utis/systp_dep_cics.htm", title: "SYSTP Functions under CICS" },
                        { url: "utis/systp_dep_ims.htm", title: "SYSTP Functions under IMS TM" },
                        { url: "utis/systp_batch.htm", title: "SYSTP in Batch for CICS Sessions" },
                    ]
                  },
              ]
            },
            { url: "debug_mf/ug-over_0001.htm", title: "Debugger und Dienstprogramme (Utilities)",
              tree: [
                  { url: "debug_mf/debugger_mf_intro.htm", title: "Debugger" },
                  { url: "debug_mf/debug_mf_tutorial.htm", title: "Debugger-Tutorial" },
                  { url: "debug_mf/debug_mf_conc.htm", title: "Debugger-Konzept" },
                  { url: "debug_mf/debug_mf_invoke.htm", title: "Debugger starten" },
                  { url: "debug_mf/debug_mf_set.htm", title: "Test-Modus ein- und ausschalten" },
                  { url: "debug_mf/debug_mf_env.htm", title: "Debug Environment Maintenance (Verwaltung der Debug-Umgebung)" },
                  { url: "debug_mf/debug_mf_spy.htm", title: "Spy Maintenance (Verwaltung der Debug-Einträge)" },
                  { url: "debug_mf/debug_mf_break.htm", title: "Breakpoint Maintenance (Verwaltung der Breakpoints)" },
                  { url: "debug_mf/debug_mf_watch.htm", title: "Watchpoint Maintenance (Verwaltung der Watchpoints)" },
                  { url: "debug_mf/debug_mf_call.htm", title: "Call Statistics Maintenance (Statistiken über gerufene Objekte)" },
                  { url: "debug_mf/debug_mf_state.htm", title: "Statement Execution Statistics Maintenance (Statistiken über ausgeführte Statement-Zeilen)" },
                  { url: "debug_mf/debug_mf_vari.htm", title: "Variable Maintenance (Anzeigen und Ändern von Variablen)" },
                  { url: "debug_mf/debug_mf_list.htm", title: "List Object Source (Objekt-Quellcode anzeigen)" },
                  { url: "debug_mf/debug_mf_error.htm", title: "Fehlerbehandlung" },
                  { url: "debug_mf/debug_mf_exec.htm", title: "Kommandos zur Ausführungssteuerung" },
                  { url: "debug_mf/debug_mf_navig.htm", title: "Kommandos zum Navigieren und Anzeigen von Informationen" },
                  { url: "debug_mf/debug_mf_summ.htm", title: "Debug-Kommandoübersicht und -syntax" },
                  { url: "debug_mf/debug_mf_attach.htm", title: "Natural für Attached-Debugging vorbereiten" },
                  { url: "debug_mf/utis_mf_groups_de.htm", title: "Dienstprogramme gruppiert nach Verwendungszweck" },
                  { url: "debug_mf/utis_activate_de.htm", title: "Utility-Aktivierung" },
                  { url: "debug_mf/ada.htm", title: "ADACALL Utility" },
                  { url: "debug_mf/bpm-over.htm", title: "SYSBPM Utility",
                    tree: [
                        { url: "debug_mf/bpm_gen_info.htm", title: "Allgemeines zum Dienstprogramm SYSBPM" },
                        { url: "debug_mf/bpm_invoke.htm", title: "SYSBPM aufrufen und benutzen" },
                        { url: "debug_mf/bpm_list_obj.htm", title: "Objekte auflisten" },
                        { url: "debug_mf/bpm_del_obj.htm", title: "Objekte löschen" },
                        { url: "debug_mf/bpm_obj_dir.htm", title: "Verzeichnisinformationen anzeigen" },
                        { url: "debug_mf/bpm_obj_hex.htm", title: "Hexadezimale Anzeige" },
                        { url: "debug_mf/bpm_workfile.htm", title: "In Arbeitsdatei schreiben" },
                        { url: "debug_mf/bpm_dis_sort.htm", title: "Sortierten Auszug anzeigen" },
                        { url: "debug_mf/bpm_bp_stat.htm", title: "Buffer Pool-Statistiken anzeigen" },
                        { url: "debug_mf/bpm_cache_stat.htm", title: "BP Cache-Statistiken anzeigen" },
                        { url: "debug_mf/bpm_message_stat.htm", title: "Message Buffer Pool-Statistiken anzeigen" },
                        { url: "debug_mf/bpm_sel_buff.htm", title: "Buffer Pool auswählen" },
                        { url: "debug_mf/bpm_sel_mess.htm", title: "Message Buffer Pool auswählen" },
                        { url: "debug_mf/bpm_blacklist.htm", title: "Sperrliste verwalten" },
                        { url: "debug_mf/bpm_preload.htm", title: "Preload-Liste verwalten" },
                        { url: "debug_mf/bpm_perf.htm", title: "Performance-Aspekte" },
                        { url: "debug_mf/bpm_dir_cmd.htm", title: "SYSBPM-Direktkommandos" },
                        { url: "debug_mf/bpm_batch.htm", title: "Batch-Verarbeitung" },
                        { url: "debug_mf/bpm_inter.htm", title: "Anwendungsprogrammierschnittstellen" },
                    ]
                  },
                  { url: "debug_mf/log.htm", title: "DBLOG Utility - Datenbankaufrufe protokollieren",
                    tree: [
                        { url: "debug_mf/log_exec.htm", title: "DBLOG ausführen" },
                        { url: "debug_mf/log_menu.htm", title: "DBLOG-Menü" },
                        { url: "debug_mf/log_trace.htm", title: "DBLOG Trace-Bildschirm" },
                        { url: "debug_mf/log_snap.htm", title: "DBLOG Snapshot-Funktion" },
                        { url: "debug_mf/log_comm.htm", title: "TEST DBLOG -Kommando" },
                    ]
                  },
                  { url: "debug_mf/inpl.htm", title: "INPL Utility" },
                  { url: "debug_mf/natpage_de.htm", title: "NATPAGE Utility" },
                  { url: "debug_mf/rje_de.htm", title: "NATRJE Utility" },
                  { url: "debug_mf/profiler.htm", title: "Natural Profiler",
                    tree: [
                        { url: "debug_mf/profiling_applications.htm", title: "Profil-Erstellung für Natural-Anwendungen (Profiling)" },
                        { url: "debug_mf/code_coverage_applications.htm", title: "Codeabdeckung von Natural-Anwendungen (Code Coverage)" },
                        { url: "debug_mf/profiler_intro.htm", title: "Grundlegendes Konzept der Profiler Utility" },
                        { url: "debug_mf/profiler_online.htm", title: "Profiler Utility im Online-Modus benutzen" },
                        { url: "debug_mf/profiler_batch_mode.htm", title: "Profiler Utility im Batch-Modus benutzen" },
                        { url: "debug_mf/profiler_rich_gui.htm", title: "Natural Profiler Rich GUI-Schnittstelle" },
                    ]
                  },
                  { url: "debug_mf/recording_de.htm", title: "Recording Utility" },
                  { url: "debug_mf/sysapi_de.htm", title: "SYSAPI Utility" },
                  { url: "debug_mf/syscp_de.htm", title: "SYSCP Utility" },
                  { url: "debug_mf/sysedt.htm", title: "SYSEDT Utility" },
                  { url: "debug_mf/syserr_de.htm", title: "SYSERR Utility",
                    tree: [
                        { url: "debug_mf/syserr_gen_mess.htm", title: "Allgemeine Informationen zu Meldungen" },
                        { url: "debug_mf/syserr_invoke.htm", title: "SYSERR aufrufen" },
                        { url: "debug_mf/syserr_function.htm", title: "Funktionen" },
                        { url: "debug_mf/syserr_parms.htm", title: "Parameter" },
                        { url: "debug_mf/syserr_dir_com.htm", title: "Direktkommandos" },
                        { url: "debug_mf/syserr_errupper.htm", title: "Umwandlung in Großbuchstaben - ERRUPPER" },
                        { url: "debug_mf/syserr_errchar.htm", title: "Zeichen ersetzen - ERRCHAR" },
                        { url: "debug_mf/syserr_manage_messages.htm", title: "Meldungen in verschiedenen Libraries verwalten" },
                    ]
                  },
                  { url: "debug_mf/sysext_de.htm", title: "SYSEXT Utility" },
                  { url: "debug_mf/sysexv_de.htm", title: "SYSEXV Utility" },
                  { url: "debug_mf/sysmain_mf-over.htm", title: "SYSMAIN Utility",
                    tree: [
                        { url: "debug_mf/sysmain_mf_gen.htm", title: "Allgemeine Informationen zu SYSMAIN" },
                        { url: "debug_mf/sysmain_mf_invoke.htm", title: "SYSMAIN aufrufen und beenden" },
                        { url: "debug_mf/sysmain_mf_functions.htm", title: "Menüfunktionen und Kommandos benutzen" },
                        { url: "debug_mf/sysmain_mf_prog_obj.htm", title: "Programmierobjekte bearbeiten" },
                        { url: "debug_mf/sysmain_mf_debug.htm", title: "Debug-Umgebungen bearbeiten" },
                        { url: "debug_mf/sysmain_mf_error.htm", title: "Fehlermeldungen bearbeiten" },
                        { url: "debug_mf/sysmain_mf_profiles.htm", title: "Profile bearbeiten" },
                        { url: "debug_mf/sysmain_mf_rules.htm", title: "Rules bearbeiten" },
                        { url: "debug_mf/sysmain_mf_ddm.htm", title: "DDMs bearbeiten" },
                        { url: "debug_mf/sysmain_mf_predict_sets.htm", title: "Predict Sets bearbeiten" },
                        { url: "debug_mf/sysmain_mf_keywords.htm", title: "Schlüsselwörter und Variablen in Direktkommandos" },
                        { url: "debug_mf/sysmain_mf_cmds_sys.htm", title: "An SYSMAIN absetzbare spezielle Kommandos" },
                        { url: "debug_mf/sysmain_mf_reject.htm", title: "Statusmeldungen und Fehlerbenachrichtigungen bearbeiten" },
                        { url: "debug_mf/sysmain_mf_consider.htm", title: "Besondere Hinweise für Administratoren" },
                    ]
                  },
                  { url: "debug_mf/sysncp_de.htm", title: "SYSNCP Utility" },
                  { url: "debug_mf/sysobjh.htm", title: "Object Handler",
                    tree: [
                        { url: "debug_mf/sysobjh_gen_info.htm", title: "Allgemeine Informationen zum Object Handler" },
                        { url: "debug_mf/sysobjh_func.htm", title: "Funktionen" },
                        { url: "debug_mf/sysobjh_wizard.htm", title: "Assistenten (Wizards)" },
                        { url: "debug_mf/sysobjh_adv.htm", title: "Expertenmodus (Advanced User)" },
                        { url: "debug_mf/sysobj_compact.htm", title: "Kompaktmodus (Compact Mode)" },
                        { url: "debug_mf/sysobjh_restart_cui.htm", title: "Ladefunktion erneut starten (Restart Load)" },
                        { url: "debug_mf/sysobjh_view.htm", title: "Objekte in der Natural-Umgebung sichten (View)" },
                        { url: "debug_mf/sysobjh_find.htm", title: "Objekte suchen (Find)" },
                        { url: "debug_mf/sysobjh_admin.htm", title: "Administration (Arbeitspläne verwalten)" },
                        { url: "debug_mf/sysobjh_sel_fi.htm", title: "Systemdatei auswählen (Select System File)" },
                        { url: "debug_mf/sysobjh_sel_lib.htm", title: "Bibliothek auswählen (Select Library)" },
                        { url: "debug_mf/sysobjh_sel_mess.htm", title: "Systemfehlermeldungen auswählen (Select System Error Messages)" },
                        { url: "debug_mf/sysobjh_sel_obj.htm", title: "Objekte auswählen (Select Objects)" },
                        { url: "debug_mf/sysobjh_objects.htm", title: "Objekte angeben" },
                        { url: "debug_mf/sysobjh_all.htm", title: "Objektangabe - Alle Objekte in der Arbeitsdatei laden/durchsuchen" },
                        { url: "debug_mf/sysobjh_library.htm", title: "Objektangabe - Natural-Library-Objekte entladen/laden/durchsuchen" },
                        { url: "debug_mf/sysobjh_syserr.htm", title: "Objektangabe - Natural Systemfehlermeldungen" },
                        { url: "debug_mf/sysobjh_ncp.htm", title: "Objektangabe - Natural-Kommandoprozessoren" },
                        { url: "debug_mf/sysobjh_related.htm", title: "Objektangabe - Natural-zugehörige Objekte" },
                        { url: "debug_mf/sysobjh_ddm_mf.htm", title: "Objektangabe - Datendefinitionsmodule (DDMs)" },
                        { url: "debug_mf/sysobjh_fdt.htm", title: "Objektangabe für Felddefinitionstabellen (FDTs)" },
                        { url: "debug_mf/sysobjh_use_work.htm", title: "Arbeitsplan-Typ SELECTION oder LIST verwenden" },
                        { url: "debug_mf/sysobjh_settings.htm", title: "Einstellungen (Settings)" },
                        { url: "debug_mf/sysobjh_workplan.htm", title: "Arbeitspläne (Workplans)" },
                        { url: "debug_mf/sysobjh_dat_time.htm", title: "Angabe von Name, Datum und Zeit" },
                        { url: "debug_mf/sysobjh_workfile.htm", title: "Arbeitsdateien (Work Files)" },
                        { url: "debug_mf/sysobjh_commands.htm", title: "Direkkommandos" },
                        { url: "debug_mf/sysobjh_work_cmd.htm", title: "Grundlegende Kommandosyntax" },
                        { url: "debug_mf/sysobjh_select.htm", title: "select-clause" },
                        { url: "debug_mf/sysobjh_object.htm", title: "Objektliste - Arbeitsplantyp LIST" },
                        { url: "debug_mf/sysobjh_parm.htm", title: "parameter-setting" },
                        { url: "debug_mf/sysobjh_option.htm", title: "option-setting" },
                        { url: "debug_mf/sysobjh_example_cmds.htm", title: "Beispiele für die Verwendung von Object Handler-Direktkommandos" },
                        { url: "debug_mf/sysobjh_int_cmd.htm", title: "Kommandos für die Navigation und für spezielle Funktionen" },
                        { url: "debug_mf/sysobjh_cc_uexit.htm", title: "Batch Condition Codes und User Exit Routinen" },
                        { url: "debug_mf/sysobjh_profile.htm", title: "Profileinstellungen (Profile Settings)" },
                        { url: "debug_mf/sysobjh_tools.htm", title: "Werkzeuge (Tools)" },
                        { url: "debug_mf/sysobjh_migration.htm", title: "Migration von NATUNLD/NATLOAD und SYSTRANS zum Object Handler" },
                    ]
                  },
                  { url: "debug_mf/sysparm_de.htm", title: "SYSPARM Utility" },
                  { url: "debug_mf/rdc.htm", title: "SYSRDC Utility" },
                  { url: "debug_mf/sysrpc-over.htm", title: "SYSRPC Utility",
                    tree: [
                        { url: "debug_mf/sysrpc_basic.htm", title: "SYSRPC Utility aufrufen und beenden" },
                        { url: "debug_mf/sysrpc_sm.htm", title: "Funktion Service Directory Maintenance benutzen" },
                        { url: "debug_mf/sysrpc_replace_command.htm", title: "Elemente im Service Directory ersetzen" },
                        { url: "debug_mf/sysrpc_interface_general.htm", title: "Interface-Objekte generieren - Allgemeine Aspekte" },
                        { url: "debug_mf/sysrpc_interface_object_single.htm", title: "Einzelne Interface-Objekte mit Parameterangabe generieren" },
                        { url: "debug_mf/sysrpc_interface_object_mass.htm", title: "Mehrere Interface-Objekte generieren" },
                        { url: "debug_mf/sysrpc_buffer.htm", title: "Benötigte Puffergröße berechnen" },
                        { url: "debug_mf/sysrpc_parm_cui.htm", title: "Parameter verwalten (Parameter Maintenance)" },
                        { url: "debug_mf/sysrpc_com_exec.htm", title: "Server-Kommandos ausführen (Server Command Execution)" },
                        { url: "debug_mf/sysrpc_srvlist.htm", title: "Beim EntireX Broker registrierte Server auflisten" },
                        { url: "debug_mf/sysrpc_direct_batch_commands.htm", title: "Übersicht über die SYSRPC-Direktkommandos und -Batch-Kommandos" },
                    ]
                  },
                  { url: "debug_mf/systp-over.htm", title: "SYSTP Utility",
                    tree: [
                        { url: "debug_mf/systp_invoke_utility.htm", title: "SYSTP aufrufen und Funktionen ausführen" },
                        { url: "debug_mf/systp_use_systp_screens.htm", title: "SYSTP-Bildschirme benutzen" },
                        { url: "debug_mf/systp_env_ind.htm", title: "Allgemeine SYSTP-Funktionen" },
                        { url: "debug_mf/systp_dep_cics.htm", title: "SYSTP-Funktionen unter CICS" },
                        { url: "debug_mf/systp_dep_ims.htm", title: "SYSTP-Funktionen unter IMS TM" },
                        { url: "debug_mf/systp_batch.htm", title: "SYSTP im Batch-Modus für CICS-Sitzungen" },
                    ]
                  },
              ]
            },
            { url: "webtech/webtech-over.htm", title: "Web Technology",
              tree: [
                  { url: "webtech/webtech_json.htm", title: "JSON Parser" },
                  { url: "webtech/nwx-over.htm", title: "Natural Web Interface",
                    tree: [
                        { url: "webtech/nwx_intro.htm", title: "Introducing the Natural Web Interface" },
                        { url: "webtech/nwx_inst.htm", title: "Natural Web Interface Configuration" },
                        { url: "webtech/nwx_configuring.htm", title: "Configuring the Natural Web Interface" },
                        { url: "webtech/nwx_troublesh.htm", title: "Web Interface Troubleshooting" },
                        { url: "webtech/nwx_inter.htm", title: "Natural Web Interface Essentials" },
                        { url: "webtech/nwx_working.htm", title: "Working with the Natural Web Interface" },
                    ]
                  },
                  { url: "webtech/nwx_adapt.htm", title: "Natural Web Server Extensions",
                    tree: [
                        { url: "webtech/nwx_general_old.htm", title: "Natural Web Server Extensions - Introduction" },
                        { url: "webtech/nwx_initfile.htm", title: "Natural Web Server Extensions - Initialization File" },
                        { url: "webtech/nwx_errormsg.htm", title: "Natural Web Server Extensions - Error Messages" },
                        { url: "webtech/nwx_tipsprog.htm", title: "Programming Tips" },
                        { url: "webtech/nwx_administr.htm", title: "Web Interface Administration" },
                        { url: "webtech/nwx_demoapp.htm", title: "Demonstration Application - without JavaScript" },
                        { url: "webtech/nwx_demonew.htm", title: "Demonstration Application - with JavaScript" },
                        { url: "webtech/nwx_error.htm", title: "Natural Web Interface Error Messages" },
                    ]
                  },
                  { url: "webtech/nwx_examp-over_t31_0300.htm", title: "Natural Web Online Documentation SYSWEB" },
                  { url: "webtech/t31_0310.htm", title: "Clear Output Area" },
                  { url: "webtech/t31_0320.htm", title: "Set Document Content-Type" },
                  { url: "webtech/t31_0330.htm", title: "Count Size of Output Area" },
                  { url: "webtech/t31_0340.htm", title: "Generate Error Page" },
                  { url: "webtech/t31_0350.htm", title: "Writes to the Document and Converts to Valid HTML" },
                  { url: "webtech/t31_0360.htm", title: "Writes HTTP Settings to the Document" },
                  { url: "webtech/t31_0370.htm", title: "Info About Internal Values" },
                  { url: "webtech/t31_0380.htm", title: "End and Initialize Document" },
                  { url: "webtech/t31_0390.htm", title: "List All Environment Variables" },
                  { url: "webtech/t31_0400.htm", title: "Set Document Location" },
                  { url: "webtech/t31_0410.htm", title: "Read Environment Variable" },
                  { url: "webtech/t31_0420.htm", title: "Read Environment Variables Groups" },
                  { url: "webtech/t31_0430.htm", title: "Read Environment Text Area Variables" },
                  { url: "webtech/t31_0440.htm", title: "Write Text to Document" },
                  { url: "webtech/t31_0450.htm", title: "Write Newline to Output Area" },
                  { url: "webtech/t31_0460.htm", title: "Text to HTML" },
                  { url: "webtech/t31_0470.htm", title: "Text to XML" },
                  { url: "webtech/t31_0480.htm", title: "Text to URL" },
                  { url: "webtech/t31_0490.htm", title: "Replace Inside Return Document" },
                  { url: "webtech/t31_0580.htm", title: "Read Output Page" },
                  { url: "webtech/t31_0590.htm", title: "Anchor" },
                  { url: "webtech/t31_0600.htm", title: "Button" },
                  { url: "webtech/t31_0610.htm", title: "Checkbox Group" },
                  { url: "webtech/t31_0620.htm", title: "Comment Line" },
                  { url: "webtech/t31_0630.htm", title: "Level n Header" },
                  { url: "webtech/t31_0640.htm", title: "Image" },
                  { url: "webtech/t31_0650.htm", title: "Input" },
                  { url: "webtech/t31_0660.htm", title: "Line Break" },
                  { url: "webtech/t31_0670.htm", title: "Form" },
                  { url: "webtech/t31_0680.htm", title: "HTML Document" },
                  { url: "webtech/t31_0690.htm", title: "List" },
                  { url: "webtech/t31_0700.htm", title: "Paragraph" },
                  { url: "webtech/t31_0710.htm", title: "Radio Button Group" },
                  { url: "webtech/t31_0720.htm", title: "Horizontal Rule" },
                  { url: "webtech/t31_0730.htm", title: "Scrolling List" },
                  { url: "webtech/t31_0740.htm", title: "Table" },
                  { url: "webtech/t31_0750.htm", title: "Universal Tag" },
                  { url: "webtech/t31_0760.htm", title: "Text Area" },
                  { url: "webtech/t31_0770.htm", title: "Text to URL - Decoded" },
                  { url: "webtech/t31_0780.htm", title: "Time/Date String" },
                  { url: "webtech/t31_0790.htm", title: "List all Natural Libraries" },
                  { url: "webtech/t31_0800.htm", title: "Run Online Natural Web Interface Subprograms" },
                  { url: "webtech/t31_0810.htm", title: "Generate Natural Subprogram to use with Natural Web Interface" },
                  { url: "webtech/t31_0820.htm", title: "List Directory of a Natural Library" },
                  { url: "webtech/t31_0830.htm", title: "List All Parameters Passed From a HTTP Server To a Called Natural Subprogram" },
                  { url: "webtech/t31_0840.htm", title: "Return an HTML Page Saved as Natural Source Object" },
                  { url: "webtech/t31_0850.htm", title: "List the Current Natural Web Interface Settings" },
                  { url: "webtech/t31_0860.htm", title: "List Source of Natural Object" },
                  { url: "webtech/t31_0870.htm", title: "Online Documentation" },
                  { url: "webtech/xml-over.htm", title: "XML Toolkit",
                    tree: [
                        { url: "webtech/xml.htm", title: "Introduction" },
                        { url: "webtech/xml_run.htm", title: "Using the XML Toolkit" },
                        { url: "webtech/xml_opti.htm", title: "Setting up Specific Generation Options" },
                        { url: "webtech/xml_nda.htm", title: "Using a Natural Data Source" },
                        { url: "webtech/xml_dtd.htm", title: "Using an external Data Source" },
                        { url: "webtech/xml_nixe.htm", title: "Natural Simple XML Parser" },
                        { url: "webtech/xml_exa.htm", title: "Examples" },
                        { url: "webtech/xml_err.htm", title: "XML Parser Error Messages" },
                    ]
                  },
              ]
            },
            { url: "noc_mf/noc_mf-over.htm", title: "Natural Optimizer Compiler",
              tree: [
                  { url: "noc_mf/noc_mf_gen.htm", title: "Allgemeine Informationen" },
                  { url: "noc_mf/noc_mf_conditio.htm", title: "Optimizer Compiler benutzen - Übersicht",
                    tree: [
                        { url: "noc_mf/noc_mf_whatcomp.htm", title: "Was kompiliert wird und was nicht" },
                        { url: "noc_mf/noc_mf_nocstat.htm", title: "NOCSTAT-Kommando" },
                        { url: "noc_mf/noc_mf_dissize.htm", title: "Größe des Maschinencodes anzeigen" },
                        { url: "noc_mf/noc_mf_examples.htm", title: "Beispiele für die Optimizer-Verwendung" },
                    ]
                  },
                  { url: "noc_mf/noc_mf_switch.htm", title: "Optimizer Compiler aktivieren" },
                  { url: "noc_mf/noc_mf_options.htm", title: "Optimizer-Optionen" },
                  { url: "noc_mf/noc_mf_perf.htm", title: "Performance-Überlegungen" },
                  { url: "noc_mf/noc_mf_zaps.htm", title: "Zaps auflisten" },
              ]
            },
            { url: "rnm_mf/rnm_mf-over.htm", title: "Natural Review",
              tree: [
                  { url: "rnm_mf/start.htm", title: "Getting Started with Natural Review" },
                  { url: "rnm_mf/access.htm", title: "Accessing Natural Monitor" },
                  { url: "rnm_mf/response.htm", title: "Using Response Time Reports" },
                  { url: "rnm_mf/user.htm", title: "Active User Information" },
                  { url: "rnm_mf/tech.htm", title: "Technical Information" },
                  { url: "rnm_mf/admin.htm", title: "Administrative Functions" },
                  { url: "rnm_mf/fcc.htm", title: "Function Codes and Commands" },
                  { url: "rnm_mf/lda.htm", title: "Local Data Area View Description" },
                  { url: "rnm_mf/repfile.htm", title: "Natural Review Repository File" },
              ]
            },
            { url: "glossary/glossary.htm", title: "Glossary" },
            { url: "general/legal.htm", title: "Copyright" },
        ]
};

var mainProject = 1;

$.event.trigger({ type: "fishidbloaded", db: naturalformainframes });
