/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.List;
import java.awt.Panel;
import java.net.URL;

class SelectPanel
extends Panel
implements Runnable {
    private Component NextTab;
    private hi hi;
    private Button promptButton;
    private List indexList;
    private Component focus;
    private boolean sized;

    public boolean keyDown(Event event, int n) {
        if (n == 9) {
            Component component;
            Component component2 = component = this.focus == this.promptButton ? this.indexList : this.promptButton;
            if (this.focus == this.indexList && event.shiftDown() || this.focus == this.promptButton && !event.shiftDown() && this.NextTab != null) {
                this.NextTab.requestFocus();
                this.focus = component;
            } else {
                this.SetFocus(component);
            }
            return true;
        }
        if (event.key == 10 || event.key == 13) {
            this.selectIndex();
            return true;
        }
        return super.keyDown(event, n);
    }

    public void requestFocus() {
        this.SetFocus(this.focus != null ? this.focus : this.indexList);
        this.hi.ourMainPanel.setStatus(this.promptButton.getLabel());
    }

    private void SetFocus(Component component) {
        component.requestFocus();
        this.focus = component;
    }

    public void setNextTab(Component component) {
        this.NextTab = component;
    }

    public SelectPanel(hi hi2) {
        this.hi = hi2;
        this.setLayout(null);
        this.setFont(this.hi.formFont);
        this.promptButton = new Button(this.hi.LanguageString(9));
        this.add(this.promptButton);
        this.indexList = new List(5, false);
        this.indexList.setBackground(this.hi.FieldBgColour);
        this.indexList.disable();
        this.add(this.indexList);
        if (this.hi.readIndexParams) {
            this.BuildIndexList();
            return;
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        int n = dimension.width;
        if (!this.sized) {
            Dimension dimension2 = this.promptButton.preferredSize();
            if (dimension2.width + 10 > n) {
                dimension2.width = n - 10;
            }
            this.promptButton.reshape(5, 5, dimension2.width, dimension2.height);
            this.indexList.reshape(5, 10 + dimension2.height, n - 10, dimension.height - dimension2.height - 15);
            this.sized = true;
        }
    }

    private void selectIndex() {
        int n = this.indexList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.hi.ourMainPanel.setStatus("Loading " + this.indexList.getItem(n));
        this.hi.LoadEnglish();
        IndexParam indexParam = (IndexParam)this.hi.IndexParams.elementAt(n);
        if (indexParam.LanguageURL != null) {
            try {
                URL uRL = new URL(this.hi.applet.getCodeBase(), indexParam.LanguageURL);
                this.hi.LoadLanguage(uRL.openStream(), indexParam.LanguageURLCharEncoding);
            }
            catch (Exception exception) {}
        }
        this.hi.ourMainPanel.clearStatus();
        this.hi.newIndex(indexParam);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.promptButton) {
            this.selectIndex();
        }
        return super.action(event, object);
    }

    private void BuildIndexList() {
        int n = this.hi.IndexParams.size();
        int n2 = 0;
        while (n2 < n) {
            IndexParam indexParam = (IndexParam)this.hi.IndexParams.elementAt(n2);
            String string = indexParam.IndexURLDescription;
            String string2 = indexParam.LanguageURLName;
            if (string2 == null) {
                string2 = "English";
            }
            string = string + " ( " + string2 + ")";
            this.indexList.addItem(string);
            ++n2;
        }
        this.indexList.enable();
        if (this.indexList.getRows() > 0) {
            this.indexList.select(0);
        }
        this.repaint();
    }

    public void run() {
        try {
            Thread thread = Thread.currentThread();
            while (!this.hi.readIndexParams) {
                Thread.sleep(1000L);
            }
            this.BuildIndexList();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 501: {
                if (event.clickCount <= 1 || event.target != this.indexList) break;
                this.selectIndex();
            }
        }
        return super.handleEvent(event);
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        this.sized = false;
        super.reshape(n, n2, n3, n4);
    }
}

