/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.image.ImageObserver;

public class PHDTreePanel
extends Panel
implements ImageObserver,
Runnable {
    private static String _Version = "1.0.13";
    public static final int LEADING = 2;
    public static final int IMAGEINC = 4;
    public static final int MINBOX = 5;
    public static final int X_INC = 2;
    public boolean ShowTips = true;
    private Component NextTab;
    Color selectedColour = Color.green;
    Color tipBgColour = new Color(239, 255, 255);
    PHDTreeNode selectedNode;
    Image IconSet;
    PHDTreeNode tipNode;
    PHDTreeNode prevTipNode;
    Thread tipThread;
    Point tipRectLT = new Point(0, 0);
    Point tipRectBR = new Point(0, 0);
    private boolean NoTips = true;
    private boolean sort;
    private boolean ButtonShapeSquare;
    private boolean isJDK11plus;
    private boolean vbarWanted = true;
    private Scrollbar vbar;
    private boolean vbarVisible;
    private int vbarWidth;
    int UsableWidth;
    int UsableHeight;
    Font lineFont;
    Font rootFont;
    int fontHeight;
    int fontDescent;
    int lineHeight = 2;
    boolean lineHeightSet;
    int boxSize;
    private int prevBoxSize = -1;
    int lines;
    int maxWidth;
    private int firstX;
    int firstLine;
    private int linesOnPanel = -1;
    private PHDTreeNode root;
    boolean laidout;
    boolean justSelPaint;
    PHDTreeNode prevSelNode;
    int paintLine;
    int firstPaintLine;
    int linesToShow;
    Image CollapsedImage;
    Image ExpandedImage;
    int linefontsize;
    int linefontspacewidth;
    PHDTreeNode lowest;

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.NoTips || n >= this.UsableWidth || n2 >= this.UsableHeight) {
            return super.mouseMove(event, n, n2);
        }
        int n3 = n + this.firstX;
        int n4 = n2 + this.firstLine * this.lineHeight;
        if (this.getRoot().processMove(n3, n4)) {
            return true;
        }
        this.stopTip();
        return super.mouseMove(event, n, n2);
    }

    public void setNextTab(Component component) {
        this.NextTab = component;
    }

    private synchronized void SetScrollbars() {
        boolean bl;
        boolean bl2;
        Dimension dimension;
        if (this.vbarWanted && this.vbarWidth == 0) {
            this.add("East", this.vbar);
            this.layout();
            dimension = this.vbar.size();
            this.vbarWidth = dimension.width;
            if (!this.vbarVisible) {
                this.remove(this.vbar);
            }
        }
        dimension = this.size();
        this.UsableWidth = dimension.width;
        this.UsableHeight = dimension.height;
        this.linesOnPanel = this.UsableHeight / this.lineHeight;
        boolean bl3 = this.lines <= this.linesOnPanel;
        boolean bl4 = bl2 = this.UsableWidth >= this.maxWidth;
        if (bl2 && bl3) {
            bl = this.vbarVisible;
            if (this.vbarVisible) {
                this.remove(this.vbar);
                this.vbarVisible = false;
            }
            if (bl) {
                this.firstLine = 0;
                this.firstX = 0;
                this.layout();
                this.repaint();
            }
        }
        bl = false;
        if (!bl3 && this.vbarWanted) {
            bl = true;
            this.UsableWidth -= this.vbarWidth;
            bl2 = this.UsableWidth >= this.maxWidth;
        }
        boolean bl5 = false;
        if (bl) {
            if (!this.vbarVisible) {
                this.add("East", this.vbar);
                this.vbarVisible = true;
                bl5 = true;
            }
        } else if (this.vbarVisible) {
            this.remove(this.vbar);
            this.vbarVisible = false;
            bl5 = true;
        }
        if (bl5) {
            this.layout();
            this.repaint();
        }
        int n = this.firstLine;
        int n2 = this.firstX;
        if (this.firstLine + this.linesOnPanel > this.lines) {
            this.firstLine = this.lines - this.linesOnPanel;
        }
        if (this.firstLine < 0) {
            this.firstLine = 0;
        }
        if (this.firstX + this.UsableWidth > this.maxWidth) {
            this.firstX = this.maxWidth - this.UsableWidth;
        }
        if (this.firstX < 0) {
            this.firstX = 0;
        }
        if (this.vbarVisible) {
            if (this.isJDK11plus) {
                this.vbar.setValues(this.firstLine, this.linesOnPanel, 0, this.lines);
            } else {
                this.vbar.setValues(this.firstLine, this.linesOnPanel - 1, 0, this.lines - this.linesOnPanel);
            }
        }
        if (!(bl5 || this.firstLine == n && n2 == this.firstX)) {
            this.repaint();
        }
    }

    public void setTipNode(PHDTreeNode pHDTreeNode) {
        this.tipNode = pHDTreeNode;
    }

    public void setIcons(Image image) {
        this.IconSet = image;
    }

    public void select(PHDTreeNode pHDTreeNode, boolean bl) {
        this.prevSelNode = this.selectedNode;
        boolean bl2 = pHDTreeNode.selected;
        if (bl) {
            if (this.selectedNode != null) {
                this.selectedNode.selected = false;
            }
            PHDTreeNode pHDTreeNode2 = this.selectedNode = pHDTreeNode;
            while (pHDTreeNode2.parent != null) {
                pHDTreeNode2 = pHDTreeNode2.parent;
                if (pHDTreeNode2.expanded) continue;
                pHDTreeNode2.expand(true);
            }
        } else if (bl2) {
            this.selectedNode = null;
        }
        pHDTreeNode.selected = bl;
        if (bl2 != bl) {
            if (this.MadeVisible(this.selectedNode)) {
                this.SetScrollbars();
            } else {
                this.justSelPaint = true;
            }
            this.repaint();
        }
    }

    boolean checkHeight(int n) {
        if (n + 2 > this.lineHeight) {
            this.lineHeight = n + 2;
            this.linesOnPanel = -1;
            this.laidout = false;
            this.repaint();
            return false;
        }
        return true;
    }

    private void BuildCollapsedExpandedImages(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.boxSize = fontMetrics.getAscent() - fontMetrics.getDescent();
        if (this.boxSize < 5) {
            this.boxSize = 5;
        }
        if (this.boxSize == this.prevBoxSize) {
            return;
        }
        this.prevBoxSize = this.boxSize;
        int n5 = this.boxSize / 2;
        int n6 = 2;
        if (this.boxSize < 7) {
            n6 = 1;
        }
        if ((n4 = (n3 = this.boxSize - (n2 = (this.boxSize - (n = this.boxSize / 5)) / 2) - 1) - n2 + 1) > n + 1) {
            ++n2;
            n4 -= 2;
        }
        this.ExpandedImage = this.createImage(this.boxSize + 2, this.boxSize);
        Graphics graphics2 = this.ExpandedImage.getGraphics();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, this.boxSize + 2, this.boxSize);
        graphics2.setColor(PHDTreeNode.LineColour);
        if (this.ButtonShapeSquare) {
            graphics2.drawRect(0, 0, this.boxSize - 1, this.boxSize - 1);
        } else {
            graphics2.drawOval(0, 0, this.boxSize - 1, this.boxSize - 1);
        }
        graphics2.drawLine(this.boxSize + 1, n5, this.boxSize + 1, n5);
        graphics2.setColor(PHDTreeNode.ScribeColour);
        if (n4 < 1) {
            graphics2.drawLine(n6, n5, this.boxSize - n6 - 1, n5);
        } else {
            graphics2.fillRect(n6, n2, this.boxSize - n6 - n6, n4);
        }
        graphics2.dispose();
        this.CollapsedImage = this.createImage(this.boxSize + 2, this.boxSize);
        Graphics graphics3 = this.CollapsedImage.getGraphics();
        graphics3.drawImage(this.ExpandedImage, 0, 0, null);
        graphics3.setColor(PHDTreeNode.ScribeColour);
        if (n4 < 1) {
            graphics3.drawLine(n5, n6, n5, this.boxSize - n6 - 1);
        } else {
            graphics3.fillRect(n2, n6, n4, this.boxSize - n6 - n6);
        }
        graphics3.dispose();
    }

    void undrawTip() {
        if (this.prevTipNode == null) {
            return;
        }
        int n = this.tipRectLT.x;
        int n2 = this.tipRectLT.y;
        int n3 = this.tipRectBR.x - n;
        int n4 = this.tipRectBR.y - n2;
        Graphics graphics = this.getTranslatedGraphics();
        if (graphics == null) {
            return;
        }
        this.prevTipNode.undrawTipIndicator(graphics);
        this.prevTipNode = null;
        graphics.translate(this.firstX, this.firstLine * this.lineHeight);
        graphics.clipRect(n - this.firstX, n2 - this.firstLine * this.lineHeight, n3, n4);
        this.paint(graphics);
        graphics.dispose();
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            if (this.checkHeight(image.getHeight(null))) {
                this.laidout = false;
                this.repaint();
            }
            return false;
        }
        return true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void SetRootTip(String string) {
        this.root.Tip = string;
        if (string != null) {
            this.NoTips = false;
        }
    }

    public void setColours(Color color, Color color2) {
        this.selectedColour = color;
        this.tipBgColour = color2;
    }

    public void doubleClick(PHDTreeNode pHDTreeNode) {
    }

    private boolean MadeVisible(PHDTreeNode pHDTreeNode) {
        if (!this.laidout) {
            return true;
        }
        int n = pHDTreeNode.bottomY - this.firstLine * this.lineHeight;
        if (n - this.lineHeight < 0) {
            this.firstLine = pHDTreeNode.bottomY / this.lineHeight - 1;
            return true;
        }
        if (n > this.UsableHeight) {
            this.firstLine = pHDTreeNode.bottomY / this.lineHeight - 1;
            this.firstLine -= this.linesOnPanel - 1;
            if (this.firstLine < 0) {
                this.firstLine = 0;
            }
            return true;
        }
        return false;
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.SetScrollbars();
    }

    public boolean keyDown(Event event, int n) {
        if (this.selectedNode != null) {
            int n2;
            if (n != 1008 && n != 32) {
                this.stopTip();
            }
            if ((n2 = this.linesOnPanel - 1) < 1) {
                n2 = 1;
            }
            switch (n) {
                case 1004: {
                    if (event.shiftDown()) {
                        this.moveBough(true);
                        return true;
                    }
                    this.moveSelection(-1);
                    break;
                }
                case 1005: {
                    if (event.shiftDown()) {
                        this.moveBough(false);
                        return true;
                    }
                    this.moveSelection(1);
                    break;
                }
                case 1002: {
                    this.moveSelection(-n2);
                    break;
                }
                case 1003: {
                    this.moveSelection(n2);
                    break;
                }
                case 1006: {
                    if (this.selectedNode.hasKids && this.selectedNode.expanded) {
                        this.selectedNode.expand(false);
                        break;
                    }
                    PHDTreeNode pHDTreeNode = this.selectedNode.parent;
                    if (pHDTreeNode == null) break;
                    this.select(pHDTreeNode, true);
                    break;
                }
                case 1007: {
                    if (!this.selectedNode.hasKids) break;
                    if (this.selectedNode.expanded) {
                        this.select(this.selectedNode.childN(1), true);
                        break;
                    }
                    this.selectedNode.expand(true);
                    break;
                }
                case 1000: {
                    this.select(this.getRoot(), true);
                    break;
                }
                case 1001: {
                    this.select(this.getRoot().lastVisibleDescendant(), true);
                    break;
                }
                case 45: {
                    if (!this.selectedNode.hasKids || !this.selectedNode.expanded) break;
                    this.selectedNode.expand(false);
                    break;
                }
                case 43: {
                    if (!this.selectedNode.hasKids || this.selectedNode.expanded) break;
                    this.selectedNode.expand(true);
                    break;
                }
                case 42: {
                    this.selectedNode.expandAll();
                    break;
                }
                case 10: 
                case 13: {
                    this.doubleClick(this.selectedNode);
                    break;
                }
                case 9: {
                    if (this.NextTab == null) break;
                    this.NextTab.requestFocus();
                    break;
                }
                case 32: 
                case 1008: {
                    if (this.tipNode == null) {
                        this.tipNode = this.selectedNode;
                        this.selectedNode.drawTip(null);
                        break;
                    }
                    this.stopTip();
                    break;
                }
                default: {
                    this.moveToKey(n);
                }
            }
        }
        return super.keyDown(event, n);
    }

    public static String Version() {
        return _Version;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        this.stopTip();
        return true;
    }

    void LayoutTree(Graphics graphics) {
        int n;
        if (!this.lineHeightSet) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            this.fontHeight = fontMetrics.getHeight() - fontMetrics.getLeading();
            this.fontDescent = fontMetrics.getDescent();
            n = this.fontHeight + 2;
            if (n < 7) {
                n = 7;
            }
            if (n > this.lineHeight) {
                this.lineHeight = n;
            }
            this.lineHeightSet = true;
        }
        this.BuildCollapsedExpandedImages(graphics);
        int n2 = this.lines;
        n = this.maxWidth;
        this.lines = 0;
        this.maxWidth = 0;
        this.getRoot().LayoutTree(graphics, 2, this.lineHeight);
        if (n2 != this.lines || n != this.maxWidth) {
            this.SetScrollbars();
        }
        this.laidout = true;
    }

    public void setInTree(PHDTreeNode pHDTreeNode, Image image) {
        pHDTreeNode.ourPanel = this;
        if (pHDTreeNode.parent == null && pHDTreeNode != this.getRoot()) {
            pHDTreeNode.parent = this.getRoot();
        }
        if (pHDTreeNode.Tip != null) {
            this.NoTips = false;
        }
        pHDTreeNode.Icon = image;
        this.laidout = false;
        if (this.isEnabled()) {
            this.repaint();
        }
    }

    public PHDTreePanel(Font font, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.lineFont = font;
        this.rootFont = font;
        this.vbarWanted = bl;
        this.sort = bl3;
        this.ButtonShapeSquare = bl4;
        this.isJDK11plus = bl5;
        if (!this.lineFont.isBold()) {
            this.rootFont = new Font(this.lineFont.getName(), this.lineFont.getStyle() | 1, this.lineFont.getSize());
            if (this.rootFont == null) {
                this.rootFont = this.lineFont;
            }
        }
        this.linefontsize = this.lineFont.getSize();
        this.setFont(this.rootFont);
        this.setLayout(new BorderLayout());
        if (this.vbarWanted) {
            this.vbar = new Scrollbar(1);
        }
        this.vbarVisible = false;
        this.selectedNode = this.root = new PHDTreeNode(0, null, "root", null, null, -1, null);
        this.root.selected = true;
    }

    public synchronized void paint(Graphics graphics) {
        if (!this.isEnabled()) {
            return;
        }
        graphics.setFont(this.rootFont);
        if (!this.laidout) {
            this.LayoutTree(graphics);
            this.justSelPaint = false;
        }
        if (this.linesOnPanel < 0) {
            this.SetScrollbars();
        }
        this.getForeground();
        Color color = this.getBackground();
        Rectangle rectangle = graphics.getClipRect();
        if (rectangle == null) {
            return;
        }
        if (rectangle.y + rectangle.height > this.UsableHeight) {
            rectangle.height = this.UsableHeight - rectangle.y;
        }
        if (rectangle.x + rectangle.width > this.UsableWidth) {
            rectangle.width = this.UsableWidth - rectangle.x;
        }
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (!this.justSelPaint) {
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.translate(-this.firstX, -this.firstLine * this.lineHeight);
        this.linesToShow = this.linesOnPanel;
        if (this.firstLine + this.linesToShow > this.lines) {
            this.linesToShow = this.lines - this.firstLine;
        }
        this.firstPaintLine = this.firstLine + rectangle.y / this.lineHeight;
        int n = rectangle.height / this.lineHeight + 2;
        if (n < this.linesToShow) {
            this.linesToShow = n;
        }
        this.paintLine = 0;
        this.getRoot().paint(graphics);
        if (this.tipNode != null) {
            this.tipNode.drawTip(graphics);
        }
        this.justSelPaint = false;
    }

    public PHDTreeNode getRoot() {
        return this.root;
    }

    public void setRoot(PHDTreeNode pHDTreeNode) {
        this.root = pHDTreeNode;
    }

    private void moveBough(boolean bl) {
        if (this.selectedNode == null) {
            return;
        }
        boolean bl2 = this.selectedNode.parent == null;
        PHDTreeNode pHDTreeNode = this.selectedNode;
        if (!bl2) {
            while (pHDTreeNode.parent != this.getRoot()) {
                pHDTreeNode = pHDTreeNode.parent;
            }
        }
        int n = this.getRoot().numKids();
        int n2 = pHDTreeNode.childNo;
        if (bl) {
            if (bl2) {
                if (n == 0) {
                    return;
                }
                pHDTreeNode = this.getRoot().childN(n);
            } else {
                pHDTreeNode = n2 == 1 ? this.getRoot() : this.getRoot().childN(n2 - 1);
            }
        } else if (bl2) {
            if (n == 0) {
                return;
            }
            pHDTreeNode = this.getRoot().childN(1);
        } else {
            pHDTreeNode = n2 == n ? this.getRoot() : this.getRoot().childN(n2 + 1);
        }
        this.select(pHDTreeNode, true);
        int n3 = 1;
        while (n3 <= n) {
            this.getRoot().childN(n3).expand(false);
            ++n3;
        }
        pHDTreeNode.expand(true);
    }

    synchronized void stopTip() {
        if (this.tipThread != null) {
            this.tipThread.stop();
            this.tipThread = null;
        }
        this.tipNode = null;
        this.undrawTip();
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.stopTip();
        if (n >= this.UsableWidth || n2 >= this.UsableHeight) {
            return super.mouseDown(event, n, n2);
        }
        int n3 = n + this.firstX;
        int n4 = n2 + this.firstLine * this.lineHeight;
        if (this.getRoot().processClick(n3, n4, event.clickCount)) {
            this.requestFocus();
            return true;
        }
        boolean bl = super.mouseDown(event, n, n2);
        this.requestFocus();
        return bl;
    }

    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(333L);
        }
        catch (InterruptedException interruptedException) {}
        if (this.tipNode != null) {
            this.tipNode.drawTip(null);
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            try {
                Thread.currentThread();
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        PHDTreePanel pHDTreePanel = this;
        synchronized (pHDTreePanel) {
            this.tipNode = null;
            this.undrawTip();
            this.tipThread = null;
            Object var3_3 = null;
            return;
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                int n = this.firstLine;
                int n2 = this.firstX;
                if (this.vbarVisible) {
                    this.firstLine = this.vbar.getValue();
                    if (this.isJDK11plus) {
                        this.vbar.setValues(this.firstLine, this.linesOnPanel, 0, this.lines);
                    } else {
                        this.vbar.setValues(this.firstLine, this.linesOnPanel - 1, 0, this.lines - this.linesOnPanel);
                    }
                }
                if (this.firstLine != n || this.firstX != n2) {
                    this.repaint();
                }
                this.requestFocus();
                break;
            }
            case 205: {
                this.SetScrollbars();
            }
        }
        return super.handleEvent(event);
    }

    private void moveToKey(int n) {
        PHDTreeNode pHDTreeNode;
        if (n <= 32 || n >= 127 || this.selectedNode == null) {
            return;
        }
        n = Character.toLowerCase((char)n);
        PHDTreeNode pHDTreeNode2 = this.selectedNode;
        PHDTreeNode pHDTreeNode3 = pHDTreeNode = this.selectedNode;
        while (true) {
            if (pHDTreeNode3 == (pHDTreeNode = pHDTreeNode.traverse(1, true))) {
                pHDTreeNode = this.getRoot();
            }
            if (pHDTreeNode2 == pHDTreeNode) {
                return;
            }
            String string = pHDTreeNode.Title;
            if (string != null && n == Character.toLowerCase(string.charAt(0))) break;
            pHDTreeNode3 = pHDTreeNode;
        }
        this.select(pHDTreeNode, true);
    }

    Graphics getTranslatedGraphics() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return null;
        }
        graphics.translate(-this.firstX, -this.firstLine * this.lineHeight);
        return graphics;
    }

    private void moveSelection(int n) {
        if (n == 0 || this.selectedNode == null) {
            return;
        }
        this.lowest = this.selectedNode;
        this.select(this.selectedNode.traverse(n, true), true);
    }
}

