/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class PHDTreeNode {
    static Color LineColour = Color.gray;
    static Color ScribeColour = Color.black;
    public transient int Number;
    public transient BaseURL BaseURL;
    public transient String url;
    public transient boolean urlHasAnchor;
    public transient short TargetNo;
    public transient String Title;
    public transient PHDTreeNode parent;
    public transient String IconURL;
    public transient String Tip;
    private transient Vector kids = new Vector();
    transient boolean hasKids;
    PHDTreePanel ourPanel;
    public Image Icon;
    private String lowerText;
    public int childNo = -1;
    private boolean isAbsolute;
    boolean expanded = true;
    boolean selected;
    private int leftX;
    private int selX;
    int bottomY;
    private int textX;
    private int textY;
    private int parentKidsY;
    private int boxY;
    private int TextWidth;
    int kidsY;
    private boolean usingRootFont;
    private static final short SHADOW_SIZE = 5;

    private boolean carefulKidCollapse() {
        boolean bl = this.selected;
        this.expanded = false;
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            PHDTreeNode pHDTreeNode = (PHDTreeNode)enumeration.nextElement();
            if (!pHDTreeNode.carefulKidCollapse()) continue;
            bl = true;
        }
        return bl;
    }

    PHDTreeNode childN(int n) {
        if (!this.hasKids || n <= 0 || n > this.kids.size()) {
            return null;
        }
        return (PHDTreeNode)this.kids.elementAt(n - 1);
    }

    boolean processClick(int n, int n2, int n3) {
        if (n2 < this.bottomY && n2 >= this.bottomY - this.ourPanel.lineHeight) {
            if (n >= this.selX) {
                boolean bl = this.selected;
                this.ourPanel.select(this, true);
                if (n3 == 2) {
                    this.ourPanel.doubleClick(this);
                } else if (this.hasKids && (bl || n < this.textX)) {
                    this.expand(!this.expanded);
                }
            } else if (this.hasKids && n >= this.leftX) {
                this.expand(!this.expanded);
            }
            return true;
        }
        if (this.hasKids && this.expanded) {
            Enumeration enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                PHDTreeNode pHDTreeNode = (PHDTreeNode)enumeration.nextElement();
                if (!pHDTreeNode.processClick(n, n2, n3)) continue;
                return true;
            }
        }
        return false;
    }

    void addToTree(PHDTreePanel pHDTreePanel, Image image) {
        this.ourPanel = pHDTreePanel;
        this.Icon = image;
        if (this.Icon == null && this.url != null) {
            this.isAbsolute = IndexFile.isAbsoluteURL(this.url);
        }
    }

    int LayoutTree(Graphics graphics, int n, int n2) {
        Object object;
        int n3;
        boolean bl = this.parent == null && this.hasKids && this.expanded;
        graphics.setFont(this.usingRootFont ? this.ourPanel.rootFont : this.ourPanel.lineFont);
        this.leftX = n;
        this.bottomY = n2;
        ++this.ourPanel.lines;
        int n4 = this.ourPanel.lineHeight;
        int n5 = n4 - 2;
        int n6 = this.ourPanel.fontDescent;
        int n7 = this.ourPanel.boxSize;
        this.textY = this.bottomY - n6 - (n5 - this.ourPanel.fontHeight) / 2;
        this.kidsY = this.textY + n6 + 2;
        this.boxY = this.textY - n7;
        this.parentKidsY = 0;
        if (this.parent != null) {
            this.parentKidsY = this.parent.kidsY;
            this.parent.kidsY = this.hasKids ? this.textY + 1 : this.boxY + n7 / 2;
        }
        this.selX = this.leftX;
        if (!bl) {
            this.selX += 5 + n7;
        }
        this.textX = this.selX;
        int n8 = -1;
        int n9 = -1;
        if (this.Icon == null) {
            if (this.ourPanel.IconSet != null) {
                n8 = this.ourPanel.IconSet.getWidth(this.ourPanel);
                n9 = this.ourPanel.IconSet.getHeight(this.ourPanel);
                if (n8 != -1) {
                    n8 /= 4;
                }
            }
        } else {
            n8 = this.Icon.getWidth(this.ourPanel);
            n9 = this.Icon.getHeight(this.ourPanel);
        }
        if (n8 != -1 && n9 != -1) {
            n3 = this.bottomY - (n5 + n9) / 2;
            if (n3 + n9 < this.textY) {
                n3 = this.textY - n9;
            }
            this.textX = this.selX + n8 + 4;
            if (n3 + n9 + 2 > this.kidsY) {
                this.kidsY = n3 + n9 + 2;
            }
        }
        n3 = this.textX;
        if (this.Title != null) {
            object = graphics.getFontMetrics();
            this.TextWidth = ((FontMetrics)object).stringWidth(this.Title);
            n3 += this.TextWidth + 2;
            if (this.textY + n6 + 1 > this.kidsY) {
                this.kidsY = this.textY + n6 + 1;
            }
        }
        if (n3 > this.ourPanel.maxWidth) {
            this.ourPanel.maxWidth = n3;
        }
        if (this.hasKids && this.expanded) {
            object = this.children();
            if (!bl) {
                n += n7;
            }
            while (object.hasMoreElements()) {
                PHDTreeNode pHDTreeNode = (PHDTreeNode)object.nextElement();
                n2 += this.ourPanel.lineHeight;
                n2 = pHDTreeNode.LayoutTree(graphics, n, n2);
            }
        }
        return n2;
    }

    PHDTreeNode(int n, BaseURL baseURL, String string, String string2, PHDTreeNode pHDTreeNode, short s, String string3) {
        this.Number = n;
        this.BaseURL = baseURL;
        this.Title = string;
        this.url = string2;
        if (this.url != null) {
            this.urlHasAnchor = this.url.lastIndexOf(35) != -1;
        }
        this.parent = pHDTreeNode;
        if (this.parent == null || this.parent.parent == null) {
            this.usingRootFont = true;
        }
        this.TargetNo = s;
        this.IconURL = string3;
    }

    void paint(Graphics graphics) {
        int n;
        boolean bl;
        graphics.setFont(this.usingRootFont ? this.ourPanel.rootFont : this.ourPanel.lineFont);
        boolean bl2 = this.parent == null && this.hasKids && this.expanded;
        int n2 = this.ourPanel.lineHeight;
        int n3 = this.ourPanel.boxSize;
        int n4 = n2 - 2;
        int n5 = this.ourPanel.fontHeight;
        boolean bl3 = false;
        if (this.parent != null) {
            bl3 = this.parent.parent == null;
        }
        int n6 = n3 / 2;
        boolean bl4 = bl = this.ourPanel.paintLine >= this.ourPanel.firstPaintLine && this.ourPanel.paintLine <= this.ourPanel.firstPaintLine + this.ourPanel.linesToShow;
        if (this.ourPanel.justSelPaint) {
            bl = this == this.ourPanel.prevSelNode || this == this.ourPanel.selectedNode;
        }
        graphics.setColor(LineColour);
        int n7 = this.leftX + n6;
        if (!bl2) {
            if (this.hasKids) {
                if (this.parentKidsY != 0) {
                    graphics.drawLine(n7, this.parentKidsY, n7, this.boxY - 2);
                    if (bl3) {
                        graphics.drawLine(n7 + 1, this.parentKidsY, n7 + 1, this.boxY - 2);
                    }
                }
                if (bl) {
                    graphics.drawImage(this.expanded ? this.ourPanel.ExpandedImage : this.ourPanel.CollapsedImage, this.leftX, this.boxY, null);
                }
            } else {
                n = this.parentKidsY != 0 ? this.parentKidsY : this.bottomY - n2;
                graphics.drawLine(n7, n, n7, this.boxY + n6);
                if (bl3) {
                    graphics.drawLine(n7 + 1, n, n7 + 1, this.boxY + n6);
                }
                if (bl) {
                    graphics.drawLine(n7, this.boxY + n6, this.leftX + n3 + 1, this.boxY + n6);
                }
            }
        }
        if (bl) {
            int n8;
            int n9;
            if (this.Icon == null) {
                if (this.ourPanel.IconSet != null) {
                    n = this.ourPanel.IconSet.getWidth(this.ourPanel);
                    n9 = this.ourPanel.IconSet.getHeight(this.ourPanel);
                    if (n != -1 && n9 != -1) {
                        n /= 4;
                        this.ourPanel.checkHeight(n9);
                        n8 = this.bottomY - (n4 + n9) / 2;
                        if (n8 + n9 < this.textY) {
                            n8 = this.textY - n9;
                        }
                        int n10 = this.hasKids ? (this.expanded ? 1 : 0) : (this.isAbsolute ? 3 : 2);
                        Graphics graphics2 = this.ourPanel.getTranslatedGraphics();
                        graphics2.clipRect(this.selX, n8, n, n9);
                        graphics2.drawImage(this.ourPanel.IconSet, this.selX - n10 * n, n8, this.ourPanel);
                    } else {
                        graphics.drawImage(this.ourPanel.IconSet, this.selX, this.bottomY - n4, this.ourPanel);
                    }
                }
            } else {
                n = this.Icon.getWidth(this.ourPanel);
                n9 = this.Icon.getHeight(this.ourPanel);
                if (n != -1 && n9 != -1) {
                    this.ourPanel.checkHeight(n9);
                    n8 = this.bottomY - (n4 + n9) / 2;
                    if (n8 + n9 < this.textY) {
                        n8 = this.textY - n9;
                    }
                    graphics.drawImage(this.Icon, this.selX, n8, this.ourPanel);
                } else {
                    graphics.drawImage(this.Icon, this.selX, this.bottomY - n4, this.ourPanel);
                }
            }
            if (this.Title != null) {
                graphics.setColor(this.selected ? this.ourPanel.selectedColour : this.ourPanel.getBackground());
                n = this.textY - n5 + this.ourPanel.fontDescent;
                graphics.fillRect(this.textX - 2, n, this.TextWidth + 3, n5);
                graphics.drawRect(this.textX - 2, n, this.TextWidth + 3, this.ourPanel.fontHeight);
                graphics.setColor(this.ourPanel.getForeground());
                graphics.drawString(this.Title, this.textX, this.textY);
            }
        }
        ++this.ourPanel.paintLine;
        if (this.hasKids && this.expanded) {
            Enumeration enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                PHDTreeNode pHDTreeNode = (PHDTreeNode)enumeration.nextElement();
                pHDTreeNode.paint(graphics);
            }
        }
    }

    public void expand(boolean bl) {
        boolean bl2 = this.expanded;
        this.expanded = bl;
        if (this.hasKids && bl2 != this.expanded) {
            if (bl2 && this.carefulKidCollapse()) {
                this.ourPanel.select(this, true);
            }
            if (this.ourPanel.laidout) {
                int n = this.ourPanel.lineHeight;
                int n2 = this.bottomY - n;
                if ((n2 -= this.ourPanel.firstLine * n) < 0) {
                    n2 = 0;
                }
                this.ourPanel.repaint(0, n2, this.ourPanel.UsableWidth, this.ourPanel.UsableHeight - n2);
            } else {
                this.ourPanel.repaint();
            }
            this.ourPanel.laidout = false;
            this.ourPanel.justSelPaint = false;
        }
    }

    PHDTreeNode lastVisibleDescendant() {
        if (this.hasKids && this.expanded) {
            PHDTreeNode pHDTreeNode = (PHDTreeNode)this.kids.elementAt(this.kids.size() - 1);
            return pHDTreeNode.lastVisibleDescendant();
        }
        return this;
    }

    boolean processMove(int n, int n2) {
        block9: {
            block11: {
                block10: {
                    if (n2 >= this.bottomY || n2 < this.bottomY - this.ourPanel.lineHeight) break block9;
                    if (n < this.selX || this.Tip == null) break block10;
                    PHDTreePanel pHDTreePanel = this.ourPanel;
                    synchronized (pHDTreePanel) {
                        block8: {
                            if (this.ourPanel.tipNode == null) {
                                this.ourPanel.tipNode = this;
                                if (this.ourPanel.tipThread == null) {
                                    this.ourPanel.tipThread = new Thread(this.ourPanel);
                                    this.ourPanel.tipThread.start();
                                }
                                break block8;
                            }
                            if (this.ourPanel.tipNode == this) break block8;
                            if (this.ourPanel.tipThread != null) {
                                this.ourPanel.tipThread.interrupt();
                            }
                            this.ourPanel.tipNode = this;
                            this.drawTip(null);
                        }
                        Object var6_4 = null;
                        break block11;
                    }
                }
                this.ourPanel.stopTip();
            }
            return true;
        }
        if (this.hasKids && this.expanded) {
            Enumeration enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                PHDTreeNode pHDTreeNode = (PHDTreeNode)enumeration.nextElement();
                if (!pHDTreeNode.processMove(n, n2)) continue;
                return true;
            }
        }
        return false;
    }

    int addChildrenAfter(PHDTreeNode pHDTreeNode, int n, boolean bl) {
        int n2 = pHDTreeNode.numKids();
        int n3 = 0;
        while (n3 < n2) {
            PHDTreeNode pHDTreeNode2 = (PHDTreeNode)pHDTreeNode.kids.elementAt(n3);
            pHDTreeNode2.parent = this;
            this.addChildAfter(pHDTreeNode2, n++, bl);
            ++n3;
        }
        return n2;
    }

    public void expandAll() {
        if (this.hasKids) {
            this.expand(true);
            Enumeration enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                PHDTreeNode pHDTreeNode = (PHDTreeNode)enumeration.nextElement();
                pHDTreeNode.expandAll();
            }
        }
    }

    public void select(boolean bl) {
        this.ourPanel.select(this, bl);
    }

    PHDTreeNode traverse(int n, boolean bl) {
        if (n == 0) {
            return this;
        }
        PHDTreeNode pHDTreeNode = this.parent;
        if (n > 0) {
            if (this.hasKids && this.expanded && bl) {
                this.ourPanel.lowest = null;
                return this.childN(1).traverse(n - 1, true);
            }
            if (pHDTreeNode == null) {
                return this.ourPanel.lowest;
            }
            int n2 = pHDTreeNode.numKids();
            if (this.childNo < n2) {
                this.ourPanel.lowest = null;
                return pHDTreeNode.childN(this.childNo + 1).traverse(n - 1, true);
            }
            if (this.ourPanel.lowest == null) {
                this.ourPanel.lowest = this;
            }
            return pHDTreeNode.traverse(n, false);
        }
        if (pHDTreeNode == null) {
            return this;
        }
        if (this.childNo == 1) {
            return pHDTreeNode.traverse(n + 1, true);
        }
        PHDTreeNode pHDTreeNode2 = pHDTreeNode.childN(this.childNo - 1);
        return pHDTreeNode2.lastVisibleDescendant().traverse(n + 1, true);
    }

    int numKids() {
        if (this.hasKids) {
            return this.kids.size();
        }
        return 0;
    }

    synchronized Enumeration children() {
        return this.kids.elements();
    }

    void drawTip(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.ourPanel.undrawTip();
        if (this.Tip == null || !this.ourPanel.ShowTips) {
            return;
        }
        boolean bl = false;
        if (graphics == null) {
            graphics = this.ourPanel.getTranslatedGraphics();
            if (graphics == null) {
                return;
            }
            bl = true;
        }
        graphics.setFont(this.ourPanel.lineFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.ourPanel.linefontspacewidth == 0) {
            this.ourPanel.linefontspacewidth = fontMetrics.stringWidth(" ");
        }
        int n7 = this.ourPanel.UsableWidth - 5;
        int n8 = n7 / 3;
        int n9 = 2 * n7 / 3;
        boolean bl2 = true;
        if (this.textX + this.TextWidth < n9) {
            n8 = this.textX + this.TextWidth + 7;
            bl2 = false;
        }
        int n10 = n6 = n8;
        Vector<String> vector = new Vector<String>(this.ourPanel.lines);
        if (vector == null) {
            return;
        }
        String string = "";
        String string2 = " \t\n\r";
        StringTokenizer stringTokenizer = new StringTokenizer(this.Tip, string2, true);
        while (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.length() == 1 && string2.indexOf(n5 = string3.charAt(0)) != -1) {
                if (n5 != 13 && n5 != 10) continue;
                if (n6 > n10) {
                    n10 = n6;
                }
                vector.addElement(string);
                string = "";
                n6 = n8;
                continue;
            }
            n5 = fontMetrics.stringWidth(string3) + this.ourPanel.linefontspacewidth;
            if (n6 + n5 > n7 && n6 > n8) {
                if (n6 > n10) {
                    n10 = n6;
                }
                vector.addElement(string);
                string = "";
                n6 = n8;
            }
            string = string + string3 + " ";
            n6 += n5;
        }
        if (string.length() > 0) {
            if (n6 > n10) {
                n10 = n6;
            }
            vector.addElement(string);
        }
        if ((n10 -= this.ourPanel.linefontspacewidth) > n7) {
            if ((n8 = n7 - n10 + n8 - 5) < 2) {
                n8 = 2;
            } else {
                n10 = n7;
            }
        } else if (bl2 && this.textX + this.TextWidth + (n4 = n10 - n8) + 5 < n7) {
            n8 = this.textX + this.TextWidth + 5;
            n10 = n8 + n4;
        }
        int n11 = n3 = this.textY - this.ourPanel.fontHeight + this.ourPanel.fontDescent;
        n5 = 2 + vector.size() * this.ourPanel.linefontsize;
        int n12 = this.ourPanel.UsableHeight - 5;
        int n13 = n11 - this.ourPanel.firstLine * this.ourPanel.lineHeight;
        if (n13 + n5 > n12) {
            n2 = n13 + n5 - n12;
            n11 -= n2;
            if ((n13 -= n2) < 2) {
                n11 -= n13 - 2;
            }
        }
        if (this.Title != null && n8 > this.textX) {
            graphics.setColor(Color.lightGray);
            graphics.drawRect(this.textX - 2, n3, this.TextWidth + 3, this.ourPanel.fontHeight);
        }
        graphics.setColor(Color.gray);
        graphics.drawRect(n8 - 4, n11 - 1, 6 + n10 - n8, 3 + n5);
        graphics.setColor(this.ourPanel.tipBgColour);
        graphics.fillRect(n8 - 3, n11, 5 + n10 - n8, 2 + n5);
        graphics.setColor(this.ourPanel.getForeground());
        n2 = n11 + this.ourPanel.fontHeight - this.ourPanel.fontDescent;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            graphics.drawString(string4, n8, n2);
            n2 += this.ourPanel.linefontsize;
        }
        graphics.setColor(Color.black);
        int n14 = n11 + 2 + n5;
        int n15 = n10 - n8 + 6;
        int n16 = n8 - 3;
        int n17 = 0;
        while (n17 < n15) {
            n = n16 + n17;
            graphics.drawLine(n, n14, n + 5 - 1, n14 + 5 - 1);
            n17 += 2;
        }
        n17 = 4 + n5;
        n = n15 % 2 + n17 % 2;
        int n18 = n11 - 1;
        int n19 = n10 + 2;
        int n20 = n % 2;
        while (n20 < n17) {
            int n21 = n18 + n20;
            graphics.drawLine(n19, n21, n19 + 5 - 1, n21 + 5 - 1);
            n20 += 2;
        }
        graphics.setColor(Color.gray);
        graphics.drawRect(n8 - 4, n11 - 1, 6 + n10 - n8, 3 + n5);
        this.ourPanel.tipRectLT.x = n8 - 4;
        this.ourPanel.tipRectLT.y = n11 - 1;
        this.ourPanel.tipRectBR.x = n19 + 5;
        this.ourPanel.tipRectBR.y = n14 + 5;
        this.ourPanel.prevTipNode = this;
        if (bl) {
            graphics.dispose();
        }
    }

    void undrawTipIndicator(Graphics graphics) {
        int n = this.textY - this.ourPanel.fontHeight + this.ourPanel.fontDescent;
        graphics.setColor(this.selected ? this.ourPanel.selectedColour : this.ourPanel.getBackground());
        graphics.drawRect(this.textX - 2, n, this.TextWidth + 3, this.ourPanel.fontHeight);
    }

    void addChild(PHDTreeNode pHDTreeNode, boolean bl) {
        this.hasKids = true;
        int n = this.numKids();
        boolean bl2 = false;
        if (bl && this.hasKids && pHDTreeNode.Title != null) {
            String string = pHDTreeNode.lowerText;
            if (string == null) {
                pHDTreeNode.lowerText = string = pHDTreeNode.Title.toLowerCase();
            }
            int n2 = 1;
            while (n2 <= n) {
                PHDTreeNode pHDTreeNode2 = this.childN(n2);
                if (bl2) {
                    pHDTreeNode2.childNo = n2;
                } else {
                    if (pHDTreeNode2.Title == null) break;
                    String string2 = pHDTreeNode2.lowerText;
                    if (string2 == null) {
                        pHDTreeNode2.lowerText = string2 = pHDTreeNode2.Title.toLowerCase();
                    }
                    if (string.compareTo(string2) < 0) {
                        try {
                            this.kids.insertElementAt(pHDTreeNode, n2 - 1);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            break;
                        }
                        bl2 = true;
                        ++n;
                        pHDTreeNode.childNo = n2;
                    }
                }
                ++n2;
            }
        }
        if (!bl2) {
            this.kids.addElement(pHDTreeNode);
            pHDTreeNode.childNo = this.kids.size();
        }
    }

    int addChildAfter(PHDTreeNode pHDTreeNode, int n, boolean bl) {
        if (bl) {
            this.addChild(pHDTreeNode, bl);
        } else {
            int n2 = this.numKids();
            if (n < n2) {
                this.kids.insertElementAt(pHDTreeNode, n);
                pHDTreeNode.childNo = n + 1;
                ++n;
                ++n2;
                while (n < n2) {
                    PHDTreeNode pHDTreeNode2 = (PHDTreeNode)this.kids.elementAt(n);
                    pHDTreeNode2.childNo = n + 1;
                    ++n;
                }
            } else {
                this.addChild(pHDTreeNode, bl);
            }
        }
        return 1;
    }

    public String getURL() {
        if (this.url == null) {
            return null;
        }
        if (this.BaseURL == null) {
            return this.url;
        }
        return MainPanel.Normalise(this.BaseURL.Link + this.url);
    }

    public boolean hasKids() {
        return this.hasKids;
    }
}

