/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;

class PHDTab
extends Canvas {
    private static String _Version = "1.1.3";
    private static final int MAX_TABS = 10;
    private static final int X_OFFSET = 4;
    private Font unselFont;
    private Font selFont;
    private int fontHeight;
    private int fontDescent;
    private Image IconSet;
    private int IconSetWidth;
    private Panel cardPanel;
    private CardLayout cardLayout;
    private Color CardBgColour;
    private String preText;
    private Font preFont;
    private Color preColour;
    private boolean sized;
    private boolean justSelChanged;
    private boolean justTipChanged;
    private boolean forcePaintAll;
    private int cardCount;
    private String[] cardNames = new String[10];
    private Image[] icons = new Image[10];
    private Component[] cardComponent = new Component[10];
    private int[] IconX = new int[11];
    private int[] NameX = new int[10];
    private int[] textWidth = new int[10];
    private int[] IconSetNo = new int[10];
    private int textY;
    private int OurHeight;
    private int OurWidth;
    private boolean showText = true;
    private int tipX;
    private int tipCardNo = -1;
    private int preferredWidth;
    private int selNo = -1;
    private int prevSelNo = -1;
    private boolean highlighted;
    private Color FgColour;
    private Color BgColour;
    private Color tabLineColour;
    private Color highlightColour;
    private Color baseColour = Color.gray;
    private Color uprightColour = Color.black;

    public boolean keyDown(Event event, int n) {
        switch (n) {
            case 1006: {
                this.highlighted = true;
                if (this.selNo <= 0) break;
                this.select(this.selNo - 1);
                break;
            }
            case 1007: {
                this.highlighted = true;
                if (this.selNo >= this.cardCount - 1) break;
                this.select(this.selNo + 1);
                break;
            }
            case 1000: {
                this.highlighted = true;
                this.select(0);
                break;
            }
            case 1001: {
                this.highlighted = true;
                this.select(this.cardCount - 1);
                break;
            }
            case 9: {
                this.highlighted = false;
                this.justSelChanged = true;
                this.repaint();
                this.cardComponent[this.selNo].requestFocus();
            }
        }
        return super.keyDown(event, n);
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        this.sized = false;
        super.reshape(n, n2, n3, n4);
    }

    public void requestFocus() {
        this.highlighted = true;
        this.justSelChanged = true;
        this.repaint();
        super.requestFocus();
    }

    public boolean lostFocus(Event event, Object object) {
        this.highlighted = false;
        this.justSelChanged = true;
        this.repaint();
        return super.lostFocus(event, object);
    }

    public static String Version() {
        return _Version;
    }

    private boolean sizeCards(Graphics graphics, boolean bl) {
        FontMetrics fontMetrics;
        if (this.cardCount == 0) {
            return true;
        }
        this.FgColour = this.getForeground();
        this.BgColour = this.getBackground();
        this.tabLineColour = this.FgColour;
        if (this.tabLineColour.equals(Color.gray) || this.tabLineColour.equals(Color.lightGray) || this.tabLineColour.equals(Color.black)) {
            this.tabLineColour = Color.blue;
        }
        this.highlightColour = new Color(255 - this.CardBgColour.getRed(), 255 - this.CardBgColour.getGreen(), 255 - this.CardBgColour.getBlue());
        this.showText = bl;
        if (this.textY == 0) {
            this.preferredSize();
        }
        int n = 8;
        if (this.preText != null) {
            graphics.setFont(this.preFont);
            fontMetrics = graphics.getFontMetrics();
            n += fontMetrics.stringWidth(this.preText) + 8;
        }
        graphics.setFont(this.selFont);
        fontMetrics = graphics.getFontMetrics();
        this.fontHeight = fontMetrics.getHeight();
        this.fontDescent = fontMetrics.getDescent();
        int n2 = 0;
        while (n2 < this.cardCount) {
            int n3;
            this.IconX[n2] = n;
            Image image = this.icons[n2];
            int n4 = this.IconSetNo[n2];
            if (n4 != 0) {
                n += this.IconSetWidth;
            } else if (image != null && (n3 = image.getWidth(this)) != -1) {
                n += n3;
            }
            this.NameX[n2] = ++n;
            String string = this.cardNames[n2];
            int n5 = 0;
            if (this.showText) {
                n5 = fontMetrics.stringWidth(string);
            } else if (n4 == 0 && image == null) {
                string = string.substring(0, 3);
                n5 = fontMetrics.stringWidth(string);
            }
            this.textWidth[n2] = n5;
            n += n5 + 8;
            ++n2;
        }
        this.IconX[n2] = n;
        if (this.showText) {
            this.preferredWidth = n;
            if (n > this.OurWidth) {
                this.sizeCards(graphics, false);
            } else {
                this.tipX = 0;
            }
        } else {
            this.tipX = n;
            this.tipCardNo = -1;
        }
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this.tipCardNo != -1) {
            this.tipCardNo = -1;
            this.justTipChanged = true;
            this.repaint();
        }
        return super.mouseExit(event, n, n2);
    }

    public PHDTab(Font font, Panel panel, CardLayout cardLayout, Color color) {
        this.unselFont = new Font(font.getName(), 0, font.getSize());
        this.selFont = new Font(font.getName(), 1, font.getSize());
        this.cardLayout = cardLayout;
        this.cardPanel = panel;
        this.CardBgColour = color;
        this.forcePaintAll = true;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        this.OurHeight = dimension.height;
        this.OurWidth = dimension.width;
        if (!this.sized) {
            this.sizeCards(graphics, true);
            this.sized = true;
        }
        if (this.forcePaintAll) {
            this.justSelChanged = false;
            this.justTipChanged = false;
        }
        int n = this.OurHeight - 1;
        int n2 = 0;
        if (this.justTipChanged && this.tipX != 0) {
            graphics.setColor(this.BgColour);
            graphics.fillRect(this.tipX, 0, this.OurWidth - 1, n - 1);
            if (this.tipCardNo >= 0) {
                String string = this.cardNames[this.tipCardNo];
                graphics.setFont(this.unselFont);
                graphics.setColor(this.tabLineColour);
                graphics.drawString(string, this.tipX, this.textY);
            }
            this.justTipChanged = false;
            return;
        }
        if (!this.justSelChanged) {
            graphics.setColor(this.BgColour);
            Rectangle rectangle = graphics.getClipRect();
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.preText != null) {
                graphics.setFont(this.preFont);
                graphics.setColor(this.preColour);
                graphics.drawString(this.preText, 4, this.textY);
            }
        }
        int n3 = 0;
        while (n3 < this.cardCount) {
            boolean bl = n3 == this.selNo;
            graphics.setColor(this.tabLineColour);
            int n4 = this.IconX[n3] - 4;
            int n5 = this.IconX[n3 + 1] - 4;
            if (bl) {
                graphics.drawLine(n2, n, n4, n);
                graphics.setColor(this.baseColour);
                graphics.drawLine(n2, n - 1, n4, n - 1);
                graphics.setColor(this.CardBgColour);
                graphics.drawLine(this.IconX[n3] - 4, n, n5, n);
                graphics.drawLine(this.IconX[n3] - 4, n - 1, n5, n - 1);
            } else {
                graphics.drawLine(n2, n, n5, n);
                graphics.setColor(this.baseColour);
                graphics.drawLine(n2, n - 1, n5, n - 1);
            }
            int n6 = this.textY - this.fontHeight + this.fontDescent - 3;
            int n7 = bl ? n : n - 2;
            graphics.setColor(this.uprightColour);
            graphics.drawLine(n4, n7, n4, n6 + 1);
            graphics.setColor(this.tabLineColour);
            graphics.drawLine(n4 + 2, n6 - 1, n5 - 3, n6 - 1);
            graphics.drawLine(n5 - 2, n6, n5 - 2, n6);
            graphics.drawLine(n5 - 1, n6 + 1, n5 - 1, n7);
            graphics.setColor(this.baseColour);
            graphics.drawLine(n5 - 2, n6 + 1, n5 - 2, n7);
            graphics.drawLine(n4 + 1, n6, n5 - 3, n6);
            n2 = n5;
            if (this.justSelChanged) {
                if (n3 == this.selNo || n3 == this.prevSelNo) {
                    this.paintTab(graphics, n3);
                }
            } else {
                this.paintTab(graphics, n3);
            }
            ++n3;
        }
        graphics.setColor(this.tabLineColour);
        graphics.drawLine(n2, n, this.OurWidth - 1, n);
        graphics.setColor(this.baseColour);
        graphics.drawLine(n2, n - 1, this.OurWidth - 1, n - 1);
        this.justSelChanged = false;
        this.forcePaintAll = false;
    }

    private int cardFromX(int n) {
        int n2 = 0;
        while (n2 < this.cardCount) {
            if (n >= this.IconX[n2] && n < this.IconX[n2 + 1]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void select(int n) {
        this.prevSelNo = this.selNo;
        this.selNo = n;
        String string = this.cardNames[this.selNo];
        this.cardLayout.show(this.cardPanel, string);
        this.postEvent(new Event(this, 1001, string));
        this.justSelChanged = true;
        this.repaint();
    }

    public void select(String string) {
        int n = 0;
        while (n < this.cardCount) {
            if (string.equals(this.cardNames[n])) {
                this.select(n);
                this.highlighted = false;
                this.cardComponent[n].requestFocus();
                return;
            }
            ++n;
        }
    }

    public void setTabImage(Image image, int n) {
        this.IconSet = image;
        this.IconSetWidth = n;
    }

    public synchronized void update(Graphics graphics) {
        this.paint(graphics);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.sized = false;
            this.justSelChanged = false;
            this.forcePaintAll = true;
            this.repaint();
            return false;
        }
        return true;
    }

    private void paintTab(Graphics graphics, int n) {
        int n2;
        boolean bl = n == this.selNo;
        int n3 = this.IconX[n];
        graphics.setColor(bl ? this.CardBgColour : this.BgColour);
        int n4 = this.IconX[n] - 4;
        int n5 = this.IconX[n + 1] - 4;
        int n6 = this.textY - this.fontHeight + this.fontDescent - 3;
        graphics.fillRect(n4 + 1, n6 + 1, n5 - n4 - 3, this.OurHeight - n6 - 3);
        Image image = this.icons[n];
        int n7 = this.IconSetNo[n];
        if (n7 != 0) {
            image = this.IconSet;
        }
        if (image != null) {
            int n8 = image.getWidth(this);
            n2 = image.getHeight(this);
            if (n8 != -1 && n2 != -1) {
                if (n7 != 0) {
                    Graphics graphics2 = this.getGraphics();
                    graphics2.clipRect(n3, this.textY - n2, this.IconSetWidth, n2);
                    graphics2.drawImage(image, n3 - (n7 - 1) * this.IconSetWidth, this.textY - n2, this);
                    graphics2.dispose();
                } else {
                    graphics.drawImage(image, n3, this.textY - n2, this);
                }
            } else {
                graphics.drawImage(image, n3, this.textY, this);
            }
        }
        graphics.setColor(this.tabLineColour);
        graphics.setFont(bl ? this.selFont : this.unselFont);
        String string = this.cardNames[n];
        if (!this.showText && image == null) {
            string = string.substring(0, 3);
        }
        if (this.showText || image == null) {
            graphics.setColor(this.FgColour);
            graphics.drawString(string, this.NameX[n], this.textY);
            if (this.highlighted && bl) {
                graphics.setColor(this.highlightColour);
                n2 = this.NameX[n] - n3 + this.textWidth[n] + 2;
                graphics.drawRect(n3 - 2, this.textY - this.fontHeight + this.fontDescent - 1, n2, this.fontHeight);
            }
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        int n3 = this.cardFromX(n);
        if (n3 != -1) {
            if (n3 == this.selNo) {
                this.requestFocus();
            } else {
                this.select(n3);
                if (!this.highlighted) {
                    this.cardComponent[n3].requestFocus();
                }
            }
            return true;
        }
        return super.mouseDown(event, n, n2);
    }

    public Dimension preferredSize() {
        int n;
        int n2 = this.unselFont.getSize();
        if (this.preText != null && (n = this.preFont.getSize()) > n2) {
            n2 = n;
        }
        this.textY = n2 * 3 / 2;
        n = n2 * 2;
        if (this.preferredWidth == 0) {
            this.preferredWidth = n;
        }
        return new Dimension(n, n);
    }

    public boolean addTab(String string, int n, Component component) {
        int n2 = this.cardCount;
        if (!this.addTab(string, null, component)) {
            return false;
        }
        if (this.IconSet != null) {
            this.IconSetNo[n2] = n;
        }
        return true;
    }

    public boolean addTab(String string, Image image, Component component) {
        if (this.cardCount == 10) {
            return false;
        }
        this.cardNames[this.cardCount] = string;
        this.icons[this.cardCount] = image;
        this.cardComponent[this.cardCount] = component;
        this.sized = false;
        this.IconSetNo[this.cardCount] = 0;
        if (++this.cardCount == 1) {
            this.selNo = 0;
        }
        return true;
    }

    public void setPreText(String string, Font font, Color color) {
        this.preText = string;
        this.preFont = font;
        this.preColour = color;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        int n3;
        if (this.tipX != 0 && (n3 = this.cardFromX(n)) != this.tipCardNo) {
            this.tipCardNo = n3;
            this.justTipChanged = true;
            this.repaint();
        }
        return super.mouseMove(event, n, n2);
    }
}

