/*
 * Decompiled with CFR 0.152.
 */
import java.util.NoSuchElementException;

public class PHDStringTokenizer {
    private static String _Version = "1.1";
    private int currentPosition;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean skipped;
    private boolean alwaysTrim;

    public static String Version() {
        return _Version;
    }

    public String nextToken() {
        this.skipDelimiter();
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int n = this.currentPosition;
        while (this.currentPosition < this.maxPosition && this.delimiters.indexOf(this.str.charAt(this.currentPosition)) < 0) {
            ++this.currentPosition;
        }
        this.skipped = false;
        String string = this.str.substring(n, this.currentPosition);
        if (this.alwaysTrim) {
            string = string.trim();
        }
        return string;
    }

    public PHDStringTokenizer(String string) {
        this(string, " \t\n\r", false);
    }

    public PHDStringTokenizer(String string, String string2) {
        this(string, string2, false);
    }

    public PHDStringTokenizer(String string, String string2, boolean bl) {
        this.str = string;
        this.delimiters = string2;
        this.alwaysTrim = bl;
        this.currentPosition = 0;
        this.maxPosition = this.str.length();
        this.skipped = true;
    }

    public boolean hasMoreTokens() {
        this.skipDelimiter();
        return this.currentPosition < this.maxPosition;
    }

    private void skipDelimiter() {
        if (!this.skipped && this.currentPosition < this.maxPosition && this.delimiters.indexOf(this.str.charAt(this.currentPosition)) >= 0) {
            ++this.currentPosition;
            this.skipped = true;
        }
    }
}

