/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;

class MainPanel
extends Panel {
    private hi hi;
    private boolean setUpComplete;
    private boolean toSetUpContents;
    private Color BgColour;
    private Color FgColour;
    private Color CardBgColour;
    private PHDTab tabs;
    private String ContentsCardName;
    private String IndexCardName;
    private String SelectCardName;
    private String AboutCardName;
    private ContentsPanel contentsPanel;
    private IndexPanel indexForm;
    private SelectPanel selectPanel;
    private AboutPanel aboutPanel;
    private Panel StatusPanel;
    private Button DisplayPageButton;
    private Button ExitButton;
    private Label Status;
    private String DisplayPageTarget;
    private Panel bucket;
    private Panel cards;
    private CardLayout cardLayout;
    private String URLtoDisplay;
    boolean selectingURL;
    IndexParam info;

    public MainPanel(hi hi2) {
        this.hi = hi2;
        this.setLayout(new BorderLayout());
        this.ContentsCardName = this.hi.LanguageString(3);
        this.IndexCardName = this.hi.LanguageString(4);
        this.SelectCardName = this.hi.LanguageString(5);
        this.AboutCardName = this.hi.LanguageString(6);
    }

    public void setQuery(String string) {
        if (!this.setUpComplete) {
            return;
        }
        if (this.indexForm != null) {
            this.indexForm.setQuery(string);
        }
    }

    public void clearStatus() {
        this.setStatus("", null, null);
    }

    static String Normalise(String string) {
        int n;
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        while ((n = string.indexOf("/./")) != -1) {
            string = string.substring(0, n) + string.substring(n + 2);
        }
        while ((n = string.indexOf("/../")) != -1) {
            String string2 = string.substring(0, n);
            int n2 = string2.lastIndexOf(47);
            int n3 = string2.lastIndexOf(58);
            if (n2 == -1 && n3 == -1) {
                if (n == 2 && string.startsWith("..")) break;
                string = string.substring(n + 4);
                continue;
            }
            if (n2 != -1 && n3 != -1) {
                if (n3 > n2) {
                    n2 = n3;
                }
            } else if (n3 != -1) {
                n2 = n3;
            }
            string = string.substring(0, n2 + 1) + string.substring(n + 4);
        }
        return string;
    }

    private void setTree(PHDTreeNode pHDTreeNode) {
        int n;
        Image image = null;
        if (pHDTreeNode.IconURL != null) {
            image = this.hi.applet.getImage(this.hi.applet.getDocumentBase(), pHDTreeNode.IconURL);
        }
        this.contentsPanel.setInTree(pHDTreeNode, image);
        pHDTreeNode.expand(this.hi.expandedOption);
        String string = pHDTreeNode.url;
        if (this.selectingURL && string != null) {
            Object object;
            n = string.equals(this.info.SelectURL) ? 1 : 0;
            if (n == 0 && pHDTreeNode.BaseURL != null && ((String)(object = MainPanel.Normalise(pHDTreeNode.BaseURL.Link + string))).equals(this.info.SelectURL)) {
                n = 1;
            }
            if (n != 0) {
                this.contentsPanel.initialSelectNode = pHDTreeNode;
                this.selectingURL = false;
                object = pHDTreeNode.parent;
                while (object != null) {
                    ((PHDTreeNode)object).expanded = true;
                    object = ((PHDTreeNode)object).parent;
                }
            }
        }
        n = pHDTreeNode.numKids();
        int n2 = 1;
        while (n2 <= n) {
            PHDTreeNode pHDTreeNode2 = pHDTreeNode.childN(n2);
            this.setTree(pHDTreeNode2);
            ++n2;
        }
    }

    public boolean SetUp() {
        Object object;
        boolean bl = this.hi.highMode;
        Font font = this.hi.formFont;
        this.BgColour = this.hi.BgColour;
        this.CardBgColour = this.hi.CardBgColour;
        this.FgColour = this.hi.FgColour;
        this.bucket = new BorderPanel(0, 1, 1, 1);
        this.bucket.setBackground(this.FgColour);
        this.bucket.setLayout(new BorderLayout());
        BorderPanel borderPanel = new BorderPanel(1, 0, 0, 0);
        borderPanel.setBackground(this.FgColour);
        borderPanel.setLayout(new BorderLayout());
        this.StatusPanel = new Panel();
        if (this.StatusPanel == null) {
            return false;
        }
        this.StatusPanel.setForeground(this.FgColour);
        this.StatusPanel.setBackground(this.CardBgColour);
        this.StatusPanel.setFont(font);
        this.StatusPanel.setLayout(new FlowLayout(0));
        if (this.hi.iconMode) {
            this.ExitButton = new Button(this.hi.LanguageString(7));
            this.StatusPanel.add(this.ExitButton);
        }
        this.DisplayPageButton = new Button(this.hi.LanguageString(8));
        this.DisplayPageButton.disable();
        this.StatusPanel.add(this.DisplayPageButton);
        this.Status = new Label(this.hi.LanguageString(15));
        this.StatusPanel.add(this.Status);
        borderPanel.add("Center", this.StatusPanel);
        this.bucket.add("South", borderPanel);
        this.cards = new Panel();
        if (this.cards == null) {
            return false;
        }
        this.cardLayout = new CardLayout();
        this.cards.setLayout(this.cardLayout);
        this.tabs = new PHDTab(font, this.cards, this.cardLayout, this.CardBgColour);
        if (this.tabs == null) {
            return false;
        }
        this.tabs.setBackground(this.BgColour);
        this.tabs.setForeground(this.FgColour);
        Color color = this.FgColour;
        if (this.BgColour != Color.red) {
            color = Color.red;
        }
        Font font2 = new Font("Helvetica", 1, font.getSize());
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        if (this.hi.heading.length() == 0) {
            panel.add("Center", this.tabs);
        } else if (bl) {
            object = new PHDLabel(this.hi.heading);
            ((Component)object).setForeground(color);
            ((Component)object).setBackground(this.BgColour);
            ((Component)object).setFont(font2);
            panel.add("North", (Component)object);
            panel.add("South", this.tabs);
        } else {
            this.tabs.setPreText(this.hi.heading, font2, color);
            panel.add("Center", this.tabs);
        }
        if (!this.hi.noContentsOption) {
            this.contentsPanel = new ContentsPanel(this.hi, font);
            this.contentsPanel.disable();
            this.contentsPanel.setBackground(this.CardBgColour);
            this.contentsPanel.setForeground(this.FgColour);
            this.contentsPanel.setColours(this.hi.SelectColour, this.hi.TipBgColour);
            this.contentsPanel.setNextTab(this.tabs);
            object = this.hi.applet.getImage(this.hi.applet.getCodeBase(), this.hi.contentsIconsUrl);
            this.contentsPanel.setIcons((Image)object);
        }
        if (!this.hi.noIndexOption) {
            this.indexForm = new IndexPanel(this.hi);
            if (this.indexForm == null || !this.indexForm.SetUpForm()) {
                this.indexForm = null;
                return false;
            }
            this.indexForm.setNextTab(this.tabs);
        }
        if (!this.hi.noSelectOption) {
            this.selectPanel = new SelectPanel(this.hi);
            this.selectPanel.setBackground(this.CardBgColour);
            this.selectPanel.setForeground(this.FgColour);
            this.selectPanel.setNextTab(this.tabs);
        }
        this.aboutPanel = new AboutPanel(this.hi);
        this.aboutPanel.setBackground(this.CardBgColour);
        this.aboutPanel.setForeground(this.FgColour);
        this.aboutPanel.setNextTab(this.tabs);
        if (!this.hi.noContentsOption) {
            this.cards.add(this.ContentsCardName, this.contentsPanel);
        }
        if (!this.hi.noIndexOption) {
            this.cards.add(this.IndexCardName, this.indexForm);
        }
        if (!this.hi.noSelectOption) {
            this.cards.add(this.SelectCardName, this.selectPanel);
        }
        this.cards.add(this.AboutCardName, this.aboutPanel);
        this.bucket.add("Center", this.cards);
        object = this.hi.applet.getImage(this.hi.applet.getCodeBase(), this.hi.tabIconsUrl);
        this.tabs.setTabImage((Image)object, 14);
        if (!this.hi.noContentsOption) {
            this.tabs.addTab(this.ContentsCardName, 1, (Component)this.contentsPanel);
        }
        if (!this.hi.noIndexOption) {
            this.tabs.addTab(this.IndexCardName, 2, (Component)this.indexForm);
        }
        if (!this.hi.noSelectOption) {
            this.tabs.addTab(this.SelectCardName, 3, (Component)this.selectPanel);
        }
        this.tabs.addTab(this.AboutCardName, 4, (Component)this.aboutPanel);
        this.add("North", panel);
        this.add("Center", this.bucket);
        MainPanel mainPanel = this;
        synchronized (mainPanel) {
            block22: {
                this.setUpComplete = true;
                if (!this.toSetUpContents) break block22;
                this.SetUpContents();
            }
            Object var9_9 = null;
        }
        return true;
    }

    public void start() {
        if (!this.setUpComplete) {
            return;
        }
        if (this.contentsPanel != null && !this.hi.indexOption) {
            this.tabs.select(this.ContentsCardName);
            return;
        }
        if (this.indexForm != null) {
            this.tabs.select(this.IndexCardName);
            this.indexForm.start();
        }
    }

    public void GotNewIndex() {
        if (!this.setUpComplete) {
            return;
        }
        if (this.indexForm != null) {
            this.indexForm.DoLookup();
        }
        MainPanel mainPanel = this;
        synchronized (mainPanel) {
            this.SetUpContents();
            Object var2_2 = null;
        }
        this.start();
    }

    public void setStatus(String string) {
        this.setStatus(string, null, null);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.tabs) {
            this.setStatus((String)object);
            return true;
        }
        if (event.target == this.DisplayPageButton) {
            if (this.URLtoDisplay != null) {
                this.hi.DisplayPage(this.URLtoDisplay, this.DisplayPageTarget);
            }
            return true;
        }
        if (event.target == this.ExitButton) {
            Frame frame = (Frame)this.getParent();
            frame.dispose();
            return true;
        }
        return super.action(event, object);
    }

    public void setStatus(String string, String string2, String string3) {
        if (!this.setUpComplete || this.Status == null) {
            return;
        }
        this.URLtoDisplay = string3 == null ? string : string3;
        Dimension dimension = this.Status.getParent().size();
        this.Status.resize(dimension);
        this.Status.setText(string);
        this.DisplayPageTarget = string2;
        this.DisplayPageButton.enable(this.DisplayPageTarget != null);
    }

    public void SetUpContents() {
        if (!this.setUpComplete) {
            this.toSetUpContents = true;
            return;
        }
        if (this.contentsPanel == null) {
            return;
        }
        this.contentsPanel.disable();
        IndexFile indexFile = this.hi.Indices;
        this.info = this.hi.indexParam;
        this.selectingURL = this.info.SelectURL != null;
        PHDTreeNode pHDTreeNode = indexFile.ContentsRoot;
        this.contentsPanel.setRoot(pHDTreeNode);
        pHDTreeNode.Title = indexFile.Description;
        if (pHDTreeNode.Title == null || pHDTreeNode.Title.length() == 0) {
            pHDTreeNode.Title = this.info.IndexURL;
        }
        this.contentsPanel.SetRootTip(indexFile.IndexFileTip);
        this.setTree(pHDTreeNode);
        pHDTreeNode.expand(true);
        pHDTreeNode.select(true);
        if (!this.selectingURL) {
            this.contentsPanel.setTipNode(pHDTreeNode);
        }
        this.contentsPanel.enable();
        this.contentsPanel.repaint();
    }
}

