/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.util.Vector;

class IndexPanel
extends Panel
implements Runnable {
    private hi hi;
    private boolean iconMode;
    private boolean highMode;
    private Color CardBgColour = Color.lightGray;
    private Color FgColour = Color.black;
    private Color FieldBgColour = Color.white;
    private Thread TaskThread;
    private String newQuery;
    private static final int ID_LABEL = 1;
    private static final int ID_QUERY = 2;
    private static final int ID_INDICES = 3;
    private static final int ID_URLS = 4;
    private GridBagForm ourGridBagForm;
    private TextField QueryField;
    private List IndicesList;
    private List UrlsList;
    private Vector indices = new Vector();
    private Vector indicesStart = new Vector();
    private Vector urls = new Vector();
    private boolean prevQuerySet;
    private String prevQuery = "";
    private boolean indicesHidden;

    public boolean SetUpForm() {
        Font font = this.hi.formFont;
        this.CardBgColour = this.hi.CardBgColour;
        this.FgColour = this.hi.FgColour;
        this.FieldBgColour = this.hi.FieldBgColour;
        try {
            this.setBackground(this.CardBgColour);
            this.ourGridBagForm = new GridBagForm();
            this.ourGridBagForm.init(this, this.CardBgColour, this.FgColour, font, 100, 100);
            this.ourGridBagForm.setInsets(5, 0, 0, 0);
            int n = 0;
            Label label = new Label(this.hi.LanguageString(0));
            label.setAlignment(2);
            if (this.highMode) {
                this.ourGridBagForm.setConstraints(0, ++n, 2, 1, 100, 0);
            } else {
                this.ourGridBagForm.setConstraints(0, ++n, 1, 1, 0, 0);
            }
            if (!this.ourGridBagForm.addComponent(label, 1, this.CardBgColour)) {
                return false;
            }
            this.QueryField = new TextField(40);
            this.ourGridBagForm.setInsets(5, 0, 0, 2);
            if (this.highMode) {
                this.ourGridBagForm.setConstraints(0, ++n, 2, 1, 100, 0);
            } else {
                this.ourGridBagForm.setConstraints(1, n, 2, 1, 100, 0);
            }
            if (!this.ourGridBagForm.addComponent(this.QueryField, 2, this.hi.LookForBgColor)) {
                return false;
            }
            this.ourGridBagForm.setInsets(0, 0, 0, 0);
            if (!this.highMode) {
                label = new Label("");
                this.ourGridBagForm.setConstraints(0, ++n, 1, 1, 0, 0);
                if (!this.ourGridBagForm.addComponent(label, 1, this.CardBgColour)) {
                    return false;
                }
            }
            label = new Label(this.hi.LanguageString(1));
            label.setAlignment(2);
            if (this.highMode) {
                this.ourGridBagForm.setConstraints(0, ++n, 2, 1, 100, 0);
            } else {
                this.ourGridBagForm.setConstraints(0, ++n, 1, 1, 0, 0);
            }
            if (!this.ourGridBagForm.addComponent(label, 1, this.CardBgColour)) {
                return false;
            }
            this.IndicesList = new List(this.hi.indexLines, false);
            this.ourGridBagForm.setInsets(0, 0, 0, 2);
            if (this.highMode) {
                this.ourGridBagForm.setConstraints(0, ++n, 2, this.hi.indexLines);
            } else {
                this.ourGridBagForm.setConstraints(1, n, 2, this.hi.indexLines);
            }
            if (!this.ourGridBagForm.addComponent(this.IndicesList, 3, this.FieldBgColour)) {
                return false;
            }
            this.ourGridBagForm.setInsets(5, 0, 0, 0);
            label = new Label(this.hi.LanguageString(2));
            label.setAlignment(2);
            n += this.hi.indexLines;
            if (this.highMode) {
                this.ourGridBagForm.setConstraints(0, n, 2, 1, 100, 0);
            } else {
                this.ourGridBagForm.setConstraints(0, n, 1, 1, 0, 0);
            }
            if (!this.ourGridBagForm.addComponent(label, 1, this.CardBgColour)) {
                return false;
            }
            this.ourGridBagForm.setInsets(5, 0, 2, 2);
            this.UrlsList = new List(this.hi.pageLines, false);
            if (this.highMode) {
                this.ourGridBagForm.setConstraints(0, ++n, 2, this.hi.pageLines);
            } else {
                this.ourGridBagForm.setConstraints(1, n, 2, this.hi.pageLines);
            }
            if (!this.ourGridBagForm.addComponent(this.UrlsList, 4, this.FieldBgColour)) {
                return false;
            }
            this.ourGridBagForm.start();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void requestFocus() {
        this.ourGridBagForm.requestFocus();
        this.PaintLink();
    }

    public void setNextTab(Component component) {
        this.ourGridBagForm.setNextTab(component);
    }

    public IndexPanel(hi hi2) {
        this.hi = hi2;
        this.iconMode = this.hi.iconMode;
        this.highMode = this.hi.highMode;
    }

    public void setQuery(String string) {
        this.QueryField.setText(string);
    }

    private void DisplaySelection() {
        int n = this.UrlsList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        IndexItem indexItem = (IndexItem)this.urls.elementAt(n);
        String string = indexItem.getURL();
        if (string != null && string.length() != 0) {
            this.hi.DisplayPage(string, this.hi.getTarget(indexItem.targetNo));
        }
    }

    private String JDK10ClearTopByte(String string) {
        String string2 = string;
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if ((c & 0xFF00) != 0) {
                char c2 = (char)(c & 0xFF);
                string2 = string2.substring(0, n2) + c2 + string2.substring(n2 + 1);
            }
            ++n2;
        }
        return string2;
    }

    public boolean keyUp(Event event, int n) {
        if (event.target instanceof TextField && event.target == this.QueryField) {
            this.DoLookup();
        }
        return false;
    }

    private void PaintLink() {
        int n = this.UrlsList.getSelectedIndex();
        if (n == -1) {
            if (this.isVisible()) {
                this.hi.ourMainPanel.clearStatus();
            }
            return;
        }
        IndexItem indexItem = (IndexItem)this.urls.elementAt(n);
        String string = indexItem.getURL();
        String string2 = indexItem.tn.Tip;
        if (!this.hi.ShowIndexTips || string2 == null) {
            string2 = string;
        } else {
            int n2 = string2.indexOf(10);
            if (n2 != -1) {
                string2 = string2.substring(0, n2);
            }
        }
        if (this.isVisible()) {
            if (string2 != null && string2.length() > 0) {
                this.hi.ourMainPanel.setStatus(string2, this.hi.getTarget(indexItem.targetNo), string);
                return;
            }
            this.hi.ourMainPanel.clearStatus();
        }
    }

    public void start() {
        if (this.QueryField.isShowing()) {
            this.QueryField.requestFocus();
            this.QueryField.selectAll();
        }
    }

    private void LookupIndices(String string) {
        Object object;
        do {
            object = this.bounds();
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        } while (object == null || ((Rectangle)object).width <= 0);
        this.IndicesList.hide();
        this.IndicesList.clear();
        this.indices.removeAllElements();
        this.indicesStart.removeAllElements();
        this.UrlsList.clear();
        this.urls.removeAllElements();
        object = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (string != null) {
            n3 = string.length();
        }
        if (n3 >= this.hi.minQueryLength) {
            this.hi.Indices.startEnumeration(string);
            while (this.hi.Indices.hasMoreElements()) {
                IndexItem indexItem = this.hi.Indices.nextElement();
                String string2 = indexItem.getKeyword();
                String string3 = indexItem.getKeywordLowerCase();
                ++n;
                this.indices.addElement(indexItem);
                if (object != null && ((String)object).equals(string3)) continue;
                if (this.hi.kwMaxResults > 0 && ++n2 > this.hi.kwMaxResults) {
                    --n;
                    this.IndicesList.addItem(" ... etc");
                    break;
                }
                object = string3;
                this.IndicesList.addItem(string2);
                this.indicesStart.addElement(new Integer(n - 1));
            }
            this.indicesStart.addElement(new Integer(n));
            if (this.indices.size() > 0) {
                this.IndicesList.select(0);
                this.IndicesList.makeVisible(0);
                this.LookupPages();
            }
            this.QueryField.requestFocus();
        }
        this.IndicesList.show();
        this.PaintLink();
    }

    private void LookupPages() {
        this.UrlsList.clear();
        this.urls.removeAllElements();
        int n = this.IndicesList.getSelectedIndex();
        if (n == -1 || this.hi.kwMaxResults > 0 && n >= this.hi.kwMaxResults) {
            return;
        }
        int n2 = (Integer)this.indicesStart.elementAt(n);
        int n3 = (Integer)this.indicesStart.elementAt(n + 1);
        int n4 = n2;
        while (n4 < n3) {
            IndexItem indexItem = (IndexItem)this.indices.elementAt(n4);
            String string = indexItem.getTitle();
            if (string != null && string.length() > 0) {
                this.UrlsList.addItem(string);
                this.urls.addElement(indexItem);
            }
            ++n4;
        }
        this.UrlsList.select(0);
        this.UrlsList.makeVisible(0);
        this.PaintLink();
    }

    public void DoLookup() {
        block8: {
            block7: {
                if (this.QueryField == null) {
                    return;
                }
                if (this.hi.ir != 2) break block7;
                this.newQuery = this.QueryField.getText();
                if (this.newQuery == null) {
                    this.newQuery = "";
                }
                if (!this.hi.isJDK11plus) {
                    this.newQuery = this.JDK10ClearTopByte(this.newQuery);
                }
                if (this.prevQuerySet && this.newQuery.equals(this.prevQuery)) break block8;
                IndexPanel indexPanel = this;
                synchronized (indexPanel) {
                    if (this.TaskThread != null) {
                        this.TaskThread.stop();
                    }
                    this.TaskThread = new Thread(this);
                    this.TaskThread.start();
                    Object var2_2 = null;
                }
                this.prevQuery = this.newQuery;
                this.prevQuerySet = true;
                return;
            }
            this.hi.applet.showStatus(this.hi.LanguageString(16));
        }
    }

    public void run() {
        if (this.QueryField == null) {
            return;
        }
        this.LookupIndices(this.newQuery);
        IndexPanel indexPanel = this;
        synchronized (indexPanel) {
            this.TaskThread = null;
            Object var2_2 = null;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 501: {
                if (event.clickCount <= 1) return super.handleEvent(event);
                switch (this.ourGridBagForm.getIdFromComponent(event.target)) {
                    case 4: {
                        this.DisplaySelection();
                        return super.handleEvent(event);
                    }
                    default: {
                        return super.handleEvent(event);
                    }
                }
            }
            case 701: {
                switch (this.ourGridBagForm.getIdFromComponent(event.target)) {
                    case 3: {
                        this.LookupPages();
                        return super.handleEvent(event);
                    }
                    case 4: {
                        this.PaintLink();
                        return super.handleEvent(event);
                    }
                    default: {
                        return super.handleEvent(event);
                    }
                }
            }
            case 1004: {
                this.ourGridBagForm.GotFocus(event.target);
            }
        }
        return super.handleEvent(event);
    }

    public boolean keyDown(Event event, int n) {
        if (event.key == 9) {
            this.ourGridBagForm.Tab(!event.shiftDown());
            return true;
        }
        if (event.key == 10 || event.key == 13) {
            this.DisplaySelection();
            return true;
        }
        if (event.key == 27) {
            this.setQuery(this.hi.indexParam.InitialQuery);
            this.DoLookup();
            this.QueryField.requestFocus();
            this.QueryField.selectAll();
            return true;
        }
        return false;
    }
}

