/*
 * Decompiled with CFR 0.152.
 */
package com.phdcc.lang;

import com.phdcc.find.VirtualDbFile;
import com.phdcc.util.PHDStringTokenizer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Properties;
import java.util.Vector;

public class Language {
    public static final String suppliedLanguageFileList = "com/phdcc/lang/findbg3.hil,com/phdcc/lang/findcs3.hil,com/phdcc/lang/findda3.hil,com/phdcc/lang/findde3.hil,com/phdcc/lang/findet3.hil,com/phdcc/lang/findes3.hil,com/phdcc/lang/findel3.hil,com/phdcc/lang/findfr3.hil,com/phdcc/lang/findhr3.hil,com/phdcc/lang/findit3.hil,com/phdcc/lang/findhu3.hil,com/phdcc/lang/findlv3.hil,com/phdcc/lang/findlt3.hil,com/phdcc/lang/findmt3.hil,com/phdcc/lang/findnl3.hil,com/phdcc/lang/findno3.hil,com/phdcc/lang/findpl3.hil,com/phdcc/lang/findpt3.hil,com/phdcc/lang/findro3.hil,com/phdcc/lang/findsk3.hil,com/phdcc/lang/findsl3.hil,com/phdcc/lang/findfi3.hil,com/phdcc/lang/findsv3.hil,com/phdcc/lang/findar3.hil,com/phdcc/lang/findja3.hil,com/phdcc/lang/findth3.hil,com/phdcc/lang/findzh3.hil,com/phdcc/lang/findzhtw3.hil";
    public String languageName;
    public String languageNameInEnglish;
    public String languageCode;
    public String countryCode;
    public String allCountryCodes;
    public Vector countryCodes = new Vector();
    private String[] LanguageStrings = new String[104];
    private static final String English = "1\nEnglish\nEnglish\nSearch\nStop\nHelp\n.\n.\n.\nReading \nDescription: \nContains: \n pages and \n words.\nCreated: \nFile: \nUser locale: \nSite: \n.\n.\nEnter your search text in the box above and click on Search.\n<b>FindinSite-CD</b> finds pages that contain all the words in your search text anywhere on the page.\n.\nUse double quotes <b>\"&nbsp;\"</b> to find adjacent words.\nUse single quotes <b>'&nbsp;'</b> to find matching capital letters.\n.\nThe search database files could not be read.\nTo view a page in the results list, click on its title.\n.\n.\nNothing to search for\nSearch aborted\n page\n found\nSorry, adjacent word searches are not supported by this search database\nSorry, your search text has mismatched double-quotes\n.\n.\n.\n.\nThese words were found, but not in this order:&nbsp;\n pages\n.\n.\n.\nUse <b>?</b> to match exactly one character and <b>*</b> to match any number of characters.\n.\n.\n.\n.\nLanguage:\nSorry, your search text has mismatched parentheses ( and )\nUse <b>\n</b> and parentheses <b>(</b> <b>)</b> to do logical searches.\nSelect language:\nShowing\nThese words were not found in any pages:\nParentheses not allowed within \"double quotes\"\n in incorrect place\n* and ? not allowed within 'single quotes'\nAND\nOR\nNOT\n.\n* not allowed within \"double quotes\"\nRules:\nSubsets\nChoose subsets to include in search:\n.\ndatabases\nLanguages\nIndexes\nSelect index:\nIndex:\nNo subsets are selected.\n:\n.\n.\n.\nFindinSite-JS\n<b>find</b>in<b>site</b>\nsearch engine\n<b>FindinSite-JS</b> finds pages that contain all the words in your search text anywhere on the page.\nSearch for: \nSearch results for: \nPrevious\nNext\nFindinSite-JS Error\nFindinSite-JS Results\nIgnored common words: \n.\n.\nSearch database loading... please try again soon.\nSearch timed out.\nFirst\nLast\nof\nResults\n.\nseconds\n.\n.\n.\nSelect all\n / \nSelect none\nPlease wait...\n";
    public static final byte L_SEARCH = 0;
    public static final byte L_STOP = 1;
    public static final byte L_HELP = 2;
    public static final byte L_READING = 6;
    public static final byte L_DESCRIPTION = 7;
    public static final byte L_CONTAINS = 8;
    public static final byte L_PAGES_AND = 9;
    public static final byte L_WORDS = 10;
    public static final byte L_CREATED = 11;
    public static final byte L_FILE = 12;
    public static final byte L_USER_LOCALE = 13;
    public static final byte L_SITE = 14;
    public static final byte L_ENTER_TEXT = 17;
    public static final byte L_HELP_TOP = 18;
    public static final byte L_HELP_ADJACENT = 20;
    public static final byte L_HELP_MATCH = 21;
    public static final byte L_HELP_UNREADABLE = 23;
    public static final byte L_HELP_SEL_PAGE = 24;
    public static final byte L_NO_SEARCH = 27;
    public static final byte L_ABORTED = 28;
    public static final byte L_PAGE = 29;
    public static final byte L_FOUND = 30;
    public static final byte L_NO_CONTIG = 31;
    public static final byte L_2DQ_NEEDED = 32;
    public static final byte L_FOUND_UNORDERED = 37;
    public static final byte L_PAGES = 38;
    public static final byte L_HELP_WILD = 42;
    public static final byte L_PRE_FOUND = 43;
    public static final byte L_LANGUAGE = 47;
    public static final byte L_MISMATCHED_PARENTHESES = 48;
    public static final byte L_HELP_LOGICAL_OPERATORS1 = 49;
    public static final byte L_HELP_LOGICAL_OPERATORS2 = 50;
    public static final byte L_SELECT_LANG = 51;
    public static final byte L_SHOWING = 52;
    public static final byte L_WORDS_NOT_FOUND = 53;
    public static final byte L_BAD_BRACKETS = 54;
    public static final byte L_INCORRECT_PLACE = 55;
    public static final byte L_BAD_WILD = 56;
    public static final byte L_AND = 57;
    public static final byte L_OR = 58;
    public static final byte L_NOT = 59;
    public static final byte L_BAD_ASTERISK_DQ = 61;
    public static final byte L_RULESET = 62;
    public static final byte L_SUBSETS = 63;
    public static final byte L_SELECT_SUBSETS = 64;
    public static final byte L_POST_SHOWING = 65;
    public static final byte L_DATABASES = 66;
    public static final byte L_LANGUAGES = 67;
    public static final byte L_INDEXES = 68;
    public static final byte L_SELECT_INDEX = 69;
    public static final byte L_INDEX = 70;
    public static final byte L_NO_SUBSETS_SELECTED = 71;
    public static final byte L_POST_READING = 72;
    public static final byte L_FOUND_PLURAL = 73;
    public static final byte L_FOUND_ZERO = 74;
    public static final byte L_PAGES_ZERO = 75;
    public static final byte L_APPNAME = 76;
    public static final byte L_APPNAME_HTML = 77;
    public static final byte L_SEARCH_ENGINE = 78;
    public static final byte L_HELP_TOP_SERVER = 79;
    public static final byte L_SEARCH_FOR = 80;
    public static final byte L_SEARCH_RESULTS_FOR = 81;
    public static final byte L_PREVIOUS = 82;
    public static final byte L_NEXT = 83;
    public static final byte L_SERVER_ERROR = 84;
    public static final byte L_SERVER_RESULT = 85;
    public static final byte L_STOP_WORDS = 86;
    public static final byte L_SEARCH_WAIT = 89;
    public static final byte L_SEARCH_TIMEDOUT = 90;
    public static final byte L_FIRST = 91;
    public static final byte L_LAST = 92;
    public static final byte L_OF = 93;
    public static final byte L_RESULTS = 94;
    public static final byte L_RESULTS_TOTAL_BEFORE = 95;
    public static final byte L_SECONDS = 96;
    public static final byte L_HTML_TAG = 97;
    public static final byte L_BODY_TAG = 98;
    public static final byte L_ALIGN_TAG = 99;
    public static final byte L_SUBSET_SELECTALL = 100;
    public static final byte L_SUBSET_DIVIDE = 101;
    public static final byte L_SUBSET_SELECTNONE = 102;
    public static final byte L_LOADING = 103;
    public static final byte L_MAX = 103;
    private static final String[] LanguageStringNames = new String[104];
    private static boolean AllLanguageStringNamesLoaded;
    private static final String AllLanguageStringNames = "L_SEARCH\nL_STOP\nL_HELP\n\n\n\nL_READING\nL_DESCRIPTION\nL_CONTAINS\nL_PAGES_AND\nL_WORDS\nL_CREATED\nL_FILE\nL_USER_LOCALE\nL_SITE\n\n\nL_ENTER_TEXT\nL_HELP_TOP\n\nL_HELP_ADJACENT\nL_HELP_MATCH\n\nL_HELP_UNREADABLE\nL_HELP_SEL_PAGE\n\n\nL_NO_SEARCH\nL_ABORTED\nL_PAGE\nL_FOUND\nL_NO_CONTIG\nL_2DQ_NEEDED\n\n\n\n\nL_FOUND_UNORDERED\nL_PAGES\n\n\n\nL_HELP_WILD\nL_PRE_FOUND\n\n\n\nL_LANGUAGE\nL_MISMATCHED_PARENTHESES\nL_HELP_LOGICAL_OPERATORS1\nL_HELP_LOGICAL_OPERATORS2\nL_SELECT_LANG\nL_SHOWING\nL_WORDS_NOT_FOUND\nL_BAD_BRACKETS\nL_INCORRECT_PLACE\nL_BAD_WILD\nL_AND\nL_OR\nL_NOT\n\nL_BAD_ASTERISK_DQ\nL_RULESET\nL_SUBSETS\nL_SELECT_SUBSETS\nL_POST_SHOWING\nL_DATABASES\nL_LANGUAGES\nL_INDEXES\nL_SELECT_INDEX\nL_INDEX\nL_NO_SUBSETS_SELECTED\nL_POST_READING\nL_FOUND_PLURAL\nL_FOUND_ZERO\nL_PAGES_ZERO\nL_APPNAME\nL_APPNAME_HTML\nL_SEARCH_ENGINE\nL_HELP_TOP_SERVER\nL_SEARCH_FOR\nL_SEARCH_RESULTS_FOR\nL_PREVIOUS\nL_NEXT\nL_SERVER_ERROR\nL_SERVER_RESULT\nL_STOP_WORDS\n\n\nL_SEARCH_WAIT\nL_SEARCH_TIMEDOUT\nL_FIRST\nL_LAST\nL_OF\nL_RESULTS\nL_RESULTS_TOTAL_BEFORE\nL_SECONDS\nL_HTML_TAG\nL_BODY_TAG\nL_ALIGN_TAG\nL_SUBSET_SELECTALL\nL_SUBSET_DIVIDE\nL_SUBSET_SELECTNONE\nL_LOADING\n";

    public final void LoadLanguage(InputStream inputStream) {
        this.LanguageStrings[73] = new String();
        this.LanguageStrings[74] = new String();
        this.LanguageStrings[75] = new String();
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.LoadLanguage2(inputStream, dataInputStream);
            dataInputStream.close();
        }
        catch (IOException iOException) {}
        if (this.LanguageStrings[73].length() == 0) {
            this.LanguageStrings[73] = this.LanguageStrings[30];
        }
        if (this.LanguageStrings[74].length() == 0) {
            this.LanguageStrings[74] = this.LanguageStrings[73];
        }
        if (this.LanguageStrings[75].length() == 0) {
            this.LanguageStrings[75] = this.LanguageStrings[38];
        }
    }

    public String getLocale2() {
        if (this.countryCode.length() == 0) {
            return this.languageCode;
        }
        return this.languageCode + "-" + this.countryCode;
    }

    final void LoadLanguage2(InputStream inputStream, DataInputStream dataInputStream) throws IOException {
        block19: {
            String string = VirtualDbFile.ReadString(dataInputStream, true);
            if (string == null || string.length() == 0) {
                return;
            }
            if (string.charAt(0) == '\ufeff') {
                string = string.substring(1);
            }
            if ((string = string.trim()).equals("1")) {
                string = dataInputStream.readLine();
                if (string == null) {
                    return;
                }
                this.languageName = string;
                string = dataInputStream.readLine();
                if (string == null) {
                    return;
                }
                this.languageNameInEnglish = string;
                int n = 0;
                while (n <= 103) {
                    string = dataInputStream.readLine();
                    if (string != null) {
                        if (string.length() == 0) continue;
                        int n2 = n;
                        n = (short)(n2 + 1);
                        String string2 = this.LanguageStrings[n2] = string.equals(".") ? "" : string;
                        continue;
                    }
                    break block19;
                }
                return;
            }
            if (string.equals("2")) {
                this.languageName = VirtualDbFile.ReadString(inputStream, true);
                this.languageNameInEnglish = VirtualDbFile.ReadString(inputStream, true);
                int n = 0;
                while (n <= 103) {
                    string = VirtualDbFile.ReadString(inputStream, true);
                    if (string.length() == 0) continue;
                    int n3 = n;
                    n = (short)(n3 + 1);
                    String string3 = this.LanguageStrings[n3] = string.equals(".") ? "" : string;
                }
                return;
            }
            if (string.equals("3")) {
                block2: while ((string = VirtualDbFile.ReadString(inputStream, true)) != null) {
                    if (string.length() == 0) continue;
                    int n = string.indexOf(61);
                    String string4 = string;
                    String string5 = null;
                    if (n != -1) {
                        string4 = string.substring(0, n);
                        string5 = this.DecodeLangLine(string.substring(n + 1));
                    }
                    if ((string4 = string4.toLowerCase()).equals("language")) {
                        this.languageCode = string5;
                        continue;
                    }
                    if (string4.equals("country")) {
                        if (string5 == null) {
                            this.allCountryCodes = "";
                            continue;
                        }
                        PHDStringTokenizer pHDStringTokenizer = new PHDStringTokenizer(string5, ",", true);
                        while (pHDStringTokenizer.hasMoreTokens()) {
                            this.countryCodes.addElement(pHDStringTokenizer.nextToken());
                        }
                        if (this.countryCodes.size() <= 0) continue;
                        this.countryCode = (String)this.countryCodes.elementAt(0);
                        continue;
                    }
                    if (string4.equals("localname")) {
                        this.languageName = string5;
                        continue;
                    }
                    if (string4.equals("englishname")) {
                        this.languageNameInEnglish = string5;
                        continue;
                    }
                    int n4 = 0;
                    do {
                        if (!string4.equalsIgnoreCase(LanguageStringNames[n4])) continue;
                        this.LanguageStrings[n4] = string5;
                        continue block2;
                    } while (++n4 <= 103);
                }
            }
        }
    }

    public boolean ChangeString(String string, String string2) {
        int n = 0;
        do {
            if (!LanguageStringNames[n].equals(string)) continue;
            this.LanguageStrings[n] = string2;
            return true;
        } while (++n <= 103);
        return false;
    }

    public Language(InputStream inputStream) {
        Language.LoadAllLanguageStringNames();
        this.LoadEnglish();
        if (inputStream != null) {
            this.LoadLanguage(inputStream);
        }
    }

    public String getLocale() {
        return this.languageCode + this.countryCode;
    }

    private static final void LoadAllLanguageStringNames() {
        if (AllLanguageStringNamesLoaded) {
            return;
        }
        try {
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(AllLanguageStringNames);
            DataInputStream dataInputStream = new DataInputStream(stringBufferInputStream);
            int n = 0;
            do {
                String string;
                if ((string = dataInputStream.readLine()) == null) {
                    throw new IOException("EOF reached");
                }
                Language.LanguageStringNames[n] = string;
            } while (++n <= 103);
            if (dataInputStream.readLine() != null) {
                throw new IOException("EOF not reached");
            }
            stringBufferInputStream.close();
            AllLanguageStringNamesLoaded = true;
            return;
        }
        catch (IOException iOException) {
            System.err.println("Language: " + iOException);
            System.exit(-1);
            return;
        }
    }

    final void LoadEnglish() {
        StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(English);
        this.languageCode = "en";
        this.countryCode = "";
        this.allCountryCodes = "";
        this.LoadLanguage(stringBufferInputStream);
    }

    public static boolean StartsWithArabicThe(StringBuffer stringBuffer) {
        if (stringBuffer.length() < 2) {
            return false;
        }
        if (stringBuffer.charAt(1) != '\u0644') {
            return false;
        }
        char c = stringBuffer.charAt(0);
        return c == '\u0627' || c == '\u0622' || c == '\u0623' || c == '\u0625';
    }

    public String getAllLocales() {
        return this.languageCode + this.allCountryCodes;
    }

    private String DecodeLangLine(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\\' && n2 + 1 < n) {
                char c2;
                if ((c2 = string.charAt(++n2)) == 'u') {
                    if (n2 + 4 < n) {
                        String string2 = string.substring(++n2, n2 + 4);
                        c = (char)Integer.parseInt(string2, 16);
                        n2 += 3;
                    }
                } else {
                    c = c2;
                }
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void loadProperty(Properties properties, byte by, String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return;
        }
        if (by >= 0 && by <= 103) {
            this.LanguageStrings[by] = string2;
        }
    }

    public String Lang(byte by) {
        if (by < 0 || by > 103) {
            return "Bad language call";
        }
        return this.LanguageStrings[by];
    }
}

