/*
 * Decompiled with CFR 0.152.
 */
package com.phdcc.find;

import com.phdcc.find.DbFile;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class VirtualDbFile
implements DbFile {
    private DbFile dbfile;

    public int readnoeof() throws IOException {
        return this.dbfile.readnoeof();
    }

    public int readeof() throws IOException, EOFException {
        int n = this.readnoeof();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public VirtualDbFile(DbFile dbFile, URL uRL) throws IOException {
        this.dbfile = dbFile;
        if (this.dbfile == null) {
            throw new IOException("VirtualDbFile: dbfile null");
        }
        if (!this.dbfile.Load(uRL)) {
            throw new IOException("VirtualDbFile: dbfile Load fail " + uRL.toString());
        }
    }

    public boolean Load(URL uRL) {
        return this.dbfile.Load(uRL);
    }

    short ReadWord() throws IOException, EOFException {
        int n = this.readeof();
        int n2 = this.readeof();
        return (short)((n2 << 8) + n);
    }

    int ReadDword() throws IOException, EOFException {
        int n = this.readeof();
        int n2 = this.readeof();
        int n3 = this.readeof();
        int n4 = this.readeof();
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    int ReadUnsignedInt(int n) throws IOException, EOFException {
        switch (n) {
            case 1: {
                int n2;
                int n3 = n2 = this.ReadByte();
                if (n2 < 0) {
                    n3 = (n2 & 0x7F) + 128;
                }
                return n3;
            }
            case 2: {
                int n4;
                int n5 = n4 = this.ReadWord();
                if (n4 < 0) {
                    n5 = (n4 & Short.MAX_VALUE) + 32768;
                }
                return n5;
            }
            case 4: {
                int n6 = this.ReadDword();
                if (n6 < 0) {
                    throw new IOException("Dword gone negative");
                }
                return n6;
            }
        }
        throw new IOException("Bad ReadUnsignedInt size: " + n);
    }

    String ReadString() throws IOException, EOFException {
        return this.ReadString(false);
    }

    String ReadString(boolean bl) throws IOException, EOFException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(16);
        while ((n = this.readeof()) != 0) {
            int n2;
            if (bl && n == 13) continue;
            if (bl && n == 10) break;
            if ((n & 0x80) != 0) {
                if ((n & 0x40) == 0) {
                    throw new IOException("bad utf8");
                }
                n2 = 32;
                int n3 = 31;
                int n4 = 1;
                do {
                    if ((n & n2) == 0) {
                        n &= n3;
                        int n5 = 0;
                        while (n5 < n4) {
                            int n6 = this.readeof();
                            if ((n6 & 0xC0) != 128) {
                                throw new IOException("bad utf8");
                            }
                            n = (n << 6) + (n6 & 0x3F);
                            ++n5;
                        }
                        break;
                    }
                    n2 >>= 1;
                    n3 >>= 1;
                } while (++n4 < 5);
            }
            n2 = n;
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public static String ReadString(InputStream inputStream, boolean bl) throws IOException, EOFException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(16);
        while ((n = VirtualDbFile.ReadByteSafely(inputStream)) != 0) {
            int n2;
            if (bl && n == 13) continue;
            if (bl && n == 10) break;
            if ((n & 0x80) != 0) {
                if ((n & 0x40) == 0) {
                    throw new IOException("bad utf8");
                }
                n2 = 32;
                int n3 = 31;
                int n4 = 1;
                do {
                    if ((n & n2) == 0) {
                        n &= n3;
                        int n5 = 0;
                        while (n5 < n4) {
                            int n6 = VirtualDbFile.ReadByteSafely(inputStream);
                            if ((n6 & 0xC0) != 128) {
                                throw new IOException("bad utf8");
                            }
                            n = (n << 6) + (n6 & 0x3F);
                            ++n5;
                        }
                        break;
                    }
                    n2 >>= 1;
                    n3 >>= 1;
                } while (++n4 < 5);
            }
            n2 = n;
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    byte ReadByte() throws IOException, EOFException {
        return (byte)this.readeof();
    }

    public void startUsing() throws IOException {
        this.dbfile.startUsing();
    }

    public void stopUsing() throws IOException {
        this.dbfile.stopUsing();
    }

    private static int ReadByteSafely(InputStream inputStream) throws IOException, EOFException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public boolean moveTo(int n) throws IOException {
        return this.dbfile.moveTo(n);
    }
}

