/*
 * Decompiled with CFR 0.152.
 */
package com.phdcc.find;

import com.phdcc.find.SearchWord;
import java.util.Vector;

public class SearchItem {
    public static final int OPERATION_NONE = 0;
    public static final int OPERATION_AND = 1;
    public static final int OPERATION_OR = 2;
    public static final int OPERATION_ADJACENT = 3;
    public static final int OPERATION_TYPE_MASK = 3;
    public static final int OPERATION_STOP_WORD = 32;
    public static final int OPERATION_EXPRESSION = 64;
    public static final int OPERATION_NOT = 128;
    public static final int OPERATION_MODIFIER_MASK = 224;
    static final char END_OF_STRING = '\uffff';
    String OriginalText;
    public int operation;
    public int dbfieldno;
    public Vector expression;
    public Vector words;
    public boolean ListMatchCaseFirst;
    public int wordno;
    public boolean lastword;
    public Vector parentexpr;
    public boolean matchCase;
    public int wordLenMin;
    public int wordLenMax;
    private static final String hex = "0123456789ABCDEF";
    private static String strSearchWords;
    private static int siNumChars;
    private static int siCharNo;

    public SearchItem(String string, int n) {
        this.OriginalText = string;
        this.words = null;
        this.expression = null;
        this.operation = 0;
        this.dbfieldno = n;
    }

    private static int getint() throws NumberFormatException {
        String string = SearchItem.getword();
        return Integer.parseInt(string);
    }

    private static String getword() {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringBuffer == null) {
            return null;
        }
        while (true) {
            char c;
            if ((c = SearchItem.nextch()) == '\uffff') {
                return null;
            }
            if (c == ' ') break;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static Vector SearchItemsFromString(String string) throws Exception {
        strSearchWords = string;
        if (strSearchWords == null) {
            return null;
        }
        siNumChars = strSearchWords.length();
        siCharNo = 0;
        if (SearchItem.nextch() != '(') {
            return null;
        }
        return SearchItem.SearchItemsExpr();
    }

    public static char safech(int n) {
        if (n < 0 || n > 15) {
            return '!';
        }
        return hex.charAt(n);
    }

    private static void ungetch() {
        siCharNo += -1;
    }

    private static int nextich() {
        char c = SearchItem.nextch();
        if (c == '\uffff') {
            return -1;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    public static String SearchItemsToString(Vector vector) {
        if (vector == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("( ");
        if (stringBuffer == null) {
            return "null";
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            SearchItem searchItem = (SearchItem)vector.elementAt(n2);
            stringBuffer.append(searchItem.operation);
            stringBuffer.append(' ');
            stringBuffer.append(searchItem.matchCase);
            stringBuffer.append(' ');
            if (searchItem.expression != null) {
                stringBuffer.append(SearchItem.SearchItemsToString(searchItem.expression));
                stringBuffer.append(' ');
            } else {
                int n3 = searchItem.words.size();
                int n4 = 0;
                while (n4 < n3) {
                    SearchWord searchWord = (SearchWord)searchItem.words.elementAt(n4);
                    int n5 = searchWord.word.length();
                    int n6 = 0;
                    while (n6 < n5) {
                        char c = searchWord.word.charAt(n6);
                        if (c <= ' ' || c == '.' || c == '\"' || c == '\'' || c == '(' || c == ')' || c == '!' || c >= '\u007f') {
                            stringBuffer.append('!');
                            stringBuffer.append(SearchItem.safech(c >> 12 & 0xF));
                            stringBuffer.append(SearchItem.safech(c >> 8 & 0xF));
                            stringBuffer.append(SearchItem.safech(c >> 4 & 0xF));
                            stringBuffer.append(SearchItem.safech(c & 0xF));
                        } else {
                            stringBuffer.append(c);
                        }
                        ++n6;
                    }
                    stringBuffer.append(' ');
                    ++n4;
                }
                stringBuffer.append('.');
                stringBuffer.append(' ');
            }
            ++n2;
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    private static boolean getbool() throws Exception {
        String string = SearchItem.getword();
        if (string != null) {
            if (string.equalsIgnoreCase("true")) {
                return true;
            }
            if (string.equalsIgnoreCase("false")) {
                return false;
            }
        }
        throw new Exception("getbool found " + string);
    }

    private static char nextNonBlankCh() {
        char c;
        while ((c = SearchItem.nextch()) == ' ' && c != '\uffff') {
        }
        return c;
    }

    private static char nextch() {
        if (siCharNo == siNumChars) {
            return '\uffff';
        }
        return strSearchWords.charAt(siCharNo++);
    }

    private static Vector SearchItemsExpr() throws Exception {
        Vector<SearchItem> vector = new Vector<SearchItem>();
        if (vector == null) {
            return null;
        }
        int n = 0;
        SearchItem searchItem = null;
        while (true) {
            char c;
            if ((c = SearchItem.nextNonBlankCh()) == '\uffff') {
                return null;
            }
            if (c == ')') break;
            SearchItem.ungetch();
            SearchItem searchItem2 = new SearchItem(null, -1);
            if (searchItem2 == null) {
                return null;
            }
            searchItem2.operation = SearchItem.getint();
            searchItem2.matchCase = SearchItem.getbool();
            vector.addElement(searchItem2);
            c = SearchItem.nextNonBlankCh();
            if (c == '\uffff') {
                return null;
            }
            if (c == '(') {
                searchItem2.expression = SearchItem.SearchItemsExpr();
            } else {
                SearchItem.ungetch();
                searchItem2.wordno = n++;
                searchItem2.words = new Vector();
                searchItem = searchItem2;
                if (searchItem2.words == null) {
                    return null;
                }
                while (true) {
                    char c2;
                    if ((c2 = SearchItem.nextNonBlankCh()) == '\uffff') {
                        return null;
                    }
                    if (c2 == '.') break;
                    SearchItem.ungetch();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (stringBuffer == null) {
                        return null;
                    }
                    while (true) {
                        if ((c2 = SearchItem.nextch()) == '\uffff') {
                            return null;
                        }
                        if (c2 == ' ') break;
                        if (c2 == '!') {
                            int n2 = SearchItem.nextich();
                            if (n2 == -1) {
                                return null;
                            }
                            int n3 = SearchItem.nextich();
                            if (n2 == -1) {
                                return null;
                            }
                            int n4 = SearchItem.nextich();
                            if (n2 == -1) {
                                return null;
                            }
                            int n5 = SearchItem.nextich();
                            if (n2 == -1) {
                                return null;
                            }
                            c2 = (char)((((n2 << 4) + n3 << 4) + n4 << 4) + n5);
                        }
                        stringBuffer.append(c2);
                    }
                    SearchWord searchWord = new SearchWord(stringBuffer.toString());
                    if (searchWord == null) {
                        return null;
                    }
                    searchItem2.words.addElement(searchWord);
                }
            }
            c = SearchItem.nextNonBlankCh();
            if (c == '\uffff') {
                return null;
            }
            if (c == ')') break;
            SearchItem.ungetch();
        }
        if (searchItem != null) {
            searchItem.lastword = true;
        }
        return vector;
    }
}

