/*
 * Decompiled with CFR 0.152.
 */
package com.phdcc.find;

import com.phdcc.find.Caller;
import com.phdcc.find.CharSet;
import com.phdcc.find.DbField;
import com.phdcc.find.MemoryDbFile;
import com.phdcc.find.Page;
import com.phdcc.find.VirtualDbFile;
import java.io.EOFException;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class SearchDb {
    static int NUM_PRIORITIES = 4;
    private static int DATABASE_DIFFERENT_CASES = 1;
    private static int DATABASE_POSITIONS = 2;
    private static int DATABASE_STOP_WORDS = 4;
    private static int DATABASE_STORE_LONE_WORDS = 8;
    private Caller caller;
    public String URLNoExt;
    public URL SystemFileURL;
    public URL WordHashURL;
    public URL BaseURLsURL;
    public URL PageNamesURL;
    public URL PagesURL;
    public URL AbstractsURL;
    public URL AnchorsURL;
    public URL WordListURL;
    public URL PriorityListURL;
    public URL PageListURL;
    public URL AnchorNameURL;
    public URL Posn1URL;
    public URL Posn2URL;
    public URL Posn4URL;
    public URL StopWordsURL;
    public URL FieldsURL;
    public URL FieldsWordListURL;
    public String Description;
    public String CreationDate;
    public int tCreationDate;
    public boolean databaseHasPositions;
    public boolean databaseHasDifferentCases;
    private boolean databaseHasStopWords;
    public int PageCount;
    public int BaseUrlCount;
    private int AnchorCount;
    public int lcWordCount;
    int hashtableentries;
    byte prionosize;
    byte plpsize;
    byte PageNoBytes;
    byte posn1size;
    byte posn2size;
    byte posn4size;
    boolean WordHashTableIsShort;
    short[] ShortWordHashTable;
    int[] IntWordHashTable;
    private boolean AnchorPtrsAreUShort;
    private int[] IntAnchorPtrs;
    private short[] ShortAnchorPtrs;
    public Page[] pages;
    public String[] BaseUrls;
    private Vector Targets = new Vector();
    public Hashtable StopWords;
    private Object StopWordValue = new Object();
    public Vector fields;
    VirtualDbFile WordList;
    VirtualDbFile PriorityList;
    VirtualDbFile PageList;
    VirtualDbFile AnchorName;
    VirtualDbFile Posn1;
    VirtualDbFile Posn2;
    VirtualDbFile Posn4;
    VirtualDbFile FieldsWordListFile;
    public String defaultTarget;
    public String BaseUrl0;
    private int WordHashFileSize;
    private int WordListFileSize;
    private int PriorityListFileSize;
    private int PageListFileSize;
    private int PagesFileSize;
    private int PageNamesFileSize;
    private int BaseUrlsFileSize;
    private int AbstractsFileSize;
    private int AnchorsFileSize;
    private int AnchorNamesFileSize;
    private int Posn1FileSize;
    private int Posn2FileSize;
    private int Posn4FileSize;

    public String getTarget(short s) {
        if (s < 0 || s >= this.Targets.size()) {
            if (this.defaultTarget == null) {
                return "_self";
            }
            return this.defaultTarget;
        }
        return (String)this.Targets.elementAt(s);
    }

    private boolean ReadAnchors() {
        try {
            VirtualDbFile virtualDbFile = new VirtualDbFile(new MemoryDbFile(), this.AnchorsURL);
            if (virtualDbFile == null) {
                return false;
            }
            int n = 0;
            while (n < this.AnchorCount) {
                if (this.AnchorPtrsAreUShort) {
                    this.ShortAnchorPtrs[n] = (short)virtualDbFile.ReadUnsignedInt(2);
                } else {
                    this.IntAnchorPtrs[n] = virtualDbFile.ReadUnsignedInt(4);
                }
                ++n;
            }
            virtualDbFile = null;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public SearchDb(String string) {
        this.URLNoExt = string;
    }

    private String AsISO8601(Date date) {
        String string = this.AsDigits(date.getYear() + 1900, 4) + "-";
        string = string + this.AsDigits(date.getMonth() + 1, 2) + "-";
        string = string + this.AsDigits(date.getDate(), 2) + " ";
        string = string + this.AsDigits(date.getHours(), 2) + ":";
        string = string + this.AsDigits(date.getMinutes(), 2) + ":";
        string = string + this.AsDigits(date.getSeconds(), 2);
        return string;
    }

    public static boolean isAbsoluteURL(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == ':') {
                return true;
            }
            if ((c < 'a' || c > 'z') && (c < 'A' || c > 'Z')) break;
            n2 = (short)(n2 + 1);
        }
        return false;
    }

    private boolean ReadStopWords() {
        this.StopWords = new Hashtable();
        try {
            VirtualDbFile virtualDbFile = new VirtualDbFile(new MemoryDbFile(), this.StopWordsURL);
            while (true) {
                String string = virtualDbFile.ReadString(true);
                string = CharSet.ToUnicodeLowerCase(string);
                this.StopWords.put(string, this.StopWordValue);
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean ReadFields() {
        try {
            VirtualDbFile virtualDbFile = new VirtualDbFile(new MemoryDbFile(false), this.FieldsURL);
            this.FieldsWordListFile = new VirtualDbFile(new MemoryDbFile(), this.FieldsWordListURL);
            this.fields = new Vector();
            while (true) {
                String string = virtualDbFile.ReadString(false);
                int n = virtualDbFile.ReadDword();
                DbField dbField = new DbField(string, n);
                this.fields.addElement(dbField);
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean DoReadIndexDb(Caller caller) {
        this.caller = caller;
        if (this.SystemFileURL == null || this.WordHashURL == null || this.BaseURLsURL == null || this.PageNamesURL == null || this.PagesURL == null || this.AbstractsURL == null || this.AnchorsURL == null || this.WordListURL == null || this.PriorityListURL == null || this.PageListURL == null || this.AnchorNameURL == null || this.Posn1URL == null || this.Posn2URL == null || this.Posn4URL == null) {
            return false;
        }
        if (!this.ReadSystemFile()) {
            String string = this.URLNoExt + ": could not read System file.";
            this.caller.ReportError(string);
            return false;
        }
        int n = this.hashtableentries / 10;
        int n2 = this.PageCount / 2;
        int n3 = this.PageCount / 2;
        int n4 = this.AnchorCount / 100;
        int n5 = this.lcWordCount;
        int n6 = 1;
        int n7 = 1;
        int n8 = 1;
        int n9 = 1;
        int n10 = 1;
        int n11 = 1;
        if (this.Posn4FileSize == 0) {
            if (this.caller.DbsAreInMemory()) {
                n6 = this.lcWordCount / 2;
                n7 = this.lcWordCount * 2;
                n10 = this.lcWordCount * 2;
                n11 = this.lcWordCount;
            }
        } else if (this.Posn4FileSize != 0) {
            n = this.WordHashFileSize;
            n2 = this.PagesFileSize + this.PageNamesFileSize;
            n3 = this.AbstractsFileSize;
            n4 = this.AnchorsFileSize;
            n5 = this.WordListFileSize;
            if (this.caller.DbsAreInMemory()) {
                n6 = this.PriorityListFileSize;
                n7 = this.PageListFileSize;
                n8 = this.AnchorNamesFileSize;
                n9 = this.Posn1FileSize;
                n10 = this.Posn2FileSize;
                n11 = this.Posn4FileSize;
            }
        }
        int n12 = n + n2 + n3 + n4 + n5;
        this.caller.SetTotalFactors(n12 += n6 + n7 + n8 + n9 + n10 + n11);
        if (!this.databaseHasStopWords && this.StopWordsURL != null) {
            this.ReadStopWords();
        }
        if (this.FieldsURL != null && this.FieldsWordListURL != null) {
            this.ReadFields();
        }
        if (!this.ReadWordHashTable()) {
            this.caller.ReportError(this.URLNoExt + ": could not read Word Hash Table");
            return false;
        }
        this.caller.AddFactor(n);
        if (!this.ReadPages(n2)) {
            this.caller.ReportError(this.URLNoExt + ": could not read Pages");
            return false;
        }
        this.caller.AddFactor(n3);
        if (!this.ReadAnchors()) {
            this.caller.ReportError(this.URLNoExt + ": could not read Anchors");
            return false;
        }
        this.caller.AddFactor(n4);
        try {
            this.caller.SetFactorForDbFileLoad(n5, this.WordListFileSize);
            this.WordList = new VirtualDbFile(new MemoryDbFile(this.caller), this.WordListURL);
            this.caller.AddFactor(n5);
            this.caller.SetFactorForDbFileLoad(n6, this.PriorityListFileSize);
            this.PriorityList = new VirtualDbFile(this.caller.MakeDbFile(), this.PriorityListURL);
            this.caller.AddFactor(n6);
            this.caller.SetFactorForDbFileLoad(n7, this.PageListFileSize);
            this.PageList = new VirtualDbFile(this.caller.MakeDbFile(), this.PageListURL);
            this.caller.AddFactor(n7);
            this.caller.SetFactorForDbFileLoad(n8, this.AnchorNamesFileSize);
            this.AnchorName = new VirtualDbFile(this.caller.MakeDbFile(), this.AnchorNameURL);
            this.caller.AddFactor(n8);
            this.caller.SetFactorForDbFileLoad(n9, this.Posn1FileSize);
            this.Posn1 = new VirtualDbFile(this.caller.MakeDbFile(), this.Posn1URL);
            this.caller.AddFactor(n9);
            this.caller.SetFactorForDbFileLoad(n10, this.Posn2FileSize);
            this.Posn2 = new VirtualDbFile(this.caller.MakeDbFile(), this.Posn2URL);
            this.caller.AddFactor(n10);
            this.caller.SetFactorForDbFileLoad(n11, this.Posn4FileSize);
            this.Posn4 = new VirtualDbFile(this.caller.MakeDbFile(), this.Posn4URL);
            this.caller.AddFactor(n11);
        }
        catch (IOException iOException) {
            this.caller.ReportError(this.URLNoExt + ": could not read the search database " + iOException);
            return false;
        }
        if (this.WordList == null || this.PriorityList == null || this.PageList == null || this.AnchorName == null || this.Posn1 == null || this.Posn2 == null || this.Posn4 == null) {
            this.caller.ReportError(this.URLNoExt + ": could not open the search database");
            return false;
        }
        this.SystemFileURL = null;
        this.WordHashURL = null;
        this.BaseURLsURL = null;
        this.PageNamesURL = null;
        this.PagesURL = null;
        this.AbstractsURL = null;
        this.AnchorsURL = null;
        this.WordListURL = null;
        this.PriorityListURL = null;
        this.PageListURL = null;
        this.AnchorNameURL = null;
        this.Posn1URL = null;
        this.Posn2URL = null;
        this.Posn4URL = null;
        System.gc();
        return true;
    }

    private short TargetNo(String string) {
        short s = (short)this.Targets.size();
        short s2 = 0;
        while (s2 < s) {
            if (((String)this.Targets.elementAt(s2)).equals(string)) {
                return s2;
            }
            s2 = (short)(s2 + 1);
        }
        this.Targets.addElement(string);
        return s;
    }

    public static int stringHashCode(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        if (n3 < 16) {
            int n4 = 0;
            while (n4 < n3) {
                int n5 = string.charAt(n4) & 0xFF;
                n = n * 37 + n5;
                ++n4;
            }
        } else {
            int n6 = n3 / 8;
            int n7 = n3;
            while (n7 > 0) {
                int n8 = string.charAt(n2) & 0xFF;
                n = n * 39 + n8;
                n7 -= n6;
                n2 += n6;
            }
        }
        return n & Integer.MAX_VALUE;
    }

    private String AsDigits(int n, int n2) {
        String string = new Integer(n).toString();
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private boolean ReadPages(int var1_1) {
        try {
            var2_2 = new VirtualDbFile(new MemoryDbFile(), this.BaseURLsURL);
            var2_2.ReadByte();
            var3_3 = 0;
            try {
                while (true) {
                    var4_4 = var2_2.ReadString();
                    if (var3_3 > this.BaseUrlCount) {
                        return false;
                    }
                    this.BaseUrls[var3_3++] = var4_4;
                }
            }
            catch (Exception v0) {
                if (var3_3 != this.BaseUrlCount) {
                    return false;
                }
                var2_2 = null;
                var4_5 = new VirtualDbFile(new MemoryDbFile(), this.PagesURL);
                var5_6 = new VirtualDbFile(new MemoryDbFile(), this.PageNamesURL);
                var6_7 = 0;
                ** while (var6_7 < this.PageCount)
            }
lbl-1000:
            // 1 sources

            {
                var7_9 = new Page();
                if (var7_9 == null) {
                    return false;
                }
                var7_9.AnchorBaseNo = var4_5.ReadUnsignedInt(this.AnchorPtrsAreUShort != false ? 2 : 4);
                var7_9.BaseUrlNo = var4_5.ReadByte();
                var7_9.RevisionNo = var4_5.ReadByte();
                var7_9.Name = var5_6.ReadString();
                var7_9.Title = var5_6.ReadString();
                var8_11 = var5_6.ReadString();
                var7_9.TargetNo = (short)(var8_11.length() == 0 ? -1 : (int)this.TargetNo((String)var8_11));
                this.pages[var6_7] = var7_9;
                ++var6_7;
                continue;
            }
lbl34:
            // 1 sources

            var4_5 = null;
            var5_6 = null;
            this.caller.AddFactor(var1_1);
            var6_8 = new VirtualDbFile(new MemoryDbFile(), this.AbstractsURL);
            var7_10 = 0;
            while (var7_10 < this.PageCount) {
                var8_11 = this.pages[var7_10];
                var9_12 = var6_8.ReadString();
                while ((var10_13 = var9_12.indexOf(10)) != -1) {
                    var9_12 = var9_12.substring(0, var10_13) + "<br />" + var9_12.substring(var10_13 + 1);
                }
                var8_11.Abstract = var9_12;
                ++var7_10;
            }
            var6_8 = null;
        }
        catch (Exception v1) {
            return false;
        }
        return true;
    }

    public String AnchorName(int n) {
        try {
            int n2;
            if (this.AnchorPtrsAreUShort) {
                n2 = this.ShortAnchorPtrs[n];
                if (n2 < 0) {
                    n2 = (n2 & Short.MAX_VALUE) + 32768;
                }
            } else {
                n2 = this.IntAnchorPtrs[n];
            }
            this.AnchorName.startUsing();
            this.AnchorName.moveTo(n2);
            String string = this.AnchorName.ReadString();
            this.AnchorName.stopUsing();
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean ReadSystemFile() {
        try {
            boolean bl;
            VirtualDbFile virtualDbFile = new VirtualDbFile(new MemoryDbFile(), this.SystemFileURL);
            byte by = virtualDbFile.ReadByte();
            boolean bl2 = bl = by == 0;
            if (by > 1) {
                return false;
            }
            byte by2 = virtualDbFile.ReadByte();
            if ((by2 & DATABASE_POSITIONS) != 0) {
                this.databaseHasPositions = true;
            }
            if ((by2 & DATABASE_DIFFERENT_CASES) != 0) {
                this.databaseHasDifferentCases = true;
            }
            if ((by2 & DATABASE_STOP_WORDS) != 0) {
                this.databaseHasStopWords = true;
            }
            this.PageCount = bl ? virtualDbFile.ReadUnsignedInt(2) : virtualDbFile.ReadUnsignedInt(4);
            this.BaseUrlCount = virtualDbFile.ReadByte() & 0xFF;
            this.AnchorCount = bl ? virtualDbFile.ReadUnsignedInt(2) : virtualDbFile.ReadUnsignedInt(4);
            byte by3 = virtualDbFile.ReadByte();
            this.lcWordCount = virtualDbFile.ReadDword();
            this.hashtableentries = virtualDbFile.ReadDword();
            if (this.hashtableentries == 0) {
                return false;
            }
            this.prionosize = virtualDbFile.ReadByte();
            this.plpsize = virtualDbFile.ReadByte();
            this.PageNoBytes = virtualDbFile.ReadByte();
            this.posn1size = virtualDbFile.ReadByte();
            this.posn2size = virtualDbFile.ReadByte();
            this.posn4size = virtualDbFile.ReadByte();
            int n = 2;
            if (!bl) {
                n = virtualDbFile.ReadByte();
                int n2 = virtualDbFile.ReadDword();
                n2 = virtualDbFile.ReadDword();
            }
            this.Description = virtualDbFile.ReadString();
            this.CreationDate = virtualDbFile.ReadString();
            try {
                String string = virtualDbFile.ReadString();
                int n3 = virtualDbFile.ReadByte();
                string = virtualDbFile.ReadString();
                n3 = virtualDbFile.ReadByte();
                string = virtualDbFile.ReadString();
                n3 = virtualDbFile.ReadByte();
                n3 = virtualDbFile.ReadByte();
                n3 = virtualDbFile.ReadByte();
                n3 = virtualDbFile.ReadDword();
                n3 = virtualDbFile.ReadByte();
                n3 = virtualDbFile.ReadByte();
                n3 = virtualDbFile.ReadByte();
                n3 = virtualDbFile.ReadByte();
                n3 = virtualDbFile.ReadByte();
                n3 = virtualDbFile.ReadByte();
                n3 = virtualDbFile.ReadByte();
                string = virtualDbFile.ReadString();
                string = virtualDbFile.ReadString();
                string = virtualDbFile.ReadString();
                n3 = virtualDbFile.ReadByte();
                string = virtualDbFile.ReadString();
                this.tCreationDate = virtualDbFile.ReadDword();
                long l = (long)this.tCreationDate * 1000L;
                Date date = new Date(l);
                this.CreationDate = this.AsISO8601(date);
                n3 = virtualDbFile.ReadDword();
                this.WordHashFileSize = virtualDbFile.ReadDword();
                n3 = virtualDbFile.ReadDword();
                this.WordListFileSize = virtualDbFile.ReadDword();
                n3 = virtualDbFile.ReadDword();
                this.PriorityListFileSize = virtualDbFile.ReadDword();
                n3 = virtualDbFile.ReadDword();
                this.PageListFileSize = virtualDbFile.ReadDword();
                n3 = virtualDbFile.ReadDword();
                this.PagesFileSize = virtualDbFile.ReadDword();
                n3 = virtualDbFile.ReadDword();
                this.PageNamesFileSize = virtualDbFile.ReadDword();
                n3 = virtualDbFile.ReadDword();
                this.BaseUrlsFileSize = virtualDbFile.ReadDword();
                n3 = virtualDbFile.ReadDword();
                this.AbstractsFileSize = virtualDbFile.ReadDword();
                n3 = virtualDbFile.ReadDword();
                this.AnchorsFileSize = virtualDbFile.ReadDword();
                n3 = virtualDbFile.ReadDword();
                this.AnchorNamesFileSize = virtualDbFile.ReadDword();
                n3 = virtualDbFile.ReadDword();
                this.Posn1FileSize = virtualDbFile.ReadDword();
                n3 = virtualDbFile.ReadDword();
                this.Posn2FileSize = virtualDbFile.ReadDword();
                n3 = virtualDbFile.ReadDword();
                this.Posn4FileSize = virtualDbFile.ReadDword();
            }
            catch (Exception exception) {
                this.WordHashFileSize = 0;
                this.WordListFileSize = 0;
                this.PriorityListFileSize = 0;
                this.PageListFileSize = 0;
                this.PagesFileSize = 0;
                this.PageNamesFileSize = 0;
                this.BaseUrlsFileSize = 0;
                this.AbstractsFileSize = 0;
                this.AnchorsFileSize = 0;
                this.AnchorNamesFileSize = 0;
                this.Posn1FileSize = 0;
                this.Posn2FileSize = 0;
                this.Posn4FileSize = 0;
            }
            this.WordHashTableIsShort = by3 == 2;
            this.pages = new Page[this.PageCount];
            if (this.pages == null) {
                return false;
            }
            if (this.BaseUrlCount > 0) {
                this.BaseUrls = new String[this.BaseUrlCount];
                if (this.BaseUrls == null) {
                    return false;
                }
            }
            if (n == 2) {
                this.AnchorPtrsAreUShort = true;
            } else if (n == 4) {
                this.AnchorPtrsAreUShort = false;
            } else {
                return false;
            }
            if (this.AnchorPtrsAreUShort) {
                this.ShortAnchorPtrs = new short[this.AnchorCount];
            } else {
                this.IntAnchorPtrs = new int[this.AnchorCount];
            }
            if (this.ShortAnchorPtrs == null && this.IntAnchorPtrs == null) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean ReadWordHashTable() {
        if (this.WordHashTableIsShort) {
            this.ShortWordHashTable = new short[this.hashtableentries];
            if (this.ShortWordHashTable == null) {
                return false;
            }
        } else {
            this.IntWordHashTable = new int[this.hashtableentries];
            if (this.IntWordHashTable == null) {
                return false;
            }
        }
        try {
            VirtualDbFile virtualDbFile = new VirtualDbFile(new MemoryDbFile(), this.WordHashURL);
            int n = 0;
            while (n < this.hashtableentries) {
                int n2;
                if (this.WordHashTableIsShort) {
                    this.ShortWordHashTable[n] = n2 = virtualDbFile.ReadWord();
                } else {
                    this.IntWordHashTable[n] = n2 = virtualDbFile.ReadDword();
                }
                ++n;
            }
            virtualDbFile = null;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

