/*
 * Decompiled with CFR 0.152.
 */
package com.phdcc.find;

import com.phdcc.find.CharSet;
import com.phdcc.find.Rule;
import com.phdcc.find.SearchItem;
import com.phdcc.find.SearchWord;
import com.phdcc.find.VirtualDbFile;
import com.phdcc.util.PHDStringTokenizer;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;

public class RuleSet {
    public String FileName;
    private Vector rules;
    private int numRules;
    public String languageCode;
    public String countryCode;
    private String description;
    private String loaderror;

    void ProcessRulesForSearchItem(SearchItem searchItem, String string) {
        searchItem.words.removeAllElements();
        this.AddWordAndProcessRules(searchItem, string, true);
    }

    public String info() {
        if (this.numRules == 0) {
            String string = "No rules";
            if (this.loaderror != null) {
                string = string + "<BR>Load error: " + this.loaderror;
            }
            return string;
        }
        String string = "";
        if (this.description != null) {
            string = string + this.description;
        }
        if (this.languageCode != null) {
            string = string + "  (" + this.languageCode;
            if (this.countryCode.length() > 0) {
                string = string + " " + this.countryCode;
            }
            string = string + ")";
        }
        string = string + "  " + this.numRules + " rules";
        return string;
    }

    void AddWordAndProcessRules(SearchItem searchItem, String string, boolean bl) {
        Object object;
        int n = string.length();
        if (n == 0) {
            return;
        }
        String string2 = string.toLowerCase();
        SearchWord searchWord = null;
        int n2 = searchItem.words.size();
        int n3 = 0;
        while (n3 < n2) {
            object = (SearchWord)searchItem.words.elementAt(n3);
            if (string2.equals(((SearchWord)object).word.toLowerCase())) {
                if (bl && !((SearchWord)object).runRules) {
                    searchWord = object;
                    break;
                }
                return;
            }
            ++n3;
        }
        if (searchWord == null) {
            searchWord = new SearchWord(string);
            if (searchWord == null) {
                return;
            }
            searchItem.words.addElement(searchWord);
        }
        if (!bl) {
            return;
        }
        searchWord.runRules = true;
        if (n <= 1) {
            return;
        }
        n3 = 0;
        while (n3 < this.numRules) {
            object = (Rule)this.rules.elementAt(n3);
            block0 : switch (((Rule)object).type) {
                case 1: {
                    if (((Rule)object).numTokens < 2) break;
                    String string3 = (String)((Rule)object).tokens.elementAt(0);
                    int n4 = string3.length();
                    if (n4 == 0) {
                        ((Rule)object).AddAlternatives(this, searchItem, string);
                        break;
                    }
                    if (n4 >= n) break;
                    char c = '\u0000';
                    char c2 = '\u0000';
                    int n5 = 0;
                    while (n5 < n4) {
                        char c3 = string3.charAt(n5);
                        char c4 = string.charAt(n - n4 + n5);
                        if (c3 == '#') {
                            if (c != '\u0000' && c != c4 || !CharSet.IsConsonant(c4)) break block0;
                            c = c4;
                        } else if (c3 == '$') {
                            if (c2 != '\u0000' && c2 != c4 || !CharSet.IsVowel(c4)) break block0;
                            c2 = c4;
                        } else if (c3 != c4) break block0;
                        ++n5;
                    }
                    String string4 = string.substring(0, n - n4);
                    ((Rule)object).AddAlternatives(this, searchItem, string4, c, c2);
                    break;
                }
                case 2: {
                    int n6 = 0;
                    while (n6 < ((Rule)object).numTokens) {
                        String string5 = (String)((Rule)object).tokens.elementAt(n6);
                        if (string5.equals(string2)) {
                            int n7 = 0;
                            while (n7 < ((Rule)object).numTokens) {
                                if (n7 != n6) {
                                    String string6 = (String)((Rule)object).tokens.elementAt(n7);
                                    this.AddWordAndProcessRules(searchItem, string6, true);
                                }
                                ++n7;
                            }
                        }
                        ++n6;
                    }
                    break;
                }
                case 3: {
                    String string7;
                    if (((Rule)object).numTokens < 2 || !(string7 = (String)((Rule)object).tokens.elementAt(0)).equals(string2)) break;
                    String string8 = (String)((Rule)object).tokens.elementAt(1);
                    this.AddWordAndProcessRules(searchItem, string8, true);
                }
            }
            ++n3;
        }
    }

    public void forgetAllRules() {
        this.rules = null;
        this.numRules = 0;
        this.languageCode = null;
        this.countryCode = null;
        this.description = null;
        this.loaderror = null;
    }

    public void ReadRules(URL uRL, String string) {
        this.FileName = string;
        this.rules = new Vector();
        this.numRules = 0;
        this.languageCode = null;
        this.countryCode = null;
        this.description = null;
        this.loaderror = null;
        try {
            if (uRL == null) {
                return;
            }
            InputStream inputStream = uRL.openStream();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            String string2 = dataInputStream.readLine();
            if (string2 != null) {
                if ((string2 = string2.trim()).equals("1")) {
                    while ((string2 = dataInputStream.readLine()) != null) {
                        this.MakeLineIntoRule(string2);
                    }
                } else if (string2.equals("2")) {
                    try {
                        while (true) {
                            string2 = VirtualDbFile.ReadString(inputStream, true);
                            this.MakeLineIntoRule(string2);
                        }
                    }
                    catch (EOFException eOFException) {}
                }
            }
            inputStream.close();
            this.numRules = this.rules.size();
            return;
        }
        catch (Exception exception) {
            this.loaderror = exception.toString();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean ProcessLine(String var1_1) {
        var2_2 = var1_1.indexOf(42) != -1;
        var3_3 = var2_2 != false ? 1 : 2;
        var4_4 = false;
        var5_5 = ",";
        if (var1_1.indexOf(62) != -1) {
            if (var2_2) {
                return false;
            }
            var5_5 = ">";
            var4_4 = true;
            var3_3 = 3;
        }
        if ((var6_6 = new Vector<Object>()) == null) {
            return false;
        }
        var7_7 = new PHDStringTokenizer(var1_1, var5_5, true);
        if (var7_7 != null) ** GOTO lbl25
        return false;
        while ((var8_8 = var7_7.nextToken()) != null) {
            if (var8_8.length() != 0) {
                if (var2_2) {
                    if (var8_8.charAt(0) != '*' || var8_8.indexOf(42, 1) != -1) {
                        return false;
                    }
                    var8_8 = var8_8.substring(1);
                    var6_6.addElement(var8_8);
                } else {
                    var6_6.addElement(CharSet.ToUnicodeLowerCase((String)var8_8));
                }
            }
lbl25:
            // 5 sources

            if (var7_7.hasMoreTokens()) continue;
        }
        if (var6_6.size() > 0) {
            var8_8 = new Rule(var3_3, var6_6);
            this.rules.addElement(var8_8);
        }
        return true;
    }

    private void MakeLineIntoRule(String string) {
        if (string.length() == 0) {
            return;
        }
        if (this.languageCode == null) {
            this.languageCode = string.substring(0, 2).toLowerCase();
            if (string.length() >= 5) {
                this.countryCode = string.substring(3, 5).toUpperCase();
                return;
            }
            this.countryCode = "";
            return;
        }
        if (this.description == null) {
            this.description = string;
            return;
        }
        if (!this.ProcessLine(string)) {
            System.err.println("Bad rule/No memory: " + string);
        }
    }
}

