/*
 * Decompiled with CFR 0.152.
 */
package com.phdcc.find;

import com.phdcc.find.Caller;
import com.phdcc.find.DbFile;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class MemoryDbFile
implements DbFile {
    private byte[] buffer;
    private int buffersize;
    private int bufferptr;
    private boolean reportLoadError = true;
    private Caller caller;

    public int readnoeof() throws IOException {
        int n;
        if (this.bufferptr < 0 || this.bufferptr >= this.buffersize) {
            return -1;
        }
        if ((n = this.buffer[this.bufferptr++]) < 0) {
            n &= 0xFF;
        }
        return n;
    }

    public MemoryDbFile() {
    }

    public boolean Load(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            int n = 10000;
            this.buffer = new byte[n];
            if (this.buffer == null) {
                return false;
            }
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            while (true) {
                int n4;
                int n5 = n - n2;
                while (n5 != 0) {
                    n4 = inputStream.read(this.buffer, n2, n5);
                    if (n4 == -1) {
                        bl = true;
                        break;
                    }
                    n3 += n4;
                    n5 -= n4;
                    n2 += n4;
                    if (this.caller == null) continue;
                    this.caller.ReportTotalBytesReceived(n3);
                }
                if (bl) break;
                if (n2 != n || n2 != n3) {
                    return false;
                }
                n4 = n * 4;
                if (n4 < n) {
                    return false;
                }
                byte[] byArray = new byte[n4];
                if (byArray == null) {
                    return false;
                }
                System.arraycopy(this.buffer, 0, byArray, 0, n);
                this.buffer = byArray;
                n = n4;
            }
            this.buffersize = n3;
            this.bufferptr = 0;
            inputStream.close();
            byte[] byArray = this.buffer;
            this.buffer = new byte[n3];
            if (this.buffer == null) {
                return false;
            }
            System.arraycopy(byArray, 0, this.buffer, 0, n3);
        }
        catch (Exception exception) {
            if (this.reportLoadError) {
                if (this.caller != null) {
                    this.caller.ReportException(exception);
                } else {
                    exception.printStackTrace();
                }
            }
            return false;
        }
        return true;
    }

    public MemoryDbFile(boolean bl) {
        this.reportLoadError = bl;
    }

    public MemoryDbFile(Caller caller) {
        this.caller = caller;
    }

    public void startUsing() throws IOException {
    }

    public void stopUsing() throws IOException {
    }

    public boolean moveTo(int n) throws IOException {
        this.bufferptr = n;
        return this.bufferptr >= 0 && this.bufferptr < this.buffersize;
    }
}

