/*
 * Decompiled with CFR 0.152.
 */
package com.phdcc.find;

import com.phdcc.find.Caller;
import com.phdcc.find.DbField;
import com.phdcc.find.PrioritisedPageList;
import com.phdcc.find.SearchDb;
import com.phdcc.find.SearchItem;
import com.phdcc.find.SearchWord;
import com.phdcc.find.SignedInt;
import java.io.IOException;
import java.util.Vector;

public class DoSearch {
    private int NUM_PRIORITIES = 4;
    private Caller caller;
    private SearchDb db;
    private int dbno;
    private Vector wordsNotFound;
    private boolean usingPosn1not4 = true;
    private boolean gettingWordCounts;

    private Vector FindContiguousWords(Vector vector) {
        Vector vector2 = null;
        try {
            if (!this.gettingWordCounts) {
                this.db.Posn1.startUsing();
                this.db.Posn2.startUsing();
                this.usingPosn1not4 = true;
            }
            int n = vector.size();
            Vector vector3 = null;
            int n2 = -1;
            n2 = n - 1;
            while (n2 >= 0) {
                vector3 = (Vector)vector.elementAt(n2);
                if (vector3 != null) break;
                --n2;
            }
            if (vector3 == null) {
                return null;
            }
            vector2 = this.LookupPositions(vector, vector3, n2);
            if (!this.gettingWordCounts) {
                this.db.Posn2.stopUsing();
                if (this.usingPosn1not4) {
                    this.db.Posn1.stopUsing();
                } else {
                    this.db.Posn4.stopUsing();
                }
            }
        }
        catch (Exception exception) {
            vector2 = null;
            this.caller.ReportException(exception);
        }
        return vector2;
    }

    private void OperationNOT(Vector vector, int[] nArray) {
        vector.removeAllElements();
        int n = 0;
        int n2 = 0;
        while (n2 < this.db.PageCount) {
            if (nArray[n2] == -1) {
                PrioritisedPageList prioritisedPageList = new PrioritisedPageList();
                prioritisedPageList.dbno = this.dbno;
                prioritisedPageList.priority = 3;
                prioritisedPageList.pageno = n2;
                prioritisedPageList.pos = (byte)3;
                prioritisedPageList.anchorno = 0;
                prioritisedPageList.position = 0;
                prioritisedPageList.ListMatchCaseFirst = false;
                prioritisedPageList.wordcount = 0;
                prioritisedPageList.displayHTMLwords = null;
                vector.addElement(prioritisedPageList);
                nArray[n2] = n++;
            } else {
                nArray[n2] = -1;
            }
            ++n2;
        }
    }

    private Vector EvaluateItem(SearchItem searchItem, boolean bl) {
        if (this.caller.isAborting()) {
            return null;
        }
        Vector vector = new Vector();
        if (vector == null) {
            return null;
        }
        if ((searchItem.operation & 0x40) != 0) {
            vector = this.EvaluateExpression(searchItem.expression);
        } else {
            if (!this.LookupPriorities(vector, searchItem)) {
                return null;
            }
            if (!bl) {
                vector = this.NormalisePageList(vector);
            }
        }
        return vector;
    }

    private void OperationAND(Vector vector, int[] nArray, boolean bl, Vector vector2, int[] nArray2, boolean bl2) {
        if (bl || bl2) {
            if (bl && bl2) {
                return;
            }
            if (bl) {
                int n = vector2.size();
                vector.removeAllElements();
                int n2 = 0;
                while (n2 < n) {
                    vector.addElement(vector2.elementAt(n2));
                    ++n2;
                }
                System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                return;
            }
            return;
        }
        int n = vector.size();
        int n3 = 0;
        while (n3 < n) {
            PrioritisedPageList prioritisedPageList = (PrioritisedPageList)vector.elementAt(n3);
            int n4 = nArray2[prioritisedPageList.pageno];
            if (n4 == -1) {
                nArray[prioritisedPageList.pageno] = -1;
                vector.removeElementAt(n3);
                --n3;
                --n;
            } else {
                nArray[prioritisedPageList.pageno] = n3;
                PrioritisedPageList prioritisedPageList2 = (PrioritisedPageList)vector2.elementAt(n4);
                if (prioritisedPageList2.anchorno < prioritisedPageList.anchorno) {
                    prioritisedPageList.anchorno = prioritisedPageList2.anchorno;
                }
                if (prioritisedPageList2.priority < prioritisedPageList.priority) {
                    prioritisedPageList.priority = prioritisedPageList2.priority;
                }
                prioritisedPageList.wordcount += prioritisedPageList2.wordcount;
            }
            ++n3;
        }
    }

    private int[] DoAdjacentAND(int[] nArray, Vector vector) {
        int[] nArray2 = new int[this.db.PageCount];
        if (nArray2 == null) {
            return null;
        }
        int n = 0;
        while (n < this.db.PageCount) {
            nArray2[n] = -1;
            ++n;
        }
        n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            PrioritisedPageList prioritisedPageList = (PrioritisedPageList)vector.elementAt(n2);
            int n3 = prioritisedPageList.pageno;
            if (nArray[n3] == -1) {
                vector.removeElementAt(n2);
                --n2;
                --n;
            } else {
                nArray2[n3] = 0;
            }
            ++n2;
        }
        return nArray2;
    }

    private Vector EvaluateAdjacentExpression(Vector vector) {
        Object object;
        Vector<Object> vector2 = new Vector<Object>();
        if (vector2 == null) {
            return null;
        }
        int n = vector.size();
        Object object2 = null;
        int n2 = 0;
        while (n2 < n) {
            object = (SearchItem)vector.elementAt(n2);
            if ((((SearchItem)object).operation & 0x20) == 0) {
                object2 = object;
                break;
            }
            vector2.addElement(null);
            ++n2;
        }
        if (object2 == null) {
            return null;
        }
        object = this.EvaluateItem((SearchItem)object2, true);
        if (object == null) {
            return null;
        }
        int[] nArray = this.MakePagePos((Vector)object);
        if (nArray == null) {
            return null;
        }
        if (((Vector)object).size() == 0) {
            return object;
        }
        vector2.addElement(object);
        String string = ((SearchItem)object2).OriginalText;
        int n3 = n2 + 1;
        while (n3 < n) {
            SearchItem searchItem = (SearchItem)vector.elementAt(n3);
            if ((searchItem.operation & 3) != 3) {
                return null;
            }
            Vector vector3 = null;
            if ((searchItem.operation & 0x20) == 0) {
                vector3 = this.EvaluateItem(searchItem, true);
                if (vector3 == null) {
                    return null;
                }
                if (vector3.size() == 0) {
                    return vector3;
                }
                nArray = this.DoAdjacentAND(nArray, vector3);
                if (vector3.size() == 0) {
                    return vector3;
                }
            }
            vector2.addElement(vector3);
            string = string + " " + searchItem.OriginalText;
            ++n3;
        }
        Vector vector4 = this.FindContiguousWords(vector2);
        if (vector4 != null && vector4.size() == 0) {
            this.caller.ReportNotFound(this.caller.Lang((byte)37) + " <B>" + string + "</B>");
        }
        return vector4;
    }

    private boolean EvaluateItemPossibility(SearchItem searchItem) {
        boolean bl;
        boolean bl2 = bl = (searchItem.operation & 0x80) != 0;
        if ((searchItem.operation & 0x40) != 0) {
            boolean bl3 = this.EvaluateExpressionPossibility(searchItem.expression);
            if (bl) {
                return true;
            }
            return bl3;
        }
        if (bl) {
            return true;
        }
        if ((searchItem.operation & 0x20) != 0) {
            return true;
        }
        int n = searchItem.words.size();
        if (n == 0) {
            String string = searchItem.OriginalText;
            if (searchItem.dbfieldno != -1) {
                DbField dbField = (DbField)this.caller.getDb().fields.elementAt(searchItem.dbfieldno);
                string = " [" + dbField.lcname + ":" + string + "]";
            }
            this.wordsNotFound.addElement(string);
            return false;
        }
        return true;
    }

    public Vector DoSearch(Caller caller) {
        this.caller = caller;
        this.db = this.caller.getDb();
        this.dbno = this.caller.getDbNo();
        Vector vector = null;
        this.gettingWordCounts = this.caller.ReadWordCounts();
        try {
            if (this.gettingWordCounts) {
                this.db.Posn1.startUsing();
                this.db.Posn2.startUsing();
                this.usingPosn1not4 = true;
            }
            if ((vector = this.EvaluateExpression(this.caller.getSearchWords())) != null) {
                vector = this.NormalisePageList(vector);
            }
            if (this.gettingWordCounts) {
                this.db.Posn2.stopUsing();
                if (this.usingPosn1not4) {
                    this.db.Posn1.stopUsing();
                } else {
                    this.db.Posn4.stopUsing();
                }
            }
        }
        catch (IOException iOException) {
            vector = null;
        }
        return vector;
    }

    private boolean LookupPageList(Vector vector, int n, int n2, boolean bl) {
        try {
            this.db.PageList.startUsing();
            this.db.PageList.moveTo(n2);
            boolean bl2 = false;
            while (!bl2) {
                int n3 = this.db.PageList.ReadUnsignedInt(this.db.PageNoBytes);
                int n4 = this.db.PageList.readeof();
                if ((n4 & 0x80) != 0) {
                    bl2 = true;
                    n4 &= 0x7F;
                }
                byte by = (byte)(n4 & 0x1F);
                int n5 = n4 >> 5;
                int n6 = 0;
                switch (n5) {
                    case 0: {
                        n6 = this.db.PageList.ReadUnsignedInt(this.db.posn1size);
                        break;
                    }
                    case 1: {
                        n6 = this.db.PageList.ReadUnsignedInt(this.db.posn2size);
                        break;
                    }
                    case 3: {
                        n6 = this.db.PageList.ReadUnsignedInt(this.db.posn4size);
                    }
                }
                PrioritisedPageList prioritisedPageList = new PrioritisedPageList();
                prioritisedPageList.dbno = this.dbno;
                prioritisedPageList.priority = n;
                prioritisedPageList.pageno = n3;
                prioritisedPageList.pos = (byte)(n5 + 1);
                prioritisedPageList.anchorno = by;
                prioritisedPageList.position = n6;
                prioritisedPageList.wordcount = 0;
                prioritisedPageList.ListMatchCaseFirst = bl;
                prioritisedPageList.displayHTMLwords = null;
                vector.addElement(prioritisedPageList);
                if (this.gettingWordCounts) {
                    this.ReadPositions(prioritisedPageList);
                }
                if (this.caller.isAborting()) break;
            }
            this.db.PageList.stopUsing();
        }
        catch (Exception exception) {
            this.caller.ReportException(exception);
            return false;
        }
        return true;
    }

    private Vector NormalisePageList(Vector vector) {
        PrioritisedPageList[] prioritisedPageListArray = new PrioritisedPageList[this.db.PageCount];
        if (prioritisedPageListArray == null) {
            return null;
        }
        int n = 0;
        while (n < this.db.PageCount) {
            prioritisedPageListArray[n] = null;
            ++n;
        }
        int[] nArray = new int[this.NUM_PRIORITIES];
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[this.NUM_PRIORITIES];
        if (nArray2 == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.NUM_PRIORITIES) {
            nArray[n2] = 0;
            nArray2[n2] = 0;
            ++n2;
        }
        Vector<PrioritisedPageList> vector2 = new Vector<PrioritisedPageList>();
        if (vector2 == null) {
            return null;
        }
        int n3 = vector.size();
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            int n6;
            PrioritisedPageList prioritisedPageList = (PrioritisedPageList)vector.elementAt(n4);
            PrioritisedPageList prioritisedPageList2 = prioritisedPageListArray[prioritisedPageList.pageno];
            if (prioritisedPageList2 != null) {
                prioritisedPageList2.wordcount += prioritisedPageList.wordcount;
                if (prioritisedPageList.anchorno < prioritisedPageList2.anchorno) {
                    prioritisedPageList2.anchorno = prioritisedPageList.anchorno;
                }
                if (prioritisedPageList.priority < prioritisedPageList2.priority) {
                    n6 = vector2.indexOf(prioritisedPageList2);
                    if (n6 == -1) {
                        return null;
                    }
                    vector2.removeElementAt(n6);
                    prioritisedPageList2.priority = prioritisedPageList.priority;
                    prioritisedPageList = prioritisedPageList2;
                    n5 = 0;
                    while (n5 < this.NUM_PRIORITIES) {
                        if (nArray[n5] > n6) {
                            int n7 = n5;
                            nArray[n7] = nArray[n7] + -1;
                        }
                        if (nArray2[n5] > n6) {
                            int n8 = n5;
                            nArray2[n8] = nArray2[n8] + -1;
                        }
                        ++n5;
                    }
                }
            } else if (prioritisedPageList.ListMatchCaseFirst) {
                n6 = nArray[prioritisedPageList.priority];
                vector2.insertElementAt(prioritisedPageList, n6);
                prioritisedPageListArray[prioritisedPageList.pageno] = prioritisedPageList;
                n5 = prioritisedPageList.priority;
                while (n5 < this.NUM_PRIORITIES) {
                    int n9 = n5;
                    nArray[n9] = nArray[n9] + 1;
                    int n10 = n5++;
                    nArray2[n10] = nArray2[n10] + 1;
                }
            } else {
                n6 = nArray2[prioritisedPageList.priority];
                vector2.insertElementAt(prioritisedPageList, n6);
                prioritisedPageListArray[prioritisedPageList.pageno] = prioritisedPageList;
                n5 = prioritisedPageList.priority;
                while (n5 < this.NUM_PRIORITIES) {
                    if (n5 > prioritisedPageList.priority) {
                        int n11 = n5;
                        nArray[n11] = nArray[n11] + 1;
                    }
                    int n12 = n5++;
                    nArray2[n12] = nArray2[n12] + 1;
                }
            }
            ++n4;
        }
        return vector2;
    }

    private int[] MakePagePos(Vector vector) {
        int[] nArray = new int[this.db.PageCount];
        if (nArray == null) {
            return null;
        }
        int n = 0;
        while (n < this.db.PageCount) {
            nArray[n] = -1;
            ++n;
        }
        n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            PrioritisedPageList prioritisedPageList = (PrioritisedPageList)vector.elementAt(n2);
            nArray[prioritisedPageList.pageno] = n2++;
        }
        return nArray;
    }

    public Vector SearchResultsPossible(Caller caller) {
        this.caller = caller;
        this.db = this.caller.getDb();
        this.wordsNotFound = new Vector();
        if (this.wordsNotFound == null) {
            this.caller.ReportError("Sorry, not enough memory");
            return null;
        }
        boolean bl = this.EvaluateExpressionPossibility(this.caller.getSearchWords());
        if (!bl) {
            return this.wordsNotFound;
        }
        return null;
    }

    private Vector LookupPositions(Vector vector, Vector vector2, int n) throws IOException {
        int n2 = vector2.size();
        if (n2 == 0) {
            return null;
        }
        Vector<PrioritisedPageList> vector3 = new Vector<PrioritisedPageList>();
        int n3 = 0;
        while (n3 < n2) {
            int[] nArray;
            PrioritisedPageList prioritisedPageList = (PrioritisedPageList)vector2.elementAt(n3);
            if (prioritisedPageList.pos != 3 && this.LookupContiguousPositions(vector, nArray = this.ReadPositions(prioritisedPageList), prioritisedPageList, n)) {
                vector3.addElement(prioritisedPageList);
            }
            if (this.caller.isAborting()) break;
            ++n3;
        }
        return vector3;
    }

    private int[] mergeContiguousPositions(Vector vector, int n) {
        int n2 = vector.size();
        if (n2 == 0) {
            return null;
        }
        int[] nArray = (int[])vector.elementAt(0);
        if (n2 == 1) {
            return nArray;
        }
        int[][] nArrayArray = new int[n2][];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArrayArray[n3] = (int[])vector.elementAt(n3);
            nArray2[n3] = nArrayArray[n3].length;
            nArray3[n3] = 0;
            ++n3;
        }
        int[] nArray4 = new int[n];
        int n4 = 0;
        while (true) {
            int n5 = -1;
            int n6 = -1;
            int n7 = 0;
            while (n7 < n2) {
                int n8 = nArray3[n7];
                if (n8 < nArray2[n7]) {
                    if (n6 == -1) {
                        n6 = n7;
                        n5 = nArrayArray[n7][n8];
                    } else {
                        int n9 = nArrayArray[n7][n8];
                        if (n9 < n5) {
                            n6 = n7;
                            n5 = n9;
                        }
                    }
                }
                ++n7;
            }
            if (n6 == -1) break;
            int n10 = n6;
            nArray3[n10] = nArray3[n10] + 1;
            nArray4[n4++] = n5;
        }
        if (n4 == n) {
            return nArray4;
        }
        int[] nArray5 = new int[n4];
        System.arraycopy(nArray4, 0, nArray5, 0, n4);
        return nArray5;
    }

    private int[] ReadPositions(PrioritisedPageList prioritisedPageList) throws IOException {
        Object object;
        if (prioritisedPageList.pos == 1 && !this.usingPosn1not4) {
            this.db.Posn4.stopUsing();
            this.db.Posn1.startUsing();
            this.usingPosn1not4 = true;
        }
        if (prioritisedPageList.pos == 4 && this.usingPosn1not4) {
            this.db.Posn1.stopUsing();
            this.db.Posn4.startUsing();
            this.usingPosn1not4 = false;
        }
        switch (prioritisedPageList.pos) {
            case 1: {
                this.db.Posn1.moveTo(prioritisedPageList.position);
                break;
            }
            case 2: {
                this.db.Posn2.moveTo(prioritisedPageList.position << 1);
                break;
            }
            case 4: {
                this.db.Posn4.moveTo(prioritisedPageList.position << 2);
                break;
            }
            default: {
                return null;
            }
        }
        int n = 10;
        int[] nArray = new int[n];
        int n2 = 0;
        boolean bl = false;
        while (!bl) {
            switch (prioritisedPageList.pos) {
                case 1: {
                    object = new SignedInt(1, this.db.Posn1);
                    break;
                }
                case 2: {
                    object = new SignedInt(2, this.db.Posn2);
                    break;
                }
                case 4: {
                    object = new SignedInt(4, this.db.Posn4);
                    break;
                }
                default: {
                    return null;
                }
            }
            bl = object.atend;
            if (n2 >= n) {
                int n3 = n << 1;
                int[] nArray2 = new int[n3];
                System.arraycopy(nArray, 0, nArray2, 0, n);
                n = n3;
                nArray = nArray2;
            }
            nArray[n2++] = object.value;
        }
        prioritisedPageList.wordcount = n2;
        if (n2 == n) {
            return nArray;
        }
        object = new int[n2];
        System.arraycopy(nArray, 0, object, 0, n2);
        return object;
    }

    private boolean LookupPriorities(Vector vector, SearchItem searchItem) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            SearchWord searchWord;
            this.db.PriorityList.startUsing();
            int n5 = searchItem.words.size();
            int n6 = 0;
            while (n6 < n5) {
                searchWord = (SearchWord)searchItem.words.elementAt(n6);
                n4 = searchWord.priorityNo_plePtr;
                n3 = 0;
                searchWord.priorityEntries = new int[this.NUM_PRIORITIES];
                if (searchWord.priorityEntries == null) {
                    return false;
                }
                if (searchItem.dbfieldno == -1) {
                    n2 = n4 * this.db.plpsize;
                    n = 0;
                    while (n == 0) {
                        if (n3 == this.NUM_PRIORITIES) {
                            return false;
                        }
                        this.db.PriorityList.moveTo(n2);
                        SignedInt signedInt = new SignedInt(this.db.plpsize, this.db.PriorityList);
                        searchWord.priorityEntries[n3++] = signedInt.value;
                        n = signedInt.atend ? 1 : 0;
                        n2 += this.db.plpsize;
                    }
                    if (n3 != this.NUM_PRIORITIES) {
                        searchWord.priorityEntries[n3] = -1;
                    }
                } else {
                    searchWord.priorityEntries[n3++] = n4 << 2;
                    searchWord.priorityEntries[n3] = -1;
                }
                if (this.caller.isAborting()) break;
                ++n6;
            }
            this.db.PriorityList.stopUsing();
            n6 = 0;
            while (n6 < n5) {
                searchWord = (SearchWord)searchItem.words.elementAt(n6);
                n4 = 0;
                while (n4 < this.NUM_PRIORITIES) {
                    n3 = searchWord.priorityEntries[n4];
                    if (n3 == -1) break;
                    n2 = n3 & 3;
                    n = n3 >> 2;
                    if (!this.LookupPageList(vector, n2, n, searchWord.ListMatchCaseFirst)) {
                        return false;
                    }
                    ++n4;
                }
                ++n6;
            }
        }
        catch (Exception exception) {
            this.caller.ReportException(exception);
            return false;
        }
        return true;
    }

    private boolean LookupContiguousPositions(Vector vector, int[] nArray, PrioritisedPageList prioritisedPageList, int n) throws IOException {
        int n2 = vector.size();
        if (n2 == 1) {
            return false;
        }
        int n3 = prioritisedPageList.pageno;
        int n4 = prioritisedPageList.priority;
        int[] nArray2 = nArray;
        byte by = 32;
        int n5 = n - 1;
        while (n5 >= 0) {
            Vector vector2 = (Vector)vector.elementAt(n5);
            if (vector2 != null) {
                int n6 = n - n5;
                int n7 = vector2.size();
                Vector<int[]> vector3 = new Vector<int[]>();
                int n8 = 0;
                while (n8 < n7) {
                    int[] nArray3;
                    int[] nArray4;
                    PrioritisedPageList prioritisedPageList2 = (PrioritisedPageList)vector2.elementAt(n8);
                    if (prioritisedPageList2.pageno == n3 && prioritisedPageList2.priority == n4 && (nArray4 = this.LookforContiguity(nArray2, nArray3 = this.ReadPositions(prioritisedPageList2), n6)) != null) {
                        vector3.addElement(nArray4);
                        if (prioritisedPageList2.anchorno < by) {
                            by = prioritisedPageList2.anchorno;
                        }
                    }
                    ++n8;
                }
                if (vector3.size() == 0) {
                    return false;
                }
                nArray2 = this.mergeContiguousPositions(vector3, nArray2.length);
                n = n5;
            }
            --n5;
        }
        prioritisedPageList.wordcount = nArray2.length;
        if (by != 32 && by > prioritisedPageList.anchorno) {
            prioritisedPageList.anchorno = by;
        }
        return true;
    }

    private boolean EvaluateExpressionPossibility(Vector vector) {
        int n = vector.size();
        if (n == 0) {
            return true;
        }
        SearchItem searchItem = (SearchItem)vector.elementAt(0);
        boolean bl = this.EvaluateItemPossibility(searchItem);
        boolean bl2 = (searchItem.operation & 3) == 2;
        int n2 = 1;
        while (n2 < n) {
            SearchItem searchItem2 = (SearchItem)vector.elementAt(n2);
            boolean bl3 = this.EvaluateItemPossibility(searchItem2);
            bl = bl2 ? bl || bl3 : bl && bl3;
            bl2 = (searchItem2.operation & 3) == 2;
            ++n2;
        }
        return bl;
    }

    private int[] LookforContiguity(int[] nArray, int[] nArray2, int n) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        if (n2 == 0 || n3 == 0) {
            return null;
        }
        int[] nArray3 = new int[n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        block0: while (n6 < n2) {
            int n7 = nArray[n6];
            while (n5 != n3) {
                int n8;
                if (n7 == (n8 = nArray2[n5++]) + n) {
                    nArray3[n4++] = n8;
                    ++n5;
                } else if (n8 < n7) continue;
                --n5;
                ++n6;
                continue block0;
            }
            break block0;
        }
        if (n4 == 0) {
            return null;
        }
        if (n4 == n2) {
            return nArray3;
        }
        int[] nArray4 = new int[n4];
        System.arraycopy(nArray3, 0, nArray4, 0, n4);
        return nArray4;
    }

    private void OperationOR(Vector vector, int[] nArray, boolean bl, Vector vector2, int[] nArray2, boolean bl2) {
        if (bl || bl2) {
            if (bl && bl2) {
                return;
            }
            if (bl) {
                int n = vector2.size();
                vector.removeAllElements();
                int n2 = 0;
                while (n2 < n) {
                    vector.addElement(vector2.elementAt(n2));
                    ++n2;
                }
                System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                return;
            }
            return;
        }
        int n = vector2.size();
        int n3 = 0;
        while (n3 < n) {
            PrioritisedPageList prioritisedPageList = (PrioritisedPageList)vector2.elementAt(n3);
            int n4 = nArray[prioritisedPageList.pageno];
            if (n4 == -1) {
                vector.addElement(prioritisedPageList);
                nArray[prioritisedPageList.pageno] = vector.size() - 1;
            } else {
                PrioritisedPageList prioritisedPageList2 = (PrioritisedPageList)vector.elementAt(n4);
                if (prioritisedPageList.anchorno < prioritisedPageList2.anchorno) {
                    prioritisedPageList2.anchorno = prioritisedPageList.anchorno;
                }
                if (prioritisedPageList.priority < prioritisedPageList2.priority) {
                    prioritisedPageList2.priority = prioritisedPageList.priority;
                }
                prioritisedPageList2.wordcount += prioritisedPageList.wordcount;
            }
            ++n3;
        }
    }

    private Vector EvaluateExpression(Vector vector) {
        Vector vector2 = new Vector();
        int n = vector.size();
        if (n == 0) {
            return vector2;
        }
        SearchItem searchItem = (SearchItem)vector.elementAt(0);
        int n2 = searchItem.operation & 3;
        if (n2 == 3 && n > 1) {
            return this.EvaluateAdjacentExpression(vector);
        }
        boolean bl = (searchItem.operation & 0x20) != 0;
        boolean bl2 = (searchItem.operation & 0x80) != 0;
        vector2 = bl ? new Vector() : this.EvaluateItem(searchItem, false);
        if (vector2 == null) {
            return null;
        }
        int[] nArray = this.MakePagePos(vector2);
        if (nArray == null) {
            return null;
        }
        if (bl2 && !bl) {
            this.OperationNOT(vector2, nArray);
        }
        int n3 = 1;
        while (n3 < n) {
            SearchItem searchItem2 = (SearchItem)vector.elementAt(n3);
            boolean bl3 = (searchItem2.operation & 0x20) != 0;
            boolean bl4 = (searchItem2.operation & 0x80) != 0;
            Vector vector3 = bl3 ? new Vector() : this.EvaluateItem(searchItem2, false);
            if (vector3 == null) {
                return null;
            }
            int[] nArray2 = this.MakePagePos(vector3);
            if (nArray2 == null) {
                return null;
            }
            if (bl4 && !bl3) {
                this.OperationNOT(vector3, nArray2);
            }
            switch (n2) {
                case 0: 
                case 1: {
                    this.OperationAND(vector2, nArray, bl, vector3, nArray2, bl3);
                    break;
                }
                case 2: {
                    this.OperationOR(vector2, nArray, bl, vector3, nArray2, bl3);
                    break;
                }
                case 3: {
                    this.caller.ReportError("Bad SearchItem.OPERATION_ADJACENT");
                    return null;
                }
                default: {
                    this.caller.ReportError("Unrecognised operation " + n2);
                    return null;
                }
            }
            n2 = searchItem2.operation & 3;
            bl = bl && bl3;
            ++n3;
        }
        return vector2;
    }
}

