/*
 * Decompiled with CFR 0.152.
 */
package com.phdcc.find;

import com.phdcc.find.Caller;
import com.phdcc.find.CharSet;
import com.phdcc.find.DbField;
import com.phdcc.find.RuleSet;
import com.phdcc.find.SearchDb;
import com.phdcc.find.SearchField;
import com.phdcc.find.SearchItem;
import com.phdcc.find.SearchWord;
import com.phdcc.find.SignedInt;
import com.phdcc.find.VirtualDbFile;
import com.phdcc.find.WildSearchItem;
import com.phdcc.lang.Language;
import java.io.EOFException;
import java.util.Vector;

public class BuildSearchWords {
    private Caller caller;
    private SearchDb db;
    private Vector currentExpression;
    private int currentDbFieldNo;
    private StringBuffer currentWord;
    private boolean inDquotes;
    private boolean inSoftDquotes;
    private boolean inSquotes;
    private int parentheses;
    private boolean nextIsNOT;
    private SearchItem lastSearchItem;
    private Vector parents;
    private String ANDupper = "AND";
    private String ANDlower = "and";
    private String ORupper = "OR";
    private String ORlower = "or";
    private String NOTupper = "NOT";
    private String NOTlower = "not";
    Vector outWords;
    int MatchCaseInsertPos;
    boolean AnyCaseMatchersFound;

    private void StopExpression() {
        if (this.nextIsNOT) {
            this.caller.ReportError(this.NOTupper + this.caller.Lang((byte)55));
            return;
        }
        Vector vector = this.currentExpression;
        this.currentExpression = (Vector)this.parents.elementAt(this.parents.size() - 1);
        boolean bl = false;
        if (vector.size() == 1 && (this.lastSearchItem.operation & 0x20) != 0) {
            bl = true;
        }
        this.parents.removeElement(this.currentExpression);
        int n = this.currentExpression.size();
        if (this.lastSearchItem == null) {
            this.currentExpression.removeElementAt(--n);
        }
        this.lastSearchItem = null;
        if (n > 0) {
            this.lastSearchItem = (SearchItem)this.currentExpression.lastElement();
            if (bl) {
                this.lastSearchItem.operation |= 0x20;
            }
        }
    }

    private void StoreSearchWord() {
        SearchWord searchWord;
        SearchItem searchItem;
        if (Language.StartsWithArabicThe(this.currentWord)) {
            this.currentWord = new StringBuffer(this.currentWord.toString().substring(2));
        }
        if (this.currentWord.length() == 0) {
            return;
        }
        String string = this.currentWord.toString();
        String string2 = CharSet.ToUnicodeLowerCase(string);
        if (this.inSoftDquotes && (string2.equals(this.ANDlower) || string2.equals(this.ORlower) || string2.equals(this.NOTlower))) {
            this.inSoftDquotes = false;
            this.inDquotes = false;
            if (this.lastSearchItem != null) {
                this.lastSearchItem.lastword = true;
            }
            this.StopExpression();
        }
        if (!this.inDquotes) {
            if (string2.equals(this.ANDlower)) {
                if (this.lastSearchItem == null || (this.lastSearchItem.operation & 3) != 0) {
                    this.caller.ReportError(this.ANDupper + this.caller.Lang((byte)55));
                    return;
                }
                if (this.nextIsNOT) {
                    this.caller.ReportError(this.NOTupper + this.caller.Lang((byte)55));
                    return;
                }
                this.lastSearchItem.operation = (this.lastSearchItem.operation & 0xE0) + 1;
                this.currentWord.setLength(0);
                return;
            }
            if (string2.equals(this.ORlower)) {
                if (this.lastSearchItem == null || (this.lastSearchItem.operation & 3) != 0) {
                    this.caller.ReportError(this.ORupper + this.caller.Lang((byte)55));
                    return;
                }
                if (this.nextIsNOT) {
                    this.caller.ReportError(this.NOTupper + this.caller.Lang((byte)55));
                    return;
                }
                this.lastSearchItem.operation = (this.lastSearchItem.operation & 0xE0) + 2;
                this.currentWord.setLength(0);
                return;
            }
            if (string2.equals(this.NOTlower)) {
                this.nextIsNOT = !this.nextIsNOT;
                this.currentWord.setLength(0);
                return;
            }
        }
        boolean bl = false;
        if (this.db.StopWords != null && this.db.StopWords.containsKey(string2)) {
            bl = true;
            this.caller.ReportStopWord(string);
        }
        if (this.inSquotes && (string.indexOf(42) != -1 || string.indexOf(63) != -1)) {
            this.caller.ReportError((byte)56);
            return;
        }
        if (this.inDquotes && string.equals("*")) {
            if (!this.inSoftDquotes) {
                this.caller.ReportError((byte)61);
                return;
            }
            this.inSoftDquotes = false;
            this.inDquotes = false;
            int n = this.currentExpression.size();
            int n2 = 0;
            while (n2 < n) {
                SearchItem searchItem2 = (SearchItem)this.currentExpression.elementAt(n2);
                searchItem2.operation = (searchItem2.operation & 0xE0) + 0;
                ++n2;
            }
            this.StopExpression();
        }
        if ((searchItem = new SearchItem(string, this.currentDbFieldNo)) == null) {
            this.caller.ReportError("Sorry, not enough memory");
            return;
        }
        searchItem.words = new Vector();
        if (searchItem.words == null) {
            this.caller.ReportError("Sorry, not enough memory");
            return;
        }
        searchItem.matchCase = this.inSquotes;
        searchItem.wordno = this.lastSearchItem == null ? 0 : this.lastSearchItem.wordno + 1;
        searchItem.lastword = false;
        searchItem.parentexpr = this.currentExpression;
        searchItem.ListMatchCaseFirst = false;
        int n = searchItem.operation = bl ? 32 : 0;
        if (this.inDquotes) {
            searchItem.operation |= 3;
        }
        if (this.nextIsNOT) {
            searchItem.operation |= 0x80;
        }
        if ((searchWord = new SearchWord(string)) == null) {
            this.caller.ReportError("Sorry, not enough memory");
            return;
        }
        searchItem.words.addElement(searchWord);
        boolean bl2 = false;
        if (!this.inSquotes) {
            if (string.equals("*")) {
                searchItem.words.removeAllElements();
                searchItem.operation ^= 0x80;
                bl2 = true;
            } else {
                bl2 = this.AddWildCardsStemsAndSynonyms(searchItem, string);
            }
        }
        if (!bl2 && !bl) {
            this.LookupWords(searchItem, this.inSquotes);
        }
        this.currentExpression.addElement(searchItem);
        this.lastSearchItem = searchItem;
        this.currentWord.setLength(0);
        this.nextIsNOT = false;
    }

    private void LookupFieldWord(SearchItem searchItem, String string, String string2, boolean bl) throws Exception {
        int n;
        DbField dbField = (DbField)this.db.fields.elementAt(searchItem.dbfieldno);
        VirtualDbFile virtualDbFile = this.db.FieldsWordListFile;
        virtualDbFile.moveTo(dbField.fwlptr);
        do {
            String string3;
            if ((string3 = virtualDbFile.ReadString(false)).length() == 0) {
                return;
            }
            int n2 = virtualDbFile.ReadDword();
            String string4 = CharSet.ToUnicodeLowerCase(string3);
            n = string2.compareTo(string4);
            if (n != 0) continue;
            boolean bl2 = true;
            if (bl && !string.equals(string3)) {
                bl2 = false;
            }
            if (!bl2) continue;
            this.addSearchWord(string3, n2, searchItem, string);
            if (!bl) continue;
            return;
        } while (n >= 0);
    }

    private void LookupDbWord(SearchItem searchItem, String string, String string2, boolean bl) throws Exception {
        int n;
        int n2 = SearchDb.stringHashCode(string2) % this.db.hashtableentries;
        int n3 = 0;
        boolean bl2 = false;
        block0: while ((n = this.db.WordHashTableIsShort ? this.db.ShortWordHashTable[n2] : this.db.IntWordHashTable[n2]) != 0) {
            this.db.WordList.moveTo(n);
            SignedInt signedInt = new SignedInt(this.db.prionosize, this.db.WordList);
            int n4 = signedInt.value;
            boolean bl3 = signedInt.atend;
            String string3 = this.db.WordList.ReadString();
            if (CharSet.ToUnicodeLowerCase(string3).equals(string2)) {
                bl2 = true;
                if (bl && !string3.equals(string)) {
                    bl2 = false;
                }
                if (bl2) {
                    this.addSearchWord(string3, n4, searchItem, string);
                }
                if (bl && bl2) break;
                while (!bl3) {
                    signedInt = new SignedInt(this.db.prionosize, this.db.WordList);
                    n4 = signedInt.value;
                    bl3 = signedInt.atend;
                    string3 = this.db.WordList.ReadString();
                    if (bl && string3.equals(string)) {
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    this.addSearchWord(string3, n4, searchItem, string);
                    if (bl) break block0;
                }
                return;
            }
            if (++n2 == this.db.hashtableentries) {
                n2 = 0;
            }
            ++n3;
        }
    }

    private void WildCardSearch(Vector vector, String string) {
        int n;
        vector.removeAllElements();
        while ((n = string.indexOf("**")) != -1) {
            string = string.substring(0, n) + string.substring(n + 1);
        }
        string = CharSet.ToUnicodeLowerCase(string);
        Vector vector2 = this.GetWildSearchItems(string);
        int n2 = vector2.size();
        WildSearchItem wildSearchItem = (WildSearchItem)vector2.elementAt(0);
        WildSearchItem wildSearchItem2 = (WildSearchItem)vector2.elementAt(n2 - 1);
        try {
            this.db.WordList.moveTo(1);
            while (!this.caller.isAborting()) {
                SignedInt signedInt = new SignedInt(this.db.prionosize, this.db.WordList);
                int n3 = signedInt.value;
                String string2 = this.db.WordList.ReadString();
                if (!this.WildCardMatch(CharSet.ToUnicodeLowerCase(string2), vector2, wildSearchItem, wildSearchItem2)) continue;
                SearchWord searchWord = new SearchWord(string2, n3);
                if (searchWord == null) {
                    this.caller.ReportError("Sorry, not enough memory");
                    return;
                }
                vector.addElement(searchWord);
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            this.caller.ReportException(exception);
        }
        vector2.removeAllElements();
        vector2 = null;
    }

    private boolean SearchItemMatch(String string, Vector vector, int n, int n2) {
        if (n > n2) {
            return true;
        }
        WildSearchItem wildSearchItem = (WildSearchItem)vector.elementAt(n);
        if (wildSearchItem.str != null) {
            if (!string.startsWith(wildSearchItem.str)) {
                return false;
            }
            string = string.substring(wildSearchItem.strlen);
            return this.SearchItemMatch(string, vector, n + 1, n2);
        }
        int n3 = string.length();
        if (wildSearchItem.asterisk) {
            if (n == n2) {
                return true;
            }
            if (this.SearchItemMatch(string, vector, n + 1, n2)) {
                return true;
            }
            int n4 = 1;
            while (n4 < n3) {
                String string2 = string.substring(n4);
                if (this.SearchItemMatch(string2, vector, n + 1, n2)) {
                    return true;
                }
                ++n4;
            }
            return false;
        }
        if (wildSearchItem.onechar) {
            if (n3 == 0) {
                return false;
            }
            string = string.substring(1);
            if (n == n2) {
                return n3 == 1;
            }
            return this.SearchItemMatch(string, vector, n + 1, n2);
        }
        return false;
    }

    private int FindDbFieldNo(SearchField searchField) {
        if (this.db.fields == null) {
            return -1;
        }
        int n = this.db.fields.size();
        int n2 = 0;
        while (n2 < n) {
            DbField dbField = (DbField)this.db.fields.elementAt(n2);
            int n3 = searchField.lcname.compareTo(dbField.lcname);
            if (n3 == 0) {
                return n2;
            }
            if (n3 < 0) break;
            ++n2;
        }
        return -1;
    }

    public void doBuildSearchWords(char[] cArray, int n) {
        this.currentWord = new StringBuffer(n);
        if (this.currentWord == null) {
            return;
        }
        this.currentWord.setLength(0);
        this.parents = new Vector();
        if (this.parents == null) {
            this.caller.ReportError("Sorry, not enough memory");
            return;
        }
        this.inDquotes = false;
        this.inSoftDquotes = false;
        this.inSquotes = false;
        this.parentheses = 0;
        this.nextIsNOT = false;
        this.lastSearchItem = null;
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = CharSet.MapUnicodeChar(cArray[n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.caller.isAborting()) {
                return;
            }
            char c = cArray[n2];
            if (c == '\"') {
                this.StoreSearchWord();
                if (this.inSoftDquotes) {
                    this.inSoftDquotes = false;
                } else {
                    boolean bl = this.inDquotes = !this.inDquotes;
                    if (this.inDquotes) {
                        this.StartExpression();
                    } else {
                        if (this.lastSearchItem != null) {
                            this.lastSearchItem.lastword = true;
                        }
                        this.StopExpression();
                    }
                }
            } else if (c == '\'') {
                int n3;
                boolean bl;
                boolean bl2 = n2 == n - 1;
                boolean bl3 = this.currentWord.length() == 0;
                boolean bl4 = bl = !bl3;
                if (bl3 && !bl2) {
                    bl3 = false;
                    n3 = n2 + 1;
                    while (n3 < n) {
                        if (cArray[n3] == '\'') {
                            bl3 = true;
                            break;
                        }
                        ++n3;
                    }
                }
                n3 = 0;
                if (bl && !bl2 && !CharSet.IsUnicodeSpace(cArray[n2 + 1])) {
                    n3 = 1;
                    bl = false;
                }
                if (bl3) {
                    this.inSquotes = true;
                }
                if (n3 != 0 && !this.inDquotes) {
                    this.inDquotes = true;
                    this.inSoftDquotes = true;
                    this.StartExpression();
                }
                this.StoreSearchWord();
                if (bl) {
                    this.inSquotes = false;
                }
            } else if (c == '(') {
                if (this.inDquotes) {
                    this.caller.ReportError((byte)54);
                    return;
                }
                this.StoreSearchWord();
                this.StartExpression();
            } else if (c == ')') {
                this.StoreSearchWord();
                this.StopExpression();
            } else if (CharSet.IsUnicodeSpace(c) && c != '*' && c != '?') {
                this.StoreSearchWord();
                if (this.inSoftDquotes) {
                    this.inSoftDquotes = false;
                    this.inDquotes = false;
                    if (this.lastSearchItem != null) {
                        this.lastSearchItem.lastword = true;
                    }
                    this.StopExpression();
                }
            } else if (CharSet.IsUnicodeSeparator(c) && c != '*' && c != '?') {
                if (!this.inDquotes) {
                    this.inDquotes = true;
                    this.inSoftDquotes = true;
                    this.StartExpression();
                }
                this.StoreSearchWord();
            } else if (!CharSet.IsUnicodeCharLatin(c)) {
                this.StoreSearchWord();
                if (!this.inDquotes) {
                    this.inDquotes = true;
                    this.inSoftDquotes = true;
                    this.StartExpression();
                }
                this.currentWord.append(c);
                this.StoreSearchWord();
            } else {
                this.currentWord.append(c);
            }
            ++n2;
        }
        this.StoreSearchWord();
        if (this.nextIsNOT) {
            this.caller.ReportError(this.NOTupper + this.caller.Lang((byte)55));
            return;
        }
        if (this.inSoftDquotes) {
            if (this.lastSearchItem != null) {
                this.lastSearchItem.lastword = true;
            }
            this.StopExpression();
        }
    }

    private boolean WildCardMatch(String string, Vector vector, WildSearchItem wildSearchItem, WildSearchItem wildSearchItem2) {
        boolean bl;
        int n = string.length();
        int n2 = vector.size();
        boolean bl2 = wildSearchItem.str != null;
        boolean bl3 = bl = ((WildSearchItem)vector.elementAt((int)(n2 - 1))).str != null;
        if (n2 == 1) {
            if (wildSearchItem.asterisk) {
                return true;
            }
            return n == 1;
        }
        int n3 = 0;
        int n4 = n2 - 1;
        if (bl2) {
            if (!string.startsWith(wildSearchItem.str)) {
                return false;
            }
            string = string.substring(wildSearchItem.strlen);
            n -= wildSearchItem.strlen;
            ++n3;
        }
        if (bl) {
            if (!string.endsWith(wildSearchItem2.str)) {
                return false;
            }
            string = string.substring(0, n - wildSearchItem2.strlen);
            n -= wildSearchItem2.strlen;
            --n4;
        }
        if (n3 == n4) {
            WildSearchItem wildSearchItem3 = (WildSearchItem)vector.elementAt(n3);
            if (wildSearchItem3.asterisk) {
                return true;
            }
            return n == 1;
        }
        return this.SearchItemMatch(string, vector, n3, n4);
    }

    private void addSearchWord(String string, int n, SearchItem searchItem, String string2) {
        SearchWord searchWord = new SearchWord(string, n);
        if (searchWord == null) {
            return;
        }
        if (searchItem.ListMatchCaseFirst && string.equals(string2)) {
            this.outWords.insertElementAt(searchWord, this.MatchCaseInsertPos++);
            searchWord.ListMatchCaseFirst = true;
            this.AnyCaseMatchersFound = true;
            return;
        }
        this.outWords.addElement(searchWord);
    }

    private void StoreOperatorNames(Language language) {
        String string = language.Lang((byte)57);
        if (string == null) {
            string = "AND";
        }
        this.ANDupper = string;
        this.ANDlower = CharSet.ToUnicodeLowerCase(string);
        String string2 = language.Lang((byte)58);
        if (string2 == null) {
            string2 = "OR";
        }
        this.ORupper = string2;
        this.ORlower = CharSet.ToUnicodeLowerCase(string2);
        String string3 = language.Lang((byte)59);
        if (string3 == null) {
            string3 = "NOT";
        }
        this.NOTupper = string3;
        this.NOTlower = CharSet.ToUnicodeLowerCase(string3);
    }

    public boolean BasicCheck(Caller caller, char[] cArray, int n, Vector vector) {
        if (!this.BasicCheck(caller, cArray, n)) {
            return false;
        }
        if (vector == null) {
            return true;
        }
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            SearchField searchField = (SearchField)vector.elementAt(n3);
            if (!this.BasicCheck(caller, searchField.SearchText, searchField.SearchTextLen)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean BasicCheck(Caller caller, char[] cArray, int n) {
        SearchDb searchDb = caller.getDb();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char c = cArray[n4];
            if (c == '\"') {
                ++n2;
            }
            if (c == '(') {
                ++n3;
            }
            if (c == ')' && --n3 < 0) {
                n3 = -100;
            }
            ++n4;
        }
        if (n2 % 2 == 1) {
            caller.ReportError((byte)32);
            return false;
        }
        if (n3 != 0) {
            caller.ReportError((byte)48);
            return false;
        }
        if (n2 > 0 && !searchDb.databaseHasPositions) {
            caller.ReportError((byte)31);
            return false;
        }
        return true;
    }

    public void buildSearchWords(Caller caller, char[] cArray, int n, Language language) {
        this.buildSearchWords(caller, cArray, n, language, null);
    }

    public void buildSearchWords(Caller caller, char[] cArray, int n, Language language, Vector vector) {
        this.caller = caller;
        this.db = this.caller.getDb();
        this.StoreOperatorNames(language);
        this.currentExpression = new Vector();
        if (this.currentExpression == null) {
            return;
        }
        this.caller.setSearchWords(this.currentExpression);
        this.currentDbFieldNo = -1;
        this.doBuildSearchWords(cArray, n);
        if (this.caller.ErrorReported()) {
            return;
        }
        if (vector == null) {
            return;
        }
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            SearchField searchField = (SearchField)vector.elementAt(n3);
            this.currentDbFieldNo = this.FindDbFieldNo(searchField);
            if (this.currentDbFieldNo == -1) {
                this.caller.ReportError("Field " + searchField.lcname + " not in search database");
                return;
            }
            this.doBuildSearchWords(searchField.SearchText, searchField.SearchTextLen);
            if (this.caller.ErrorReported()) {
                return;
            }
            ++n3;
        }
    }

    private void LookupWords(SearchItem searchItem, boolean bl) {
        int n = searchItem.words.size();
        this.outWords = new Vector();
        if (this.outWords == null) {
            return;
        }
        this.MatchCaseInsertPos = 0;
        this.AnyCaseMatchersFound = false;
        try {
            int n2 = 0;
            while (n2 < n) {
                if (!this.caller.isAborting()) {
                    SearchWord searchWord = (SearchWord)searchItem.words.elementAt(n2);
                    String string = searchWord.word;
                    String string2 = CharSet.ToUnicodeLowerCase(string);
                    if (searchItem.dbfieldno != -1) {
                        this.LookupFieldWord(searchItem, string, string2, bl);
                    } else {
                        this.LookupDbWord(searchItem, string, string2, bl);
                    }
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.caller.ReportException(exception);
        }
        searchItem.words = this.outWords;
        if (!this.AnyCaseMatchersFound) {
            searchItem.ListMatchCaseFirst = false;
        }
    }

    private boolean AddWildCardsStemsAndSynonyms(SearchItem searchItem, String string) {
        RuleSet ruleSet;
        boolean bl;
        if (string.indexOf(63) != -1 || string.indexOf(42) != -1) {
            this.WildCardSearch(searchItem.words, string);
            return true;
        }
        searchItem.ListMatchCaseFirst = CharSet.WordHasSomeCapitals(string);
        boolean bl2 = bl = string.length() == 1 && !CharSet.IsUnicodeCharLatin(string.charAt(0));
        if (!bl && (ruleSet = this.caller.getRuleSet()) != null) {
            ruleSet.ProcessRulesForSearchItem(searchItem, string);
        }
        return false;
    }

    private Vector GetWildSearchItems(String string) {
        Vector<WildSearchItem> vector = new Vector<WildSearchItem>();
        int n = string.length();
        String string2 = null;
        int n2 = 0;
        while (n2 < n) {
            WildSearchItem wildSearchItem;
            boolean bl;
            char c = string.charAt(n2);
            boolean bl2 = c == '*';
            boolean bl3 = bl = c == '?';
            if ((bl2 || bl) && string2 != null) {
                wildSearchItem = new WildSearchItem(false, false, string2);
                vector.addElement(wildSearchItem);
                string2 = null;
            }
            if (bl2) {
                wildSearchItem = new WildSearchItem(true, false, null);
                vector.addElement(wildSearchItem);
            } else if (bl) {
                wildSearchItem = new WildSearchItem(false, true, null);
                vector.addElement(wildSearchItem);
            } else {
                if (string2 == null) {
                    string2 = new String();
                }
                string2 = string2 + c;
            }
            ++n2;
        }
        if (string2 != null) {
            WildSearchItem wildSearchItem = new WildSearchItem(false, false, string2);
            vector.addElement(wildSearchItem);
        }
        return vector;
    }

    private void StartExpression() {
        SearchItem searchItem = new SearchItem(null, this.currentDbFieldNo);
        if (searchItem == null) {
            this.caller.ReportError("Sorry, not enough memory");
            return;
        }
        searchItem.expression = new Vector();
        if (searchItem.expression == null) {
            this.caller.ReportError("Sorry, not enough memory");
            return;
        }
        searchItem.operation = 64;
        if (this.nextIsNOT) {
            searchItem.operation |= 0x80;
        }
        this.currentExpression.addElement(searchItem);
        this.parents.addElement(this.currentExpression);
        this.currentExpression = searchItem.expression;
        this.lastSearchItem = null;
        this.nextIsNOT = false;
    }
}

