//
//	FindinSite-CD-JS-HelpIndex database adabascore
//
//	Copyright (c) 2016-2025 Software AG, Darmstadt, Germany and/or Software AG USA Inc., Reston, VA, USA
//
var adabascore = {
    baseurls: ["../"],
    varname: "adabascore",
        tree: [
            { url: "about/about.htm", title: "About this Documentation",
              tree: [
                  { url: "about/document_conventions.htm", title: "Document Conventions" },
                  { url: "about/online_information.htm", title: "Online Information and Support" },
                  { url: "about/data_protection.htm", title: "Data Protection" },
              ]
            },
            { url: "relnotes/relnotes.htm", title: "Adabas 8.5.4 Release Notes",
              tree: [
                  { url: "relnotes/platform.htm", title: "Supported Operating System Platforms" },
                  { url: "relnotes/v85enh.htm", title: "Enhancements" },
                  { url: "relnotes/v85inst.htm", title: "Installation and License" },
                  { url: "relnotes/future.htm", title: "Future Plans" },
                  { url: "relnotes/limits.htm", title: "Limitations and Restrictions" },
                  { url: "relnotes/dscompat.htm", title: "Adabas Data Set Compatibility" },
                  { url: "relnotes/zaps.htm", title: "Applying Zaps" },
                  { url: "relnotes/compat.htm", title: "Software AG Mainframe Product Compatibility" },
                  { url: "relnotes/addons.htm", title: "Using COR-based Add-ons" },
                  { url: "relnotes/afpavilk.htm", title: "AFPLOOK /AVILOOK Considerations" },
                  { url: "relnotes/eom.htm", title: "End of Maintenance" },
                  { url: "relnotes/doc.htm", title: "Documentation and Other Online Information" },
              ]
            },
            { url: "concepts/cfover.htm", title: "Concepts and Facilities",
              tree: [
                  { url: "concepts/cfadais.htm", title: "Adabas Is . . ." },
                  { url: "concepts/cfdesign.htm", title: "Adabas Design" },
                  { url: "concepts/cfusing.htm", title: "Using Adabas" },
                  { url: "concepts/cfutil.htm", title: "Adabas Utilities" },
                  { url: "concepts/lic.htm", title: "Licensing Adabas" },
                  { url: "concepts/cfsecurity.htm", title: "Adabas Security" },
                  { url: "concepts/cfoptext.htm", title: "Optional Product Extensions" },
              ]
            },
            { url: "install_os3/instover.htm", title: "Installation for z/OS",
              tree: [
                  { url: "install_os3/supported-environments.htm", title: "Supported Environments" },
                  { url: "install_os3/install-zos.htm", title: "Installing Adabas for z/OS" },
                  { url: "install_os3/install-tp.htm", title: "Installing Adabas with TP Monitors" },
                  { url: "install_os3/install-azp.htm", title: "Installing Adabas Add-ons (including zIIP)" },
                  { url: "install_os3/connecting-ues.htm", title: "Enabling Universal Encoding Support (UES) for Your Adabas Nucleus" },
                  { url: "install_os3/adatcpos.htm", title: "Enabling Direct TCP/IP Access (ADATCP) to Your Adabas Nucleus" },
                  { url: "install_os3/device-file.htm", title: "Device and File Considerations" },
                  { url: "install_os3/install-aos.htm", title: "Installing The AOS Demo Version" },
                  { url: "install_os3/install-adarai.htm", title: "Installing the Recovery Aid (ADARAI)" },
                  { url: "install_os3/install-error.htm", title: "Installing The Error Handling And Message Buffering Feature" },
                  { url: "install_os3/adafdp.htm", title: "Adabas Dump Formatting Tool (ADAFDP)" },
                  { url: "install_os3/translation-tables.htm", title: "Translation Tables" },
              ]
            },
            { url: "dbatasks/dbaover.htm", title: "DBA Tasks",
              tree: [
                  { url: "dbatasks/p1over.htm", title: "DBA Roles and Responsibilities" },
                  { url: "dbatasks/p2over.htm", title: "Database Design" },
                  { url: "dbatasks/datetime_over.htm", title: "Date-Time Edit Mask Reference" },
                  { url: "dbatasks/dbexfiles.htm", title: "Expanded Files" },
                  { url: "dbatasks/dblobs.htm", title: "Large Object (LB) Files and Fields" },
                  { url: "dbatasks/dbdefine.htm", title: "Defining an Adabas Database" },
                  { url: "dbatasks/dbspmgt.htm", title: "Database Space Management" },
                  { url: "dbatasks/dbtune.htm", title: "Database Monitoring and Tuning" },
                  { url: "dbatasks/dberror.htm", title: "Error Handling and Message Buffering" },
                  { url: "dbatasks/dbuessup.htm", title: "Universal Encoding Support (UES)" },
                  { url: "dbatasks/dbplatforms.htm", title: "Multiple Platform Support" },
                  { url: "dbatasks/smfrecs.htm", title: "Adabas SMF Records" },
                  { url: "dbatasks/afplook.htm", title: "AFPLOOK" },
                  { url: "dbatasks/avilook.htm", title: "AVILOOK" },
                  { url: "dbatasks/p4over.htm", title: "Adabas Online System Demo Version" },
              ]
            },
            { url: "operator/operover.htm", title: "Operations",
              tree: [
                  { url: "operator/conv.htm", title: "Conventions" },
                  { url: "operator/intro.htm", title: "Controlling the Adabas Environment" },
                  { url: "operator/adarun.htm", title: "Adabas Initialization (ADARUN Statement)",
                    tree: [
                        { url: "operator/parmsyn.htm", title: "ADARUN Parameter Syntax" },
                        { url: "operator/parmdir.htm", title: "ADARUN Parameter Directory" },
                        { url: "operator/sessparm.htm", title: "Setting Adabas Session Parameters" },
                        { url: "operator/addons.htm", title: "ADARUN Parameters Pertinent to Adabas Add-on Products" },
                    ]
                  },
                  { url: "operator/opcom.htm", title: "Operator Commands" },
                  { url: "operator/session.htm", title: "Adabas Session Execution" },
                  { url: "operator/utility.htm", title: "Adabas Utility Execution" },
                  { url: "operator/linkapp.htm", title: "Linking Applications to Adabas" },
                  { url: "operator/recovery.htm", title: "Adabas Restart and Recovery" },
                  { url: "operator/timezone.htm", title: "Local Time Zone Change Support" },
                  { url: "operator/timeout.htm", title: "Adabas Timeout Feature" },
              ]
            },
            { url: "comref/comrefover.htm", title: "Command Reference",
              tree: [
                  { url: "comref/conv.htm", title: "Syntax Conventions" },
                  { url: "comref/p1over.htm", title: "Overview",
                    tree: [
                        { url: "comref/cmdover.htm", title: "About Adabas Commands" },
                        { url: "comref/genprog.htm", title: "General Programming Considerations" },
                    ]
                  },
                  { url: "comref/calling.htm", title: "Calling Adabas" },
                  { url: "comref/ctlblock.htm", title: "Adabas Control Block Structures (ACB and ACBX)" },
                  { url: "comref/abd.htm", title: "Adabas Buffer Descriptions (ABDs)" },
                  { url: "comref/buffers.htm", title: "Defining Buffers" },
                  { url: "comref/bufrel.htm", title: "Understanding the Different Buffer Types" },
                  { url: "comref/fmtbuf.htm", title: "Format Buffers" },
                  { url: "comref/recbuf.htm", title: "Record Buffers" },
                  { url: "comref/fmtrecex.htm", title: "Format and Record Buffer Examples" },
                  { url: "comref/prebuf.htm", title: "Prefetch Buffers" },
                  { url: "comref/multibuf.htm", title: "Multifetch Buffers" },
                  { url: "comref/srchbuf.htm", title: "Search Buffers" },
                  { url: "comref/valbuf.htm", title: "Value Buffers" },
                  { url: "comref/srchvalx.htm", title: "Search and Value Buffer Examples" },
                  { url: "comref/dtbuf.htm", title: "Date-Time Edit Mask Processing in Format and Search Buffers" },
                  { url: "comref/isnbuf.htm", title: "ISN Buffers" },
                  { url: "comref/userbuf.htm", title: "User Buffers" },
                  { url: "comref/perfbuf.htm", title: "Performance Buffers" },
                  { url: "comref/commands.htm", title: "Commands",
                    tree: [
                        { url: "comref/a1.htm", title: "A1 Command: Update Record" },
                        { url: "comref/bt.htm", title: "BT Command: Back Out Transaction" },
                        { url: "comref/c1.htm", title: "C1 Command: Write a Checkpoint" },
                        { url: "comref/c3.htm", title: "C3 Command: Write Checkpoint" },
                        { url: "comref/c5.htm", title: "C5 Command: Write User Data to Protection Log" },
                        { url: "comref/cl.htm", title: "CL Command: Close User Session" },
                        { url: "comref/e1.htm", title: "E1 Command: Delete Record / Refresh File" },
                        { url: "comref/et.htm", title: "ET Command: End Transaction" },
                        { url: "comref/hi.htm", title: "HI Command: Hold Record" },
                        { url: "comref/l1l4.htm", title: "L1 and L4 Commands: Read / Read and Hold Record" },
                        { url: "comref/l2l5.htm", title: "L2 and L5 Commands: Read Physical Sequential" },
                        { url: "comref/l3l6.htm", title: "L3 and L6 Commands: Read Logical Sequential" },
                        { url: "comref/l9.htm", title: "L9 Command: Read Descriptor Values" },
                        { url: "comref/lf.htm", title: "LF Command: Read Field Definitions" },
                        { url: "comref/n1n2.htm", title: "N1 and N2 Commands: Adding Records" },
                        { url: "comref/op.htm", title: "OP Command: Open User Session" },
                        { url: "comref/rc.htm", title: "RC Command: Release Command ID or Global Format ID" },
                        { url: "comref/re.htm", title: "RE Command: Read ET User Data" },
                        { url: "comref/ri.htm", title: "RI Command: Release Record" },
                        { url: "comref/s1s2s4.htm", title: "S1, S2, and S4 Commands: Find Records" },
                        { url: "comref/s5.htm", title: "S5 Command: Find Coupled ISNs" },
                        { url: "comref/s8.htm", title: "S8 Command: Process ISN Lists" },
                        { url: "comref/s9.htm", title: "S9 Command: Sort ISN Lists" },
                    ]
                  },
                  { url: "comref/ex_over.htm", title: "Programming Examples",
                    tree: [
                        { url: "comref/acb_ex.htm", title: "ACB Examples" },
                        { url: "comref/acbx_ex.htm", title: "ACBX Examples" },
                    ]
                  },
              ]
            },
            { url: "util/utilover.htm", title: "Utilities",
              tree: [
                  { url: "util/conv.htm", title: "Conventions" },
                  { url: "util/adacdc-localover.htm", title: "ADACDC Utility: Changed-Data Capture",
                    tree: [
                        { url: "util/adacdc-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adacdc-run.htm", title: "Running the Utility" },
                        { url: "util/adacdc-OpSyCo.htm", title: "Operating System Considerations" },
                        { url: "util/adacdc-UserX.htm", title: "The ADACDC User Exit" },
                        { url: "util/adacdc-Ex.htm", title: "Examples" },
                        { url: "util/adacdc-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adachk-localover.htm", title: "ADACHK Utility: Database Consistency Check Utility that Runs Concurrently with Normal Database Operations",
                    tree: [
                        { url: "util/adachk-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adachk-accheck.htm", title: "ACCHECK: Check Address Converter against Data Storage" },
                        { url: "util/adachk-acscan.htm", title: "ACSCAN: Scan the address converter to identify reusable ISNs" },
                        { url: "util/adachk-assoprint.htm", title: "ASSOPRINT: Print/Dump Associator Blocks" },
                        { url: "util/adachk-check.htm", title: "CHECK: Perform all ADACHK Checks" },
                        { url: "util/adachk-clogprint.htm", title: "CLOGPRINT: Print/Dump Command Log Blocks" },
                        { url: "util/adachk-dataprint.htm", title: "DATAPRINT: Print/Dump Data Storage Blocks" },
                        { url: "util/adachk-dscheck.htm", title: "DSCHECK: Check Data Storage" },
                        { url: "util/adachk-dsimprint.htm", title: "DSIMPRINT: Print Delta Save Image Data Set Blocks" },
                        { url: "util/adachk-dsstprint.htm", title: "DSSTPRINT: Print Data Storage Space Table" },
                        { url: "util/adachk-fcbprint.htm", title: "FCBPRINT: Print/Dump File Control Block (FCB)" },
                        { url: "util/adachk-fdtprint.htm", title: "FDTPRINT: Print/Dump Field Definition Table (FDT)" },
                        { url: "util/adachk-fstprint.htm", title: "FSTPRINT: Print/Dump Free Space Table (FST)" },
                        { url: "util/adachk-gcbprint.htm", title: "GCBPRINT: Print/Dump General Control Blocks (GCBs)" },
                        { url: "util/adachk-icheck.htm", title: "ICHECK: Check Index Physical Structure" },
                        { url: "util/adachk-niprint.htm", title: "NIPRINT: Print/Dump Normal Index" },
                        { url: "util/adachk-plogprint.htm", title: "PLOGPRINT: Print/Dump Protection Log Blocks" },
                        { url: "util/adachk-pptprint.htm", title: "PPTPRINT: Print/Dump Parallel Participant Table (PPT)" },
                        { url: "util/adachk-rlogprint.htm", title: "RLOGPRINT: Print/Dump Recovery Log" },
                        { url: "util/adachk-sortprint.htm", title: "SORTPRINT: Print/Dump Sort Data Set" },
                        { url: "util/adachk-tempprint.htm", title: "TEMPPRINT: Print/Dump Temporary Data Set" },
                        { url: "util/adachk-uiprint.htm", title: "UIPRINT: Print/Dump Upper Index" },
                        { url: "util/adachk-validate.htm", title: "VALIDATE: Validate All Database Files" },
                        { url: "util/adachk-workprint.htm", title: "WORKPRINT: Print/Dump Work Data Set" },
                        { url: "util/adachk_jcl.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adacmp-localover.htm", title: "ADACMP Utility: Compress-Decompress Data",
                    tree: [
                        { url: "util/adacmp-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adacmp-input.htm", title: "Input Data Requirements" },
                        { url: "util/adacmp-proc.htm", title: "Processing" },
                        { url: "util/adacmp-compress.htm", title: "COMPRESS: Compress an Adabas File" },
                        { url: "util/adacmp-decompress.htm", title: "DECOMPRESS: Decompress an Adabas File" },
                        { url: "util/flddefs.htm", title: "Field Definition Statements" },
                        { url: "util/adacmp-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                        { url: "util/adacmp-ComOut.htm", title: "COMPRESS Function Output" },
                        { url: "util/adacmp-DecOut.htm", title: "DECOMPRESS Function Output" },
                    ]
                  },
                  { url: "util/adacnv-localover.htm", title: "ADACNV Utility: Database Conversion",
                    tree: [
                        { url: "util/adacnv-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adacnv-convert.htm", title: "CONVERT: Convert Database to Higher Version" },
                        { url: "util/adacnv-revert.htm", title: "REVERT: Revert Database to Lower Version" },
                        { url: "util/adacnv-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adadbs-localover.htm", title: "ADADBS Utility: Database Services",
                    tree: [
                        { url: "util/adadbs-FuncOv.htm", title: "Functional Overview" },
                        { url: "util/adadbs-ADD.htm", title: "ADD: Add Data Set" },
                        { url: "util/adadbs-ADDCLOG.htm", title: "ADDCLOG: Dynamically Add CLOG Data Sets" },
                        { url: "util/adadbs-ADDPLOG.htm", title: "ADDPLOG: Dynamically Add PLOG Data Sets" },
                        { url: "util/adadbs-ALLOCAT.htm", title: "ALLOCATE: Allocate File Extent" },
                        { url: "util/adadbs-CHANGE.htm", title: "CHANGE: Change Standard Length or Format of a Field" },
                        { url: "util/adadbs-CVOLSER.htm", title: "CVOLSER: Print Adabas Extents on Given Volume" },
                        { url: "util/adadbs-DEALLOC.htm", title: "DEALLOCATE: Deallocate File Extent" },
                        { url: "util/adadbs-decr.htm", title: "DECREASE: Decrease Last Associator or Data Storage Data Set Size" },
                        { url: "util/adadbs-DELCLOG.htm", title: "DELCLOG: Dynamically Deleting CLOG Data Sets" },
                        { url: "util/adadbs-DELCP.htm", title: "DELCP: Delete Checkpoint Records" },
                        { url: "util/adadbs-DELDE.htm", title: "DELDE: Logically Deleting a Descriptor" },
                        { url: "util/adadbs-DELETE.htm", title: "DELETE: Delete File" },
                        { url: "util/adadbs-DELFN.htm", title: "DELFN: Logically Delete Fields" },
                        { url: "util/adadbs-DELPLOG.htm", title: "DELPLOG: Dynamically Deleting PLOG Data Sets" },
                        { url: "util/adadbs-DEVENTLOG.htm", title: "DEVENTLOG: Display Adabas Event Log" },
                        { url: "util/adadbs-DSREUSE.htm", title: "DSREUSE: Reuse Data Storage Blocks" },
                        { url: "util/adadbs-ENCODEF.htm", title: "ENCODEF: Change File Encoding" },
                        { url: "util/adadbs-EXPFILE.htm", title: "EXPFILE: Insert or Remove Files in an Expanded File Chain" },
                        { url: "util/adadbs-INCREASE.htm", title: "INCREASE: Increase Last Associator or Data Storage Data Set Size" },
                        { url: "util/adadbs-ISNREUSE.htm", title: "ISNREUSE: Reuse ISNs" },
                        { url: "util/adadbs-MODFCB.htm", title: "MODFCB: Modify File Parameters" },
                        { url: "util/adadbs-MUPEX.htm", title: "MUPEX: Set Maximum Count for MU and PE Fields" },
                        { url: "util/adadbs-NEWFIELD.htm", title: "NEWFIELD: Add New Field" },
                        { url: "util/adadbs-ONLADD.htm", title: "ONLADD: Allocating New ASSO or DATA Space Dynamically" },
                        { url: "util/adadbs-ONLINCREASE.htm", title: "ONLINCREASE: Allocating Appended ASSO or DATA Space Dynamically" },
                        { url: "util/adadbs-ONLINVERT.htm", title: "ONLINVERT: Start Online Invert Process" },
                        { url: "util/adadbs-ONLREORFASSO.htm", title: "ONLREORFASSO: Start Online Reorder Associator for Files" },
                        { url: "util/adadbs-ONLREORFDATA.htm", title: "ONLREORFDATA: Start Online Reorder Data for Files" },
                        { url: "util/adadbs-ONLREORFILE.htm", title: "ONLREORFILE: Start Online Reorder Associator and Data for Files" },
                        { url: "util/adadbs-OPERCOM.htm", title: "OPERCOM: Issue Adabas Operator Commands" },
                        { url: "util/adadbs-PRIORITY.htm", title: "PRIORITY: Change User Priority" },
                        { url: "util/adadbs-REACTLOG.htm", title: "REACTLOG: Reactivating Command Logging" },
                        { url: "util/adadbs-RECORDSPANNING.htm", title: "RECORDSPANNING: Enable or Disable Record Spanning" },
                        { url: "util/adadbs-RECOVER.htm", title: "RECOVER: Recover Space" },
                        { url: "util/adadbs-refr.htm", title: "REFRESH: Set File to Empty Status" },
                        { url: "util/adadbs-refrSTATS.htm", title: "REFRESHSTATS: Reset Statistical Values" },
                        { url: "util/adadbsRelease.htm", title: "RELEASE: Release Descriptor" },
                        { url: "util/adadbsRename.htm", title: "RENAME: Rename File or Database" },
                        { url: "util/adadbs-Renumber.htm", title: "RENUMBER: Change File Number" },
                        { url: "util/adadbs-Replication.htm", title: "REPLICATION: Activating or Deactivating Replication" },
                        { url: "util/adadbs-REPTOR.htm", title: "ADADBS REPTOR: Activate, Deactivate, Open, or Close Event Replicator Resources" },
                        { url: "util/adadbs-RESETDIB.htm", title: "RESETDIB: Reset Entries in Active Utility List" },
                        { url: "util/adadbs-RESETPPT.htm", title: "RESETPPT: Reset PPT Blocks" },
                        { url: "util/adadbs-SPANCOUNT.htm", title: "SPANCOUNT: Count Spanned Records" },
                        { url: "util/adadbs-TRANSACT.htm", title: "TRANSACTIONS: Suspend and Resume Update Transaction Processing" },
                        { url: "util/adadbs-UNCOUPLE.htm", title: "UNCOUPLE: Uncouple Files" },
                        { url: "util/adadbs-UNDELDE.htm", title: "UNDELDE: Undeleting a Logically Deleted Descriptor" },
                        { url: "util/adadbs-UNDELFN.htm", title: "UNDELFN: Logically Undelete Fields" },
                        { url: "util/adadbs-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adadef-localover.htm", title: "ADADEF Utility: Define a Database",
                    tree: [
                        { url: "util/adadef-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adadef-def.htm", title: "DEFINE: Defining a Database and Checkpoint File" },
                        { url: "util/adadef-mod.htm", title: "MODIFY: Change Database Options" },
                        { url: "util/adadef-newwork.htm", title: "NEWWORK: Defining a Work File" },
                        { url: "util/adadef-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adadru-localover.htm", title: "ADADRU Utility: Database Storage Usage Reports",
                    tree: [
                        { url: "util/adadru-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adadru-spaceusage.htm", title: "SPACEUSAGE: Database File Space Usage" },
                        { url: "util/adadru_jcl.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adafrm-localover.htm", title: "ADAFRM Utility: Format Adabas Database Components",
                    tree: [
                        { url: "util/adafrm-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adafrm-format.htm", title: "Formatting Database Components" },
                        { url: "util/adafrm-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adainv-localover.htm", title: "ADAINV Utility: Inverted List Management",
                    tree: [
                        { url: "util/adainv-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adainv-couple.htm", title: "COUPLE: Define File-Coupling Descriptors" },
                        { url: "util/adainv-invert.htm", title: "INVERT: Create Descriptors" },
                        { url: "util/adainv-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adalod-localover.htm", title: "ADALOD Utility: File Loader",
                    tree: [
                        { url: "util/adalod-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adalod-load.htm", title: "LOAD: Load a File" },
                        { url: "util/adalod-update.htm", title: "UPDATE: Add/Delete Records" },
                        { url: "util/adalod-LoStReq.htm", title: "Loader Storage Requirements and Use" },
                        { url: "util/adalod-TeDaSpU.htm", title: "TEMP Data Set Space Usage" },
                        { url: "util/adalod-SpStRep.htm", title: "ADALOD Space/Statistics Report" },
                        { url: "util/adalod-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adamer-localover.htm", title: "ADAMER Utility: ADAM Estimation",
                    tree: [
                        { url: "util/adamer-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adamer-est.htm", title: "Estimate ADAM Access Requirements" },
                        { url: "util/adamer-OutpRep.htm", title: "ADAMER Output Report Description" },
                        { url: "util/adamer-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adaord-localover.htm", title: "ADAORD Utility: Reordering Functions",
                    tree: [
                        { url: "util/adaord-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adaord-reorasso.htm", title: "REORASSO: Reorder Associator" },
                        { url: "util/adaord-reordata.htm", title: "REORDATA: Reorder Data Storage" },
                        { url: "util/adaord-reordb.htm", title: "REORDB: Reorder Database" },
                        { url: "util/adaord-reorfasso.htm", title: "REORFASSO: Reorder Associator for a Single File" },
                        { url: "util/adaord-reorfdata.htm", title: "REORFDATA: Reorder Data Storage for a Single File" },
                        { url: "util/adaord-reorfile.htm", title: "REORFILE: Reorder File" },
                        { url: "util/adaord-restrDB.htm", title: "RESTRUCTUREDB: Restructure Database" },
                        { url: "util/adaord-restrREF.htm", title: "RESTRUCTUREF: Restructure Single Files" },
                        { url: "util/adaord-store.htm", title: "STORE: Store Files" },
                        { url: "util/adaord-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adaplp-localover.htm", title: "ADAPLP Utility: Print Data Protection Records from PLOG/Work",
                    tree: [
                        { url: "util/adaplp-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adaplp-print.htm", title: "ADAPLP Syntax and Examples" },
                        { url: "util/adaplp-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adarai-localover.htm", title: "ADARAI Utility: Adabas Recovery Aid",
                    tree: [
                        { url: "util/adarai-funov.htm", title: "Function Overview" },
                        { url: "util/adarai-chkdb.htm", title: "CHKDB: Check the Database Recovery Status" },
                        { url: "util/adarai-disable.htm", title: "DISABLE: Disable Recovery Logging" },
                        { url: "util/adarai-list.htm", title: "LIST: Display Current RLOG Generations" },
                        { url: "util/adarai-prepare.htm", title: "PREPARE: Initialize and Start the RLOG" },
                        { url: "util/adarai-recover.htm", title: "RECOVER: Build a Recovery Job Stream" },
                        { url: "util/adarai-remove.htm", title: "REMOVE: Remove the Recovery Aid" },
                        { url: "util/adarai-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adarep-localover.htm", title: "ADAREP Utility: Database Status Report",
                    tree: [
                        { url: "util/adarep-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adarep-RepSyn.htm", title: "Report Syntax" },
                        { url: "util/adarep-ProSaTI.htm", title: "Processing Save Tape Input" },
                        { url: "util/adarep-repdesc.htm", title: "Report Description" },
                        { url: "util/adarep-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adares-localover.htm", title: "ADARES Utility: Database Recovery",
                    tree: [
                        { url: "util/adares-funov.htm", title: "Functional Overview" },
                        { url: "util/adares-Backout.htm", title: "BACKOUT Functions" },
                        { url: "util/adares-back-func.htm", title: "BACKOUT: Back Out Updates Using the Sequential Protection Log (SIBA)" },
                        { url: "util/adares-back-DplogFunc.htm", title: "BACKOUT DPLOG or MPLOG: Back Out Updates Using the Dual or Multiple Protection Log" },
                        { url: "util/adares-CLCopy.htm", title: "CLCOPY: Copy Dual Command Log" },
                        { url: "util/adares-Copy.htm", title: "COPY: Copy a Sequential Protection Log or Save Tape" },
                        { url: "util/adares-MCLOG.htm", title: "MERGE CLOG: Merge Nucleus Cluster Command Logs" },
                        { url: "util/adares-PLCopy.htm", title: "PLCOPY: Copy Protection Log to Sequential Data Set" },
                        { url: "util/adares-Regen.htm", title: "REGENERATE: Regenerate Updates" },
                        { url: "util/adares-Repair.htm", title: "REPAIR: Repair Data Storage Blocks" },
                        { url: "util/adares-MuPrSt.htm", title: "Multithreaded Processing Statistics" },
                        { url: "util/adares-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adasav-localover.htm", title: "ADASAV Utility: Save/Restore Database or Files",
                    tree: [
                        { url: "util/adasav-funov.htm", title: "Functional Overview" },
                        { url: "util/adasav-restonl.htm", title: "RESTONL: Restore Database from Online Source" },
                        { url: "util/adasav-restonlFiles.htm", title: "RESTONL FILES: Restore Files to Original RABNs from Online Source" },
                        { url: "util/adasav-restonlFMOVE.htm", title: "RESTONL FMOVE: Restore Files to Any RABNs from Online Source" },
                        { url: "util/adasav-restonlGCB.htm", title: "RESTONL GCB: Restore Database Incremental from Online Source" },
                        { url: "util/adasav-restore.htm", title: "RESTORE: Restore Database from Offline Source" },
                        { url: "util/adasav-restoreFILES.htm", title: "RESTORE FILES: Restore Files to Original RABNs from Offline Source" },
                        { url: "util/adasav-restoreFMOVE.htm", title: "RESTORE FMOVE: Restore Files to Any RABNs from Offline Source" },
                        { url: "util/adasav-restoreGCB.htm", title: "RESTORE GCB: Restore Database Incremental from Offline Source" },
                        { url: "util/adasav-restplog.htm", title: "RESTPLOG: Restore Protection Log Only" },
                        { url: "util/adasav-save.htm", title: "SAVE: Save Database" },
                        { url: "util/adasav-saveFILES.htm", title: "SAVE FILES: Save Specified Files" },
                        { url: "util/adasav-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adasel-localover.htm", title: "ADASEL Utility: Select Protection Data",
                    tree: [
                        { url: "util/adasel-funov.htm", title: "Functional Overview" },
                        { url: "util/adasel-syntax.htm", title: "ADASEL Syntax" },
                        { url: "util/adasel-scene.htm", title: "ADASEL Scenarios" },
                        { url: "util/adasel-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adauld-localover.htm", title: "ADAULD Utility: Unload Files",
                    tree: [
                        { url: "util/adauld-funov.htm", title: "Functional Overview" },
                        { url: "util/adauld-unload.htm", title: "UNLOAD FILE: Unload Specified File" },
                        { url: "util/adauld-InPr.htm", title: "ADAULD Input Processing" },
                        { url: "util/adauld-output.htm", title: "ADAULD Output Processing" },
                        { url: "util/adauld-UserX.htm", title: "ADAULD User Exit 9" },
                        { url: "util/adauld-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adawrk-localover.htm", title: "ADAWRK Utility: Work Area Recovery Reports",
                    tree: [
                        { url: "util/adawrk-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adawrk-Syntax.htm", title: "Utility Syntax" },
                        { url: "util/adawrk-repdesc.htm", title: "Report Descriptions" },
                        { url: "util/adawrk-JCL.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adazap-localover.htm", title: "ADAZAP Utility: Display or Modify Asso, Data, and Work Data Sets",
                    tree: [
                        { url: "util/adazap-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adazap_syntax.htm", title: "ADAZAP Syntax" },
                        { url: "util/adazap-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                    ]
                  },
                  { url: "util/adazin-localover.htm", title: "ADAZIN Utility: Print Adabas Maintenance and SVC Information",
                    tree: [
                        { url: "util/adazin-FunOv.htm", title: "Functional Overview" },
                        { url: "util/adazin_syntax.htm", title: "ADAZIN Syntax" },
                        { url: "util/adazin-ReqEx.htm", title: "JCL/JCS Requirements and Examples" },
                        { url: "util/adazinex.htm", title: "Sample ADAZIN Report" },
                    ]
                  },
                  { url: "util/apxa.htm", title: "Adabas Sequential Files" },
                  { url: "util/apxb.htm", title: "Library and File Procedures for z/VSE Examples" },
                  { url: "util/apxc.htm", title: "Adabas Personnel Demo File" },
              ]
            },
            { url: "exits/uexover.htm", title: "User, Hyperdescriptor, Collation Descriptor, and SMF Exits",
              tree: [
                  { url: "exits/calling_conventions.htm", title: "User Exit Calling Conventions" },
                  { url: "exits/uex1.htm", title: "User Exit 1 (General Processing)" },
                  { url: "exits/uex2.htm", title: "User Exit 2 (Dual Log Processing)" },
                  { url: "exits/uex3.htm", title: "User Exit 3 (User-Defined Phonetic Processing)" },
                  { url: "exits/uex4.htm", title: "User Exit 4 (User-Generated Log Data)" },
                  { url: "exits/uex5.htm", title: "User Exit 5 (Adabas Review Hub Event Handler)" },
                  { url: "exits/uex6.htm", title: "User Exit 6 (User Processing Before Data Compression)" },
                  { url: "exits/uex8.htm", title: "User Exit 8 (Operator Interface)" },
                  { url: "exits/uex9.htm", title: "User Exit 9 (ADAULD)" },
                  { url: "exits/uex11.htm", title: "User Exit 11 (General Processing)" },
                  { url: "exits/uex12.htm", title: "User Exit 12 (Multiple Data Set Log Processing)" },
                  { url: "exits/hyperexit.htm", title: "Hyperdescriptor Exits 01 - 31" },
                  { url: "exits/collexit.htm", title: "Collation Descriptor Exits 01 - 08" },
                  { url: "exits/smfexit.htm", title: "SMF User Exit" },
              ]
            },
            { url: "messages/macover.htm", title: "Messages and Codes",
              tree: [
                  { url: "messages/abbrev.htm", title: "List of Abbreviations" },
                  { url: "messages/msgprfxa.htm", title: "Message Prefix Reference" },
                  { url: "messages/msgprfxp.htm", title: "Message Prefix Reference by Product" },
                  { url: "messages/adarun.htm", title: "ADARUN Statement/Parameter Messages" },
                  { url: "messages/ckpoint.htm", title: "Adabas Checkpoints" },
                  { url: "messages/console.htm", title: "Adabas Console Messages (ADAN* & ADACM*)" },
                  { url: "messages/dcamcodes.htm", title: "DCAM Feedback Codes" },
                  { url: "messages/nucstart.htm", title: "Nucleus Startup Error Messages" },
                  { url: "messages/nucresp.htm", title: "Adabas Response Codes" },
                  { url: "messages/snasense.htm", title: "SNA Sense Codes" },
                  { url: "messages/MLC.htm", title: "Software AG Licensing Messages" },
                  { url: "messages/uescodes.htm", title: "Universal Encoding System (UES) Component Error Codes" },
                  { url: "messages/abends.htm", title: "User Abend Codes" },
                  { url: "messages/AAF.htm", title: "AAF* - Adabas SAF Security Messages" },
                  { url: "messages/aafmrtn.htm", title: "SAF Return Codes" },
                  { url: "messages/aafmfx.htm", title: "SAF Internal Function Codes" },
                  { url: "messages/AASmsg.htm", title: "AAS* - Adabas Administration Services Messages" },
                  { url: "messages/AAUD.htm", title: "AAUD* - AUDITLOG Messages" },
                  { url: "messages/ACLX.htm", title: "ACLX* - Adabas Review Interface Messages" },
                  { url: "messages/ADAA.htm", title: "ADAA* Adabas Auditing Messages" },
                  { url: "messages/ADATCP.htm", title: "ADACM* - ADATCP Messages" },
                  { url: "messages/ADAD.htm", title: "ADAD* Abend Code Messages" },
                  { url: "messages/ADAE.htm", title: "ADAE* Adabas SAF Security (ADASAF) Messages" },
                  { url: "messages/ADAF.htm", title: "ADAF* - Event Replicator for Adabas Messages" },
                  { url: "messages/ADAH.htm", title: "ADAH* - Dump Formatter Status Messages" },
                  { url: "messages/ADAI.htm", title: "ADAI* - ADAIOR System Messages" },
                  { url: "messages/ADAJ.htm", title: "ADAJ* System Messages" },
                  { url: "messages/ADAK.htm", title: "ADAK* System Messages" },
                  { url: "messages/ADAL.htm", title: "ADAL* - Command Log (CLOG) System Messages" },
                  { url: "messages/ADAM.htm", title: "ADAM* -- ADAMPM System Messages" },
                  { url: "messages/ADAQ.htm", title: "ADAQ* - Adabas Review Hub Messages" },
                  { url: "messages/ADAR.htm", title: "ADAR* System Messages" },
                  { url: "messages/ADAS.htm", title: "ADAS* (Adabas SVC) System Messages" },
                  { url: "messages/ADASIP.htm", title: "ADASIP* (Adabas z/VSE SVC) System Messages" },
                  { url: "messages/ADASM.htm", title: "ADASM* Adabas SMF Processing Messages" },
                  { url: "messages/ADAU.htm", title: "ADAU* Utility Status Messages" },
                  { url: "messages/ADAX.htm", title: "ADAX* - Adabas Cluster Nucleus Messages" },
                  { url: "messages/ADAZ.htm", title: "ADAZ* - ADAZIP System Messages" },
                  { url: "messages/AFP.htm", title: "AFP* - Adabas Fastpath Messages" },
                  { url: "messages/APSPSX.htm", title: "APSPSX* - ADAECS or ADATCP Messages" },
                  { url: "messages/AREV.htm", title: "AREV* - Adabas Review Hub Messages" },
                  { url: "messages/ARF.htm", title: "ARF* - Adabas Event Replicator Subsystem Messages" },
                  { url: "messages/ARMT.htm", title: "ARMT* - Adabas Review Interface Messages" },
                  { url: "messages/ARMX.htm", title: "ARMX* - Adabas Review Interface Messages" },
                  { url: "messages/ARST.htm", title: "ARST* - Adabas Review Interface Messages" },
                  { url: "messages/ARSX.htm", title: "ARSX* - Adabas Review Interface Messages" },
                  { url: "messages/ART.htm", title: "ART* - Event Replicator Target Adapter Messages" },
                  { url: "messages/ARVU.htm", title: "ARVU* - Adabas Review Interface Messages" },
                  { url: "messages/ARXM.htm", title: "ARXM* - Event Replicator for Adabas Messages for Event Replicator Target Adapter" },
                  { url: "messages/ATM.htm", title: "ATM* - Adabas Transaction Manager Messages" },
                  { url: "messages/ATMerr.htm", title: "Adabas Transaction Manager Error Codes" },
                  { url: "messages/avimdb.htm", title: "AVInnn - Adabas Vista Database Processing Messages" },
                  { url: "messages/avimproc.htm", title: "AVI-xxxx-xx - Adabas Vista Processing Messages" },
                  { url: "messages/CAS.htm", title: "CAS* - Adabas System Coordinator Cluster Application Service Messages" },
                  { url: "messages/COR.htm", title: "COR* - Adabas System Coordinator Kernel Messages" },
                  { url: "messages/CORD.htm", title: "CORD* - Adabas System Coordinator Daemon Messages" },
                  { url: "messages/CWARN.htm", title: "CWARN* - Caching Facility Error Messages" },
                  { url: "messages/DSF.htm", title: "DSF* - Delta Save Facility Messages" },
                  { url: "messages/DSP.htm", title: "DSP* - Cluster Data Space (ADADSP) Messages" },
                  { url: "messages/LNKRVX.htm", title: "LNKRVX* Adabas Review Link Routine Messages" },
                  { url: "messages/PLI.htm", title: "PLI* - ADACOM Initialization Messages" },
                  { url: "messages/PLX.htm", title: "PLX* - ADACLU Messages" },
                  { url: "messages/PL6.htm", title: "PL6* - PRILOG6 Print Program Messages" },
                  { url: "messages/POP.htm", title: "POP* - Adabas System Coordinator Server Component Messages" },
                  { url: "messages/review00.htm", title: "Adabas Review 00xxx Messages" },
                  { url: "messages/review20.htm", title: "Adabas Review 20xxx Messages" },
                  { url: "messages/REVH.htm", title: "REVH* - Adabas Review Hub Messages" },
                  { url: "messages/RTP.htm", title: "RTP* - Adabas Review Trans-port Messages" },
                  { url: "messages/RVCL.htm", title: "RVCL* - Adabas Review Batch Client Reporting (REVCLRP) Messages" },
                  { url: "messages/SAF.htm", title: "SAF* - SAF Daemon Messages" },
                  { url: "messages/SAGE.htm", title: "SAGE* - z/VSE Batch Job Exit Utility Messages" },
                  { url: "messages/SAGI.htm", title: "SAGI* - Batch Initialization Messages (z/VSE Only)" },
                  { url: "messages/SEFM.htm", title: "SEFM* - ADASAF SAF Interface and SAF Security Kernel Messages" },
                  { url: "messages/SM-PIN.htm", title: "SM-PIN* - PIN Routine Messages" },
                  { url: "messages/tsmsgs.htm", title: "XTS* - Software AG Internal Transport Subsystem Messages" },
                  { url: "messages/utilover.htm", title: "Utility Messages and Codes",
                    tree: [
                        { url: "messages/utilcom.htm", title: "Errors Common to All Utilities" },
                        { url: "messages/ADACDC.htm", title: "ADACDC Utility Messages" },
                        { url: "messages/ADACHK.htm", title: "ADACHK Utility CHK* Messages" },
                        { url: "messages/CRVmsgs.htm", title: "ADACHK Utility CRV* Decompression Messages" },
                        { url: "messages/SRTmsgs.htm", title: "ADACHK Utility SRT* Sort Messages" },
                        { url: "messages/ADACMP.htm", title: "ADACMP Utility Messages" },
                        { url: "messages/ADACNV.htm", title: "ADACNV Utility Messages" },
                        { url: "messages/ADADBS.htm", title: "ADADBS Utility Messages" },
                        { url: "messages/ADADEF.htm", title: "ADADEF Utility Messages" },
                        { url: "messages/ADADRU.htm", title: "ADADRU Utility Messages" },
                        { url: "messages/ADAFRM.htm", title: "ADAFRM Utility Messages" },
                        { url: "messages/ADAINV.htm", title: "ADAINV Utility Messages" },
                        { url: "messages/ADALOD.htm", title: "ADALOD Utility Messages" },
                        { url: "messages/ADAMER.htm", title: "ADAMER Utility Messages" },
                        { url: "messages/ADAMTR.htm", title: "ADAMTR Utility Messages" },
                        { url: "messages/ADAMTS.htm", title: "ADAMTS Utility Messages" },
                        { url: "messages/ADAORD.htm", title: "ADAORD Utility Messages" },
                        { url: "messages/ADAPLP.htm", title: "ADAPLP Utility Messages" },
                        { url: "messages/ADARAI.htm", title: "ADARAI Utility Messages" },
                        { url: "messages/ADAREP.htm", title: "ADAREP Utility Messages" },
                        { url: "messages/ADARES.htm", title: "ADARES Utility Messages" },
                        { url: "messages/ADARPE.htm", title: "ADARPE Utility Messages" },
                        { url: "messages/ADARPL.htm", title: "ADARPL Utility Messages" },
                        { url: "messages/ADARPP.htm", title: "ADARPP Utility Messages" },
                        { url: "messages/ADASAV.htm", title: "ADASAV Utility Messages" },
                        { url: "messages/ADASEL.htm", title: "ADASEL Utility Messages" },
                        { url: "messages/ADAULD.htm", title: "ADAULD Utility Messages" },
                        { url: "messages/ADAWRK.htm", title: "ADAWRK Utility Messages" },
                        { url: "messages/ADAZAP.htm", title: "ADAZAP Utility Messages" },
                        { url: "messages/ADAZIN.htm", title: "ADAZIN Utility Messages" },
                    ]
                  },
              ]
            },
            { url: "appx/comlog.htm", title: "About the Command Logs" },
            { url: "appx/uesenc.htm", title: "Supplied UES Encodings" },
            { url: "appx/datetime.htm", title: "Date-Time Edit Mask Reference" },
            { url: "appx/timezone.htm", title: "Supported Time Zones" },
            { url: "triggers/trgsover.htm", title: "Triggers and Stored Procedures",
              tree: [
                  { url: "triggers/conv.htm", title: "Conventions" },
                  { url: "triggers/p1over.htm", title: "Introduction" },
                  { url: "triggers/p2over.htm", title: "Installation and Configuration" },
                  { url: "triggers/p3over.htm", title: "Processing and Performance" },
                  { url: "triggers/p4over.htm", title: "Programming and Performance" },
                  { url: "triggers/p5over.htm", title: "Calling Stored Procedures" },
                  { url: "triggers/p6over.htm", title: "Trigger Maintenance" },
                  { url: "triggers/p7over.htm", title: "TRGMAIN: An API To Maintain Triggers" },
                  { url: "triggers/p8over.htm", title: "TRGUNLD and TRGLOAD Utilities" },
                  { url: "triggers/apx.htm", title: "Examples" },
              ]
            },
            { url: "dbacard/dbacard.htm", title: "DBA Reference Summary",
              tree: [
                  { url: "dbacard/conv.htm", title: "Conventions" },
                  { url: "dbacard/adarunp.htm", title: "ADARUN Parameters" },
                  { url: "dbacard/adarun.htm", title: "ADARUN Statement/Parameter Messages" },
                  { url: "dbacard/opcom.htm", title: "Console Operator Commands" },
                  { url: "dbacard/util.htm", title: "Adabas Utilities" },
                  { url: "dbacard/devtype.htm", title: "Adabas Device Types and Block Sizes" },
                  { url: "dbacard/dballoc.htm", title: "Database Space Allocation Rules" },
                  { url: "dbacard/nucresp.htm", title: "Adabas Response Codes" },
                  { url: "dbacard/ckpoint.htm", title: "Adabas Checkpoints" },
                  { url: "dbacard/clog.htm", title: "Adabas Command Log Layouts" },
              ]
            },
            { url: "pgmcard/pgmcard.htm", title: "Adabas Programmer's Reference Summary",
              tree: [
                  { url: "pgmcard/conventions.htm", title: "Conventions" },
                  { url: "pgmcard/adacall.htm", title: "Adabas Direct Call Syntax" },
                  { url: "pgmcard/adacb.htm", title: "Adabas Control Block Structure" },
                  { url: "pgmcard/adaabd.htm", title: "Adabas Buffer Description (ABD) Structure" },
                  { url: "pgmcard/adabufov.htm", title: "Adabas Direct Call Buffers" },
                  { url: "pgmcard/adacmds.htm", title: "Adabas Commands" },
              ]
            },
            { url: "ziip/ziip-over.htm", title: "Adabas for zIIP",
              tree: [
                  { url: "ziip/azp_prereq.htm", title: "Prerequisites" },
                  { url: "ziip/azp_limit.htm", title: "Current Limitations" },
                  { url: "ziip/azp_general.htm", title: "General Information on zIIP Processing" },
                  { url: "ziip/azp_processing.htm", title: "Adabas for zIIP Processing: Concepts" },
                  { url: "ziip/azp_monitor.htm", title: "Monitoring zIIP Usage" },
              ]
            },
            { url: "safkernel/safover.htm", title: "SAF Security Kernel",
              tree: [
                  { url: "safkernel/intro.htm", title: "Introduction" },
                  { url: "safkernel/install.htm", title: "Installation" },
                  { url: "safkernel/operator.htm", title: "Operator Commands" },
                  { url: "safkernel/SAF.htm", title: "SAF* - SAF Daemon Messages" },
                  { url: "safkernel/SEFM.htm", title: "SEFM* - ADASAF SAF Interface and SAF Security Kernel Messages" },
                  { url: "safkernel/aafmrtn.htm", title: "SAF Return Codes" },
                  { url: "safkernel/aafmfx.htm", title: "SAF Internal Function Codes" },
                  { url: "safkernel/trcmsgs.htm", title: "Interpreting Trace Messages" },
                  { url: "safkernel/secdef.htm", title: "Security Definitions" },
              ]
            },
            { url: "license/license.htm", title: "Software AG Mainframe Product Licensing" },
            { url: "general/legal.htm", title: "Copyright" },
        ]
};

var mainProject = 1;

$.event.trigger({ type: "fishidbloaded", db: adabascore });
